package com.mm.c.cloud.lib.misc.utils;

import com.mm.c.cloud.lib.logger.TimberUtils;

import java.security.MessageDigest;

/**
 * Created by Larry on 2016/6/27.
 */
public class MD5Utils {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MD5Utils() {
    }

    public static final String MD5(String s) {
        return MD5(s.getBytes());
    }

    public static final String MD5(byte[] bytes) {
        try {
            MessageDigest e = MessageDigest.getInstance("MD5");
            e.update(bytes);
            byte[] md = e.digest();
            return byteToString(md);
        } catch (Exception var3) {
            TimberUtils.e(var3, "MD5Utils Encrypt failed!");
            return null;
        }
    }

    public static String byteToString(byte[] bytes) {
        int j = bytes.length;
        char[] str = new char[j * 2];
        int k = 0;

        for(int i = 0; i < j; ++i) {
            byte byte0 = bytes[i];
            str[k++] = hexDigits[byte0 >>> 4 & 15];
            str[k++] = hexDigits[byte0 & 15];
        }

        return new String(str);
    }
}

