package com.mm.c.cloud.lib.misc.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;

import com.mm.c.cloud.lib.base.application.EReleaseType;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.valor.mfc.vms.api.common.encrypt.MD5Checksum;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import static com.mm.c.cloud.lib.base.application.EReleaseType.MFC_BOX;
import static com.mm.c.cloud.lib.base.application.EReleaseType.UNKNOWN;


public class MiscUtils {
    private static EReleaseType releaseType = null;

    public static EReleaseType getReleaseType() {
        if (releaseType == null) {
            try {
                Context context = GlobalCloudManager.getInstance().getCallback().getApplication();
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                String tmp = applicationInfo.metaData.getString("RELEASE_TYPE");
                releaseType = EReleaseType.valueOf(tmp);
            } catch (Throwable e) {
                TimberUtils.e(e, "extract the release type error!set it to UNKNOWN");
                releaseType = UNKNOWN;
            }
        }
        return releaseType;
    }

    public static boolean isMfxBox() {
        return getReleaseType() == MFC_BOX;
    }

    public static String getLocaleString() {
        //todo MyApplication.getInstance()不可能是null吧？
        if (GlobalCloudManager.getInstance().getCallback().getApplication() != null) {
            //todo locale.toString 会包含国家编码，所以这里只使用语言编码
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                LocaleList localeList = GlobalCloudManager.getInstance().getCallback().getApplication().getResources().getConfiguration().getLocales();
                return localeList.get(0).getLanguage().toLowerCase();
            } else {
                return GlobalCloudManager.getInstance().getCallback().getApplication().getResources().getConfiguration().locale.getLanguage().toLowerCase();
            }
        } else {
            return "";
        }
    }

    public static String getSupportedLocaleString() {
        String lang = getLocaleString();
        if (!"pt".equals(lang) && !"es".equals(lang) && !"en".equals(lang)) {
            lang = "en";
        }
        return lang;
    }

    public static String dateToString(long dateLong) {
        Date date = new Date(dateLong);
        return dateToString(date);
    }

    public static String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        return sdf.format(date);
    }

    public static boolean isSameDay(long currentTime, long lastTime) {
        try {
            Calendar nowCal = Calendar.getInstance();
            Calendar dataCal = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
            Long nowLong = currentTime;
            Long dataLong = lastTime;
            String data1 = df1.format(nowLong);
            String data2 = df2.format(dataLong);
            Date now = df1.parse(data1);
            Date date = df2.parse(data2);
            nowCal.setTime(now);
            dataCal.setTime(date);
            return isSameDay(nowCal, dataCal);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 != null && cal2 != null) {
            return cal1.get(Calendar.ERA) == cal2.get(Calendar.ERA)
                    && cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR)
                    && cal1.get(Calendar.DAY_OF_YEAR) == cal2.get(Calendar.DAY_OF_YEAR);
        } else {
            return false;
        }
    }

    public static String getVersion(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    // 返回10101
    public static int getVersionCode(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            return pi.versionCode;
        } catch (Exception ex) {
            Log.e(Class.class.getName(), ex.getMessage(), ex);
            return 100;
        }
    }

    /**
     * display without ':'
     * @param mac
     * @return
     */
    public static String toShrinkMac(String mac) {
        String out = "";
        if(!TextUtils.isEmpty(mac)) {
            out = mac.trim().replaceAll("[^0-9A-Fa-f]", "").toLowerCase();
        }
        return  out;
    }

    /**
     * display with ':'
     * @param mac
     * @return
     */
    public static String toStandardMac(String mac) {
        String out = "";
        if(!TextUtils.isEmpty(mac)) {
            out = mac.trim().replaceAll("[^0-9A-Fa-f]", "").toLowerCase();
            List<String> list = new ArrayList<>();
            for(int i = 0; i <out.length()/2; i++) {
                list.add(out.substring(i*2, (i+1)*2));
            }
            out = StringUtils.join(list.toArray(), ":");
        }
        return  out;
    }

    public static String makeMD5(String password) {
        MD5Checksum md5Checksum = new MD5Checksum();
        md5Checksum.update(password);
        return md5Checksum.getChecksum();
    }

    /**long转成无符号数*/
    public static final BigDecimal longParseUnsigned(long value) {
        if (value >= 0)
            return new BigDecimal(value);
        long lowValue = value & 0x7fffffffffffffffL;
        return BigDecimal.valueOf(lowValue).add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.valueOf(1));
    }

    public static final long parseUnsignedLong(String str) {
        BigDecimal data = new BigDecimal(str);
        long l = data.subtract(new BigDecimal(Long.MAX_VALUE)).subtract(BigDecimal.valueOf(1)).longValue();
        return l | Long.MIN_VALUE;
    }

    public static int string2Int(String str) {
        try {
            return Integer.valueOf(str);
        } catch (Exception e) {
            return 0;
        }
    }

    public static String getJsonFromAssets(String fileName, Context context) {
        //将json数据变成字符串
        StringBuilder stringBuilder = new StringBuilder();

        BufferedReader bf = null;
        InputStreamReader is = null;
        try {
            is = new InputStreamReader(context.getAssets().open(fileName));
            bf = new BufferedReader(is);

            String line;
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        } catch (IOException e) {
            TimberUtils.e(e, "Error in getAssetData");
        } finally {
            try {
                is.close();
                bf.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }
}
