package com.mm.c.cloud.lib.misc.utils;

/**
 * Created by elegant.wang on 2016/11/10.
 */
public class StorageInfo {
    public String path;
    public boolean readonly;
    public boolean removable;
    public int number;

    public StorageInfo(String path, boolean readonly, boolean removable, int number) {
        this.path = path;
        this.readonly = readonly;
        this.removable = removable;
        this.number = number;
    }

    public String getDisplayName() {
        StringBuilder res = new StringBuilder();
        if (!removable) {
            res.append("Internal Storage");
        } else if (number > 1) {
            res.append("SD card " + number);
        } else {
            res.append("SD card");
        }
        if (readonly) {
            res.append(" (Read only)");
        }
        return res.toString();
    }
}
