package com.mm.c.cloud.lib.ui.dialog;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;

import com.mm.c.cloud.R;

/**
 * 自定义一个Dialog 小马欢迎界面使用
 */
public class LoadingDialog extends ProgressDialog {
    private Context context;
    private String message;

    ImageView loadingImg;
    TextView loadingMsg;

    public LoadingDialog(Context context, int theme, String message) {
        super(context, theme);
        this.context = context;
        this.message = message;
    }

    public LoadingDialog(Context context, String message) {
        super(context);
        this.context = context;
        this.message = message;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tv_loading_dialog);
        LoadingDialog.this.setProgressStyle(R.style.DialogStyle);
        setScreenBrightness();
        setCancelable(true);

//        LoadingDialog.this.setOnKeyListener(new OnKeyListener() {
//			@Override
//			public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
//				// TODO Auto-generated method stub
//				if(keyCode == KeyEvent.KEYCODE_BACK){
//					//System.exit(0);
//					((Activity)context).finish();
//					return true;
//				}
//				return false;
//			}
//		});
        loadingImg = (ImageView) LoadingDialog.this.findViewById(R.id.iv_tv_loading);
        loadingMsg = (TextView) LoadingDialog.this.findViewById(R.id.tv_tv_loading);
        this.setOnShowListener(new OnShowListener() {
            @Override
            public void onShow(DialogInterface dialog) {
//                final AnimationDrawable drawable = new AnimationDrawable();
//                drawable.addFrame(context.getResources().getDrawable(R.drawable.blank), 200);//添加图片帧到AnimationDrawable
//                drawable.addFrame(context.getResources().getDrawable(R.drawable.blank), 200);
//                drawable.addFrame(context.getResources().getDrawable(R.drawable.blank), 200);
//                drawable.addFrame(context.getResources().getDrawable(R.drawable.blank), 200);
//                drawable.addFrame(context.getResources().getDrawable(R.drawable.blank), 200);
//                drawable.setOneShot(false);//设置为循环播放
//                image.setImageDrawable(drawable);//AnimationDrawable对象给imageView
//                drawable.start();//动画播放
//                msg.setText(message);
                Animation localAnimation = AnimationUtils.loadAnimation(context, R.anim.loading_rotate);
                loadingImg.startAnimation(localAnimation);
                loadingMsg.setText(message);
            }
        });
    }


    public void setLoadingMsg(int paramInt) {
        this.message = context.getString(paramInt);
        this.loadingMsg.setText(paramInt);
    }

    public void setLoadingMsg(String paramString) {
        this.message = paramString;
        this.loadingMsg.setText(paramString);
    }

    /**
     * 此处设置亮度值。dimAmount代表黑暗数量，也就是昏暗的多少，设置为0则代表完全明亮。
     * 范围是0.0到1.0
     */
    private void setScreenBrightness() {
        Window window = getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.dimAmount = 0f;
        window.setAttributes(lp);
    }
}  