package com.mm.c.cloud.lib.ui.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

//import io.reactivex.Observable;
//import io.reactivex.android.schedulers.AndroidSchedulers;
//import io.reactivex.functions.Consumer;

import com.mm.c.cloud.R;

import me.drakeet.support.toast.ToastCompat;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;

public class ToastUtils {

    private ToastUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    // Toast对象
    private static Toast toast;

    private static String mtext = "";

    private static long start = 0;

    /**
     * 自定义Toast
     */
    public static void showToast(Context context, String text, int image) {
        try {
            if (text == null) {
                return;
            }

            Long end = System.currentTimeMillis();
/*            Logger.d(TAG, "start=" + start);
            Logger.d(TAG, "end=" + end);*/
            if (end - start < 1000 && text.equals(mtext)) {
                return;
            } else {
                start = end;
                View view = LayoutInflater.from(context).inflate(R.layout.tv_toast, null);
                TextView tv_toast = (TextView) view.findViewById(R.id.tv_smtv_toast);
                ImageView iv_toast = (ImageView) view.findViewById(R.id.iv_smtv_toast);
                tv_toast.setText(text);
                iv_toast.setBackgroundResource(image);
                Toast toast = ToastCompat.makeText(context.getApplicationContext(), text, Toast.LENGTH_LONG);
                toast.setView(view);
                toast.show();
            }
            mtext = text;
        } catch (Exception e) {
            e.printStackTrace();
            // ignore
        }
    }

    /**
     * 显示土司
     * fix the toast Repeat display by zhouchuan
     */
//    @SuppressLint("CheckResult")
//    public static void showToast(final Context context, final int text, final int image) {
//        Observable.just(1)
//                .observeOn(AndroidSchedulers.mainThread())
//                .subscribe(new Consumer<Integer>() {
//                    @Override
//                    public void accept(Integer integer) throws Exception {
//                        try {
//                            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.P) {
//                                if (toast == null) {
//                                    toast = ToastCompat.makeText(context.getApplicationContext(), text, Toast.LENGTH_LONG);
//                                    View view = LayoutInflater.from(context.getApplicationContext()).inflate(R.layout.tv_toast, null);
//                                    TextView tv_toast = (TextView) view.findViewById(R.id.tv_smtv_toast);
//                                    ImageView iv_toast = (ImageView) view.findViewById(R.id.iv_smtv_toast);
//                                    tv_toast.setText(text);
//                                    iv_toast.setBackgroundResource(image);
//                                    toast.setView(view);
//                                    toast.setDuration(Toast.LENGTH_SHORT);
//                                } else {
//                                    ((ImageView) toast.getView().findViewById(R.id.iv_smtv_toast)).setBackgroundResource(image);
//                                    ((TextView) toast.getView().findViewById(R.id.tv_smtv_toast)).setText(text);
//                                }
//                                toast.show();
//                            } else {
//                                if (null != toast) {
//                                    toast.cancel();
//                                    toast = null;
//                                }
//                                toast = ToastCompat.makeText(context.getApplicationContext(), text, Toast.LENGTH_LONG);
//                                View view = LayoutInflater.from(context.getApplicationContext()).inflate(R.layout.tv_toast, null);
//                                TextView tv_toast = (TextView) view.findViewById(R.id.tv_smtv_toast);
//                                ImageView iv_toast = (ImageView) view.findViewById(R.id.iv_smtv_toast);
//                                tv_toast.setText(text);
//                                iv_toast.setBackgroundResource(image);
//                                toast.setView(view);
//                                toast.setDuration(Toast.LENGTH_SHORT);
//                                toast.show();
//                            }
//                        } catch (Exception e) {
//                            //fix bugly bug #5431
//                            //可以将context换成applicationContext或者做异常捕获
//                            e.printStackTrace();
//                        }
//                    }
//                }, new Consumer<Throwable>() {
//                    @Override
//                    public void accept(Throwable throwable) throws Exception {
//
//                    }
//                });
//    }

    /**
     * 显示土司
     * fix the toast Repeat display by zhouchuan
     */
    @SuppressLint("CheckResult")
    public static void showToast(final Context context, final int text, final int image) {
        Observable.just(1)
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(integer -> {
                    try {
                        showToastInternal(context, text, image);
                    } catch (Exception e) {
                        //fix bugly bug #5431
                        //可以将context换成applicationContext或者做异常捕获
                        e.printStackTrace();
                    }
                }, error -> {
                    //nothing
                });
    }

    private static void showToastInternal(final Context context, final int text, final int image) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.P) {
            if (toast == null) {
                toast = ToastCompat.makeText(context.getApplicationContext(), text, Toast.LENGTH_LONG);
                View view = LayoutInflater.from(context.getApplicationContext()).inflate(R.layout.tv_toast, null);
                TextView tv_toast = (TextView) view.findViewById(R.id.tv_smtv_toast);
                ImageView iv_toast = (ImageView) view.findViewById(R.id.iv_smtv_toast);
                tv_toast.setText(text);
                iv_toast.setBackgroundResource(image);
                toast.setView(view);
                toast.setDuration(Toast.LENGTH_SHORT);
            } else {
                ((ImageView) toast.getView().findViewById(R.id.iv_smtv_toast)).setBackgroundResource(image);
                ((TextView) toast.getView().findViewById(R.id.tv_smtv_toast)).setText(text);
            }
            toast.show();
        } else {
            if (null != toast) {
                toast.cancel();
                toast = null;
            }
            toast = ToastCompat.makeText(context.getApplicationContext(), text, Toast.LENGTH_LONG);
            View view = LayoutInflater.from(context.getApplicationContext()).inflate(R.layout.tv_toast, null);
            TextView tv_toast = (TextView) view.findViewById(R.id.tv_smtv_toast);
            ImageView iv_toast = (ImageView) view.findViewById(R.id.iv_smtv_toast);
            tv_toast.setText(text);
            iv_toast.setBackgroundResource(image);
            toast.setView(view);
            toast.setDuration(Toast.LENGTH_SHORT);
            toast.show();
        }
    }
}
