package com.mm.c.cloud.manager;

import android.app.Application;
import android.content.Context;

import java.io.File;

public interface CloudCallback {

    String getToken();

    int getAccountType();

    long getAccountId();

    long getUserId();

    String getUserKey();

    String getRegion();

    int getAppVersion();

    void doAutherServerPing();

    Application getApplication();

    String getAppWebHost();

    String getCloudSyncHost();

    String getNsHost();

    String getDetectedCountryCode();

    String getHost();

    long getVendorId();

    String getST();

    String getMAC();

    boolean isLoggedIn();

    String decryptString(String cipher) throws Exception;

    String encryptString(String plain) throws Exception;

    String sign(String message);

    String getUpKey();

    String getDataKey();

    String getApiServerKey();

    String getApiServerKey2();

    int checkSelfPermission(Context context,String permission);

    boolean isHot();

    void deleteAccountDownload(String site, String account);

    String getPublicDir();

    String getExternalDir();
}
