package com.mm.c.cloud.server;

import com.mm.c.cloud.BuildConfig;
import com.mm.c.cloud.lib.api.RetrofitErrorHandler;
import com.mm.c.cloud.lib.api.UrlProvider;
import com.mm.c.cloud.help.RetrofitHelper;
import com.squareup.okhttp.OkHttpClient;

import java.net.CookieManager;

import retrofit.RestAdapter;
import retrofit.client.OkClient;

abstract public class BaseServer<T> {

    private T api;
    private T ssoApi;
    private Class<T> tClass;

    public BaseServer(Class<T> tClass) {
        this.tClass = tClass;
    }

    protected abstract UrlProvider getProvider();

    protected T getSsoApi() {
        if (ssoApi == null) {
            UrlProvider provider = getProvider();
            OkHttpClient client = RetrofitHelper.clientSsoCipher(provider);
            RestAdapter restAdapter = new RestAdapter.Builder()
                    .setEndpoint(provider.url())
                    .setClient(new OkClient(client))
                    .setErrorHandler(new RetrofitErrorHandler())
                    .setLogLevel(BuildConfig.DEBUG ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE)
                    .build();
            ssoApi = restAdapter.create(tClass);
        }
        return ssoApi;
    }

    protected T getSsoApiWithCookie() {
        if (ssoApi == null) {
            UrlProvider provider = getProvider();
            OkHttpClient client = RetrofitHelper.clientSsoCipher(provider);
            client.setCookieHandler(new CookieManager());
            RestAdapter restAdapter = new RestAdapter.Builder()
                    .setEndpoint(provider.url())
                    .setClient(new OkClient(client))
                    .setErrorHandler(new RetrofitErrorHandler())
                    .setLogLevel(BuildConfig.DEBUG ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE)
                    .build();
            ssoApi = restAdapter.create(tClass);
        }
        return ssoApi;
    }

    //暂时性 for Auth OP：bind / recharge
//    private T ssoTmpApi;

//    protected T getSsoTmpApi() {
//        if (ssoTmpApi == null) {
//            UrlProvider provider = getProvider();
//            OkHttpClient client = RetrofitHelper.clientSsoCipher(provider);
//            client.interceptors().add(0, new AuthExceptionInterceptor());
//            RestAdapter restAdapter = new RestAdapter.Builder()
//                    .setEndpoint(provider.url())
//                    .setClient(new OkClient(client))
//                    .setErrorHandler(new RetrofitErrorHandler())
//                    .setLogLevel(BuildConfig.DEBUG ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE)
//                    .build();
//            ssoTmpApi = restAdapter.create(tClass);
//        }
//        return ssoTmpApi;
//    }


//    protected T getApi() {
//        if (api == null) {
//            UrlProvider provider = getProvider();
//            OkHttpClient client = RetrofitHelper.clientCipher(provider);
//            RestAdapter restAdapter = new RestAdapter.Builder()
//                    .setEndpoint(provider.url())
//                    .setClient(new OkClient(client))
//                    .setErrorHandler(new RetrofitErrorHandler())
//                    .build();
//            api = restAdapter.create(tClass);
//        }
//        return api;
//    }

    protected T getBasicApi() {
        OkHttpClient okHttpClient = RetrofitHelper.createOkHttpClient();
        RestAdapter restAdapter = new RestAdapter.Builder()
                .setEndpoint(getProvider().url())
                .setClient(new OkClient(okHttpClient))
                .setErrorHandler(new RetrofitErrorHandler())
                .setLogLevel(BuildConfig.DEBUG ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE)
                .build();
        return restAdapter.create(tClass);
    }
}