package com.mm.c.cloud.server;

import com.mm.c.cloud.lib.api.UrlProvider;
import com.mm.c.cloud.lib.api.ns.NSUpdateListener;
import com.mm.c.cloud.help.NSManager;

import java.util.ArrayList;
import java.util.List;

public class HostProvider implements NSUpdateListener, UrlProvider {
    private List<String> servers;
    private List<String> dftServers = new ArrayList<>();
    private int currentIndex;

    public HostProvider(String type, List<String> servers) {
        this.servers = servers;
        if (servers != null) {
            this.dftServers = servers;
        }
        this.currentIndex = 0;
        NSManager.getInstance().addNSListener(type, this, servers);
    }

    @Override
    public void onUpdate(List<String> servers) {
        if (servers == null || servers.isEmpty()) {
            return;
        }
        if (this.servers == null) {
            this.servers = servers;
        } else {
            List<String> newServers = new ArrayList<>(servers);
            for (String server : this.dftServers) {
                if (newServers.contains(server)) {
                    continue;
                }
                newServers.add(server);
            }
            this.servers = newServers;
        }
    }

    public void merge(List<String> servers) {
        if (servers == null || servers.isEmpty()) {
            return;
        }
        if (this.servers == null) {
            this.servers = servers;
        } else {
            List<String> newServers = new ArrayList<>(servers);
            for (String server : this.servers) {
                if (newServers.contains(server)) {
                    continue;
                }
                newServers.add(server);
            }
            this.servers = newServers;
        }
        dftServers.addAll(servers);
    }

    @Override
    public String url() {
        if (servers != null && !servers.isEmpty()) {
            return servers.get(currentIndex);
        }
        return "";
    }

    @Override
    public String nextUrl(String currentUrl) {
        if (servers == null || servers.isEmpty()) {
            return currentUrl;
        }
        if (++currentIndex >= servers.size()) {
            currentIndex = 0;
        }
        return servers.get(currentIndex);
    }
}
