package com.mm.c.cloud.server;

import android.os.Build;

import com.google.gson.JsonObject;
import com.mm.c.cloud.help.DeviceManager;
import com.mm.c.cloud.help.UrlUtils;
import com.mm.c.cloud.help.Utils;
import com.mm.c.cloud.lib.api.profile.model.HotKey;
import com.mm.c.cloud.lib.api.response.ResponseDataList;
import com.mm.c.cloud.lib.api.response.ResponseDataSingle;
import com.mm.c.cloud.lib.api.service.MetaDataServerServiceAsync;
import com.mm.c.cloud.lib.device.DeviceInfo;
import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.lib.eventbus.BusProvider;
import com.mm.c.cloud.lib.eventbus.event.PreferencesChangeEvent;
import com.mm.c.cloud.lib.logger.LogUtils;
import com.mm.c.cloud.lib.metric.MetricData;
import com.mm.c.cloud.lib.metric.MetricManager;
import com.mm.c.cloud.lib.metric.model.MetricAction;
import com.mm.c.cloud.lib.metric.model.MetricType;
import com.mm.c.cloud.lib.misc.crypto.AppKeyUtilAndroid;
import com.mm.c.cloud.lib.misc.utils.MiscUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.valor.mfc.vms.api.common.encrypt.AppKey;
import com.valor.mfc.vms.api.model.cloud.CloudPlaySourceDo;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import com.valor.mfc.vms.api.model.constant.EMetaSource;
import com.valor.mfc.vms.api.model.filter.FilterCriteriaDo;
import com.valor.mfc.vms.api.model.filter.FilterDo;
import com.valor.mfc.vms.api.model.linked.common.LinkedAcctDo;
import com.valor.mfc.vms.api.model.linked.request.LinkedCheckReq;
import com.valor.mfc.vms.api.model.linked.request.LinkedSyncReq;
import com.valor.mfc.vms.api.model.linked.request.LinkedSyncReqV2;
import com.valor.mfc.vms.api.model.linked.response.LinkedAcctMetaDo;
import com.valor.mfc.vms.api.model.linked.response.LinkedCheckRsp;
import com.valor.mfc.vms.api.model.linked.response.LinkedSyncStatusDo;
import com.valor.mfc.vms.api.model.meta.base.v1.BaseMetaDO;
import com.valor.mfc.vms.api.model.meta.media.v1.ArtworkDO;
import com.valor.mfc.vms.api.model.meta.media.v1.CastDO;
import com.valor.mfc.vms.api.model.meta.media.v1.MediaAwardDo;
import com.valor.mfc.vms.api.model.meta.media.v1.MediaMetaDo;
import com.valor.mfc.vms.api.model.meta.media.v1.ParentsGuideDo;
import com.valor.mfc.vms.api.model.meta.media.v1.SynopsisMetaDO;
import com.valor.mfc.vms.api.model.meta.media.v1.TrailerDO;
import com.valor.mfc.vms.api.model.meta.media.v1.UserReviewMetaDO;
import com.valor.mfc.vms.api.model.meta.media.v1.VideoMetaDO;
import com.valor.mfc.vms.api.model.meta.person.v1.PersonDetailMetaDO;
import com.valor.mfc.vms.api.model.meta.playlist.v1.PlaylistVideosDO;
import com.valor.mfc.vms.api.model.ui.UIConfigDo;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.io.IOException;
import java.util.HashMap;

import retrofit.Callback;
import retrofit.RetrofitError;
import rx.Observable;

/**
 * Created by sunny on 2015/10/5.
 */
public class MetaDataServerAsync extends BaseServer<MetaDataServerServiceAsync> {
    private static final String TAG = MetaDataServerAsync.class.getSimpleName();
    private static final String R_LINKED_STATUS = "LINKED_STATUS";// query result flag key
    private final static String KEY = "a7SDfrdDKRBe5FaN2n3Gfg==";
    private static MetaDataServerAsync instance;
    private int appVer;
    private DeviceInfo deviceInfo;
    private String region;
    private HostProvider provider;

    private MetaDataServerAsync() {
        super(MetaDataServerServiceAsync.class);
        region = GlobalCloudManager.getInstance().getCallback().getDetectedCountryCode();
        appVer = GlobalCloudManager.getInstance().getCallback().getAppVersion();
        BusProvider.getInstance().register(this);
    }

    private String getAppKey() {
        AppKey appKey = new AppKey();
        String mac = HardwareInfo.getInstance().getUserMac();
        Long userId = GlobalCloudManager.getInstance().getCallback().getUserId();
        appKey.setMacaddr(mac);
        appKey.setUserid(userId);
        appKey.setTimestamp(System.currentTimeMillis());
        return AppKeyUtilAndroid.encrypt(appKey, KEY).trim();
        //return AppKeyUtil.encrypt(appKey, KEY);
    }

    private String getDid() {
        return HardwareInfo.getInstance().getUserMac();
    }

    private String getUid() {
        return String.valueOf(GlobalCloudManager.getInstance().getCallback().getUserId());
    }

    /**
     * 获取国家
     */
    public String getCountry() {
        return GlobalCloudManager.getInstance().getCallback().getDetectedCountryCode();
    }


    /**
     * 获取语言
     */
    private String getLanguage() {
        return MiscUtils.getLocaleString();
    }

    /**
     * 获取设备信息
     */
    private String getDeviceInfoStr() {
        return DeviceManager.getInstance().getDeviceInfoStr();
    }

    private DeviceInfo getDeviceInfo() {
        if (deviceInfo == null) {
            deviceInfo = DeviceManager.getInstance().getDeviceInfo();
        }
        return deviceInfo;
    }

    private String getImeiId() {
        return HardwareInfo.getInstance().getImei();
    }

    private String getAndroidId() {
        return HardwareInfo.getInstance().getAndroidId();
    }

    // 需要token认证的api接口
    // sso相关的接口，不需token认证
    // 数据等api
    private MetaDataServerServiceAsync getMetaDataServerService() {
        return getSsoApi();
    }


    //设置拦截
    private Interceptor setInterceptor(final String path) {
        Interceptor interceptor = new Interceptor() {
            @Override
            public Response intercept(Chain chain) throws IOException {
                Request request = chain.request();
                boolean hasNetWork = Utils.hasNetwork(GlobalCloudManager.getInstance().getCallback().getApplication());
                if (!hasNetWork) {
                    request = request.newBuilder()
                            .cacheControl(CacheControl.FORCE_CACHE)
                            .url(path).build();
                }

                Response response = chain.proceed(request);
                if (hasNetWork) {
                    int maxAge = 60 * 60 * 60; // read from cache for 60 minute
                    response.newBuilder()
                            .removeHeader("Pragma")
                            .header("Cache-Control", "public, max-stale =" + maxAge)
                            .build();
                } else {
                    int maxStale = 60 * 60 * 24; // tolerate 1-weeks stale
                    response.newBuilder()
                            .removeHeader("Pragma")
                            .header("Cache-Control", "public ,  max-stale =" + maxStale)
                            .build();
                }
                return response;
            }
        };
        return interceptor;
    }

    public static MetaDataServerAsync getInstance() {
        if (instance == null) {
            synchronized (KEY) {
                if (instance == null) {
                    instance = new MetaDataServerAsync();
                }
            }
        }
        return instance;
    }

    public Observable<ResponseDataList<UIConfigDo>> getUICfg() {
        return getMetaDataServerService().getUICfg(commonParams());
    }

    public Observable<ResponseDataSingle<PlaylistVideosDO>> getPlayListVideos(long playListID) {
        MetricManager.getInstance().put(MetricAction.MFC_APP_PAGE_ACTION,
                new MetricData.Builder()
                        .put("actionType", MetricType.BROWSE)
                        .put("actionDetail", playListID + "")
                        .build());
        return getMetaDataServerService().getPlayListVideos(commonParams(), playListID, R_LINKED_STATUS);
    }

    public void getPlayListVideos(long playListID, int pageID, int pageSize,
                                  Callback<ResponseDataSingle<PlaylistVideosDO>> callback) {
        getMetaDataServerService().getPlayListVideos(commonParams(), playListID, pageID, pageSize, R_LINKED_STATUS,callback);
    }

    public void getPlayListVideos(long playListID, String name, int pageID, int pageSize, boolean linked, Callback<ResponseDataSingle<PlaylistVideosDO>> callback) {
        LogUtils.i(TAG, "getPlayListVideos...");
        if(1 == pageID) {// report metric when request first page data
            MetricManager.getInstance().put(MetricAction.MFC_APP_PAGE_ACTION,
                    new MetricData.Builder()
                            .put("actionType", MetricType.BROWSE)
                            .put("actionDetail", playListID + "")
                            .build());
        }
        getMetaDataServerService().getPlayListVideos(commonParams(), playListID, name, pageID, pageSize, linked ? 1 : 0, R_LINKED_STATUS, new Callback<ResponseDataSingle<PlaylistVideosDO>>() {
            @Override
            public void success(ResponseDataSingle<PlaylistVideosDO> playlistVideosDOResponseDataSingle, retrofit.client.Response response) {
                if(null != callback) {
                    callback.success(playlistVideosDOResponseDataSingle, response);
                }
            }

            @Override
            public void failure(RetrofitError error) {
                if(null != callback) {
                    callback.failure(error);
                }
            }
        });
    }

    public void getRecommendVideos(long videoID, EMetaSource metaSource, String exMetaID, Callback<ResponseDataList<BaseMetaDO>> callback) {
        getMetaDataServerService().getRecommendVideo(commonParams(), videoID, metaSource, exMetaID, R_LINKED_STATUS, callback);
    }

    /**
     * 查询人物的详细信
     */
    public void getPersonDetailMetaDO(String exPersonId,long personBaseID, int pagesize, String appendResult, final Callback<ResponseDataSingle<PersonDetailMetaDO>> callback) {
        getMetaDataServerService().getPersonDetailMetaDO(commonParams(), exPersonId,personBaseID, pagesize, appendResult, callback);
    }

    public void getPersonFilmographies(long personBaseID, int pageId, int pagesize, String videoType, int released, final Callback<ResponseDataList<BaseMetaDO>> callback) {
        getMetaDataServerService().getPersonFilmographies(commonParams(), personBaseID, pageId, pagesize, R_LINKED_STATUS,videoType, released, callback);
    }

    public void getEpisodesInfoEx(int pageId, int pageSize, long seriesId, long seasonId, String episodeOrder, Callback<ResponseDataList<VideoMetaDO>> callback) {
        getMetaDataServerService().getEpisodesInfoEx(commonParams(), pageId, pageSize, seriesId, seasonId, episodeOrder, R_LINKED_STATUS, callback);
    }

    //Upload linked resources to server side. aka connected resource
    public Observable<ResponseDataSingle<LinkedAcctDo>> uploadLinkedRes(LinkedSyncReq req) {
        return getMetaDataServerService().uploadLinkedRes(commonParams(), req);
    }

    public Observable<ResponseDataSingle<LinkedSyncStatusDo>> linkedSync(LinkedSyncReqV2 req) {
        return getMetaDataServerService().linkedSync(req, commonParams());
    }

    public Observable<ResponseDataList<LinkedSyncStatusDo>> linkedSyncState(long batchNumber, long serialNumber) {
        return getMetaDataServerService().linkedSyncState(getUid(), batchNumber, serialNumber, appVer, getCountry(), getLanguage());
    }

    //Get linked resources from server side. aka connected resource
    public Observable<ResponseDataList<LinkedAcctMetaDo>> getLinkedRes(String site, String account, boolean includeDetail) {
        return getMetaDataServerService().getLinkedRes(commonParams(),site, account, includeDetail ? 1 : 0);
    }


    public Observable<ResponseDataSingle<LinkedCheckRsp>> checkLinkedRes(LinkedCheckReq req) {
        return getMetaDataServerService().checkLinkedRes(appVer, req, getCountry(), getLanguage());
    }

    //Get linked resources' checksums from server side. aka connected resource
    public Observable<ResponseStatus> removeLinkedAcct(String site, String account) {
        return getMetaDataServerService().removeLinkedAcct(commonParams(),site, account);
    }

    public void getFilterCriteria(String playlistId, String videoType, Callback<ResponseDataSingle<FilterCriteriaDo>> callback) {
        getMetaDataServerService().getFilterCriteria(commonParams(), playlistId, videoType, callback);
    }

    public void getFilterCriteria2(String playlistId, String videoType, Callback<ResponseDataList<FilterDo>> callback){
        getMetaDataServerService().getFilterCriteria2(commonParams(), playlistId, videoType, callback);
    }

    public void getVideoDetail(long videoId, EMetaSource exMetaSource, String exMetaID, Callback<ResponseDataSingle<MediaMetaDo>> callback) {
        getMetaDataServerService().getVideoDetail(commonParams(), videoId, exMetaSource, exMetaID, R_LINKED_STATUS, "ARTWORK,TRAILER,CAST", callback);
    }

    public void getTrailer(long videoId, EMetaSource exMetaSource, String exMetaID, Callback<ResponseDataList<TrailerDO>> callback) {
        getMetaDataServerService().queryTrailer(commonParams(), videoId, exMetaSource, exMetaID, callback);
    }

    public void getCast(long videoId, EMetaSource exMetaSource, String exMetaID, int maxDirectors, int maxStars, Callback<ResponseDataSingle<CastDO>> callback) {
        getMetaDataServerService().queryCast(commonParams(), videoId, exMetaSource, exMetaID, maxDirectors, maxStars,callback);
    }

    public void getArtwork(long videoId, EMetaSource exMetaSource, String exMetaID, Callback<ResponseDataList<ArtworkDO>> callback) {
        getMetaDataServerService().queryArtwork(commonParams(), videoId, exMetaSource, exMetaID, callback);
    }

    public void getCriticReviews(long videoId, Callback<ResponseDataList<MediaAwardDo>> callback){
        getMetaDataServerService().getCriticReviews(commonParams(), videoId, getLanguage(), callback);
    }

    public void getVideoUserReviews(long videoId, Callback<ResponseDataList<UserReviewMetaDO>> callback) {
        getMetaDataServerService().getVideoUserReviews(commonParams(), videoId, callback);
    }

    public void getVideoSynopsis(long videoId, Callback<ResponseDataSingle<SynopsisMetaDO>> callback) {
        getMetaDataServerService().getVideoSynopsis(commonParams(), videoId, callback);
    }

    public void getFilter(String type, String playlistId, String filter, boolean isLinked, int pageID, int pageSize, Callback<ResponseDataList<BaseMetaDO>> callback) {
        LogUtils.i(TAG, "getFilter.....");
        getMetaDataServerService().getVideoFilter(commonParams(), type, playlistId, filter, isLinked ? 1 : 0, pageID, pageSize, R_LINKED_STATUS,callback);
    }


    public void queryParentGuide(long videoId, String exMetaID, EMetaSource exMetaSource, Callback<ResponseDataList<ParentsGuideDo>> callback) {
        getMetaDataServerService().queryParentGuide(commonParams(), videoId, exMetaID, exMetaSource, callback);
    }

    public void getBaseMetaByIds(String videoIds, Callback<ResponseDataList<BaseMetaDO>> callback) {
        //id  idtype != 1
        getMetaDataServerService().getBaseMetaByIds(commonParams(),videoIds, 0,R_LINKED_STATUS, callback);
    }

    public Observable<ResponseDataList<BaseMetaDO>> rxQueryBaseMetaByIds(String videoIds) {
        //imdbid  idtype = 1
        return getMetaDataServerService().rxQueryBaseMetaByIds(commonParams(),videoIds,1, R_LINKED_STATUS);
    }


    public Observable<JsonObject> getSubtitlesStatus(int appVer, String metaId, Integer seasonId, Integer episodeId) {
        return getMetaDataServerService().getSubtitlesStatus(commonParams(), metaId, seasonId, episodeId);
    }

    public void reportSubtitlesSetting(int appVer, String metaId, Integer seasonId, Integer episodeId, String language, Callback<ResponseStatus> callback) {
        getMetaDataServerService().reportSubtitlesSetting(commonParams(), metaId, language,seasonId, episodeId,callback);
    }

    public void getPlaySource(long videoId, int season, int episode, String displayMode, Callback<ResponseDataList<CloudPlaySourceDo>> callback) {
        getMetaDataServerService().getPlaySource(commonParams(),videoId, season == -1 ? 1 : season, episode == -1 ? 1 : episode, displayMode, GlobalCloudManager.getInstance().getCallback().getST(), GlobalCloudManager.getInstance().getCallback().getAccountType(), GlobalCloudManager.getInstance().getCallback().getAccountId(), callback);
//        for (String ip:new String[]{"47.88.16.4","47.88.18.26","198.11.179.217","198.11.179.205"}) {
//            Pair<CloudRefreshServerApi, Callback<ResponseDataList<CloudPlaySourceDo>>> pair = getPair(ip);
//            pair.first.getPlaySource(videoId, season == -1 ? 1 : season, episode == -1 ? 1 : episode, displayMode, UserManager.getInstance().getST(), getUid(), appVer, getLanguage(), getRegion(), pair.second);
//        }
    }

    public Observable<ResponseDataList<HotKey>> fetchHotKey(){
        return getMetaDataServerService().fetchHotKey(commonParams());
    }


    /*-----------------------------------------公共参数---------------------------------------*/
    private HashMap<String, String> commonParams(){
        HashMap<String, String> map = new HashMap<>();
        map.put("did", getDid());
        map.put("uid", getUid());
        map.put("appVer", appVer + "");
        map.put("region", getCountry());
        map.put("language", getLanguage());
        map.put("di", getDeviceInfoStr());
        map.put("androidId", getAndroidId());
        map.put("imeiId", getImeiId());
        map.put("channel", MiscUtils.getReleaseType().toString());

        //2019.7.10 原因: 后端要去 为不同渠道品牌定制化节目
        map.put("model", Build.MODEL);
        map.put("brand", Build.BRAND);
        map.put("vendor", "" + GlobalCloudManager.getInstance().getCallback().getVendorId());

        if(getDeviceInfo()!=null){
            map.put("cpuId", getDeviceInfo().getCpuSerial());
            map.put("e_mac", getDeviceInfo().getEthernetMac());
            map.put("w_mac", getDeviceInfo().getWifiMac());
            map.put("b_mac", getDeviceInfo().getBluetoothMac());
            map.put("sdk", getDeviceInfo().getSdk()+"");
            map.put("display", getDeviceInfo().getBuildDisplay());
            map.put("fingerprint", getDeviceInfo().getBuildFingerprint());
            map.put("manufacturer", getDeviceInfo().getProductManufacturer());
        }
        return map;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPreferenceEvent(PreferencesChangeEvent event) {
        provider.merge(UrlUtils.getHost());
    }

    @Override
    protected HostProvider getProvider() {
        provider = new HostProvider("api", UrlUtils.getHost());
        return provider;
    }
}

