package com.mm.c.cloud.sign;

import android.util.Base64;

import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.misc.crypto.AESCodecAndroid;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.valor.mfc.vms.api.common.client.AccessKeyTools;
import com.valor.mfc.vms.api.common.client.ActKey;
import com.valor.mfc.vms.api.common.client.SessionKey;

/**
 * Created by elegant.wang on 2016/7/16.
 */
public class SsoKey {

    public static final String APP_CERT_AES_KEY_CIPHER = "OUiIw7F5xWPNpWfZlfvHwJZDfN0z32yfqIfFByprxrU=";
    public static final String APP_CERT_PUBLIC_CIPHER = "RzmlRld+YjDhvrfeG5Mqio6CQ1KsjzxeFJOgaKvlyRzCE2qE/HUSRwtYM3gccn09QJ9K86p64GTh7vjslrGyRABmL+MLCf2te8cZKlLQeUgNYU3YlyT+pWXQCM7an3LGOX0UIHUcKx5HVQZOmSdYHucJAn45tsLdykmyTKOUgra7QSb6G3HrwO3Uop30bxapl7qgFgXZx18zAnwL3pVIzLxzwamKcx/qUF7C1xIl3sw=";
    public static final int BASE64_FLAG = Base64.URL_SAFE | Base64.NO_WRAP;

    // encryption 加密
    // ciphertext 密文
    // plaintext 明文
    public static String APP_CERT_AES_KEY = "";
    public static String APP_CERT_PUBLIC = "";

    // 载入前初始化密钥
    static {
        try {
            APP_CERT_AES_KEY = GlobalCloudManager.getInstance().getCallback().decryptString(APP_CERT_AES_KEY_CIPHER);
            APP_CERT_PUBLIC = GlobalCloudManager.getInstance().getCallback().decryptString(APP_CERT_PUBLIC_CIPHER);
        } catch (Exception e) {
            TimberUtils.e(e, "SsoKey static init error");
            //throw new RuntimeException(e);
        }
    }

    public static String getAppCertPublicKey() throws Exception {
        String key = AESCodecAndroid.decrypt(APP_CERT_PUBLIC, APP_CERT_AES_KEY);
        return key;
    }

    public static byte[] getAppCertPublicKeyBytes() throws Exception {
        return Base64.decode(getAppCertPublicKey(), BASE64_FLAG);
    }

    public static String getActKey(String did, String sha1Password) throws Exception {
        ActKey actKey = new ActKey();
        actKey.setDid(did);
        actKey.setSha1Pwd(sha1Password);
        byte[] rsaKey = Base64.decode(getAppCertPublicKey(), BASE64_FLAG);
        byte[] cipher = AccessKeyTools.getActKey(actKey, rsaKey);
        return Base64.encodeToString(cipher, BASE64_FLAG);
    }

    public static String getSessionKey(String did, String userKey) throws Exception {
        SessionKey sessionKey = new SessionKey();
        sessionKey.setDid(did);
        sessionKey.setUserKey(userKey);
        return Base64.encodeToString(AccessKeyTools.getSessionKey(sessionKey, getAppCertPublicKeyBytes()), BASE64_FLAG);
    }

}
