package mm.vod.lib.geoip;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import mm.vod.lib.geoip.freegeoip.FreeGeoIPProvider;
import mm.vod.lib.geoip.ipapi.IPApiGeoIPProvider;
import mm.vod.lib.geoip.ipinfo.IPInfoGeoIPProvider;
import mm.vod.lib.geoip.model.GeoIP;

/**
 * Location GeoIP Manager
 */
public class GeoIPManager {

    private List<GeoIPProvider> ipProviders = new ArrayList<>();

    private GeoIPManager() {
        ipProviders.add(FreeGeoIPProvider.getInstance());
        ipProviders.add(IPApiGeoIPProvider.getInstance());
        ipProviders.add(IPInfoGeoIPProvider.getInstance());
    }

    private static class Holder {
        private static final GeoIPManager INSTANCE = new GeoIPManager();
    }

    public static final GeoIPManager getInstance() {
        return GeoIPManager.Holder.INSTANCE;
    }

    private int index() {
        Random r = new Random();
        return r.nextInt(ipProviders.size());
    }

    public Observable<GeoIP> getGeoIP(final String ip) {
        final int idx = index() % ipProviders.size();
        return ipProviders.get(idx).getGeoIP(ip)
                .retryWhen(new Function<Observable<Throwable>, ObservableSource<GeoIP>>() {
                    @Override
                    public ObservableSource<GeoIP> apply(Observable<Throwable> throwableObservable) throws Exception {
                        return throwableObservable.flatMap(new Function<Throwable, ObservableSource<GeoIP>>() {
                            @Override
                            public ObservableSource<GeoIP> apply(Throwable throwable) throws Exception {
                                int i = (idx + 1) % ipProviders.size();
                                return ipProviders.get(i).getGeoIP(ip)
                                        .retryWhen(new Function<Observable<Throwable>, ObservableSource<GeoIP>>() {
                                            @Override
                                            public ObservableSource<GeoIP> apply(Observable<Throwable> throwableObservable) throws Exception {
                                                return throwableObservable.flatMap(new Function<Throwable, ObservableSource<GeoIP>>() {
                                                    @Override
                                                    public ObservableSource<GeoIP> apply(Throwable throwable) throws Exception {
                                                        int i = (idx + 2) % ipProviders.size();
                                                        return ipProviders.get(i).getGeoIP(ip);
                                                    }
                                                });
                                            }
                                        });
                            }
                        });
                    }
                });

    }

    public Observable<GeoIP> getGeoIP() {
        return getGeoIP("");
    }

}
