package mm.vod.lib.geoip.freegeoip;

import java.util.Map;

import mm.vod.lib.geoip.GeoIPProvider;
import mm.vod.lib.geoip.model.GeoIP;

/**
 * Created by Larry on 2016/6/14.
 */
public class FreeGeoIPProvider extends GeoIPProvider {
    private final static String HOST = "https://freegeoip.app";

    private FreeGeoIPProvider() {
    }

    private static class Holder {
        private static final FreeGeoIPProvider INSTANCE = new FreeGeoIPProvider();
    }

    public static final FreeGeoIPProvider getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    protected String getBaseUrl() {
        return HOST;
    }

    @Override
    protected GeoIP convertToGeoIP(Map<String, String> ipInfo) {
        GeoIP geoIP = new GeoIP();
        geoIP.setIp(ipInfo.get("ip"));
        geoIP.setCountryCode(ipInfo.get("country_code"));
        geoIP.setCountryName(ipInfo.get("country_name"));
        geoIP.setLatitude(ipInfo.get("latitude"));
        geoIP.setLongitude(ipInfo.get("longitude"));
        geoIP.setMetroCode(ipInfo.get("metro_code"));
        geoIP.setRegionCode(ipInfo.get("region_code"));
        geoIP.setRegionName(ipInfo.get("region_name"));
        geoIP.setTimeZone(ipInfo.get("time_zone"));
        geoIP.setZipCode(ipInfo.get("zip_code"));
        geoIP.setCity(ipInfo.get("city"));
        return geoIP;
    }
}
