package mm.vod.lib.geoip.ipinfo;

import java.util.Map;

import mm.vod.lib.geoip.GeoIPProvider;
import mm.vod.lib.geoip.model.GeoIP;

/**
 * Created by zhangyaoa on 2018/7/24.
 */

public class IPInfoGeoIPProvider extends GeoIPProvider {
    private final static String HOST = "http://ipinfo.io";

    private IPInfoGeoIPProvider() {
    }

    private static class Holder {
        private static final IPInfoGeoIPProvider INSTANCE = new IPInfoGeoIPProvider();
    }

    public static final IPInfoGeoIPProvider getInstance() {
        return IPInfoGeoIPProvider.Holder.INSTANCE;
    }

    @Override
    protected String getBaseUrl() {
        return HOST;
    }

    @Override
    protected GeoIP convertToGeoIP(Map<String, String> ipInfo) {
        GeoIP geoIP = new GeoIP();
        geoIP.setIp(ipInfo.get("ip"));
        geoIP.setCountryCode(ipInfo.get("country"));
        geoIP.setCountryName(ipInfo.get("country"));
        geoIP.setLatitude(ipInfo.get("loc"));
        geoIP.setLongitude(ipInfo.get("loc"));
        geoIP.setMetroCode(ipInfo.get("metro_code"));
        geoIP.setRegionCode(ipInfo.get("region"));
        geoIP.setRegionName(ipInfo.get("region"));
        geoIP.setTimeZone(ipInfo.get("timezone"));
        geoIP.setZipCode(ipInfo.get("zip"));
        geoIP.setCity(ipInfo.get("city"));
        return geoIP;
    }
}
