/*
 * Decompiled with CFR 0.152.
 */
package mm.vod.lib.geoip;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mm.vod.lib.geoip.GeoIPProvider;
import mm.vod.lib.geoip.freegeoip.FreeGeoIPProvider;
import mm.vod.lib.geoip.ipapi.IPApiGeoIPProvider;
import mm.vod.lib.geoip.ipinfo.IPInfoGeoIPProvider;
import mm.vod.lib.geoip.model.GeoIP;

public class GeoIPManager {
    private List<GeoIPProvider> ipProviders = new ArrayList<GeoIPProvider>();

    private GeoIPManager() {
        this.ipProviders.add(FreeGeoIPProvider.getInstance());
        this.ipProviders.add(IPApiGeoIPProvider.getInstance());
        this.ipProviders.add(IPInfoGeoIPProvider.getInstance());
    }

    public static final GeoIPManager getInstance() {
        return Holder.INSTANCE;
    }

    private int index() {
        Random r = new Random();
        return r.nextInt(this.ipProviders.size());
    }

    public Observable<GeoIP> getGeoIP(final String ip) {
        final int idx = this.index() % this.ipProviders.size();
        return this.ipProviders.get(idx).getGeoIP(ip).retryWhen((Function)new Function<Observable<Throwable>, ObservableSource<GeoIP>>(){

            public ObservableSource<GeoIP> apply(Observable<Throwable> throwableObservable) throws Exception {
                return throwableObservable.flatMap((Function)new Function<Throwable, ObservableSource<GeoIP>>(){

                    public ObservableSource<GeoIP> apply(Throwable throwable) throws Exception {
                        int i = (idx + 1) % GeoIPManager.this.ipProviders.size();
                        return ((GeoIPProvider)GeoIPManager.this.ipProviders.get(i)).getGeoIP(ip).retryWhen((Function)new Function<Observable<Throwable>, ObservableSource<GeoIP>>(){

                            public ObservableSource<GeoIP> apply(Observable<Throwable> throwableObservable) throws Exception {
                                return throwableObservable.flatMap((Function)new Function<Throwable, ObservableSource<GeoIP>>(){

                                    public ObservableSource<GeoIP> apply(Throwable throwable) throws Exception {
                                        int i = (idx + 2) % GeoIPManager.this.ipProviders.size();
                                        return ((GeoIPProvider)GeoIPManager.this.ipProviders.get(i)).getGeoIP(ip);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public Observable<GeoIP> getGeoIP() {
        return this.getGeoIP("");
    }

    private static class Holder {
        private static final GeoIPManager INSTANCE = new GeoIPManager();

        private Holder() {
        }
    }
}

