package mm.vod.lib.geoip;

import java.util.Map;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import mm.vod.lib.geoip.inner.RetrofitFactory;
import mm.vod.lib.geoip.model.GeoIP;

/**
 * Created by Larry on 2016/6/14.
 */
public abstract class GeoIPProvider {

    private GeoIPApi api;

    protected abstract String getBaseUrl();

    private GeoIPApi getApi() {
        if(null == api) {
            api = RetrofitFactory.getInstance().create(getBaseUrl(), GeoIPApi.class);
        }
        return api;
    }

    protected abstract GeoIP convertToGeoIP(Map<String, String> ipInfo);

    public Observable<GeoIP> getGeoIP(String ip) {
        return getApi().getGeoIP(ip)
                .map(new Function<Map<String, String>, GeoIP>() {
                    @Override
                    public GeoIP apply(Map<String, String> map) throws Exception {
                        return convertToGeoIP(map);
                    }
                });
    }
}
