package mm.vod.m.meta;

import androidx.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import mm.vod.m.meta.inner.DefaultConfig;
import mm.vod.m.meta.inner.Utils;

public class MetaConfig {

    private List<String> hosts;
    Callback callback;
    private long readTimeout;
    private long connnectTimeout;

    public List<String> getHosts() {
        return hosts;
    }

    public long getReadTimeout() {
        return readTimeout;
    }

    public long getConnnectTimeout() {
        return connnectTimeout;
    }

    public Callback getCallback() {
        return callback;
    }

    public static class Builder {
        private MetaConfig config;

        private Builder() {}

        @NonNull
        public static Builder create() {
            Builder builder = new Builder();
            MetaConfig config = new MetaConfig();
            config.hosts = new ArrayList<>();
            config.hosts.add(DefaultConfig.HOST);
            config.readTimeout = DefaultConfig.READ_TIMEOUT;
            config.connnectTimeout = DefaultConfig.CONNECT_TIMEOUT;
            builder.config = config;
            return builder;
        }

        /**
         *  设置 hosts
         * @param hosts
         */
        @NonNull
        public Builder setHosts(String hosts) {
            this.config.hosts = Utils.parseHosts(hosts);
            return this;
        }

        /**
         * 设置 http readTimeout
         * @param readTimeout
         */
        public Builder setReadTimeout(long readTimeout) {
            this.config.readTimeout = readTimeout;
            return this;
        }

        /**
         * 设置 http connectTimeout
         * @param connnectTimeout
         */
        public Builder setConnnectTimeout(long connnectTimeout) {
            this.config.connnectTimeout = connnectTimeout;
            return this;
        }

        /**
         * 注册回掉函数
         * @param callback
         */
        public Builder setCallback(Callback callback) {
            this.config.callback = callback;
            return this;
        }

        public void apply() {
            MetaService.getInstance().setConfig(config);
        }
    }

    public interface Callback {

        Map<String, String> getCommonParams();

        String getDid();

        long getUid();

        String getToken();

        long getTime();

        String encrypt(String content) throws Exception;

        String decrypt(String content) throws Exception;

        String getST();

        int getAccountType();

        long getAccountId();
    }
}
