package mm.vod.m.meta.inner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import mm.vod.m.meta.MetaException;
import mm.vod.m.meta.MetaService;
import mm.vod.m.meta.model.CipherData;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class CipherInterceptor implements Interceptor {

    private Gson gson;

    public CipherInterceptor() {
        this.gson = new GsonBuilder().serializeNulls()
                .setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Map<String, String> params = new HashMap<>(20);
        HttpUrl originUrl = request.url();
        for(int i = 0; i < originUrl.querySize(); i++) {
            params.put(originUrl.queryParameterName(i), originUrl.queryParameterValue(i));
        }
        params.putAll(MetaService.getInstance().getConfig().getCallback().getCommonParams());
        String reqM = null;
        try {
            reqM = MetaService.getInstance().getConfig().getCallback().encrypt(gson.toJson(params));
        } catch (Exception e) {
            e.printStackTrace();
            throw new MetaException("encryption failed");
        }
        String reqS = Utils.SHA1(reqM);

        HttpUrl newUrl = new HttpUrl.Builder()
                .scheme(originUrl.scheme())
                .host(originUrl.host())
                .port(originUrl.port())
                .encodedPath(originUrl.encodedPath())
                .addQueryParameter("v", "5")
                .addQueryParameter("m", reqM)
                .addQueryParameter("s", reqS)
                .build();

        request = request.newBuilder().url(newUrl).build();
        Response response = chain.proceed(request);
        if(response.isSuccessful() || response.code() == 555) {
            String resStr = response.body().string();
            CipherData cipherData = gson.fromJson(resStr, CipherData.class);
            String bodyString = null;
            try {
                bodyString = MetaService.getInstance().getConfig().getCallback().decrypt(cipherData.getM());
            } catch (Exception e) {
                e.printStackTrace();
                throw new MetaException("decryption failed");
            }
            //Response newResponse = response.newBuilder().body(ResponseBody.create(bodyString, response.body().contentType())).build();
            Response newResponse = response.newBuilder().body(ResponseBody.create(response.body().contentType(), bodyString)).build();
            return newResponse;
        } else {
            throw new MetaException("http failed:" + response.code() + " msg:" + response.message());
        }
    }
}
