package mm.vod.m.meta.inner;

import com.google.gson.JsonObject;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import mm.vod.m.meta.model.Artwork;
import mm.vod.m.meta.model.BaseMeta;
import mm.vod.m.meta.model.Cast;
import mm.vod.m.meta.model.CloudPlaySource;
import mm.vod.m.meta.model.EMetaSource;
import mm.vod.m.meta.model.Filter;
import mm.vod.m.meta.model.HotKey;
import mm.vod.m.meta.model.MediaAward;
import mm.vod.m.meta.model.MediaMeta;
import mm.vod.m.meta.model.ParentsGuide;
import mm.vod.m.meta.model.PersonDetail;
import mm.vod.m.meta.model.ResponseData;
import mm.vod.m.meta.model.ResponsePage;
import mm.vod.m.meta.model.ResponseStatus;
import mm.vod.m.meta.model.SynopsisMeta;
import mm.vod.m.meta.model.Trailer;
import mm.vod.m.meta.model.UiConfig;
import mm.vod.m.meta.model.UserReviewMeta;
import mm.vod.m.meta.model.VideoList;
import mm.vod.m.meta.model.VideoMeta;
import retrofit2.http.GET;
import retrofit2.http.Query;

public interface MetaApi {
    @GET("/api/ui/cfg/v1")
    Observable<ResponseData<List<UiConfig>>> getUICfg();

    @GET("/api/playlist/videos/v1")
    Observable<ResponseData<VideoList>> getVideoList(
            @Query("playlistId") long playListID,
            @Query("appendResult") String appendResult);

    @GET("/api/playlist/videos/v1")
    Observable<ResponseData<VideoList>> getVideoList(
            @Query("playlistId") long playListID,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult);

    //add tony
    @GET("/api/playlist/videos/v1")
    Observable<ResponseData<VideoList>> getVideoList(
            @Query("playlistId") long playListID,
            @Query("name") String name,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("linked") int linked,
            @Query("appendResult") String appendResult);

    @GET("/api/person/detail/v1")
    Observable<ResponseData<PersonDetail>> getPersonDetail(
            @Query("exPersonId") String exPersonId,
            @Query("personId") long personBaseID,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult);

    @GET("/api/person/filmography/v1")
    Observable<ResponsePage<List<BaseMeta>>> getPersonFilmography(
            @Query("personId") long personBaseID,
            @Query("videoType") String videoType,
            @Query("released") int released,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult);

    //详情
    @GET("/api/media/detail/v1")
    Observable<ResponseData<MediaMeta>> getVideoDetail(
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            @Query("appendResult") String appendResult,
            @Query("excludeResult") String excludeResult
    );

    @GET("/api/media/episode/v1")
    Observable<ResponsePage<List<VideoMeta>>> getEpisodes(
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("seriesId") long seriesId,
            @Query("seasonId") long seasonId,
            @Query("episodeOrder") String episodeOrder,
            @Query("appendResult") String appendResult);

    //相似&推荐影片
    @GET("/api/media/similar/v1")
    Observable<ResponsePage<List<BaseMeta>>> getSimilarVideos(
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            @Query("appendResult") String appendResult
    );

    //获取奖项信息
    @GET("/api/media/awards/v1")
    Observable<ResponsePage<List<MediaAward>>> getVideosAwards(
            @Query("videoId") long videoID,
            @Query("language") String language
    );

    //用户评论
    @GET("/api/media/userreview/v1")
    Observable<ResponsePage<List<UserReviewMeta>>> getVideoUserReviews(
            @Query("videoId") long videoId
    );

    //剧透
    @GET("/api/media/synopsis/v1")
    Observable<ResponseData<SynopsisMeta>> getVideoSynopsis(
            @Query("videoId") long videoId
    );

    @GET("/api/media/parentsGuide/v1")
    Observable<ResponsePage<List<ParentsGuide>>> queryParentGuide(
            @Query("videoId") long videoID,
            @Query("exMetaId") String exMetaID,
            @Query("exMetaSource") EMetaSource exMetaSource
    );

    @GET("/api/media/trailer/v1")
    Observable<ResponsePage<List<Trailer>>> queryTrailer(
            @Query("videoId") long videoID,
            @Query("exMetaId") String exMetaID,
            @Query("exMetaSource") EMetaSource exMetaSource
    );

    @GET("/api/media/cast/v1")
    Observable<ResponseData<Cast>> queryCast(
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            @Query("maxDirectors") int maxDirectors,
            @Query("maxStars") int maxStars
    );

    @GET("/api/media/artwork/v1")
    Observable<ResponsePage<List<Artwork>>> queryArtwork(
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID
    );

    @GET("/api/media/playSource/v1")
    Observable<ResponsePage<List<CloudPlaySource>>> getPlaySource(
            @Query("videoId") long videoId,
            @Query("season") int season,
            @Query("episode") int episode,
            @Query("displayMode") String displayMode,
            @Query("st") String serviceToken,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId
    );

    @GET("/api/search/filter/criteria/v2")
    Observable<ResponsePage<List<Filter>>> getFilterCriteria2(
            @Query("pid") String playlistId,
            @Query("videoType") String videoType);

    //搜索过滤
    @GET("/api/media/search/v1")
    Observable<ResponsePage<List<BaseMeta>>> getVideoFilter(
            @Query("videoType") String videoType,
            @Query("pid") String playlistId,
            @Query("filter") String filter,
            @Query("linked") int linked,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult
    );

    @GET("/api/media/baseInfo/v1")
    Observable<ResponsePage<List<BaseMeta>>> queryBaseMetaByIds(
            @Query("ids") String videIds,
            @Query("idType") int idType,
            @Query("appendResult") String appendResult
    );

    @GET("/api/ops/setSubStatus/v1")
    Observable<ResponseStatus> reportSubtitlesSetting(
            @Query("metaId") String metaId,
            @Query("subLanguage") String subLanguage,
            @Query("seasonId") Integer seasonId,
            @Query("episodeId") Integer episodeId
    );

    @GET("/api/ops/querySubStatus/v1")
    Observable<JsonObject> getSubtitlesStatus(
            @Query("metaId") String id,
            @Query("seasonId") Integer uid,
            @Query("episodeId") Integer did);

    @GET("/api/search/hotKeyword/list")
    Observable<ResponsePage<List<HotKey>>> fetchHotKey();
}
