package mm.vod.m.meta.inner;

import java.io.IOException;

import mm.vod.m.meta.MetaService;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TokenInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();

        String did = MetaService.getInstance().getConfig().getCallback().getDid();
        long uid = MetaService.getInstance().getConfig().getCallback().getUid();
        long time = MetaService.getInstance().getConfig().getCallback().getTime();
        String token = MetaService.getInstance().getConfig().getCallback().getToken();

        String cookieValue = "did=" + did + ";uid=" + uid + ";time=" + time + ";token=" + token;
        Request newRequest = request.newBuilder().addHeader("Cookie", cookieValue).build();
        Response response = chain.proceed(newRequest);
        return response;
    }
}
