package mm.vod.m.meta.inner;

import android.text.TextUtils;

import androidx.annotation.RestrictTo;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class Utils {
    public static List<String> parseHosts(String hostStr) {
        if(TextUtils.isEmpty(hostStr)) {
            return null;
        }
        String[] hostArray = hostStr.split(",");
        return Arrays.asList(hostArray);
    }

    public static String SHA1(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(content.getBytes("UTF-8"));
            String result = byte2hex(digest.digest(), false);
            return result;
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String byte2hex(byte[] b, boolean uppercase) {
        String hs = "";
        String stmp = "";

        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 255);
            if (stmp.length() == 1) {
                hs = hs + "0" + stmp;
            } else {
                hs = hs + stmp;
            }

            if (n < b.length - 1) {
                hs = hs + "";
            }
        }

        if (uppercase) {
            return hs.toUpperCase();
        } else {
            return hs.toLowerCase();
        }
    }
}
