package com.mm.vod.ota;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;

import com.mm.vod.ota.inner.OtaUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class InstallUtils {
    /**
     * װapk
     *
     * @param apkPath
     */
    public static void install(@NonNull Context mContext, @NonNull String apkPath) throws OtaException{
        File srcFile = new File(apkPath);
        File downloadDir = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
        if (!downloadDir.exists()) {
            downloadDir.mkdir();
        }

        File dstFile = new File(downloadDir.getAbsolutePath() + File.separator+ apkPath.substring(apkPath.lastIndexOf(File.separator)));
        // ļ
        try {
            OtaUtils.copy(srcFile, dstFile);
        } catch (IOException e) {
            throw new OtaException("copy apk file error");
        }

        File file = dstFile;
        if (!file.exists()) {
            throw new OtaException("apk file not exists");
        }

        if(!silentInstall(dstFile.getAbsolutePath())) {
            //װ
            Intent install = new Intent(Intent.ACTION_VIEW);
            //жǷandroid 7.0
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                //7.0ȡ洢ļuri
                Uri uri = FileProvider.getUriForFile(mContext, "com.mm.vod.ota", file);
                install.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                //ʱȨ
                install.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                //dataAndType
                install.setDataAndType(uri, "application/vnd.android.package-archive");
            } else {
                if (file.exists()) {
                    install.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    install.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
                } else {
                    throw new OtaException("apk file not exists.");
                }
            }
            mContext.startActivity(install);
        }
    }

    /**
     * װapk
     *
     * @param apkPath
     */
    private static boolean silentInstall(@NonNull String apkPath) {
        Process process = null;
        OutputStream outputStream = null;
        BufferedReader successResult = null;
        BufferedReader errorResult = null;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        try {
            process = Runtime.getRuntime().exec("su");
            outputStream = process.getOutputStream();
            String command1 = "chmod 644 " + apkPath + "\n";
            String command2 = "pm install -r " + apkPath + "\n";
            outputStream.write(command1.getBytes());
            outputStream.write(command2.getBytes());
            outputStream.flush();
            outputStream.write("exit\n".getBytes());
            outputStream.flush();
            process.waitFor();
            successResult = new BufferedReader(new InputStreamReader(process.getInputStream()));
            errorResult = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String s;
            while ((s = successResult.readLine()) != null) {
                successMsg.append(s);
            }
            while ((s = errorResult.readLine()) != null) {
                errorMsg.append(s);
            }
        } catch (Exception e) {

        } finally {
            try {
                if (successResult != null) {
                    successResult.close();
                }
                if (errorResult != null) {
                    errorResult.close();
                }
            } catch (Exception e) {

            }
            if (process != null) {
                process.destroy();
            }
        }
        Log.e("InstallUtils", "" + errorMsg.toString());
        //СsuccessΪװɹ
        return successMsg.toString().equalsIgnoreCase("success");
    }
}
