package com.mm.vod.ota;

import android.app.Activity;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import com.mm.vod.ota.inner.HostProvider;
import com.mm.vod.ota.inner.OtaDefaultConfig;
import com.mm.vod.ota.inner.OtaUtils;

import java.io.Serializable;
import java.util.List;

public class OtaConfig implements Serializable {
    private OtaCallback callback;
    private Class<? extends Activity> otaDownloadActivityClass = null;
    private Class<? extends DialogFragment> otaDownloadDialogFragmentClass = null;
    private List<String> hosts;
    private int readTimeout;
    private int connnectTimeout;

    public OtaCallback getCallback() {
        return callback;
    }

    public Class<? extends Activity> getOtaDownloadActivityClass() {
        return otaDownloadActivityClass;
    }

    private int currentHostIndex = 1;
    private HostProvider hostProvider = new HostProvider() {
        @Override
        public String host() {
            if(null != hosts && !hosts.isEmpty()) {
                return hosts.get(0);
            }
            return null;
        }

        @Override
        public String next() {
            if(null != hosts && !hosts.isEmpty()) {
                currentHostIndex = currentHostIndex % hosts.size();
                return hosts.get(currentHostIndex++);
            }
            return null;
        }
    };

    @NonNull
    public HostProvider getHostProvider() {
        return hostProvider;
    }

    public List<String> getHosts() {
        return hosts;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public int getConnnectTimeout() {
        return connnectTimeout;
    }

    public static class Builder {
        private OtaConfig config;

        @NonNull
        public static Builder create() {
            Builder builder = new Builder();
            OtaConfig config = new OtaConfig();
            config.callback = null;
            config.otaDownloadActivityClass = null;
            config.otaDownloadDialogFragmentClass = null;
            config.hosts = OtaUtils.parseHosts(OtaDefaultConfig.DEFAULT_HOST);
            config.readTimeout = OtaDefaultConfig.DEFAULT_READ_TIMEOUT;
            config.connnectTimeout = OtaDefaultConfig.DEFAULT_CONNECT_TIMEOUT;

            builder.config = config;
            return builder;
        }

        @NonNull
        public Builder setCallback(OtaCallback callback) {
            this.config.callback = callback;
            return this;
        }

        /*@NonNull
        public Builder setOtaDownloadActivityClass(Class<? extends Activity> otaDownloadActivityClass) {
            this.config.otaDownloadActivityClass = otaDownloadActivityClass;
            return this;
        }

        @NonNull
        public Builder setOtaDownloadDialogFragmentClass(Class<? extends DialogFragment> otaDownloadDialogFragmentClass) {
            this.config.otaDownloadDialogFragmentClass = otaDownloadDialogFragmentClass;
            return this;
        }*/

        /*
        *  设置 OTA host
        *
        * */
        @NonNull
        public Builder setHost(@NonNull String host) {
            this.config.hosts = OtaUtils.parseHosts(host);
            return this;
        }

        /*
         *  设置 http readtimeout
         *
         * */
        @NonNull
        public Builder setReadTimeoutInSeconds(int readTimeout) {
            this.config.readTimeout = readTimeout;
            return this;
        }

        /*
         *  设置 http connectTimeout
         *
         * */
        @NonNull
        public Builder setConnnectTimeoutInSeconds(int connnectTimeout) {
            this.config.connnectTimeout = connnectTimeout;
            return this;
        }

        public void apply() {
            OtaManager.setConfig(config);
        }
    }
}
