package com.mm.vod.ota.inner;

import android.text.TextUtils;

import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class MultiHostsRetryInterceptor implements Interceptor {
    private HostProvider hostProvider;

    public MultiHostsRetryInterceptor(HostProvider hostProvider) {
        this.hostProvider = hostProvider;
    }

    @NotNull
    @Override
    public Response intercept(@NotNull Chain chain) throws IOException {
        Request request = chain.request();
        List<String> triedHost = new ArrayList<>();
        do {
            try {
                Response response = chain.proceed(request);
                return response;
            } catch (IOException e) {
                String host = hostProvider.next();
                if(!triedHost.contains(host)) {
                    triedHost.add(host);
                    HttpUrl nextUrl = HttpUrl.parse(host);
                    if(null != nextUrl && !TextUtils.isEmpty(nextUrl.scheme()) && !TextUtils.isEmpty(nextUrl.host())) {
                        HttpUrl url = request.url().newBuilder()
                                .scheme(nextUrl.scheme())
                                .host(nextUrl.host())
                                .port(nextUrl.port())
                                .build();
                        request = request.newBuilder().url(url).build();
                    }
                } else {
                    throw e;
                }
            }
        } while (true);
    }
}
