package com.mm.vod.ota.inner;

import com.mm.vod.ota.model.OtaResponse;
import com.mm.vod.ota.model.UpdateInfo;

import java.util.Map;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface OtaApi {

    @GET("/api/ota/update/v1")
    Observable<ResponseBody> update(
            @Query("did") String did,
            @Query("language") String language,
            @Query("updateType") String updateType,
            @Query("currentVersion") String currentVersion,
            @Query("brand") String brand,
            @Query("model") String model,
            @Query("os") String os,
            @Query("appId") String appId,
            @Query("appVer") int appVer
    );

    @GET("/api/ota/update/v1")
    Observable<OtaResponse<UpdateInfo>> update(
            @QueryMap Map<String, Object> params
    );
}
