package com.mm.vod.ota;

import androidx.annotation.NonNull;

import com.google.gson.Gson;

public class OtaEvent {

    public enum Event {
        OTA_EVENT_TASK_CREATED,
        OTA_EVENT_TASK_START,
        OTA_EVENT_TASK_STOP,
        OTA_EVENT_TASK_FINALIZE,
        OTA_EVENT_CHECK_NEW_VERSION_START,
        OTA_EVENT_CHECK_NEW_VERSION_HAVE,
        OTA_EVENT_CHECK_NEW_VERSION_NULL,
        OTA_EVENT_CHECK_NEW_VERSION_FAILED,
        OTA_EVENT_DOWNLOAD_NEW_VERSION_START,
        OTA_EVENT_DOWNLOAD_NEW_VERSION_PROGRESS,
        OTA_EVENT_DOWNLOAD_NEW_VERSION_COMPLETE,
        OTA_EVENT_DOWNLOAD_NEW_VERSION_FAILED
    }

    /*public static final int OTA_EVENT_TASK_CREATED = 10;
    public static final int OTA_EVENT_TASK_START = 11;
    public static final int OTA_EVENT_TASK_STOP = 12;
    public static final int OTA_EVENT_TASK_FINALIZE = 19;

    public static final int OTA_EVENT_CHECK_NEW_VERSION_START = 50;
    public static final int OTA_EVENT_CHECK_NEW_VERSION_SUCCESS = 51;
    public static final int OTA_EVENT_CHECK_NEW_VERSION_FAILED = 52;
    public static final int OTA_EVENT_CHECK_NEW_VERSION_HAVE = 53;
    public static final int OTA_EVENT_CHECK_NEW_VERSION_NULL = 54;

    public static final int OTA_EVENT_DOWNLOAD_NEW_VERSION_START = 100;
    public static final int OTA_EVENT_DOWNLOAD_NEW_VERSION_PROGRESS = 101;
    public static final int OTA_EVENT_DOWNLOAD_NEW_VERSION_COMPLETE = 102;
    public static final int OTA_EVENT_DOWNLOAD_NEW_VERSION_FAILED = 103;*/


    public String taskUuid;
    public Event event;
    public long argv1;
    public long argv2;
    public String extra;

    private OtaEvent(){}

    public OtaEvent(OtaTask task, Event event, long argv1, long argv2) {
        this.taskUuid = task.getUuid();
        this.event = event;
        this.argv1 = argv1;
        this.argv2 = argv2;
    }

    public OtaEvent(OtaTask task, Event event, String extra) {
        this.taskUuid = task.getUuid();
        this.event = event;
        this.extra = extra;
    }

    @NonNull
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
