package com.mm.vod.ota;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

import com.liulishuo.filedownloader.FileDownloader;
import com.mm.vod.ota.inner.OtaLogger;

import org.greenrobot.eventbus.EventBus;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class OtaManager {

    private final static String TAG = "OtaManager";
    private Map<String, OtaTask> tasks = new HashMap<>();
    private static OtaConfig config = new OtaConfig();

    private static OtaManager INSTANCE;
    private static AtomicBoolean isInitializing = new AtomicBoolean(false); // 是否正在登录
    private static Object object = new Object();

    private static Application application;

    private OtaManager() {
        OtaLogger.setLogLevel(OtaLogger.VERBOSE); // todo
    }

    public void uninit() {
        removeAll();
    }

    public static OtaManager getInstance() {
        if (INSTANCE == null) {
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new OtaManager();
                }
            }
        }
        return INSTANCE;
    }

    @RestrictTo(RestrictTo.Scope.LIBRARY)
    public static void install(@Nullable final Context context) {
        if(null == context) {
            Log.e(TAG, "Install failed: context is null!");
        } else {
            application = (Application) context.getApplicationContext();
        }
    }

    @RestrictTo(RestrictTo.Scope.LIBRARY)
    @NonNull
    public static OtaConfig getConfig() {
        return config;
    }

    /**
     * INTERNAL method that sets the configuration of the library.
     * You must not use this, use CaocConfig.Builder.apply()
     *
     * @param config the configuration to use
     */
    @RestrictTo(RestrictTo.Scope.LIBRARY)
    public static void setConfig(@NonNull OtaConfig config) {
        OtaManager.config = config;
    }

    @RestrictTo(RestrictTo.Scope.LIBRARY)
    public static Application getApplication() {
        return application;
    }

    public OtaTask findOtaTaskByUuid(String uuid) {
        return tasks.get(uuid);
    }

    public OtaTask addTask(@NonNull OtaTask otaTask) {
        tasks.put(otaTask.getUuid(), otaTask);
        return otaTask;
    }

    public void removeTask(@NonNull String taskUuid) {
        OtaTask otaTask = tasks.remove(taskUuid);
        if(null != otaTask) {
            otaTask.stop();
        }
    }

    public void removeAll() {
        for(Map.Entry<String, OtaTask> entry: tasks.entrySet()) {
            entry.getValue().stop();
        }
        tasks.clear();
    }
}
