package com.mm.vod.ota.inner;

import android.os.Handler;
import android.os.Looper;

import androidx.annotation.NonNull;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class OtaExecutors {
    private final Executor mDiskIO;

    private final Executor mNetworkIO;

    private final Executor mMainThread;
    private final ScheduledThreadPoolExecutor schedule;

    private static OtaExecutors instance;

    private static Object object = new Object();

    public static OtaExecutors getInstance() {
        if (instance == null) {
            synchronized (object) {
                if (instance == null) {
                    instance = new OtaExecutors();
                }
            }
        }
        return instance;
    }

    private OtaExecutors() {

        this.mDiskIO = Executors.newSingleThreadExecutor(new MyThreadFactory("ota-single"));

        this.mNetworkIO = Executors.newFixedThreadPool(3, new MyThreadFactory("ota-fixed"));

        this.mMainThread = new MainThreadExecutor();

        this.schedule = new ScheduledThreadPoolExecutor(8, new MyThreadFactory("ota-sc"), new ThreadPoolExecutor.AbortPolicy());
    }

    class MyThreadFactory implements ThreadFactory {

        private final String name;
        private int count = 0;

        MyThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            count++;
            return new Thread(r, name + "-" + count + "-Thread");
        }
    }

    public Executor diskIO() {
        return mDiskIO;
    }

    public ScheduledThreadPoolExecutor schedule() {
        return schedule;
    }

    public Executor networkIO() {
        return mNetworkIO;
    }

    public Executor mainThread() {
        return mMainThread;
    }

    private static class MainThreadExecutor implements Executor {
        private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        @Override
        public void execute(@NonNull Runnable command) {
            mainThreadHandler.post(command);
        }
    }
}
