/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.Iterator;
import net.bytebuddy.matcher.ElementMatcher;

public class CollectionElementMatcher<T>
extends ElementMatcher.Junction.AbstractBase<Iterable<? extends T>> {
    private final int index;
    private final ElementMatcher<? super T> matcher;

    public CollectionElementMatcher(int index, ElementMatcher<? super T> matcher) {
        this.index = index;
        this.matcher = matcher;
    }

    @Override
    public boolean matches(Iterable<? extends T> target) {
        Iterator<T> iterator = target.iterator();
        for (int index = 0; index < this.index; ++index) {
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
        }
        return iterator.hasNext() && this.matcher.matches(iterator.next());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.index == ((CollectionElementMatcher)other).index && this.matcher.equals(((CollectionElementMatcher)other).matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode() + 31 * this.index;
    }

    public String toString() {
        return "with(" + this.index + " matches " + this.matcher + ")";
    }
}

