/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.util.exif.ExifFilterUtils;
import net.coobird.thumbnailator.util.exif.ExifUtils;
import net.coobird.thumbnailator.util.exif.Orientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSource
extends AbstractImageSource<File> {
    private static final int FIRST_IMAGE_INDEX = 0;
    private final File sourceFile;

    public FileImageSource(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = file;
    }

    public FileImageSource(String string) {
        if (string == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.sourceFile = new File(string);
    }

    @Override
    public BufferedImage read() throws IOException {
        Object object;
        Object object2;
        if (!this.sourceFile.exists()) {
            throw new FileNotFoundException("Could not find file: " + this.sourceFile.getAbsolutePath());
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.sourceFile);
        if (imageInputStream == null) {
            throw new IOException("Could not open file: " + this.sourceFile.getAbsolutePath());
        }
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            String string = this.sourceFile.getPath();
            throw new UnsupportedFormatException("<unknown>", "No suitable ImageReader found for " + string + ".");
        }
        ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream);
        this.inputFormatName = imageReader.getFormatName();
        try {
            if (this.param.useExifOrientation() && (object2 = ExifUtils.getExifOrientation(imageReader, 0)) != null && object2 != Orientation.TOP_LEFT) {
                object = this.param.getImageFilters();
                object.add(ExifFilterUtils.getFilterForOrientation(object2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.param != null && this.param.getSourceRegion() != null) {
            object = this.param.getSourceRegion();
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            Rectangle rectangle = ((Region)object).calculate(n, n2);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            imageReadParam.setSourceRegion(rectangle);
            object2 = imageReader.read(0, imageReadParam);
        } else {
            object2 = imageReader.read(0);
        }
        imageInputStream.close();
        return (BufferedImage)((Object)this.finishedReading(object2));
    }

    @Override
    public File getSource() {
        return this.sourceFile;
    }
}

