/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.dongliu.apk.parser.bean.AttributeValues;
import net.dongliu.apk.parser.bean.Locales;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.struct.ChunkHeader;
import net.dongliu.apk.parser.struct.ResourceValue;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.xml.Attribute;
import net.dongliu.apk.parser.struct.xml.Attributes;
import net.dongliu.apk.parser.struct.xml.NullHeader;
import net.dongliu.apk.parser.struct.xml.XmlCData;
import net.dongliu.apk.parser.struct.xml.XmlHeader;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeHeader;
import net.dongliu.apk.parser.struct.xml.XmlNodeStartTag;
import net.dongliu.apk.parser.struct.xml.XmlResourceMapHeader;
import net.dongliu.apk.parser.utils.Buffers;
import net.dongliu.apk.parser.utils.ParseUtils;
import net.dongliu.apk.parser.utils.Strings;

public class BinaryXmlParser {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private StringPool stringPool;
    private String[] resourceMap;
    private ByteBuffer buffer;
    private XmlStreamer xmlStreamer;
    private final ResourceTable resourceTable;
    private Locale locale = Locales.any;
    private static final Set<String> intAttributes = new HashSet<String>(Arrays.asList("screenOrientation", "configChanges", "windowSoftInputMode", "launchMode", "installLocation", "protectionLevel"));

    public BinaryXmlParser(ByteBuffer buffer, ResourceTable resourceTable) {
        this.buffer = buffer.duplicate();
        this.buffer.order(this.byteOrder);
        this.resourceTable = resourceTable;
    }

    public void parse() {
        ChunkHeader firstChunkHeader = this.readChunkHeader();
        if (firstChunkHeader == null) {
            return;
        }
        switch (firstChunkHeader.getChunkType()) {
            case 0: 
            case 3: {
                break;
            }
        }
        ChunkHeader stringPoolChunkHeader = this.readChunkHeader();
        if (stringPoolChunkHeader == null) {
            return;
        }
        ParseUtils.checkChunkType(1, stringPoolChunkHeader.getChunkType());
        this.stringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)stringPoolChunkHeader);
        ChunkHeader chunkHeader = this.readChunkHeader();
        if (chunkHeader == null) {
            return;
        }
        if (chunkHeader.getChunkType() == 384) {
            long[] resourceIds = this.readXmlResourceMap((XmlResourceMapHeader)chunkHeader);
            this.resourceMap = new String[resourceIds.length];
            for (int i = 0; i < resourceIds.length; ++i) {
                this.resourceMap[i] = Attribute.AttrIds.getString(resourceIds[i]);
            }
            chunkHeader = this.readChunkHeader();
        }
        while (chunkHeader != null) {
            long beginPos = this.buffer.position();
            switch (chunkHeader.getChunkType()) {
                case 257: {
                    XmlNamespaceEndTag xmlNamespaceEndTag = this.readXmlNamespaceEndTag();
                    this.xmlStreamer.onNamespaceEnd(xmlNamespaceEndTag);
                    break;
                }
                case 256: {
                    XmlNamespaceStartTag namespaceStartTag = this.readXmlNamespaceStartTag();
                    this.xmlStreamer.onNamespaceStart(namespaceStartTag);
                    break;
                }
                case 258: {
                    XmlNodeStartTag xmlNodeStartTag = this.readXmlNodeStartTag();
                    break;
                }
                case 259: {
                    XmlNodeEndTag xmlNodeEndTag = this.readXmlNodeEndTag();
                    break;
                }
                case 260: {
                    XmlCData xmlCData = this.readXmlCData();
                    break;
                }
                default: {
                    if (chunkHeader.getChunkType() >= 256 && chunkHeader.getChunkType() <= 383) {
                        Buffers.skip(this.buffer, chunkHeader.getBodySize());
                        break;
                    }
                    throw new ParserException("Unexpected chunk type:" + chunkHeader.getChunkType());
                }
            }
            Buffers.position(this.buffer, beginPos + (long)chunkHeader.getBodySize());
            chunkHeader = this.readChunkHeader();
        }
    }

    private XmlCData readXmlCData() {
        XmlCData xmlCData = new XmlCData();
        int dataRef = this.buffer.getInt();
        if (dataRef > 0) {
            xmlCData.setData(this.stringPool.get(dataRef));
        }
        xmlCData.setTypedData(ParseUtils.readResValue(this.buffer, this.stringPool));
        if (this.xmlStreamer != null) {
            // empty if block
        }
        return xmlCData;
    }

    private XmlNodeEndTag readXmlNodeEndTag() {
        XmlNodeEndTag xmlNodeEndTag = new XmlNodeEndTag();
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        if (nsRef > 0) {
            xmlNodeEndTag.setNamespace(this.stringPool.get(nsRef));
        }
        xmlNodeEndTag.setName(this.stringPool.get(nameRef));
        if (this.xmlStreamer != null) {
            this.xmlStreamer.onEndTag(xmlNodeEndTag);
        }
        return xmlNodeEndTag;
    }

    private XmlNodeStartTag readXmlNodeStartTag() {
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        XmlNodeStartTag xmlNodeStartTag = new XmlNodeStartTag();
        if (nsRef > 0) {
            xmlNodeStartTag.setNamespace(this.stringPool.get(nsRef));
        }
        xmlNodeStartTag.setName(this.stringPool.get(nameRef));
        int attributeStart = Buffers.readUShort(this.buffer);
        int attributeSize = Buffers.readUShort(this.buffer);
        int attributeCount = Buffers.readUShort(this.buffer);
        int idIndex = Buffers.readUShort(this.buffer);
        int classIndex = Buffers.readUShort(this.buffer);
        int styleIndex = Buffers.readUShort(this.buffer);
        Attributes attributes = new Attributes(attributeCount);
        for (int count = 0; count < attributeCount; ++count) {
            Attribute attribute = this.readAttribute();
            if (this.xmlStreamer == null) continue;
            String value = attribute.toStringValue(this.resourceTable, this.locale);
            if (intAttributes.contains(attribute.getName()) && Strings.isNumeric(value)) {
                try {
                    value = this.getFinalValueAsString(attribute.getName(), value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            attribute.setValue(value);
            attributes.set(count, attribute);
        }
        xmlNodeStartTag.setAttributes(attributes);
        if (this.xmlStreamer != null) {
            this.xmlStreamer.onStartTag(xmlNodeStartTag);
        }
        return xmlNodeStartTag;
    }

    private String getFinalValueAsString(String attributeName, String str) {
        int value = Integer.parseInt(str);
        switch (attributeName) {
            case "screenOrientation": {
                return AttributeValues.getScreenOrientation(value);
            }
            case "configChanges": {
                return AttributeValues.getConfigChanges(value);
            }
            case "windowSoftInputMode": {
                return AttributeValues.getWindowSoftInputMode(value);
            }
            case "launchMode": {
                return AttributeValues.getLaunchMode(value);
            }
            case "installLocation": {
                return AttributeValues.getInstallLocation(value);
            }
            case "protectionLevel": {
                return AttributeValues.getProtectionLevel(value);
            }
        }
        return str;
    }

    private Attribute readAttribute() {
        int rawValueRef;
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        Attribute attribute = new Attribute();
        if (nsRef > 0) {
            attribute.setNamespace(this.stringPool.get(nsRef));
        }
        attribute.setName(this.stringPool.get(nameRef));
        if (attribute.getName().isEmpty() && this.resourceMap != null && nameRef < this.resourceMap.length) {
            attribute.setName(this.resourceMap[nameRef]);
        }
        if ((rawValueRef = this.buffer.getInt()) > 0) {
            attribute.setRawValue(this.stringPool.get(rawValueRef));
        }
        ResourceValue resValue = ParseUtils.readResValue(this.buffer, this.stringPool);
        attribute.setTypedValue(resValue);
        return attribute;
    }

    private XmlNamespaceStartTag readXmlNamespaceStartTag() {
        int prefixRef = this.buffer.getInt();
        int uriRef = this.buffer.getInt();
        XmlNamespaceStartTag nameSpace = new XmlNamespaceStartTag();
        if (prefixRef > 0) {
            nameSpace.setPrefix(this.stringPool.get(prefixRef));
        }
        if (uriRef > 0) {
            nameSpace.setUri(this.stringPool.get(uriRef));
        }
        return nameSpace;
    }

    private XmlNamespaceEndTag readXmlNamespaceEndTag() {
        int prefixRef = this.buffer.getInt();
        int uriRef = this.buffer.getInt();
        XmlNamespaceEndTag nameSpace = new XmlNamespaceEndTag();
        if (prefixRef > 0) {
            nameSpace.setPrefix(this.stringPool.get(prefixRef));
        }
        if (uriRef > 0) {
            nameSpace.setUri(this.stringPool.get(uriRef));
        }
        return nameSpace;
    }

    private long[] readXmlResourceMap(XmlResourceMapHeader chunkHeader) {
        int count = chunkHeader.getBodySize() / 4;
        long[] resourceIds = new long[count];
        for (int i = 0; i < count; ++i) {
            resourceIds[i] = Buffers.readUInt(this.buffer);
        }
        return resourceIds;
    }

    private ChunkHeader readChunkHeader() {
        if (!this.buffer.hasRemaining()) {
            return null;
        }
        long begin = this.buffer.position();
        int chunkType = Buffers.readUShort(this.buffer);
        int headerSize = Buffers.readUShort(this.buffer);
        long chunkSize = Buffers.readUInt(this.buffer);
        switch (chunkType) {
            case 3: {
                return new XmlHeader(chunkType, headerSize, chunkSize);
            }
            case 1: {
                StringPoolHeader stringPoolHeader = new StringPoolHeader(headerSize, chunkSize);
                stringPoolHeader.setStringCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStyleCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setFlags(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStringsStart(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStylesStart(Buffers.readUInt(this.buffer));
                Buffers.position(this.buffer, begin + (long)headerSize);
                return stringPoolHeader;
            }
            case 384: {
                Buffers.position(this.buffer, begin + (long)headerSize);
                return new XmlResourceMapHeader(chunkType, headerSize, chunkSize);
            }
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                XmlNodeHeader header = new XmlNodeHeader(chunkType, headerSize, chunkSize);
                header.setLineNum((int)Buffers.readUInt(this.buffer));
                header.setCommentRef((int)Buffers.readUInt(this.buffer));
                Buffers.position(this.buffer, begin + (long)headerSize);
                return header;
            }
            case 0: {
                return new NullHeader(chunkType, headerSize, chunkSize);
            }
        }
        throw new ParserException("Unexpected chunk type:" + chunkType);
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public XmlStreamer getXmlStreamer() {
        return this.xmlStreamer;
    }

    public void setXmlStreamer(XmlStreamer xmlStreamer) {
        this.xmlStreamer = xmlStreamer;
    }
}

