/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.nio.charset.Charset;
import java.util.Base64;
import net.dreamlu.mica.core.utils.Charsets;

public class Base64Util {
    public static final Base64.Encoder ENCODER = Base64.getEncoder();
    public static final Base64.Encoder URL_ENCODER = Base64.getUrlEncoder();
    public static final Base64.Decoder DECODER = Base64.getDecoder();
    public static final Base64.Decoder URL_DECODER = Base64.getUrlDecoder();

    public static String encode(String value) {
        return Base64Util.encode(value, Charsets.UTF_8);
    }

    public static String encode(String value, Charset charset) {
        byte[] val = value.getBytes(charset);
        return new String(Base64Util.encode(val), charset);
    }

    public static String encodeUrlSafe(String value) {
        return Base64Util.encodeUrlSafe(value, Charsets.UTF_8);
    }

    public static String encodeUrlSafe(String value, Charset charset) {
        byte[] val = value.getBytes(charset);
        return new String(Base64Util.encodeUrlSafe(val), charset);
    }

    public static String decode(String value) {
        return Base64Util.decode(value, Charsets.UTF_8);
    }

    public static String decode(String value, Charset charset) {
        byte[] val = value.getBytes(charset);
        byte[] decodedValue = Base64Util.decode(val);
        return new String(decodedValue, charset);
    }

    public static String decodeUrlSafe(String value) {
        return Base64Util.decodeUrlSafe(value, Charsets.UTF_8);
    }

    public static String decodeUrlSafe(String value, Charset charset) {
        byte[] val = value.getBytes(charset);
        byte[] decodedValue = Base64Util.decodeUrlSafe(val);
        return new String(decodedValue, charset);
    }

    public static byte[] encode(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return ENCODER.encode(src);
    }

    public static byte[] decode(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return DECODER.decode(src);
    }

    public static byte[] encodeUrlSafe(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return URL_ENCODER.encode(src);
    }

    public static byte[] decodeUrlSafe(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return URL_DECODER.decode(src);
    }

    public static String encodeToString(byte[] src) {
        if (src.length == 0) {
            return "";
        }
        return new String(Base64Util.encode(src), Charsets.UTF_8);
    }

    public static byte[] decodeFromString(String src) {
        if (src.isEmpty()) {
            return new byte[0];
        }
        return Base64Util.decode(src.getBytes(Charsets.UTF_8));
    }

    public static String encodeToUrlSafeString(byte[] src) {
        return new String(Base64Util.encodeUrlSafe(src), Charsets.UTF_8);
    }

    public static byte[] decodeFromUrlSafeString(String src) {
        return Base64Util.decodeUrlSafe(src.getBytes(Charsets.UTF_8));
    }
}

