/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.spring;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

public class ReactiveRedisLockProvider
implements LockProvider {
    private static final String KEY_PREFIX_DEFAULT = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private final ReactiveStringRedisTemplate redisTemplate;
    private final String environment;
    private final String keyPrefix;

    public ReactiveRedisLockProvider(@NonNull ReactiveRedisConnectionFactory redisConn) {
        this(redisConn, ENV_DEFAULT);
    }

    public ReactiveRedisLockProvider(@NonNull ReactiveRedisConnectionFactory redisConn, @NonNull String environment) {
        this(redisConn, environment, KEY_PREFIX_DEFAULT);
    }

    public ReactiveRedisLockProvider(@NonNull ReactiveRedisConnectionFactory redisConn, @NonNull String environment, @NonNull String keyPrefix) {
        this(new ReactiveStringRedisTemplate(redisConn), environment, keyPrefix);
    }

    public ReactiveRedisLockProvider(@NonNull ReactiveStringRedisTemplate redisTemplate, @NonNull String environment, @NonNull String keyPrefix) {
        this.redisTemplate = redisTemplate;
        this.environment = environment;
        this.keyPrefix = keyPrefix;
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        Instant now = ClockProvider.now();
        String key = ReactiveRedisLock.createKey(this.keyPrefix, this.environment, lockConfiguration.getName());
        String value = ReactiveRedisLock.createValue(now);
        Duration expirationTime = Duration.between(now, lockConfiguration.getLockAtMostUntil());
        Boolean lockResult = (Boolean)this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, expirationTime).block();
        if (Boolean.TRUE.equals(lockResult)) {
            return Optional.of(new ReactiveRedisLock(key, this.redisTemplate, lockConfiguration));
        }
        return Optional.empty();
    }

    private static final class ReactiveRedisLock
    extends AbstractSimpleLock {
        private final String key;
        private final ReactiveStringRedisTemplate redisTemplate;

        private static String createKey(String keyPrefix, String environment, String lockName) {
            return String.format("%s:%s:%s", keyPrefix, environment, lockName);
        }

        private static String createValue(Instant now) {
            return String.format("ADDED:%s@%s", Utils.toIsoString((Instant)now), Utils.getHostname());
        }

        private ReactiveRedisLock(String key, ReactiveStringRedisTemplate redisTemplate, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.redisTemplate = redisTemplate;
        }

        protected void doUnlock() {
            Instant now = ClockProvider.now();
            Duration expirationTime = Duration.between(now, this.lockConfiguration.getLockAtLeastUntil());
            if (expirationTime.isNegative() || expirationTime.isZero()) {
                try {
                    this.redisTemplate.delete((Object[])new String[]{this.key}).block();
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
            } else {
                String value = ReactiveRedisLock.createValue(now);
                this.redisTemplate.opsForValue().setIfPresent((Object)this.key, (Object)value, expirationTime).block();
            }
        }
    }

    public static class Builder {
        private final ReactiveStringRedisTemplate redisTemplate;
        private String environment = "default";
        private String keyPrefix = "job-lock";

        public Builder(@NonNull ReactiveRedisConnectionFactory redisConnectionFactory) {
            this.redisTemplate = new ReactiveStringRedisTemplate(redisConnectionFactory);
        }

        public Builder(@NonNull ReactiveStringRedisTemplate redisTemplate) {
            this.redisTemplate = redisTemplate;
        }

        public Builder environment(@NonNull String environment) {
            this.environment = environment;
            return this;
        }

        public Builder keyPrefix(@NonNull String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public ReactiveRedisLockProvider build() {
            return new ReactiveRedisLockProvider(this.redisTemplate, this.environment, this.keyPrefix);
        }
    }
}

