/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger log = LoggerFactory.getLogger(Command.class);
    private static final int SRC_ID = Command.genRandomSrc();
    public static final byte OPT_JOIN = 1;
    public static final byte OPT_EVICT_KEY = 2;
    public static final byte OPT_CLEAR_KEY = 3;
    public static final byte OPT_QUIT = 4;
    private int src = SRC_ID;
    private int operator;
    private String region;
    private String[] keys;

    private static int genRandomSrc() {
        long ct = System.currentTimeMillis();
        Random rnd_seed = new Random(ct);
        return (int)((long)(rnd_seed.nextInt(10000) * 1000) + ct % 1000L);
    }

    public Command() {
    }

    public Command(byte o, String r, String ... keys) {
        this.operator = o;
        this.region = r;
        this.keys = keys;
    }

    public static final int LocalID() {
        return SRC_ID;
    }

    public static Command join() {
        return new Command(1, null, new String[0]);
    }

    public static Command quit() {
        return new Command(4, null, new String[0]);
    }

    public String json() {
        return JSON.toJSONString((Object)this);
    }

    public static Command parse(String json) {
        try {
            return (Command)JSON.parseObject((String)json, Command.class);
        }
        catch (JSONException e) {
            log.warn("Failed to parse j2cache command: " + json, (Throwable)e);
            return null;
        }
    }

    @JSONField(serialize=false)
    public boolean isLocal() {
        return this.src == SRC_ID;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getRegion() {
        return this.region;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int src) {
        this.src = src;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public String toString() {
        return this.json();
    }
}

