/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.util.concurrent.atomic.AtomicBoolean;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.cluster.ClusterPolicy;
import net.oschina.j2cache.cluster.ClusterPolicyFactory;
import net.oschina.j2cache.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class J2CacheBuilder {
    private static final Logger log = LoggerFactory.getLogger(J2CacheBuilder.class);
    private CacheChannel channel;
    private CacheProviderHolder holder;
    private ClusterPolicy policy;
    private AtomicBoolean opened = new AtomicBoolean(false);
    private J2CacheConfig config;

    private J2CacheBuilder(J2CacheConfig config) {
        this.config = config;
    }

    public static final J2CacheBuilder init(J2CacheConfig config) {
        return new J2CacheBuilder(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CacheChannel getChannel() {
        if (this.channel != null && this.opened.get()) return this.channel;
        Class<J2CacheBuilder> clazz = J2CacheBuilder.class;
        synchronized (J2CacheBuilder.class) {
            if (this.channel != null && this.opened.get()) return this.channel;
            this.initFromConfig(this.config);
            this.channel = new CacheChannel(this.config, this.holder){

                @Override
                public void sendClearCmd(String region) {
                    J2CacheBuilder.this.policy.sendClearCmd(region);
                }

                @Override
                public void sendEvictCmd(String region, String ... keys) {
                    J2CacheBuilder.this.policy.sendEvictCmd(region, keys);
                }

                @Override
                public void close() {
                    super.close();
                    J2CacheBuilder.this.policy.disconnect();
                    J2CacheBuilder.this.holder.shutdown();
                    J2CacheBuilder.this.opened.set(false);
                }
            };
            this.opened.set(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.channel;
        }
    }

    public void close() {
        this.channel.close();
        this.channel = null;
    }

    private void initFromConfig(J2CacheConfig config) {
        SerializationUtils.init(config.getSerialization(), config.getSubProperties(config.getSerialization()));
        this.holder = CacheProviderHolder.init(config, (region, key) -> {
            Level2Cache level2 = this.holder.getLevel2Cache(region);
            level2.evict(key);
            if (!level2.supportTTL()) {
                this.holder.getLevel1Cache(region).evict(key);
            }
            log.debug(String.format("Level 1 cache object expired, evict level 2 cache object [%s,%s]", region, key));
            if (this.policy != null) {
                this.policy.sendEvictCmd(region, key);
            }
        });
        this.policy = ClusterPolicyFactory.init(this.holder, config.getBroadcast(), config.getBroadcastProperties());
        log.info("Using cluster policy : " + this.policy.getClass().getName());
    }
}

