/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.cluster.ClusterPolicy;
import net.oschina.j2cache.lettuce.LettuceGenericCache;
import net.oschina.j2cache.lettuce.LettuceHashCache;

public class LettuceCacheProvider
extends RedisPubSubAdapter<String, String>
implements CacheProvider,
ClusterPolicy {
    private static AbstractRedisClient redisClient;
    private StatefulRedisPubSubConnection<String, String> pubsub_subscriber;
    private String storage;
    private CacheProviderHolder holder;
    private String channel;
    private String namespace;
    private static final ConcurrentHashMap<String, Level2Cache> regions;

    @Override
    public String name() {
        return "lettuce";
    }

    @Override
    public int level() {
        return 2;
    }

    @Override
    public void start(Properties props) {
        this.namespace = props.getProperty("namespace");
        this.storage = props.getProperty("storage", "hash");
        this.channel = props.getProperty("channel", "j2cache");
        String scheme = props.getProperty("scheme", "redis");
        String hosts = props.getProperty("hosts", "127.0.0.1:6379");
        String password = props.getProperty("password");
        int database = Integer.parseInt(props.getProperty("database", "0"));
        String sentinelMasterId = props.getProperty("sentinelMasterId");
        boolean isCluster = false;
        if ("redis-cluster".equalsIgnoreCase(scheme)) {
            scheme = "redis";
            isCluster = true;
        }
        String redis_url = String.format("%s://%s@%s/%d#%s", scheme, password, hosts, database, sentinelMasterId);
        redisClient = isCluster ? RedisClusterClient.create((String)redis_url) : RedisClient.create((String)redis_url);
    }

    @Override
    public void stop() {
        regions.clear();
        redisClient.shutdown();
    }

    @Override
    public Cache buildCache(String region, CacheExpiredListener listener) {
        return regions.computeIfAbsent(region, v -> "hash".equalsIgnoreCase(this.storage) ? new LettuceHashCache(this.namespace, region, redisClient) : new LettuceGenericCache(this.namespace, region, redisClient));
    }

    @Override
    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        return this.buildCache(region, listener);
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        return Collections.emptyList();
    }

    @Override
    public void evict(String region, String ... keys) {
        this.holder.getLevel1Cache(region).evict(keys);
    }

    @Override
    public void clear(String region) {
        this.holder.getLevel1Cache(region).clear();
    }

    private StatefulRedisPubSubConnection pubsub() {
        if (redisClient instanceof RedisClient) {
            return ((RedisClient)redisClient).connectPubSub();
        }
        if (redisClient instanceof RedisClusterClient) {
            return ((RedisClusterClient)redisClient).connectPubSub();
        }
        return null;
    }

    @Override
    public void connect(Properties props, CacheProviderHolder holder) {
        long ct = System.currentTimeMillis();
        this.holder = holder;
        this.channel = props.getProperty("channel", "j2cache");
        this.publish(Command.join());
        this.pubsub_subscriber = this.pubsub();
        this.pubsub_subscriber.addListener((RedisPubSubListener)this);
        RedisPubSubAsyncCommands async = this.pubsub_subscriber.async();
        async.subscribe((Object[])new String[]{this.channel});
        log.info("Connected to redis channel:" + this.channel + ", time " + (System.currentTimeMillis() - ct) + " ms.");
    }

    public void message(String channel, String message) {
        Command cmd = Command.parse(message);
        this.handleCommand(cmd);
    }

    @Override
    public void publish(Command cmd) {
        try (StatefulRedisPubSubConnection connection = this.pubsub();){
            RedisPubSubCommands sync = connection.sync();
            sync.publish((Object)this.channel, (Object)cmd.json());
        }
    }

    @Override
    public void disconnect() {
        try {
            this.publish(Command.quit());
            super.unsubscribed((Object)this.channel, 1L);
        }
        finally {
            this.pubsub_subscriber.close();
        }
    }

    static {
        regions = new ConcurrentHashMap();
    }
}

