/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import java.io.IOException;
import java.util.Properties;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.util.FSTSerializer;
import net.oschina.j2cache.util.FastjsonSerializer;
import net.oschina.j2cache.util.FstJSONSerializer;
import net.oschina.j2cache.util.FstSnappySerializer;
import net.oschina.j2cache.util.JavaSerializer;
import net.oschina.j2cache.util.KryoPoolSerializer;
import net.oschina.j2cache.util.KryoSerializer;
import net.oschina.j2cache.util.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtils {
    private static final Logger log = LoggerFactory.getLogger(SerializationUtils.class);
    private static Serializer g_serializer;

    public static void init(String ser, Properties props) {
        if (ser == null || "".equals(ser.trim())) {
            g_serializer = new JavaSerializer();
        } else if ("java".equals(ser)) {
            g_serializer = new JavaSerializer();
        } else if ("fst".equals(ser)) {
            g_serializer = new FSTSerializer();
        } else if ("kryo".equals(ser)) {
            g_serializer = new KryoSerializer();
        } else if ("kryo-pool".equals(ser)) {
            g_serializer = new KryoPoolSerializer();
        } else if ("fst-snappy".equals(ser)) {
            g_serializer = new FstSnappySerializer();
        } else if ("json".equals(ser)) {
            g_serializer = new FstJSONSerializer(props);
        } else if ("fastjson".equals(ser)) {
            g_serializer = new FastjsonSerializer();
        } else {
            try {
                g_serializer = (Serializer)Class.forName(ser).newInstance();
            }
            catch (Exception e) {
                throw new CacheException("Cannot initialize Serializer named [" + ser + ']', e);
            }
        }
        log.info("Using Serializer -> [" + g_serializer.name() + ":" + g_serializer.getClass().getName() + ']');
    }

    public static byte[] serialize(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        return g_serializer.serialize(obj);
    }

    public static byte[] serializeWithoutException(Object obj) {
        try {
            return SerializationUtils.serialize(obj);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    public static Object deserialize(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return g_serializer.deserialize(bytes);
    }
}

