/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.caffeine.CaffeineCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(CaffeineProvider.class);
    private static final String PREFIX_REGION = "region.";
    private static final String DEFAULT_REGION = "default";
    private ConcurrentHashMap<String, CaffeineCache> caches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CacheConfig> cacheConfigs = new ConcurrentHashMap();

    @Override
    public String name() {
        return "caffeine";
    }

    @Override
    public int level() {
        return 1;
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        ArrayList<CacheChannel.Region> regions = new ArrayList<CacheChannel.Region>();
        this.caches.forEach((k, c) -> regions.add(new CacheChannel.Region((String)k, c.size(), c.ttl())));
        return regions;
    }

    @Override
    public Cache buildCache(String region, CacheExpiredListener listener) {
        return this.caches.computeIfAbsent(region, v -> {
            CacheConfig config = this.cacheConfigs.get(region);
            if (config == null) {
                config = this.cacheConfigs.get(DEFAULT_REGION);
                if (config == null) {
                    throw new CacheException(String.format("Undefined [default] caffeine cache", new Object[0]));
                }
                log.warn("Caffeine cache [{}] not defined, using default.", (Object)region);
            }
            return this.newCaffeineCache(region, config.size, config.expire, listener);
        });
    }

    @Override
    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        CaffeineCache cache = this.caches.computeIfAbsent(region, v -> {
            CacheConfig config = this.cacheConfigs.get(region);
            if (config != null && config.expire != timeToLiveInSeconds) {
                throw new IllegalArgumentException(String.format("Region [%s] TTL %d not match with %d", region, config.expire, timeToLiveInSeconds));
            }
            if (config == null && (config = this.cacheConfigs.get(DEFAULT_REGION)) == null) {
                throw new CacheException(String.format("Undefined caffeine cache region name = %s", region));
            }
            log.info("Started caffeine region [{}] with TTL: {}", (Object)region, (Object)timeToLiveInSeconds);
            return this.newCaffeineCache(region, config.size, timeToLiveInSeconds, listener);
        });
        if (cache != null && cache.ttl() != timeToLiveInSeconds) {
            throw new IllegalArgumentException(String.format("Region [%s] TTL %d not match with %d", region, cache.ttl(), timeToLiveInSeconds));
        }
        return cache;
    }

    @Override
    public void removeCache(String region) {
        this.cacheConfigs.remove(region);
        this.caches.remove(region);
    }

    private CaffeineCache newCaffeineCache(String region, long size, long expire, CacheExpiredListener listener) {
        Caffeine caffeine = Caffeine.newBuilder();
        caffeine = caffeine.maximumSize(size).removalListener((k, v, cause) -> {
            if (cause != RemovalCause.EXPLICIT && cause != RemovalCause.REPLACED && cause != RemovalCause.SIZE) {
                listener.notifyElementExpired(region, (String)k);
            }
        });
        if (expire > 0L) {
            caffeine = caffeine.expireAfterWrite(expire, TimeUnit.SECONDS);
        }
        com.github.benmanes.caffeine.cache.Cache loadingCache = caffeine.build();
        return new CaffeineCache((com.github.benmanes.caffeine.cache.Cache<String, Object>)loadingCache, size, expire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Properties props) {
        for (String region : props.stringPropertyNames()) {
            if (!region.startsWith(PREFIX_REGION)) continue;
            String s_config = props.getProperty(region).trim();
            region = region.substring(PREFIX_REGION.length());
            this.saveCacheConfig(region, s_config);
        }
        String propertiesFile = props.getProperty("properties");
        if (propertiesFile != null && propertiesFile.trim().length() > 0) {
            InputStream stream = null;
            try {
                stream = this.getClass().getResourceAsStream(propertiesFile);
                if (stream == null) {
                    stream = this.getClass().getClassLoader().getResourceAsStream(propertiesFile);
                }
                Properties regionsProps = new Properties();
                regionsProps.load(stream);
                for (String region : regionsProps.stringPropertyNames()) {
                    String s_config = regionsProps.getProperty(region).trim();
                    this.saveCacheConfig(region, s_config);
                }
            }
            catch (IOException e) {
                log.error("Failed to load caffeine regions define {}", (Object)propertiesFile, (Object)e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void saveCacheConfig(String region, String region_config) {
        CacheConfig cfg = CacheConfig.parse(region_config);
        if (cfg == null) {
            log.warn("Illegal caffeine cache config [{}={}]", (Object)region, (Object)region_config);
        } else {
            this.cacheConfigs.put(region, cfg);
        }
    }

    @Override
    public void stop() {
        this.caches.clear();
        this.cacheConfigs.clear();
    }

    private static class CacheConfig {
        private long size = 0L;
        private long expire = 0L;

        private CacheConfig() {
        }

        public static CacheConfig parse(String cfg) {
            CacheConfig cacheConfig = null;
            String[] cfgs = cfg.split(",");
            if (cfgs.length == 1) {
                cacheConfig = new CacheConfig();
                String sSize = cfgs[0].trim();
                cacheConfig.size = Long.parseLong(sSize);
            } else if (cfgs.length == 2) {
                cacheConfig = new CacheConfig();
                String sSize = cfgs[0].trim();
                String sExpire = cfgs[1].trim();
                cacheConfig.size = Long.parseLong(sSize);
                char unit = Character.toLowerCase(sExpire.charAt(sExpire.length() - 1));
                cacheConfig.expire = Long.parseLong(sExpire.substring(0, sExpire.length() - 1));
                switch (unit) {
                    case 's': {
                        break;
                    }
                    case 'm': {
                        cacheConfig.expire *= 60L;
                        break;
                    }
                    case 'h': {
                        cacheConfig.expire *= 3600L;
                        break;
                    }
                    case 'd': {
                        cacheConfig.expire *= 86400L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown expire unit:" + unit);
                    }
                }
            }
            return cacheConfig;
        }

        public String toString() {
            return String.format("[SIZE:%d,EXPIRE:%d]", this.size, this.expire);
        }
    }
}

