/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.ehcache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.Level1Cache;
import org.ehcache.Cache;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.expiry.Duration;

public class EhCache3
implements Level1Cache,
CacheEventListener {
    private String name;
    private Cache<String, Object> cache;
    private CacheExpiredListener listener;

    public EhCache3(String name, Cache<String, Object> cache, CacheExpiredListener listener) {
        this.name = name;
        this.cache = cache;
        this.cache.getRuntimeConfiguration().registerCacheEventListener((CacheEventListener)this, EventOrdering.ORDERED, EventFiring.ASYNCHRONOUS, EventType.EXPIRED, new EventType[0]);
        this.listener = listener;
    }

    @Override
    public long ttl() {
        Duration dur = this.cache.getRuntimeConfiguration().getExpiry().getExpiryForCreation(null, null);
        if (dur.isInfinite()) {
            return 0L;
        }
        return dur.getTimeUnit().toSeconds(dur.getLength());
    }

    @Override
    public long size() {
        return ((SizedResourcePool)this.cache.getRuntimeConfiguration().getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP)).getSize();
    }

    @Override
    public Object get(String key) {
        return this.cache.get((Object)key);
    }

    @Override
    public void put(String key, Object value) {
        this.cache.put((Object)key, value);
    }

    @Override
    public Map<String, Object> get(Collection<String> keys) {
        return this.cache.getAll(keys.stream().collect(Collectors.toSet()));
    }

    @Override
    public boolean exists(String key) {
        return this.cache.containsKey((Object)key);
    }

    @Override
    public void put(Map<String, Object> elements) {
        this.cache.putAll(elements);
    }

    @Override
    public Collection<String> keys() {
        return Collections.emptyList();
    }

    @Override
    public void evict(String ... keys) {
        this.cache.removeAll(Arrays.stream(keys).collect(Collectors.toSet()));
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public void onEvent(CacheEvent cacheEvent) {
        if (cacheEvent.getType() == EventType.EXPIRED) {
            this.listener.notifyElementExpired(this.name, (String)cacheEvent.getKey());
        }
    }
}

