/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.ehcache;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.ehcache.EhCache3;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheProvider3
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(EhCacheProvider3.class);
    private static final String DEFAULT_TPL = "default";
    private CacheManager manager;
    private ConcurrentHashMap<String, EhCache3> caches = new ConcurrentHashMap();
    private long defaultHeapSize = 1000L;

    @Override
    public String name() {
        return "ehcache3";
    }

    @Override
    public int level() {
        return 1;
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        ArrayList<CacheChannel.Region> regions = new ArrayList<CacheChannel.Region>();
        this.caches.forEach((k, c) -> regions.add(new CacheChannel.Region((String)k, c.size(), c.ttl())));
        return regions;
    }

    @Override
    public EhCache3 buildCache(String region, CacheExpiredListener listener) {
        return this.caches.computeIfAbsent(region, v -> {
            Cache cache = this.manager.getCache(region, String.class, Serializable.class);
            if (cache == null) {
                CacheConfiguration defaultCacheConfig = (CacheConfiguration)this.manager.getRuntimeConfiguration().getCacheConfigurations().get(DEFAULT_TPL);
                CacheConfiguration cacheCfg = CacheConfigurationBuilder.newCacheConfigurationBuilder((CacheConfiguration)defaultCacheConfig).build();
                cache = this.manager.createCache(region, cacheCfg);
                Duration dura = cache.getRuntimeConfiguration().getExpiry().getExpiryForCreation(null, null);
                long ttl = dura.isInfinite() ? -1L : dura.getTimeUnit().toSeconds(dura.getLength());
                log.warn("Could not find configuration [{}]; using defaults (TTL:{} seconds).", (Object)region, (Object)ttl);
            }
            return new EhCache3(region, (Cache<String, Object>)cache, listener);
        });
    }

    @Override
    public EhCache3 buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        EhCache3 ehcache = this.caches.computeIfAbsent(region, v -> {
            CacheConfiguration conf = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)this.defaultHeapSize)).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)timeToLiveInSeconds, (TimeUnit)TimeUnit.SECONDS))).build();
            Cache cache = this.manager.createCache(region, conf);
            log.info("Started Ehcache region [{}] with TTL: {}", (Object)region, (Object)timeToLiveInSeconds);
            return new EhCache3(region, (Cache<String, Object>)cache, listener);
        });
        if (ehcache.ttl() != timeToLiveInSeconds) {
            throw new IllegalArgumentException(String.format("Region [%s] TTL %d not match with %d", region, ehcache.ttl(), timeToLiveInSeconds));
        }
        return ehcache;
    }

    @Override
    public void removeCache(String region) {
        this.caches.remove(region);
        this.manager.removeCache(region);
    }

    @Override
    public void start(Properties props) {
        URL url;
        String sDefaultHeapSize = props.getProperty("defaultHeapSize");
        try {
            this.defaultHeapSize = Long.parseLong(sDefaultHeapSize);
        }
        catch (Exception e) {
            log.warn("Failed to read ehcache3.defaultHeapSize = {} , use default {}", (Object)sDefaultHeapSize, (Object)this.defaultHeapSize);
        }
        String configXml = props.getProperty("configXml");
        if (configXml == null || configXml.trim().length() == 0) {
            configXml = "/ehcache3.xml";
        }
        url = (url = this.getClass().getResource(configXml)) == null ? this.getClass().getClassLoader().getResource(configXml) : url;
        XmlConfiguration xmlConfig = new XmlConfiguration(url);
        this.manager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfig);
        this.manager.init();
    }

    @Override
    public void stop() {
        if (this.manager != null) {
            this.manager.close();
            this.caches.clear();
            this.manager = null;
        }
    }
}

