/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.redis.RedisCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadonlyRedisCacheProvider
extends RedisCacheProvider {
    private static final Logger log = LoggerFactory.getLogger(ReadonlyRedisCacheProvider.class);

    @Override
    public String name() {
        return "redis";
    }

    @Override
    public Cache buildCache(String region, CacheExpiredListener listener) {
        Cache cache = super.buildCache(region, listener);
        return new ReadonlyCache(cache).get();
    }

    @Override
    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        Cache cache = super.buildCache(region, timeToLiveInSeconds, listener);
        return new ReadonlyCache(cache).get();
    }

    private static final class ReadonlyCache
    implements InvocationHandler {
        private static final List<String> ignoreMethods = Arrays.asList("put", "evict", "clear");
        private Cache cache;

        public ReadonlyCache(Cache cache) {
            this.cache = cache;
        }

        public Cache get() {
            return (Cache)Proxy.newProxyInstance(this.cache.getClass().getClassLoader(), this.cache.getClass().getInterfaces(), (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (ignoreMethods.contains(methodName)) {
                log.debug("Cache [{}] skipped.", (Object)methodName);
                return null;
            }
            try {
                return method.invoke((Object)this.cache, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

