/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.oschina.j2cache.util.Serializer;

public class KryoSerializer
implements Serializer {
    @Override
    public String name() {
        return "kryo";
    }

    @Override
    public byte[] serialize(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (Output output = new Output((OutputStream)baos);){
            new Kryo().writeClassAndObject(output, obj);
            output.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    @Override
    public Object deserialize(byte[] bits) {
        if (bits == null || bits.length == 0) {
            return null;
        }
        try (Input ois = new Input((InputStream)new ByteArrayInputStream(bits));){
            Object object = new Kryo().readClassAndObject(ois);
            return object;
        }
    }
}

