/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cluster;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Properties;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.cluster.ClusterPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQClusterPolicy
implements ClusterPolicy,
Consumer {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQClusterPolicy.class);
    private int LOCAL_COMMAND_ID = Command.genRandomSrc();
    private static final String EXCHANGE_TYPE = "fanout";
    private CacheProviderHolder holder;
    private ConnectionFactory factory;
    private Connection conn_publisher;
    private Connection conn_consumer;
    private Channel channel_publisher;
    private Channel channel_consumer;
    private String exchange;

    public RabbitMQClusterPolicy(Properties props) {
        this.exchange = props.getProperty("exchange", "j2cache");
        this.factory = new ConnectionFactory();
        this.factory.setHost(props.getProperty("host", "127.0.0.1"));
        this.factory.setPort(Integer.valueOf(props.getProperty("port", "5672")).intValue());
        this.factory.setUsername(props.getProperty("username", null));
        this.factory.setPassword(props.getProperty("password", null));
    }

    @Override
    public boolean isLocalCommand(Command cmd) {
        return cmd.getSrc() == this.LOCAL_COMMAND_ID;
    }

    @Override
    public void evict(String region, String ... keys) {
        this.holder.getLevel1Cache(region).evict(keys);
    }

    @Override
    public void clear(String region) {
        this.holder.getLevel1Cache(region).clear();
    }

    @Override
    public void connect(Properties props, CacheProviderHolder holder) {
        this.holder = holder;
        try {
            long ct = System.currentTimeMillis();
            this.conn_publisher = this.factory.newConnection();
            this.channel_publisher = this.conn_publisher.createChannel();
            this.channel_publisher.exchangeDeclare(this.exchange, EXCHANGE_TYPE);
            this.publish(Command.join());
            this.conn_consumer = this.factory.newConnection();
            this.channel_consumer = this.conn_consumer.createChannel();
            this.channel_consumer.exchangeDeclare(this.exchange, EXCHANGE_TYPE);
            String queueName = this.channel_consumer.queueDeclare().getQueue();
            this.channel_consumer.queueBind(queueName, this.exchange, "");
            this.channel_consumer.basicConsume(queueName, true, (Consumer)this);
            log.info("Connected to RabbitMQ:{}, time {}ms", (Object)this.conn_consumer, (Object)(System.currentTimeMillis() - ct));
        }
        catch (Exception e) {
            throw new CacheException(String.format("Failed to connect to RabbitMQ (%s:%d)", this.factory.getHost(), this.factory.getPort()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void publish(Command cmd) {
        if (!this.channel_publisher.isOpen() || !this.conn_publisher.isOpen()) {
            Class<RabbitMQClusterPolicy> clazz = RabbitMQClusterPolicy.class;
            // MONITORENTER : net.oschina.j2cache.cluster.RabbitMQClusterPolicy.class
            if (!this.channel_publisher.isOpen() || !this.conn_publisher.isOpen()) {
                try {
                    this.conn_publisher = this.factory.newConnection();
                    this.channel_publisher = this.conn_publisher.createChannel();
                }
                catch (Exception e) {
                    throw new CacheException("Failed to connect to RabbitMQ!", e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            cmd.setSrc(this.LOCAL_COMMAND_ID);
            this.channel_publisher.basicPublish(this.exchange, "", null, cmd.json().getBytes());
            return;
        }
        catch (IOException e) {
            throw new CacheException("Failed to publish cmd to RabbitMQ!", e);
        }
    }

    @Override
    public void disconnect() {
        try {
            this.publish(Command.quit());
        }
        finally {
            try {
                this.channel_publisher.close();
                this.conn_publisher.close();
            }
            catch (Exception exception) {}
            try {
                this.channel_consumer.close();
                this.conn_consumer.close();
            }
            catch (Exception exception) {}
        }
    }

    public void handleDelivery(String s, Envelope envelope, AMQP.BasicProperties basicProperties, byte[] bytes) {
        this.handleCommand(Command.parse(new String(bytes)));
    }

    public void handleConsumeOk(String s) {
    }

    public void handleCancelOk(String s) {
    }

    public void handleCancel(String s) {
    }

    public void handleShutdownSignal(String s, ShutdownSignalException e) {
    }

    public void handleRecoverOk(String s) {
    }
}

