/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class RedisClient
implements Closeable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RedisClient.class);
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int SO_TIMEOUT = 5000;
    private static final int MAX_ATTEMPTS = 3;
    private ThreadLocal<BinaryJedisCommands> clients;
    private JedisCluster cluster;
    private JedisPool single;
    private JedisSentinelPool sentinel;
    private ShardedJedisPool sharded;

    private RedisClient(String mode, String hosts, String password, String cluster_name, int database, JedisPoolConfig poolConfig, boolean ssl) {
        password = password != null && password.trim().length() > 0 ? password.trim() : null;
        this.clients = new ThreadLocal();
        switch (mode) {
            case "sentinel": {
                HashSet<String> nodes = new HashSet<String>();
                for (String node : hosts.split(",")) {
                    nodes.add(node);
                }
                this.sentinel = new JedisSentinelPool(cluster_name, nodes, (GenericObjectPoolConfig)poolConfig, 5000, password, database);
                break;
            }
            case "cluster": {
                HashSet<HostAndPort> hps = new HashSet<HostAndPort>();
                for (String node : hosts.split(",")) {
                    String[] infos = node.split(":");
                    String host = infos[0];
                    int port = infos.length > 1 ? Integer.parseInt(infos[1]) : 6379;
                    hps.add(new HostAndPort(host, port));
                }
                this.cluster = new JedisCluster(hps, 5000, 5000, 3, password, (GenericObjectPoolConfig)poolConfig);
                break;
            }
            case "sharded": {
                ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
                try {
                    for (String node : hosts.split(",")) {
                        shards.add(new JedisShardInfo(new URI(node)));
                    }
                }
                catch (URISyntaxException e) {
                    throw new JedisConnectionException((Throwable)e);
                }
                this.sharded = new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, shards);
                break;
            }
            default: {
                String[] stringArray = hosts.split(",");
                int n = stringArray.length;
                int n2 = 0;
                if (n2 < n) {
                    String node = stringArray[n2];
                    String[] infos = node.split(":");
                    String host = infos[0];
                    int port = infos.length > 1 ? Integer.parseInt(infos[1]) : 6379;
                    this.single = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 5000, password, database, ssl);
                }
                if ("single".equalsIgnoreCase(mode)) break;
                log.warn("Redis mode [{}] not defined. Using 'single'.", (Object)mode);
            }
        }
    }

    public BinaryJedisCommands get() {
        BinaryJedisCommands client = this.clients.get();
        if (client == null) {
            if (this.single != null) {
                client = this.single.getResource();
            } else if (this.sentinel != null) {
                client = this.sentinel.getResource();
            } else if (this.sharded != null) {
                client = this.sharded.getResource();
            } else if (this.cluster != null) {
                client = this.toBinaryJedisCommands(this.cluster);
            }
            this.clients.set(client);
        }
        return client;
    }

    public void release() {
        BinaryJedisCommands client = this.clients.get();
        if (client != null) {
            if (client instanceof Closeable && !(client instanceof JedisCluster)) {
                try {
                    ((Closeable)client).close();
                }
                catch (IOException e) {
                    log.error("Failed to release jedis connection.", (Throwable)e);
                }
            } else {
                log.warn("Nothing to do while release redis client.");
            }
            this.clients.remove();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.single != null) {
            this.single.close();
        }
        if (this.sentinel != null) {
            this.sentinel.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
        if (this.sharded != null) {
            this.sharded.close();
        }
    }

    private BinaryJedisCommands toBinaryJedisCommands(final JedisCluster cluster) {
        return new BinaryJedisCommands(){

            public String set(byte[] bytes, byte[] bytes1) {
                return cluster.set(bytes, bytes1);
            }

            public String set(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return null;
            }

            public String set(byte[] bytes, byte[] bytes1, byte[] bytes2, byte[] bytes3, long l) {
                return null;
            }

            public byte[] get(byte[] bytes) {
                return cluster.get(bytes);
            }

            public Boolean exists(byte[] bytes) {
                return cluster.exists(bytes);
            }

            public Long persist(byte[] bytes) {
                return cluster.persist(bytes);
            }

            public String type(byte[] bytes) {
                return cluster.type(bytes);
            }

            public Long expire(byte[] bytes, int i) {
                return cluster.expire(bytes, i);
            }

            public Long pexpire(String s, long l) {
                return cluster.pexpire(s, l);
            }

            public Long pexpire(byte[] bytes, long l) {
                return cluster.pexpire(bytes, l);
            }

            public Long expireAt(byte[] bytes, long l) {
                return cluster.expireAt(bytes, l);
            }

            public Long pexpireAt(byte[] bytes, long l) {
                return cluster.pexpireAt(bytes, l);
            }

            public Long ttl(byte[] bytes) {
                return cluster.ttl(bytes);
            }

            public Boolean setbit(byte[] bytes, long l, boolean b) {
                return cluster.setbit(bytes, l, b);
            }

            public Boolean setbit(byte[] bytes, long l, byte[] bytes1) {
                return cluster.setbit(bytes, l, bytes1);
            }

            public Boolean getbit(byte[] bytes, long l) {
                return cluster.getbit(bytes, l);
            }

            public Long setrange(byte[] bytes, long l, byte[] bytes1) {
                return cluster.setrange(bytes, l, bytes1);
            }

            public byte[] getrange(byte[] bytes, long l, long l1) {
                return cluster.getrange(bytes, l, l1);
            }

            public byte[] getSet(byte[] bytes, byte[] bytes1) {
                return cluster.getSet(bytes, bytes1);
            }

            public Long setnx(byte[] bytes, byte[] bytes1) {
                return cluster.setnx(bytes, bytes1);
            }

            public String setex(byte[] bytes, int i, byte[] bytes1) {
                return cluster.setex(bytes, i, bytes1);
            }

            public Long decrBy(byte[] bytes, long l) {
                return cluster.decrBy(bytes, l);
            }

            public Long decr(byte[] bytes) {
                return cluster.decr(bytes);
            }

            public Long incrBy(byte[] bytes, long l) {
                return cluster.incrBy(bytes, l);
            }

            public Double incrByFloat(byte[] bytes, double v) {
                return cluster.incrByFloat(bytes, v);
            }

            public Long incr(byte[] bytes) {
                return cluster.incr(bytes);
            }

            public Long append(byte[] bytes, byte[] bytes1) {
                return cluster.append(bytes, bytes1);
            }

            public byte[] substr(byte[] bytes, int i, int i1) {
                return cluster.substr(bytes, i, i1);
            }

            public Long hset(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.hset(bytes, bytes1, bytes2);
            }

            public byte[] hget(byte[] bytes, byte[] bytes1) {
                return cluster.hget(bytes, bytes1);
            }

            public Long hsetnx(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.hsetnx(bytes, bytes1, bytes2);
            }

            public String hmset(byte[] bytes, Map<byte[], byte[]> map) {
                return cluster.hmset(bytes, map);
            }

            public List<byte[]> hmget(byte[] bytes, byte[] ... bytes1) {
                return cluster.hmget(bytes, bytes1);
            }

            public Long hincrBy(byte[] bytes, byte[] bytes1, long l) {
                return cluster.hincrBy(bytes, bytes1, l);
            }

            public Double hincrByFloat(byte[] bytes, byte[] bytes1, double v) {
                return cluster.hincrByFloat(bytes, bytes1, v);
            }

            public Boolean hexists(byte[] bytes, byte[] bytes1) {
                return cluster.hexists(bytes, bytes1);
            }

            public Long hdel(byte[] bytes, byte[] ... bytes1) {
                return cluster.hdel(bytes, bytes1);
            }

            public Long hlen(byte[] bytes) {
                return cluster.hlen(bytes);
            }

            public Set<byte[]> hkeys(byte[] bytes) {
                return cluster.hkeys(bytes);
            }

            public Collection<byte[]> hvals(byte[] bytes) {
                return cluster.hvals(bytes);
            }

            public Map<byte[], byte[]> hgetAll(byte[] bytes) {
                return cluster.hgetAll(bytes);
            }

            public Long rpush(byte[] bytes, byte[] ... bytes1) {
                return cluster.rpush(bytes, bytes1);
            }

            public Long lpush(byte[] bytes, byte[] ... bytes1) {
                return cluster.lpush(bytes, bytes1);
            }

            public Long llen(byte[] bytes) {
                return cluster.llen(bytes);
            }

            public List<byte[]> lrange(byte[] bytes, long l, long l1) {
                return cluster.lrange(bytes, l, l1);
            }

            public String ltrim(byte[] bytes, long l, long l1) {
                return cluster.ltrim(bytes, l, l1);
            }

            public byte[] lindex(byte[] bytes, long l) {
                return cluster.lindex(bytes, l);
            }

            public String lset(byte[] bytes, long l, byte[] bytes1) {
                return cluster.lset(bytes, l, bytes1);
            }

            public Long lrem(byte[] bytes, long l, byte[] bytes1) {
                return cluster.lrem(bytes, l, bytes1);
            }

            public byte[] lpop(byte[] bytes) {
                return cluster.lpop(bytes);
            }

            public byte[] rpop(byte[] bytes) {
                return cluster.rpop(bytes);
            }

            public Long sadd(byte[] bytes, byte[] ... bytes1) {
                return cluster.sadd(bytes, bytes1);
            }

            public Set<byte[]> smembers(byte[] bytes) {
                return cluster.smembers(bytes);
            }

            public Long srem(byte[] bytes, byte[] ... bytes1) {
                return cluster.srem(bytes, bytes1);
            }

            public byte[] spop(byte[] bytes) {
                return cluster.spop(bytes);
            }

            public Set<byte[]> spop(byte[] bytes, long l) {
                return cluster.spop(bytes, l);
            }

            public Long scard(byte[] bytes) {
                return cluster.scard(bytes);
            }

            public Boolean sismember(byte[] bytes, byte[] bytes1) {
                return cluster.sismember(bytes, bytes1);
            }

            public byte[] srandmember(byte[] bytes) {
                return cluster.srandmember(bytes);
            }

            public List<byte[]> srandmember(byte[] bytes, int i) {
                return cluster.srandmember(bytes, i);
            }

            public Long strlen(byte[] bytes) {
                return cluster.strlen(bytes);
            }

            public Long zadd(byte[] bytes, double v, byte[] bytes1) {
                return cluster.zadd(bytes, v, bytes1);
            }

            public Long zadd(byte[] bytes, double v, byte[] bytes1, ZAddParams zAddParams) {
                return cluster.zadd(bytes, v, bytes1, zAddParams);
            }

            public Long zadd(byte[] bytes, Map<byte[], Double> map) {
                return cluster.zadd(bytes, map);
            }

            public Long zadd(byte[] bytes, Map<byte[], Double> map, ZAddParams zAddParams) {
                return cluster.zadd(bytes, map, zAddParams);
            }

            public Set<byte[]> zrange(byte[] bytes, long l, long l1) {
                return cluster.zrange(bytes, l, l1);
            }

            public Long zrem(byte[] bytes, byte[] ... bytes1) {
                return cluster.zrem(bytes, bytes1);
            }

            public Double zincrby(byte[] bytes, double v, byte[] bytes1) {
                return cluster.zincrby(bytes, v, bytes1);
            }

            public Double zincrby(byte[] bytes, double v, byte[] bytes1, ZIncrByParams zIncrByParams) {
                return cluster.zincrby(bytes, v, bytes1, zIncrByParams);
            }

            public Long zrank(byte[] bytes, byte[] bytes1) {
                return cluster.zrank(bytes, bytes1);
            }

            public Long zrevrank(byte[] bytes, byte[] bytes1) {
                return cluster.zrevrank(bytes, bytes1);
            }

            public Set<byte[]> zrevrange(byte[] bytes, long l, long l1) {
                return cluster.zrevrange(bytes, l, l1);
            }

            public Set<Tuple> zrangeWithScores(byte[] bytes, long l, long l1) {
                return cluster.zrangeWithScores(bytes, l, l1);
            }

            public Set<Tuple> zrevrangeWithScores(byte[] bytes, long l, long l1) {
                return cluster.zrevrangeWithScores(bytes, l, l1);
            }

            public Long zcard(byte[] bytes) {
                return cluster.zcard(bytes);
            }

            public Double zscore(byte[] bytes, byte[] bytes1) {
                return cluster.zscore(bytes, bytes1);
            }

            public List<byte[]> sort(byte[] bytes) {
                return cluster.sort(bytes);
            }

            public List<byte[]> sort(byte[] bytes, SortingParams sortingParams) {
                return cluster.sort(bytes, sortingParams);
            }

            public Long zcount(byte[] bytes, double v, double v1) {
                return cluster.zcount(bytes, v, v1);
            }

            public Long zcount(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zcount(bytes, bytes1, bytes2);
            }

            public Set<byte[]> zrangeByScore(byte[] bytes, double v, double v1) {
                return cluster.zrangeByScore(bytes, v, v1);
            }

            public Set<byte[]> zrangeByScore(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zrangeByScore(bytes, bytes1, bytes2);
            }

            public Set<byte[]> zrevrangeByScore(byte[] bytes, double v, double v1) {
                return cluster.zrevrangeByScore(bytes, v, v1);
            }

            public Set<byte[]> zrangeByScore(byte[] bytes, double v, double v1, int i, int i1) {
                return cluster.zrangeByScore(bytes, v, v1, i, i1);
            }

            public Set<byte[]> zrevrangeByScore(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zrevrangeByScore(bytes, bytes1, bytes2);
            }

            public Set<byte[]> zrangeByScore(byte[] bytes, byte[] bytes1, byte[] bytes2, int i, int i1) {
                return cluster.zrangeByScore(bytes, bytes1, bytes2, i, i1);
            }

            public Set<byte[]> zrevrangeByScore(byte[] bytes, double v, double v1, int i, int i1) {
                return cluster.zrevrangeByScore(bytes, v, v1, i, i1);
            }

            public Set<Tuple> zrangeByScoreWithScores(byte[] bytes, double v, double v1) {
                return cluster.zrangeByScoreWithScores(bytes, v, v1);
            }

            public Set<Tuple> zrevrangeByScoreWithScores(byte[] bytes, double v, double v1) {
                return cluster.zrevrangeByScoreWithScores(bytes, v, v1);
            }

            public Set<Tuple> zrangeByScoreWithScores(byte[] bytes, double v, double v1, int i, int i1) {
                return cluster.zrangeByScoreWithScores(bytes, v, v1, i, i1);
            }

            public Set<byte[]> zrevrangeByScore(byte[] bytes, byte[] bytes1, byte[] bytes2, int i, int i1) {
                return cluster.zrevrangeByScore(bytes, bytes1, bytes2, i, i1);
            }

            public Set<Tuple> zrangeByScoreWithScores(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zrangeByScoreWithScores(bytes, bytes1, bytes2);
            }

            public Set<Tuple> zrevrangeByScoreWithScores(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zrevrangeByScoreWithScores(bytes, bytes1, bytes2);
            }

            public Set<Tuple> zrangeByScoreWithScores(byte[] bytes, byte[] bytes1, byte[] bytes2, int i, int i1) {
                return cluster.zrangeByScoreWithScores(bytes, bytes1, bytes2, i, i1);
            }

            public Set<Tuple> zrevrangeByScoreWithScores(byte[] bytes, double v, double v1, int i, int i1) {
                return cluster.zrevrangeByScoreWithScores(bytes, v, v1, i, i1);
            }

            public Set<Tuple> zrevrangeByScoreWithScores(byte[] bytes, byte[] bytes1, byte[] bytes2, int i, int i1) {
                return cluster.zrevrangeByScoreWithScores(bytes, bytes1, bytes2, i, i1);
            }

            public Long zremrangeByRank(byte[] bytes, long l, long l1) {
                return cluster.zremrangeByRank(bytes, l, l1);
            }

            public Long zremrangeByScore(byte[] bytes, double v, double v1) {
                return cluster.zremrangeByScore(bytes, v, v1);
            }

            public Long zremrangeByScore(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zremrangeByScore(bytes, bytes1, bytes2);
            }

            public Long zlexcount(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zlexcount(bytes, bytes1, bytes2);
            }

            public Set<byte[]> zrangeByLex(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zrangeByLex(bytes, bytes1, bytes2);
            }

            public Set<byte[]> zrangeByLex(byte[] bytes, byte[] bytes1, byte[] bytes2, int i, int i1) {
                return cluster.zrangeByLex(bytes, bytes1, bytes2, i, i1);
            }

            public Set<byte[]> zrevrangeByLex(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zrevrangeByLex(bytes, bytes1, bytes2);
            }

            public Set<byte[]> zrevrangeByLex(byte[] bytes, byte[] bytes1, byte[] bytes2, int i, int i1) {
                return cluster.zrevrangeByLex(bytes, bytes1, bytes2, i, i1);
            }

            public Long zremrangeByLex(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.zremrangeByLex(bytes, bytes1, bytes2);
            }

            public Long linsert(byte[] bytes, BinaryClient.LIST_POSITION list_position, byte[] bytes1, byte[] bytes2) {
                return cluster.linsert(bytes, list_position, bytes1, bytes2);
            }

            public Long lpushx(byte[] bytes, byte[] ... bytes1) {
                return cluster.lpushx(bytes, bytes1);
            }

            public Long rpushx(byte[] bytes, byte[] ... bytes1) {
                return cluster.rpushx(bytes, bytes1);
            }

            public List<byte[]> blpop(byte[] bytes) {
                return cluster.blpop(0, (byte[][])new byte[][]{bytes});
            }

            public List<byte[]> brpop(byte[] bytes) {
                return cluster.brpop(0, (byte[][])new byte[][]{bytes});
            }

            public Long del(byte[] bytes) {
                return cluster.del(bytes);
            }

            public byte[] echo(byte[] bytes) {
                return cluster.echo(bytes);
            }

            public Long move(byte[] bytes, int i) {
                return cluster.move(new String(bytes), i);
            }

            public Long bitcount(byte[] bytes) {
                return cluster.bitcount(bytes);
            }

            public Long bitcount(byte[] bytes, long l, long l1) {
                return cluster.bitcount(bytes, l, l1);
            }

            public Long pfadd(byte[] bytes, byte[] ... bytes1) {
                return cluster.pfadd(bytes, bytes1);
            }

            public long pfcount(byte[] bytes) {
                return cluster.pfcount(bytes);
            }

            public Long geoadd(byte[] bytes, double v, double v1, byte[] bytes1) {
                return cluster.geoadd(bytes, v, v1, bytes1);
            }

            public Long geoadd(byte[] bytes, Map<byte[], GeoCoordinate> map) {
                return cluster.geoadd(bytes, map);
            }

            public Double geodist(byte[] bytes, byte[] bytes1, byte[] bytes2) {
                return cluster.geodist(bytes, bytes1, bytes2);
            }

            public Double geodist(byte[] bytes, byte[] bytes1, byte[] bytes2, GeoUnit geoUnit) {
                return cluster.geodist(bytes, bytes1, bytes2, geoUnit);
            }

            public List<byte[]> geohash(byte[] bytes, byte[] ... bytes1) {
                return cluster.geohash(bytes, bytes1);
            }

            public List<GeoCoordinate> geopos(byte[] bytes, byte[] ... bytes1) {
                return cluster.geopos(bytes, bytes1);
            }

            public List<GeoRadiusResponse> georadius(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit) {
                return cluster.georadius(bytes, v, v1, v2, geoUnit);
            }

            public List<GeoRadiusResponse> georadius(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
                return cluster.georadius(bytes, v, v1, v2, geoUnit, geoRadiusParam);
            }

            public List<GeoRadiusResponse> georadiusByMember(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit) {
                return cluster.georadiusByMember(bytes, bytes1, v, geoUnit);
            }

            public List<GeoRadiusResponse> georadiusByMember(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
                return cluster.georadiusByMember(bytes, bytes1, v, geoUnit, geoRadiusParam);
            }

            public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] bytes, byte[] bytes1) {
                return cluster.hscan(bytes, bytes1);
            }

            public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] bytes, byte[] bytes1, ScanParams scanParams) {
                return cluster.hscan(bytes, bytes1, scanParams);
            }

            public ScanResult<byte[]> sscan(byte[] bytes, byte[] bytes1) {
                return cluster.sscan(bytes, bytes1);
            }

            public ScanResult<byte[]> sscan(byte[] bytes, byte[] bytes1, ScanParams scanParams) {
                return cluster.sscan(bytes, bytes1, scanParams);
            }

            public ScanResult<Tuple> zscan(byte[] bytes, byte[] bytes1) {
                return cluster.zscan(bytes, bytes1);
            }

            public ScanResult<Tuple> zscan(byte[] bytes, byte[] bytes1, ScanParams scanParams) {
                return cluster.zscan(bytes, bytes1, scanParams);
            }

            public List<byte[]> bitfield(byte[] bytes, byte[] ... bytes1) {
                return cluster.bitfield(bytes, bytes1);
            }
        };
    }

    public static class Builder {
        private String mode;
        private String hosts;
        private String password;
        private String cluster;
        private int database;
        private JedisPoolConfig poolConfig;
        private boolean ssl;

        public Builder mode(String mode) {
            this.mode = mode == null || mode.trim().length() == 0 ? "single" : mode;
            return this;
        }

        public Builder hosts(String hosts) {
            this.hosts = hosts == null || hosts.trim().length() == 0 ? "127.0.0.1:6379" : hosts;
            return this;
        }

        public Builder password(String password) {
            if (password != null && password.trim().length() > 0) {
                this.password = password;
            }
            return this;
        }

        public Builder cluster(String cluster) {
            this.cluster = cluster == null || cluster.trim().length() == 0 ? "j2cache" : cluster;
            return this;
        }

        public Builder database(int database) {
            this.database = database;
            return this;
        }

        public Builder poolConfig(JedisPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public RedisClient newClient() {
            return new RedisClient(this.mode, this.hosts, this.password, this.cluster, this.database, this.poolConfig, this.ssl);
        }
    }
}

