/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;

public class Formatter {
    private File toFile;
    private String type;
    private boolean toConsole;
    private boolean showSuppressed;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private Writer writer;
    private Renderer renderer;

    public void setShowSuppressed(boolean value) {
        this.showSuppressed = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setToConsole(boolean toConsole) {
        this.toConsole = toConsole;
    }

    public void addConfiguredParam(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void start(String baseDir) {
        Charset charset;
        Properties properties = this.createProperties();
        String s = (String)properties.get("encoding");
        if (null == s) {
            if (this.toConsole && null == (s = Formatter.getConsoleEncoding())) {
                s = System.getProperty("file.encoding");
            }
            charset = null == s ? StandardCharsets.UTF_8 : Charset.forName(s);
            Parameter parameter = new Parameter();
            parameter.setName("encoding");
            parameter.setValue(charset.name());
            this.parameters.add(parameter);
        } else {
            charset = Charset.forName(s);
        }
        try {
            if (this.toConsole) {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, charset));
            }
            if (this.toFile != null) {
                this.writer = Formatter.getToFileWriter(baseDir, this.toFile, charset);
            }
            this.renderer = this.createRenderer();
            this.renderer.setWriter(this.writer);
            this.renderer.start();
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void end(Report errorReport) {
        try {
            this.renderer.renderFileReport(errorReport);
            this.renderer.end();
            if (this.toConsole) {
                this.writer.flush();
            } else {
                this.writer.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public boolean isNoOutputSupplied() {
        return this.toFile == null && !this.toConsole;
    }

    public String toString() {
        return "file = " + this.toFile + "; renderer = " + this.type;
    }

    private static String[] validRendererCodes() {
        return RendererFactory.REPORT_FORMAT_TO_RENDERER.keySet().toArray(new String[RendererFactory.REPORT_FORMAT_TO_RENDERER.size()]);
    }

    private static String unknownRendererMessage(String userSpecifiedType) {
        String[] typeCodes = Formatter.validRendererCodes();
        StringBuilder sb = new StringBuilder(100);
        sb.append("Formatter type must be one of: '").append(typeCodes[0]);
        for (int i = 1; i < typeCodes.length; ++i) {
            sb.append("', '").append(typeCodes[i]);
        }
        sb.append("', or a class name; you specified: ").append(userSpecifiedType);
        return sb.toString();
    }

    Renderer createRenderer() {
        if (StringUtils.isBlank((CharSequence)this.type)) {
            throw new BuildException(Formatter.unknownRendererMessage("<unspecified>"));
        }
        Properties properties = this.createProperties();
        Renderer renderer = RendererFactory.createRenderer(this.type, properties);
        renderer.setShowSuppressedViolations(this.showSuppressed);
        return renderer;
    }

    private Properties createProperties() {
        Properties properties = new Properties();
        for (Parameter parameter : this.parameters) {
            properties.put(parameter.getName(), parameter.getValue());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Writer getToFileWriter(String baseDir, File toFile, Charset charset) throws IOException {
        File file = toFile.isAbsolute() ? toFile : new File(baseDir + System.getProperty("file.separator") + toFile.getPath());
        OutputStream output = null;
        Writer writer = null;
        boolean isOnError = true;
        try {
            output = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(output, charset);
            return new BufferedWriter(outputStreamWriter);
        }
        catch (Throwable throwable) {
            if (!isOnError) throw throwable;
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
    }

    private static String getConsoleEncoding() {
        Console console = System.console();
        if (console != null) {
            try {
                Field f = Console.class.getDeclaredField("cs");
                f.setAccessible(true);
                Object res = f.get(console);
                if (res instanceof Charset) {
                    return ((Charset)res).name();
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            return Formatter.getNativeConsoleEncoding();
        }
        return null;
    }

    private static String getNativeConsoleEncoding() {
        try {
            Method m = Console.class.getDeclaredMethod("encoding", new Class[0]);
            m.setAccessible(true);
            Object res = m.invoke(null, new Object[0]);
            if (res instanceof String) {
                return (String)res;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

