/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> Iterator<T> reverse(Iterator<T> it) {
        List<T> tmp = IteratorUtil.toList(it);
        Collections.reverse(tmp);
        return tmp.iterator();
    }

    public static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static <T> Iterable<T> toIterable(final Iterator<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return it;
            }
        };
    }

    public static int count(Iterator<?> it) {
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static <T> Iterable<T> asReversed(final List<T> lst) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    ListIterator<T> li;
                    {
                        this.li = lst.listIterator(lst.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.li.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.li.previous();
                    }

                    @Override
                    public void remove() {
                        this.li.remove();
                    }
                };
            }
        };
    }
}

