/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.ast.xpath.AttributeAxisIterator;
import net.sourceforge.pmd.lang.ast.xpath.DocumentNavigator;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import org.apache.commons.lang3.ArrayUtils;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractNode
implements Node {
    private static final Logger LOG = Logger.getLogger(AbstractNode.class.getName());
    @Deprecated
    protected Node parent;
    @Deprecated
    protected Node[] children;
    @Deprecated
    protected int childIndex;
    @Deprecated
    protected int id;
    @Deprecated
    protected int beginLine = -1;
    @Deprecated
    protected int endLine;
    @Deprecated
    protected int beginColumn = -1;
    @Deprecated
    protected int endColumn;
    @Deprecated
    protected GenericToken firstToken;
    @Deprecated
    protected GenericToken lastToken;
    private DataFlowNode dataFlowNode;
    private Object userData;
    private String image;

    public AbstractNode(int id) {
        this.id = id;
    }

    public AbstractNode(int id, int theBeginLine, int theEndLine, int theBeginColumn, int theEndColumn) {
        this(id);
        this.beginLine = theBeginLine;
        this.endLine = theEndLine;
        this.beginColumn = theBeginColumn;
        this.endColumn = theEndColumn;
    }

    @Override
    public Node getParent() {
        return this.jjtGetParent();
    }

    @Override
    public int getIndexInParent() {
        return this.jjtGetChildIndex();
    }

    @Override
    public Node getChild(int index) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.children[index];
    }

    @Override
    public int getNumChildren() {
        return this.jjtGetNumChildren();
    }

    @Deprecated
    public boolean isSingleLine() {
        return this.beginLine == this.endLine;
    }

    @Override
    @Deprecated
    @InternalApi
    public void jjtOpen() {
    }

    @Override
    @Deprecated
    @InternalApi
    public void jjtClose() {
    }

    @Override
    @Deprecated
    @InternalApi
    public void jjtSetParent(Node parent) {
        this.parent = parent;
    }

    @Override
    @Deprecated
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    @Deprecated
    @InternalApi
    public void jjtAddChild(Node child, int index) {
        if (this.children == null) {
            this.children = new Node[index + 1];
        } else if (index >= this.children.length) {
            Node[] newChildren = new Node[index + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.children[index] = child;
        child.jjtSetChildIndex(index);
    }

    @Override
    @Deprecated
    @InternalApi
    public void jjtSetChildIndex(int index) {
        this.childIndex = index;
    }

    @Override
    @Deprecated
    public int jjtGetChildIndex() {
        return this.childIndex;
    }

    @Override
    @Deprecated
    public Node jjtGetChild(int index) {
        return this.children[index];
    }

    @Override
    @Deprecated
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    @Deprecated
    public int jjtGetId() {
        return this.id;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    @Deprecated
    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public boolean hasImageEqualTo(String image) {
        return Objects.equals(this.getImage(), image);
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Deprecated
    @InternalApi
    public void testingOnlySetBeginLine(int i) {
        this.beginLine = i;
    }

    @Override
    public int getBeginColumn() {
        if (this.beginColumn == -1) {
            if (this.children != null && this.children.length > 0) {
                return this.children[0].getBeginColumn();
            }
            throw new RuntimeException("Unable to determine beginning line of Node.");
        }
        return this.beginColumn;
    }

    @Deprecated
    @InternalApi
    public void testingOnlySetBeginColumn(int i) {
        this.beginColumn = i;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Deprecated
    @InternalApi
    public void testingOnlySetEndLine(int i) {
        this.endLine = i;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Deprecated
    @InternalApi
    public void testingOnlySetEndColumn(int i) {
        this.endColumn = i;
    }

    @Override
    public DataFlowNode getDataFlowNode() {
        if (this.dataFlowNode == null) {
            if (this.parent != null) {
                return this.parent.getDataFlowNode();
            }
            return null;
        }
        return this.dataFlowNode;
    }

    @Override
    public void setDataFlowNode(DataFlowNode dataFlowNode) {
        this.dataFlowNode = dataFlowNode;
    }

    @Override
    public Node getNthParent(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Node result = this.getParent();
        for (int i = 1; i < n; ++i) {
            if (result == null) {
                return null;
            }
            result = result.getParent();
        }
        return result;
    }

    @Override
    public <T> T getFirstParentOfType(Class<T> parentType) {
        Node parentNode;
        for (parentNode = this.getParent(); parentNode != null && !parentType.isInstance(parentNode); parentNode = parentNode.getParent()) {
        }
        return parentType.cast(parentNode);
    }

    @Override
    public <T> List<T> getParentsOfType(Class<T> parentType) {
        ArrayList<T> parents = new ArrayList<T>();
        for (Node parentNode = this.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
            if (!parentType.isInstance(parentNode)) continue;
            parents.add(parentType.cast(parentNode));
        }
        return parents;
    }

    @Override
    @SafeVarargs
    public final <T> T getFirstParentOfAnyType(Class<? extends T> ... parentTypes) {
        for (Node parentNode = this.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
            for (Class<T> clazz : parentTypes) {
                if (!clazz.isInstance(parentNode)) continue;
                return clazz.cast(parentNode);
            }
        }
        return null;
    }

    @Override
    public <T> List<T> findDescendantsOfType(Class<T> targetType) {
        ArrayList list = new ArrayList();
        AbstractNode.findDescendantsOfType(this, targetType, list, false);
        return list;
    }

    @Override
    public <T> List<T> findDescendantsOfType(Class<T> targetType, boolean crossBoundaries) {
        ArrayList list = new ArrayList();
        AbstractNode.findDescendantsOfType(this, targetType, list, crossBoundaries);
        return list;
    }

    @Override
    @Deprecated
    public <T> void findDescendantsOfType(Class<T> targetType, List<T> results, boolean crossBoundaries) {
        AbstractNode.findDescendantsOfType(this, targetType, results, crossBoundaries);
    }

    private static <T> void findDescendantsOfType(Node node, Class<T> targetType, List<T> results, boolean crossFindBoundaries) {
        for (Node node2 : node.children()) {
            if (targetType.isAssignableFrom(node2.getClass())) {
                results.add(targetType.cast(node2));
            }
            if (!crossFindBoundaries && node2.isFindBoundary()) continue;
            AbstractNode.findDescendantsOfType(node2, targetType, results, crossFindBoundaries);
        }
    }

    @Override
    public <T> List<T> findChildrenOfType(Class<T> targetType) {
        ArrayList<T> list = new ArrayList<T>();
        for (Node node : this.children()) {
            if (!targetType.isInstance(node)) continue;
            list.add(targetType.cast(node));
        }
        return list;
    }

    @Override
    public boolean isFindBoundary() {
        return false;
    }

    @Override
    public Document getAsDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            this.appendElement(document);
            return document;
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    protected void appendElement(org.w3c.dom.Node parentNode) {
        DocumentNavigator docNav = new DocumentNavigator();
        Document ownerDocument = parentNode.getOwnerDocument();
        if (ownerDocument == null) {
            ownerDocument = (Document)parentNode;
        }
        String elementName = docNav.getElementName(this);
        Element element = ownerDocument.createElement(elementName);
        parentNode.appendChild(element);
        Iterator<Object> iter = docNav.getAttributeAxisIterator(this);
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            element.setAttribute(attr.getName(), attr.getStringValue());
        }
        iter = docNav.getChildAxisIterator(this);
        while (iter.hasNext()) {
            AbstractNode child = (AbstractNode)iter.next();
            child.appendElement(element);
        }
    }

    @Override
    public <T> T getFirstDescendantOfType(Class<T> descendantType) {
        return AbstractNode.getFirstDescendantOfType(descendantType, this);
    }

    @Override
    public <T> T getFirstChildOfType(Class<T> childType) {
        for (Node node : this.children()) {
            if (!childType.isInstance(node)) continue;
            return childType.cast(node);
        }
        return null;
    }

    private static <T> T getFirstDescendantOfType(Class<T> descendantType, Node node) {
        for (Node node2 : node.children()) {
            T n2;
            if (descendantType.isAssignableFrom(node2.getClass())) {
                return descendantType.cast(node2);
            }
            if (node2.isFindBoundary() || (n2 = AbstractNode.getFirstDescendantOfType(descendantType, node2)) == null) continue;
            return n2;
        }
        return null;
    }

    @Override
    public final <T> boolean hasDescendantOfType(Class<T> type) {
        return this.getFirstDescendantOfType(type) != null;
    }

    @Deprecated
    public final boolean hasDecendantOfAnyType(Class<?> ... types) {
        return this.hasDescendantOfAnyType(types);
    }

    public final boolean hasDescendantOfAnyType(Class<?> ... types) {
        for (Class<?> type : types) {
            if (!this.hasDescendantOfType(type)) continue;
            return true;
        }
        return false;
    }

    public List<Node> findChildNodesWithXPath(String xpathString) throws JaxenException {
        return new BaseXPath(xpathString, new DocumentNavigator()).selectNodes(this);
    }

    @Override
    public boolean hasDescendantMatchingXPath(String xpathString) {
        try {
            return !this.findChildNodesWithXPath(xpathString).isEmpty();
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression " + xpathString + " failed: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Deprecated
    public GenericToken jjtGetFirstToken() {
        return this.firstToken;
    }

    @Deprecated
    public void jjtSetFirstToken(GenericToken token) {
        this.firstToken = token;
    }

    @Deprecated
    public GenericToken jjtGetLastToken() {
        return this.lastToken;
    }

    @Deprecated
    public void jjtSetLastToken(GenericToken token) {
        this.lastToken = token;
    }

    @Override
    public Iterable<? extends Node> children() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return AbstractNode.childrenIterator(AbstractNode.this);
            }
        };
    }

    private static Iterator<Node> childrenIterator(final Node parent) {
        assert (parent != null) : "parent should not be null";
        final int numChildren = parent.getNumChildren();
        if (numChildren == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<Node>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < numChildren;
            }

            @Override
            public Node next() {
                return parent.getChild(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove");
            }
        };
    }

    @Override
    @Deprecated
    @InternalApi
    public void remove() {
        Node parent = this.getParent();
        if (parent != null) {
            parent.removeChildAtIndex(this.getIndexInParent());
            this.jjtSetParent(null);
        }
    }

    @Override
    @Deprecated
    @InternalApi
    public void removeChildAtIndex(int childIndex) {
        if (0 <= childIndex && childIndex < this.getNumChildren()) {
            this.children = (Node[])ArrayUtils.remove((Object[])this.children, (int)childIndex);
            for (int i = childIndex; i < this.getNumChildren(); ++i) {
                this.getChild(i).jjtSetChildIndex(i);
            }
        }
    }

    @Override
    public String getXPathNodeName() {
        LOG.warning("getXPathNodeName should be overriden in classes derived from AbstractNode. The implementation is provided for compatibility with existing implementors,but could be declared abstract as soon as release " + PMDVersion.getNextMajorRelease() + ".");
        return this.toString();
    }

    @Deprecated
    public String toString() {
        return this.getXPathNodeName();
    }

    @Override
    public Iterator<Attribute> getXPathAttributesIterator() {
        return new AttributeAxisIterator(this);
    }
}

