/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.internal.DeprecatedAttribute;

public class Attribute {
    private static final Logger LOG = Logger.getLogger(Attribute.class.getName());
    static final ConcurrentMap<String, Boolean> DETECTED_DEPRECATED_ATTRIBUTES = new ConcurrentHashMap<String, Boolean>();
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private final Node parent;
    private final String name;
    private Method method;
    private List<?> value;
    private String stringValue;

    public Attribute(Node parent, String name, Method m) {
        this.parent = parent;
        this.name = name;
        this.method = m;
    }

    public Attribute(Node parent, String name, String value) {
        this.parent = parent;
        this.name = name;
        this.value = Collections.singletonList(value);
        this.stringValue = value;
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    @Experimental
    public Class<?> getType() {
        return this.method == null ? String.class : this.method.getReturnType();
    }

    private boolean isAttributeDeprecated() {
        return this.method != null && (this.method.isAnnotationPresent(Deprecated.class) || this.method.isAnnotationPresent(DeprecatedAttribute.class));
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value.get(0);
        }
        if (LOG.isLoggable(Level.WARNING) && this.isAttributeDeprecated() && DETECTED_DEPRECATED_ATTRIBUTES.putIfAbsent(this.getLoggableAttributeName(), Boolean.TRUE) == null) {
            LOG.warning("Use of deprecated attribute '" + this.getLoggableAttributeName() + "' in XPath query");
        }
        try {
            this.value = Collections.singletonList(this.method.invoke((Object)this.parent, EMPTY_OBJ_ARRAY));
            return this.value.get(0);
        }
        catch (IllegalAccessException | InvocationTargetException iae) {
            iae.printStackTrace();
            return null;
        }
    }

    public String getStringValue() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        Object v = this.getValue();
        this.stringValue = v == null ? "" : String.valueOf(v);
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.parent, attribute.parent) && Objects.equals(this.name, attribute.name);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name);
    }

    private String getLoggableAttributeName() {
        return this.parent.getXPathNodeName() + "/@" + this.name;
    }

    public String toString() {
        return this.name + ':' + this.getValue() + ':' + this.parent.getXPathNodeName();
    }
}

