/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics.internal;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.QualifiableNode;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.MetricsComputer;
import net.sourceforge.pmd.lang.metrics.ResultOption;
import net.sourceforge.pmd.lang.metrics.internal.DummyMetricMemoizer;
import net.sourceforge.pmd.lang.metrics.internal.DummyProjectMemoizer;

public abstract class AbstractLanguageMetricsProvider<T extends QualifiableNode, O extends QualifiableNode>
implements LanguageMetricsProvider<T, O> {
    private final Class<T> tClass;
    private final Class<O> oClass;
    private final MetricsComputer<T, O> myComputer;

    protected AbstractLanguageMetricsProvider(Class<T> tClass, Class<O> oClass, MetricsComputer<T, O> computer) {
        this.tClass = tClass;
        this.oClass = oClass;
        this.myComputer = computer;
    }

    @Override
    public T asTypeNode(Node anyNode) {
        return (T)(this.tClass.isInstance(anyNode) ? (QualifiableNode)this.tClass.cast(anyNode) : null);
    }

    @Override
    public O asOperationNode(Node anyNode) {
        return (O)(this.oClass.isInstance(anyNode) ? (QualifiableNode)this.oClass.cast(anyNode) : null);
    }

    @Override
    public double computeForType(MetricKey<T> key, T node, MetricOptions options) {
        return this.myComputer.computeForType(key, node, true, options, DummyMetricMemoizer.getInstance());
    }

    @Override
    public double computeForOperation(MetricKey<O> key, O node, MetricOptions options) {
        return this.myComputer.computeForOperation(key, node, true, options, DummyMetricMemoizer.getInstance());
    }

    @Override
    public double computeWithResultOption(MetricKey<O> key, T node, MetricOptions options, ResultOption option) {
        return this.myComputer.computeWithResultOption(key, node, true, options, option, DummyProjectMemoizer.getInstance());
    }

    @Override
    public Map<MetricKey<?>, Double> computeAllMetricsFor(Node node) {
        O o;
        HashMap results = new HashMap();
        T t = this.asTypeNode(node);
        if (t != null) {
            for (MetricKey tkey : this.getAvailableTypeMetrics()) {
                results.put(tkey, this.computeForType(tkey, t, MetricOptions.emptyOptions()));
            }
        }
        if ((o = this.asOperationNode(node)) != null) {
            for (MetricKey okey : this.getAvailableOperationMetrics()) {
                results.put(okey, this.computeForOperation(okey, o, MetricOptions.emptyOptions()));
            }
        }
        return results;
    }
}

