/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.xpath.JaxenXPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.SaxonXPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.XPathRuleQuery;
import net.sourceforge.pmd.properties.EnumeratedProperty;
import net.sourceforge.pmd.properties.StringProperty;
import org.apache.commons.lang3.StringUtils;

public class XPathRule
extends AbstractRule {
    public static final StringProperty XPATH_DESCRIPTOR = ((StringProperty.StringPBuilder)((StringProperty.StringPBuilder)((StringProperty.StringPBuilder)StringProperty.named("xpath").desc("XPath expression")).defaultValue("")).uiOrder(1.0f)).build();
    private static final Map<String, String> XPATH_VERSIONS;
    public static final EnumeratedProperty<String> VERSION_DESCRIPTOR;
    private XPathRuleQuery xpathRuleQuery;

    public XPathRule() {
        this.definePropertyDescriptor(XPATH_DESCRIPTOR);
        this.definePropertyDescriptor(VERSION_DESCRIPTOR);
        super.setTypeResolution(true);
    }

    public XPathRule(String xPath) {
        this();
        this.setXPath(xPath);
    }

    public void setXPath(String xPath) {
        this.setProperty(XPATH_DESCRIPTOR, xPath);
    }

    public void setVersion(String version) {
        this.setProperty(VERSION_DESCRIPTOR, version);
    }

    @Override
    public void apply(List<? extends Node> nodes, RuleContext ctx) {
        for (Node node : nodes) {
            this.evaluate(node, ctx);
        }
    }

    public void evaluate(Node node, RuleContext data) {
        if (this.xPathRuleQueryNeedsInitialization()) {
            this.initXPathRuleQuery();
        }
        List<Node> nodesWithViolation = this.xpathRuleQuery.evaluate(node, data);
        for (Node nodeWithViolation : nodesWithViolation) {
            this.addViolation((Object)data, nodeWithViolation, nodeWithViolation.getImage());
        }
    }

    private void initXPathRuleQuery() {
        String xpath = this.getProperty(XPATH_DESCRIPTOR);
        String version = this.getProperty(VERSION_DESCRIPTOR);
        this.initRuleQueryBasedOnVersion(version);
        this.xpathRuleQuery.setXPath(xpath);
        this.xpathRuleQuery.setVersion(version);
        this.xpathRuleQuery.setProperties(this.getPropertiesByPropertyDescriptor());
    }

    private boolean xPathRuleQueryNeedsInitialization() {
        return this.xpathRuleQuery == null;
    }

    private void initRuleQueryBasedOnVersion(String version) {
        this.xpathRuleQuery = "1.0".equals(version) ? new JaxenXPathRuleQuery() : new SaxonXPathRuleQuery();
    }

    @Override
    public List<String> getRuleChainVisits() {
        if (this.xPathRuleQueryNeedsInitialization()) {
            this.initXPathRuleQuery();
            for (String nodeName : this.xpathRuleQuery.getRuleChainVisits()) {
                super.addRuleChainVisit(nodeName);
            }
        }
        return super.getRuleChainVisits();
    }

    @Override
    public String dysfunctionReason() {
        return this.hasXPathExpression() ? null : "Missing xPath expression";
    }

    private boolean hasXPathExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getProperty(XPATH_DESCRIPTOR));
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("1.0", "1.0");
        tmp.put("1.0 compatibility", "1.0 compatibility");
        tmp.put("2.0", "2.0");
        XPATH_VERSIONS = Collections.unmodifiableMap(tmp);
        VERSION_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)((EnumeratedProperty.EnumPBuilder)((EnumeratedProperty.EnumPBuilder)EnumeratedProperty.named("version").desc("XPath specification version")).mappings(XPATH_VERSIONS).defaultValue("1.0")).type(String.class).uiOrder(2.0f)).build();
    }
}

