/* Generated By:JavaCC: Do not edit this line. SqlParserImpl.java */
package org.apache.calcite.sql.parser.impl;


import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAlter;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDescribeSchema;
import org.apache.calcite.sql.SqlDescribeTable;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlHint;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJdbcDataTypeName;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonEncoding;
import org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonValueReturning;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPivot;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlTableRef;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.SqlUnpivot;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.Span;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.Glossary;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;

import org.slf4j.Logger;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import static org.apache.calcite.util.Static.RESOURCE;

/**
 * SQL parser, generated from Parser.jj by JavaCC.
 *
 * <p>The public wrapper for this parser is {@link SqlParser}.
 */
public class SqlParserImpl extends SqlAbstractParserImpl implements SqlParserImplConstants {
    private static final Logger LOGGER = CalciteTrace.getParserTracer();

    // Can't use quoted literal because of a bug in how JavaCC translates
    // backslash-backslash.
    private static final char BACKSLASH = 0x5c;
    private static final char DOUBLE_QUOTE = 0x22;
    private static final String DQ = DOUBLE_QUOTE + "";
    private static final String DQDQ = DQ + DQ;

    private static Metadata metadata;

    private Casing unquotedCasing;
    private Casing quotedCasing;
    private int identifierMaxLength;
    private SqlConformance conformance;

    /**
     * {@link SqlParserImplFactory} implementation for creating parser.
     */
    public static final SqlParserImplFactory FACTORY = new SqlParserImplFactory() {
        public SqlAbstractParserImpl getParser(Reader reader) {
            final SqlParserImpl parser = new SqlParserImpl(reader);
            if (reader instanceof SourceStringReader) {
                final String sql =
                    ((SourceStringReader) reader).getSourceString();
                parser.setOriginalSql(sql);
            }
          return parser;
        }
    };

    public SqlParseException normalizeException(Throwable ex) {
        try {
            if (ex instanceof ParseException) {
                ex = cleanupParseException((ParseException) ex);
            }
            return convertException(ex);
        } catch (ParseException e) {
            throw new AssertionError(e);
        }
    }

    public Metadata getMetadata() {
        synchronized (SqlParserImpl.class) {
            if (metadata == null) {
                metadata = new MetadataImpl(
                    new SqlParserImpl(new java.io.StringReader("")));
            }
            return metadata;
        }
    }

    public void setTabSize(int tabSize) {
        jj_input_stream.setTabSize(tabSize);
    }

    public void switchTo(SqlAbstractParserImpl.LexicalState state) {
        final int stateOrdinal =
            Arrays.asList(SqlParserImplTokenManager.lexStateNames)
                .indexOf(state.name());
        token_source.SwitchTo(stateOrdinal);
    }

    public void setQuotedCasing(Casing quotedCasing) {
        this.quotedCasing = quotedCasing;
    }

    public void setUnquotedCasing(Casing unquotedCasing) {
        this.unquotedCasing = unquotedCasing;
    }

    public void setIdentifierMaxLength(int identifierMaxLength) {
        this.identifierMaxLength = identifierMaxLength;
    }

    public void setConformance(SqlConformance conformance) {
        this.conformance = conformance;
    }

    public SqlNode parseSqlExpressionEof() throws Exception {
        return SqlExpressionEof();
    }

    public SqlNode parseSqlStmtEof() throws Exception {
        return SqlStmtEof();
    }

    public SqlNodeList parseSqlStmtList() throws Exception {
        return SqlStmtList();
    }

    private SqlNode extend(SqlNode table, SqlNodeList extendList) {
        return SqlStdOperatorTable.EXTEND.createCall(
            Span.of(table, extendList).pos(), table, extendList);
    }

    /** Adds a warning that a token such as "HOURS" was used,
    * whereas the SQL standard only allows "HOUR".
    *
    * <p>Currently, we silently add an exception to a list of warnings. In
    * future, we may have better compliance checking, for example a strict
    * compliance mode that throws if any non-standard features are used. */
    private TimeUnit warn(TimeUnit timeUnit) throws ParseException {
        final String token = getToken(0).image.toUpperCase(Locale.ROOT);
        warnings.add(
            SqlUtil.newContextException(getPos(),
                RESOURCE.nonStandardFeatureUsed(token)));
        return timeUnit;
    }

  void debug_message1() throws ParseException {
    LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

  String unquotedIdentifier() throws ParseException {
    return SqlParserUtil.toCase(getToken(0).image, unquotedCasing);
  }

/**
 * Allows parser to be extended with new types of table references.  The
 * default implementation of this production is empty.
 */
  final public SqlNode ExtendedTableRef() throws ParseException {
    UnusedExtension();
        {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * Allows an OVER clause following a table expression as an extension to
 * standard SQL syntax. The default implementation of this production is empty.
 */
  final public SqlNode TableOverOpt() throws ParseException {
        {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/*
 * Parses dialect-specific keywords immediately following the SELECT keyword.
 */
  final public void SqlSelectKeywords(List<SqlLiteral> keywords) throws ParseException {
    E();
  }

/*
 * Parses dialect-specific keywords immediately following the INSERT keyword.
 */
  final public void SqlInsertKeywords(List<SqlLiteral> keywords) throws ParseException {
    E();
  }

/*
* Parse Floor/Ceil function parameters
*/
  final public SqlNode FloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
    SqlNode node;
    node = StandardFloorCeilOptions(s, floorFlag);
        {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  void E() throws ParseException {
  }

  List startList(Object o) throws ParseException {
    List list = new ArrayList();
    list.add(o);
    return list;
  }

  protected SqlParserPos getPos() throws ParseException {
    return new SqlParserPos(
        token.beginLine,
        token.beginColumn,
        token.endLine,
        token.endColumn);
  }

  Span span() throws ParseException {
    return Span.of(getPos());
  }

  void checkQueryExpression(ExprContext exprContext) throws ParseException {
    switch (exprContext) {
    case ACCEPT_NON_QUERY:
    case ACCEPT_SUB_QUERY:
    case ACCEPT_CURSOR:
        throw SqlUtil.newContextException(getPos(),
            RESOURCE.illegalQueryExpression());
    }
  }

  void checkNonQueryExpression(ExprContext exprContext) throws ParseException {
    switch (exprContext) {
    case ACCEPT_QUERY:
        throw SqlUtil.newContextException(getPos(),
            RESOURCE.illegalNonQueryExpression());
    }
  }

  SqlParseException convertException(Throwable ex) throws ParseException {
    if (ex instanceof SqlParseException) {
        return (SqlParseException) ex;
    }
    SqlParserPos pos = null;
    int[][] expectedTokenSequences = null;
    String[] tokenImage = null;
    if (ex instanceof ParseException) {
        ParseException pex = (ParseException) ex;
        expectedTokenSequences = pex.expectedTokenSequences;
        tokenImage = pex.tokenImage;
        if (pex.currentToken != null) {
            final Token token = pex.currentToken.next;
            // Checks token.image.equals("1") to avoid recursive call.
            // The SqlAbstractParserImpl#MetadataImpl constructor uses constant "1" to
            // throw intentionally to collect the expected tokens.
            if (!token.image.equals("1")
                && getMetadata().isKeyword(token.image)
                && SqlParserUtil.allowsIdentifier(tokenImage, expectedTokenSequences)) {
                // If the next token is a keyword, reformat the error message as:

                // Incorrect syntax near the keyword '{keyword}' at line {line_number},
                // column {column_number}.
                final String expecting = ex.getMessage()
                    .substring(ex.getMessage().indexOf("Was expecting"));
                final String errorMsg = String.format("Incorrect syntax near the keyword '%s' "
                        + "at line %d, column %d.\n%s",
                    token.image,
                    token.beginLine,
                    token.beginColumn,
                    expecting);
                // Replace the ParseException with explicit error message.
                ex = new ParseException(errorMsg);
            }
            pos = new SqlParserPos(
                token.beginLine,
                token.beginColumn,
                token.endLine,
                token.endColumn);
        }
    } else if (ex instanceof TokenMgrError) {
        TokenMgrError tme = (TokenMgrError) ex;
        expectedTokenSequences = null;
        tokenImage = null;
        // Example:
        //    Lexical error at line 3, column 24.  Encountered "#" after "a".
        final java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(
            "(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
        java.util.regex.Matcher matcher = pattern.matcher(ex.getMessage());
        if (matcher.matches()) {
            int line = Integer.parseInt(matcher.group(1));
            int column = Integer.parseInt(matcher.group(2));
            pos = new SqlParserPos(line, column, line, column);
        }
    } else if (ex instanceof CalciteContextException) {
        // CalciteContextException is the standard wrapper for exceptions
        // produced by the validator, but in the parser, the standard is
        // SqlParseException; so, strip it away. In case you were wondering,
        // the CalciteContextException appears because the parser
        // occasionally calls into validator-style code such as
        // SqlSpecialOperator.reduceExpr.
        CalciteContextException ece =
            (CalciteContextException) ex;
        pos = new SqlParserPos(
            ece.getPosLine(),
            ece.getPosColumn(),
            ece.getEndPosLine(),
            ece.getEndPosColumn());
        ex = ece.getCause();
    }

    return new SqlParseException(
        ex.getMessage(), pos, expectedTokenSequences, tokenImage, ex);
  }

  ParseException cleanupParseException(ParseException ex) throws ParseException {
    if (ex.expectedTokenSequences == null) {
        return ex;
    }
    int iIdentifier = Arrays.asList(ex.tokenImage).indexOf("<IDENTIFIER>");

    // Find all sequences in the error which contain identifier. For
    // example,
    //       {<IDENTIFIER>}
    //       {A}
    //       {B, C}
    //       {D, <IDENTIFIER>}
    //       {D, A}
    //       {D, B}
    //
    // would yield
    //       {}
    //       {D}
    boolean id = false;
    final List<int[]> prefixList = new ArrayList<int[]>();
    for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
        int[] seq = ex.expectedTokenSequences[i];
        int j = seq.length - 1;
        int i1 = seq[j];
        if (i1 == iIdentifier) {
            int[] prefix = new int[j];
            System.arraycopy(seq, 0, prefix, 0, j);
            prefixList.add(prefix);
        }
    }

    if (prefixList.isEmpty()) {
        return ex;
    }

    int[][] prefixes = (int[][])
        prefixList.toArray(new int[prefixList.size()][]);

    // Since <IDENTIFIER> was one of the possible productions,
    // we know that the parser will also have included all
    // of the non-reserved keywords (which are treated as
    // identifiers in non-keyword contexts).  So, now we need
    // to clean those out, since they're totally irrelevant.

    final List<int[]> list = new ArrayList<int[]>();
    Metadata metadata = getMetadata();
    for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
        int [] seq = ex.expectedTokenSequences[i];
        String tokenImage = ex.tokenImage[seq[seq.length - 1]];
        String token = SqlParserUtil.getTokenVal(tokenImage);
        if (token == null  || !metadata.isNonReservedKeyword(token)) {
            list.add(seq);
            continue;
        }
        boolean match = matchesPrefix(seq, prefixes);
        if (!match) {
            list.add(seq);
        }
    }

    ex.expectedTokenSequences =
        (int [][]) list.toArray(new int [list.size()][]);
    return ex;
  }

  boolean matchesPrefix(int[] seq, int[][] prefixes) throws ParseException {
    nextPrefix:
    for (int[] prefix : prefixes) {
        if (seq.length == prefix.length + 1) {
            for (int k = 0; k < prefix.length; k++) {
                if (prefix[k] != seq[k]) {
                    continue nextPrefix;
                }
            }
            return true;
        }
    }
    return false;
  }

/*****************************************
 * Syntactical Descriptions              *
 *****************************************/

/**
 * Parses either a row expression or a query expression with an optional
 * ORDER BY.
 *
 * <p>Postgres syntax for limit:
 *
 * <blockquote><pre>
 *    [ LIMIT { count | ALL } ]
 *    [ OFFSET start ]</pre>
 * </blockquote>
 *
 * <p>MySQL syntax for limit:
 *
 * <blockquote><pre>
 *    [ LIMIT { count | start, count } ]</pre>
 * </blockquote>
 *
 * <p>SQL:2008 syntax for limit:
 *
 * <blockquote><pre>
 *    [ OFFSET start { ROW | ROWS } ]
 *    [ FETCH { FIRST | NEXT } [ count ] { ROW | ROWS } ONLY ]</pre>
 * </blockquote>
 */
  final public SqlNode OrderedQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    SqlNodeList orderBy = null;
    SqlNode start = null;
    SqlNode count = null;
    e = QueryOrExpr(exprContext);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      // use the syntactic type of the expression we just parsed
              // to decide whether ORDER BY makes sense
              orderBy = OrderBy(e.isA(SqlKind.QUERY));
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      jj_consume_token(LIMIT);
      if (jj_2_1(2)) {
        start = UnsignedNumericLiteralOrParam();
        jj_consume_token(COMMA);
        count = UnsignedNumericLiteralOrParam();
                if (!this.conformance.isLimitStartCountAllowed()) {
                    {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.limitStartCountNotAllowed());}
                }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
        case HOOK:
          count = UnsignedNumericLiteralOrParam();
          break;
        case ALL:
          jj_consume_token(ALL);
          break;
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFFSET:
      jj_consume_token(OFFSET);
      start = UnsignedNumericLiteralOrParam();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
      case ROWS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ROW:
          jj_consume_token(ROW);
          break;
        case ROWS:
          jj_consume_token(ROWS);
          break;
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[4] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FETCH:
      jj_consume_token(FETCH);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FIRST:
        jj_consume_token(FIRST);
        break;
      case NEXT:
        jj_consume_token(NEXT);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      count = UnsignedNumericLiteralOrParam();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
        break;
      case ROWS:
        jj_consume_token(ROWS);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ONLY);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
        if (orderBy != null || start != null || count != null) {
            if (orderBy == null) {
                orderBy = SqlNodeList.EMPTY;
            }
            e = new SqlOrderBy(getPos(), e, orderBy, start, count);

        }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a leaf in a query expression (SELECT, VALUES or TABLE).
 */
  final public SqlNode LeafQuery(ExprContext exprContext) throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
        // ensure a query is legal in this context
        checkQueryExpression(exprContext);
      e = SqlSelect();
                      {if (true) return e;}
      break;
    case VALUES:
      e = TableConstructor();
                             {if (true) return e;}
      break;
    case TABLE:
      e = ExplicitTable(getPos());
                                  {if (true) return e;}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a parenthesized query or single row expression.
 */
  final public SqlNode ParenthesizedExpression(ExprContext exprContext) throws ParseException {
    SqlNode e;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so queries inside should
        // be allowed as sub-queries
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            exprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            exprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    e = OrderedQueryOrExpr(exprContext);
    jj_consume_token(RPAREN);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a parenthesized query or comma-list of row expressions.
 *
 * <p>REVIEW jvs 8-Feb-2004: There's a small hole in this production.  It can be
 * used to construct something like
 *
 * <blockquote><pre>
 * WHERE x IN (select count(*) from t where c=d,5)</pre>
 * </blockquote>
 *
 * <p>which should be illegal.  The above is interpreted as equivalent to
 *
 * <blockquote><pre>
 * WHERE x IN ((select count(*) from t where c=d),5)</pre>
 * </blockquote>
 *
 * <p>which is a legal use of a sub-query.  The only way to fix the hole is to
 * be able to remember whether a subexpression was parenthesized or not, which
 * means preserving parentheses in the SqlNode tree.  This is probably
 * desirable anyway for use in purely syntactic parsing applications (e.g. SQL
 * pretty-printer).  However, if this is done, it's important to also make
 * isA() on the paren node call down to its operand so that we can
 * always correctly discriminate a query from a row expression.
 */
  final public SqlNodeList ParenthesizedQueryOrCommaList(ExprContext exprContext) throws ParseException {
    SqlNode e;
    List<SqlNode> list;
    ExprContext firstExprContext = exprContext;
    final Span s;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so a query by itself should
        // be interpreted as a sub-query
        s = span();
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    e = OrderedQueryOrExpr(firstExprContext);
        list = startList(e);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      e = Expression(exprContext);
            list.add(e);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** As ParenthesizedQueryOrCommaList, but allows DEFAULT
 * in place of any of the expressions. For example,
 * {@code (x, DEFAULT, null, DEFAULT)}. */
  final public SqlNodeList ParenthesizedQueryOrCommaListWithDefault(ExprContext exprContext) throws ParseException {
    SqlNode e;
    List<SqlNode> list;
    ExprContext firstExprContext = exprContext;
    final Span s;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so a query by itself should
        // be interpreted as a sub-query
        s = span();
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = OrderedQueryOrExpr(firstExprContext);
      break;
    case DEFAULT_:
      e = Default();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        list = startList(e);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_2;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = Expression(exprContext);
        break;
      case DEFAULT_:
        e = Default();
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            list.add(e);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses function parameter lists.
 * If the list starts with DISTINCT or ALL, it is discarded.
 */
  final public List UnquantifiedFunctionParameterList(ExprContext exprContext) throws ParseException {
    final List args;
    args = FunctionParameterList(exprContext);
        final SqlLiteral quantifier = (SqlLiteral) args.get(0);
        args.remove(0); // remove DISTINCT or ALL, if present
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses function parameter lists including DISTINCT keyword recognition,
 * DEFAULT, and named argument assignment.
 */
  final public List FunctionParameterList(ExprContext exprContext) throws ParseException {
    final SqlLiteral qualifier;
    final List list = new ArrayList();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      qualifier = AllOrDistinct();
                                      list.add(qualifier);
      break;
    default:
      jj_la1[14] = jj_gen;
          list.add(null);
    }
    Arg0(list, exprContext);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      Arg(list, exprContext);
    }
    jj_consume_token(RPAREN);
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral AllOrDistinct() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                 {if (true) return SqlSelectKeyword.DISTINCT.symbol(getPos());}
      break;
    case ALL:
      jj_consume_token(ALL);
            {if (true) return SqlSelectKeyword.ALL.symbol(getPos());}
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void Arg0(List list, ExprContext exprContext) throws ParseException {
    SqlIdentifier name = null;
    SqlNode e = null;
    final ExprContext firstExprContext;
    {
        // we've now seen left paren, so queries inside should
        // be allowed as sub-queries
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        default:
            firstExprContext = exprContext;
            break;
        }
    }
    if (jj_2_2(2)) {
      name = SimpleIdentifier();
      jj_consume_token(NAMED_ARGUMENT_ASSIGNMENT);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_:
      e = Default();
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = OrderedQueryOrExpr(firstExprContext);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (e != null) {
            if (name != null) {
                e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(
                    Span.of(name, e).pos(), e, name);
            }
            list.add(e);
        }
  }

  final public void Arg(List list, ExprContext exprContext) throws ParseException {
    SqlIdentifier name = null;
    SqlNode e = null;
    if (jj_2_3(2)) {
      name = SimpleIdentifier();
      jj_consume_token(NAMED_ARGUMENT_ASSIGNMENT);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_:
      e = Default();
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(exprContext);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (e != null) {
            if (name != null) {
                e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(
                    Span.of(name, e).pos(), e, name);
            }
            list.add(e);
        }
  }

  final public SqlNode Default() throws ParseException {
    jj_consume_token(DEFAULT_);
        {if (true) return SqlStdOperatorTable.DEFAULT.createCall(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a query (SELECT, UNION, INTERSECT, EXCEPT, VALUES, TABLE) followed by
 * the end-of-file symbol.
 */
  final public SqlNode SqlQueryEof() throws ParseException {
    SqlNode query;
    query = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
    jj_consume_token(0);
      {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of SQL statements separated by semicolon.
 * The semicolon is required between statements, but is
 * optional at the end.
 */
  final public SqlNodeList SqlStmtList() throws ParseException {
    final List<SqlNode> stmtList = new ArrayList<SqlNode>();
    SqlNode stmt;
    stmt = SqlStmt();
        stmtList.add(stmt);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_4;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CALL:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DELETE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIBE:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXPLAIN:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSERT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MERGE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESET:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SET:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPDATE:
      case UPPER:
      case UPSERT:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        stmt = SqlStmt();
                stmtList.add(stmt);
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
    }
    jj_consume_token(0);
        {if (true) return new SqlNodeList(stmtList, Span.of(stmtList).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an SQL statement.
 */
  final public SqlNode SqlStmt() throws ParseException {
    SqlNode stmt;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RESET:
    case SET:
      stmt = SqlSetOption(Span.of(), null);
      break;
    case ALTER:
      stmt = SqlAlter();
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
      break;
    case EXPLAIN:
      stmt = SqlExplain();
      break;
    case DESCRIBE:
      stmt = SqlDescribe();
      break;
    case INSERT:
    case UPSERT:
      stmt = SqlInsert();
      break;
    case DELETE:
      stmt = SqlDelete();
      break;
    case UPDATE:
      stmt = SqlUpdate();
      break;
    case MERGE:
      stmt = SqlMerge();
      break;
    case CALL:
      stmt = SqlProcedureCall();
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an SQL statement followed by the end-of-file symbol.
 */
  final public SqlNode SqlStmtEof() throws ParseException {
    SqlNode stmt;
    stmt = SqlStmt();
    jj_consume_token(0);
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList ParenthesizedKeyValueOptionCommaList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
      s = span();
    jj_consume_token(LPAREN);
    KeyValueOption(list);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      KeyValueOption(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an option with format key=val whose key is a simple identifier or string literal
* and value is a string literal.
*/
  final public void KeyValueOption(List<SqlNode> list) throws ParseException {
    final SqlNode key;
    final SqlNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      key = SimpleIdentifier();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      key = StringLiteral();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(EQ);
    value = StringLiteral();
        list.add(key);
        list.add(value);
  }

/**
* Parses an option value, it's either a string or a numeric.
*/
  final public SqlNode OptionValue() throws ParseException {
    final SqlNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case PLUS:
    case MINUS:
      value = NumericLiteral();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      value = StringLiteral();
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a literal list separated by comma. The literal is either a string or a numeric.
 */
  final public SqlNodeList ParenthesizedLiteralOptionCommaList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    SqlNode optionVal;
      s = span();
    jj_consume_token(LPAREN);
    optionVal = OptionValue();
        list.add(optionVal);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_6;
      }
      jj_consume_token(COMMA);
      optionVal = OptionValue();
            list.add(optionVal);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void CommaSeparatedSqlHints(List<SqlNode> hints) throws ParseException {
    SqlIdentifier hintName;
    SqlNodeList hintOptions;
    SqlNode optionVal;
    SqlHint.HintOptionFormat optionFormat;
    hintName = SimpleIdentifier();
    if (jj_2_4(5)) {
      hintOptions = ParenthesizedKeyValueOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.KV_LIST;
    } else if (jj_2_5(3)) {
      hintOptions = ParenthesizedSimpleIdentifierList();
            optionFormat = SqlHint.HintOptionFormat.ID_LIST;
    } else if (jj_2_6(3)) {
      hintOptions = ParenthesizedLiteralOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.LITERAL_LIST;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[26] = jj_gen;
        ;
      }
            hintOptions = SqlNodeList.EMPTY;
            optionFormat = SqlHint.HintOptionFormat.EMPTY;
    }
        hints.add(new SqlHint(Span.of(hintOptions).end(this), hintName, hintOptions, optionFormat));
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      hintName = SimpleIdentifier();
      if (jj_2_7(5)) {
        hintOptions = ParenthesizedKeyValueOptionCommaList();
                optionFormat = SqlHint.HintOptionFormat.KV_LIST;
      } else if (jj_2_8(3)) {
        hintOptions = ParenthesizedSimpleIdentifierList();
                optionFormat = SqlHint.HintOptionFormat.ID_LIST;
      } else if (jj_2_9(3)) {
        hintOptions = ParenthesizedLiteralOptionCommaList();
                optionFormat = SqlHint.HintOptionFormat.LITERAL_LIST;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[28] = jj_gen;
          ;
        }
                hintOptions = SqlNodeList.EMPTY;
                optionFormat = SqlHint.HintOptionFormat.EMPTY;
      }
            hints.add(new SqlHint(Span.of(hintOptions).end(this), hintName, hintOptions, optionFormat));
    }
  }

/**
 * Parses a table reference with optional hints.
 */
  final public SqlNode TableRefWithHintsOpt() throws ParseException {
    SqlNode tableRef;
    SqlNodeList hintList;
    final List<SqlNode> hints = new ArrayList<SqlNode>();
    final Span s;
      s = span();
    tableRef = CompoundTableIdentifier();
    if (jj_2_10(2)) {
      jj_consume_token(HINT_BEG);
      CommaSeparatedSqlHints(hints);
      jj_consume_token(COMMENT_END);
            hintList = new SqlNodeList(hints, s.addAll(hints).end(this));
            tableRef = new SqlTableRef(Span.of(tableRef, hintList).pos(),
                    (SqlIdentifier) tableRef, hintList);
    } else {
      ;
    }
        {if (true) return tableRef;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a leaf SELECT expression without ORDER BY.
 */
  final public SqlSelect SqlSelect() throws ParseException {
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlLiteral keyword;
    final SqlNodeList keywordList;
    List<SqlNode> selectList;
    final SqlNode fromClause;
    final SqlNode where;
    final SqlNodeList groupBy;
    final SqlNode having;
    final SqlNodeList windowDecls;
    final List<SqlNode> hints = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(SELECT);
        s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      jj_consume_token(HINT_BEG);
      CommaSeparatedSqlHints(hints);
      jj_consume_token(COMMENT_END);
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    SqlSelectKeywords(keywords);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STREAM:
      jj_consume_token(STREAM);
            keywords.add(SqlSelectKeyword.STREAM.symbol(getPos()));
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      keyword = AllOrDistinct();
                                    keywords.add(keyword);
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
        keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
    selectList = SelectList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      fromClause = FromClause();
      where = WhereOpt();
      groupBy = GroupByOpt();
      having = HavingOpt();
      windowDecls = WindowOpt();
      break;
    default:
      jj_la1[32] = jj_gen;
      E();
            fromClause = null;
            where = null;
            groupBy = null;
            having = null;
            windowDecls = null;
    }
        {if (true) return new SqlSelect(s.end(this), keywordList,
            new SqlNodeList(selectList, Span.of(selectList).pos()),
            fromClause, where, groupBy, having, windowDecls, null, null, null,
            new SqlNodeList(hints, getPos()));}
    throw new Error("Missing return statement in function");
  }

/*
 * Abstract production:
 *
 *    void SqlSelectKeywords(List keywords)
 *
 * Parses dialect-specific keywords immediately following the SELECT keyword.
 */

/**
 * Parses an EXPLAIN PLAN statement.
 */
  final public SqlNode SqlExplain() throws ParseException {
    SqlNode stmt;
    SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    SqlExplain.Depth depth;
    final SqlExplainFormat format;
    jj_consume_token(EXPLAIN);
    jj_consume_token(PLAN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLUDING:
    case INCLUDING:
      detailLevel = ExplainDetailLevel();
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    depth = ExplainDepth();
    if (jj_2_11(2)) {
      jj_consume_token(AS);
      jj_consume_token(XML);
                     format = SqlExplainFormat.XML;
    } else if (jj_2_12(2)) {
      jj_consume_token(AS);
      jj_consume_token(JSON);
                      format = SqlExplainFormat.JSON;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        jj_consume_token(DOT_FORMAT);
                            format = SqlExplainFormat.DOT;
        break;
      default:
        jj_la1[34] = jj_gen;
          format = SqlExplainFormat.TEXT;
      }
    }
    jj_consume_token(FOR);
    stmt = SqlQueryOrDml();
        {if (true) return new SqlExplain(getPos(),
            stmt,
            detailLevel.symbol(SqlParserPos.ZERO),
            depth.symbol(SqlParserPos.ZERO),
            format.symbol(SqlParserPos.ZERO),
            nDynamicParams);}
    throw new Error("Missing return statement in function");
  }

/** Parses a query (SELECT or VALUES)
 * or DML statement (INSERT, UPDATE, DELETE, MERGE). */
  final public SqlNode SqlQueryOrDml() throws ParseException {
    SqlNode stmt;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
      break;
    case INSERT:
    case UPSERT:
      stmt = SqlInsert();
      break;
    case DELETE:
      stmt = SqlDelete();
      break;
    case UPDATE:
      stmt = SqlUpdate();
      break;
    case MERGE:
      stmt = SqlMerge();
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses WITH TYPE | WITH IMPLEMENTATION | WITHOUT IMPLEMENTATION modifier for
 * EXPLAIN PLAN.
 */
  final public SqlExplain.Depth ExplainDepth() throws ParseException {
    if (jj_2_13(2)) {
      jj_consume_token(WITH);
      jj_consume_token(TYPE);
            {if (true) return SqlExplain.Depth.TYPE;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(IMPLEMENTATION);
            {if (true) return SqlExplain.Depth.PHYSICAL;}
        break;
      case WITHOUT:
        jj_consume_token(WITHOUT);
        jj_consume_token(IMPLEMENTATION);
            {if (true) return SqlExplain.Depth.LOGICAL;}
        break;
      default:
        jj_la1[36] = jj_gen;
            {if (true) return SqlExplain.Depth.PHYSICAL;}
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses INCLUDING ALL ATTRIBUTES modifier for EXPLAIN PLAN.
 */
  final public SqlExplainLevel ExplainDetailLevel() throws ParseException {
    SqlExplainLevel level = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      jj_consume_token(ATTRIBUTES);
            level = SqlExplainLevel.NO_ATTRIBUTES;
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                  level = SqlExplainLevel.ALL_ATTRIBUTES;
        break;
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      jj_consume_token(ATTRIBUTES);

      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return level;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a DESCRIBE statement.
 */
  final public SqlNode SqlDescribe() throws ParseException {
   final Span s;
   final SqlIdentifier table;
   final SqlIdentifier column;
   final SqlIdentifier id;
   final SqlNode stmt;
    jj_consume_token(DESCRIBE);
                 s = span();
    if (jj_2_14(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATABASE:
        jj_consume_token(DATABASE);
        break;
      case CATALOG:
        jj_consume_token(CATALOG);
        break;
      case SCHEMA:
        jj_consume_token(SCHEMA);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      id = CompoundIdentifier();
            // DESCRIBE DATABASE and DESCRIBE CATALOG currently do the same as
            // DESCRIBE SCHEMA but should be different. See
            //   [CALCITE-1221] Implement DESCRIBE DATABASE, CATALOG, STATEMENT
            {if (true) return new SqlDescribeSchema(s.end(id), id);}
    } else if (jj_2_15(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
        jj_consume_token(TABLE);
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      table = CompoundIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        column = SimpleIdentifier();
        break;
      default:
        jj_la1[41] = jj_gen;
        E();
                  column = null;
      }
            {if (true) return new SqlDescribeTable(s.add(table).addIf(column).pos(),
                table, column);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DELETE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSERT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MERGE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPDATE:
      case UPPER:
      case UPSERT:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STATEMENT:
          jj_consume_token(STATEMENT);
          break;
        default:
          jj_la1[42] = jj_gen;
          ;
        }
        stmt = SqlQueryOrDml();
            // DESCRIBE STATEMENT currently does the same as EXPLAIN. See
            //   [CALCITE-1221] Implement DESCRIBE DATABASE, CATALOG, STATEMENT
            final SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
            final SqlExplain.Depth depth = SqlExplain.Depth.PHYSICAL;
            final SqlExplainFormat format = SqlExplainFormat.TEXT;
            {if (true) return new SqlExplain(s.end(stmt),
                stmt,
                detailLevel.symbol(SqlParserPos.ZERO),
                depth.symbol(SqlParserPos.ZERO),
                format.symbol(SqlParserPos.ZERO),
                nDynamicParams);}
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CALL statement.
 */
  final public SqlNode SqlProcedureCall() throws ParseException {
    final Span s;
    SqlNode routineCall;
    jj_consume_token(CALL);
        s = span();
    routineCall = NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_PROCEDURE,
            ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.PROCEDURE_CALL.createCall(
            s.end(routineCall), routineCall);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode NamedRoutineCall(SqlFunctionCategory routineType,
    ExprContext exprContext) throws ParseException {
    SqlIdentifier name;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    name = CompoundIdentifier();
        s = span();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULT_:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      Arg0(list, exprContext);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
                // a comma-list can't appear where only a query is expected
                checkNonQueryExpression(exprContext);
        Arg(list, exprContext);
      }
      break;
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return createCall(name, s.end(this), routineType, null, list);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an INSERT statement.
 */
  final public SqlNode SqlInsert() throws ParseException {
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlNodeList keywordList;
    SqlNode table;
    SqlNodeList extendList = null;
    SqlNode source;
    SqlNodeList columnList = null;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
      break;
    case UPSERT:
      jj_consume_token(UPSERT);
                   keywords.add(SqlInsertKeyword.UPSERT.symbol(getPos()));
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
    jj_consume_token(INTO);
    table = TableRefWithHintsOpt();
    if (jj_2_16(5)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTEND:
        jj_consume_token(EXTEND);
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      extendList = ExtendList();
            table = extend(table, extendList);
    } else {
      ;
    }
    if (jj_2_17(2)) {
          final Pair<SqlNodeList, SqlNodeList> p;
      p = ParenthesizedCompoundIdentifierList();
            if (p.right.size() > 0) {
                table = extend(table, p.right);
            }
            if (p.left.size() > 0) {
                columnList = p.left;
            }
    } else {
      ;
    }
    source = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlInsert(s.end(source), keywordList, table, source,
            columnList);}
    throw new Error("Missing return statement in function");
  }

/*
 * Abstract production:
 *
 *    void SqlInsertKeywords(List keywords)
 *
 * Parses dialect-specific keywords immediately following the INSERT keyword.
 */

/**
 * Parses a DELETE statement.
 */
  final public SqlNode SqlDelete() throws ParseException {
    SqlNode table;
    SqlNodeList extendList = null;
    SqlIdentifier alias = null;
    final SqlNode condition;
    final Span s;
    jj_consume_token(DELETE);
        s = span();
    jj_consume_token(FROM);
    table = TableRefWithHintsOpt();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTEND:
        jj_consume_token(EXTEND);
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      extendList = ExtendList();
            table = extend(table, extendList);
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    condition = WhereOpt();
        {if (true) return new SqlDelete(s.add(table).addIf(extendList).addIf(alias)
            .addIf(condition).pos(), table, condition, null, alias);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an UPDATE statement.
 */
  final public SqlNode SqlUpdate() throws ParseException {
    SqlNode table;
    SqlNodeList extendList = null;
    SqlIdentifier alias = null;
    SqlNode condition;
    SqlNodeList sourceExpressionList;
    SqlNodeList targetColumnList;
    SqlIdentifier id;
    SqlNode exp;
    final Span s;
    jj_consume_token(UPDATE);
               s = span();
    table = TableRefWithHintsOpt();
        targetColumnList = new SqlNodeList(s.pos());
        sourceExpressionList = new SqlNodeList(s.pos());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTEND:
        jj_consume_token(EXTEND);
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      extendList = ExtendList();
            table = extend(table, extendList);
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    jj_consume_token(SET);
    id = SimpleIdentifier();
        targetColumnList.add(id);
    jj_consume_token(EQ);
    exp = Expression(ExprContext.ACCEPT_SUB_QUERY);
        // TODO:  support DEFAULT also
        sourceExpressionList.add(exp);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[56] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      id = SimpleIdentifier();
            targetColumnList.add(id);
      jj_consume_token(EQ);
      exp = Expression(ExprContext.ACCEPT_SUB_QUERY);
            sourceExpressionList.add(exp);
    }
    condition = WhereOpt();
        {if (true) return new SqlUpdate(s.addAll(targetColumnList)
            .addAll(sourceExpressionList).addIf(condition).pos(), table,
            targetColumnList, sourceExpressionList, condition, null, alias);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a MERGE statement.
 */
  final public SqlNode SqlMerge() throws ParseException {
    SqlNode table;
    SqlNodeList extendList = null;
    SqlIdentifier alias = null;
    SqlNode sourceTableRef;
    SqlNode condition;
    SqlUpdate updateCall = null;
    SqlInsert insertCall = null;
    final Span s;
    jj_consume_token(MERGE);
              s = span();
    jj_consume_token(INTO);
    table = TableRefWithHintsOpt();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTEND:
        jj_consume_token(EXTEND);
        break;
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      extendList = ExtendList();
            table = extend(table, extendList);
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    jj_consume_token(USING);
    sourceTableRef = TableRef();
    jj_consume_token(ON);
    condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
    if (jj_2_18(2)) {
      updateCall = WhenMatchedClause(table, alias);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        insertCall = WhenNotMatchedClause(table);
        break;
      default:
        jj_la1[61] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        insertCall = WhenNotMatchedClause(table);
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return new SqlMerge(s.addIf(updateCall).addIf(insertCall).pos(), table,
            condition, sourceTableRef, updateCall, insertCall, null, alias);}
    throw new Error("Missing return statement in function");
  }

  final public SqlUpdate WhenMatchedClause(SqlNode table, SqlIdentifier alias) throws ParseException {
    SqlIdentifier id;
    final Span s;
    final SqlNodeList updateColumnList = new SqlNodeList(SqlParserPos.ZERO);
    SqlNode exp;
    final SqlNodeList updateExprList = new SqlNodeList(SqlParserPos.ZERO);
    jj_consume_token(WHEN);
             s = span();
    jj_consume_token(MATCHED);
    jj_consume_token(THEN);
    jj_consume_token(UPDATE);
    jj_consume_token(SET);
    id = CompoundIdentifier();
        updateColumnList.add(id);
    jj_consume_token(EQ);
    exp = Expression(ExprContext.ACCEPT_SUB_QUERY);
        updateExprList.add(exp);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[63] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      id = CompoundIdentifier();
            updateColumnList.add(id);
      jj_consume_token(EQ);
      exp = Expression(ExprContext.ACCEPT_SUB_QUERY);
            updateExprList.add(exp);
    }
        {if (true) return new SqlUpdate(s.addAll(updateExprList).pos(), table,
            updateColumnList, updateExprList, null, null, alias);}
    throw new Error("Missing return statement in function");
  }

  final public SqlInsert WhenNotMatchedClause(SqlNode table) throws ParseException {
    final Span insertSpan, valuesSpan;
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlNodeList keywordList;
    SqlNodeList insertColumnList = null;
    SqlNode rowConstructor;
    SqlNode insertValues;
    jj_consume_token(WHEN);
    jj_consume_token(NOT);
    jj_consume_token(MATCHED);
    jj_consume_token(THEN);
    jj_consume_token(INSERT);
        insertSpan = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, insertSpan.end(this));
    if (jj_2_19(2)) {
      insertColumnList = ParenthesizedSimpleIdentifierList();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    jj_consume_token(VALUES);
               valuesSpan = span();
    rowConstructor = RowConstructor();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RPAREN:
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
        // TODO zfong 5/26/06: note that extra parentheses are accepted above
        // around the VALUES clause as a hack for unparse, but this is
        // actually invalid SQL; should fix unparse
        insertValues = SqlStdOperatorTable.VALUES.createCall(
            valuesSpan.end(this), rowConstructor);
        {if (true) return new SqlInsert(insertSpan.end(this), keywordList,
            table, insertValues, insertColumnList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the select list of a SELECT statement.
 */
  final public List<SqlNode> SelectList() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    SqlNode item;
    item = SelectItem();
        list.add(item);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      item = SelectItem();
            list.add(item);
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one item in a select list.
 */
  final public SqlNode SelectItem() throws ParseException {
    SqlNode e;
    final SqlIdentifier id;
    e = SelectExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case QUOTED_STRING:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[67] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        id = SimpleIdentifier();
        break;
      case QUOTED_STRING:
        id = SimpleIdentifierFromStringLiteral();
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            e = SqlStdOperatorTable.AS.createCall(span().end(e), e, id);
      break;
    default:
      jj_la1[69] = jj_gen;
      ;
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one unaliased expression in a select list.
 */
  final public SqlNode SelectExpression() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
        {if (true) return SqlIdentifier.star(getPos());}
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return e;}
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral Natural() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NATURAL:
      jj_consume_token(NATURAL);
                {if (true) return SqlLiteral.createBoolean(true, getPos());}
      break;
    default:
      jj_la1[71] = jj_gen;
      {if (true) return SqlLiteral.createBoolean(false, getPos());}
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral JoinType() throws ParseException {
    JoinType joinType;
    if (jj_2_20(3)) {
      jj_consume_token(JOIN);
                 joinType = JoinType.INNER;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INNER:
        jj_consume_token(INNER);
        jj_consume_token(JOIN);
                         joinType = JoinType.INNER;
        break;
      case LEFT:
        jj_consume_token(LEFT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[72] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                    joinType = JoinType.LEFT;
        break;
      case RIGHT:
        jj_consume_token(RIGHT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[73] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                     joinType = JoinType.RIGHT;
        break;
      case FULL:
        jj_consume_token(FULL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[74] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                    joinType = JoinType.FULL;
        break;
      case CROSS:
        jj_consume_token(CROSS);
        jj_consume_token(JOIN);
                         joinType = JoinType.CROSS;
        break;
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return joinType.symbol(getPos());}
    throw new Error("Missing return statement in function");
  }

/** Matches "LEFT JOIN t ON ...", "RIGHT JOIN t USING ...", "JOIN t". */
  final public SqlNode JoinTable(SqlNode e) throws ParseException {
    SqlNode e2, condition;
    final SqlLiteral natural, joinType, on, using;
    SqlNodeList list;
    natural = Natural();
    joinType = JoinType();
    e2 = TableRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ON:
      jj_consume_token(ON);
               on = JoinConditionType.ON.symbol(getPos());
      condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                on,
                condition);}
      break;
    case USING:
      jj_consume_token(USING);
                  using = JoinConditionType.USING.symbol(getPos());
      list = ParenthesizedSimpleIdentifierList();
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                using,
                new SqlNodeList(list, Span.of(using).end(this)));}
      break;
    default:
      jj_la1[76] = jj_gen;
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                JoinConditionType.NONE.symbol(joinType.getParserPosition()),
                null);}
    }
    throw new Error("Missing return statement in function");
  }

// TODO jvs 15-Nov-2003:  SQL standard allows parentheses in the FROM list for
// building up non-linear join trees (e.g. OUTER JOIN two tables, and then INNER
// JOIN the result).  Also note that aliases on parenthesized FROM expressions
// "hide" all table names inside the parentheses (without aliases, they're
// visible).
//
// We allow CROSS JOIN to have a join condition, even though that is not valid
// SQL; the validator will catch it.
/**
 * Parses the FROM clause for a SELECT.
 *
 * <p>FROM is mandatory in standard SQL, optional in dialects such as MySQL,
 * PostgreSQL. The parser allows SELECT without FROM, but the validator fails
 * if conformance is, say, STRICT_2003.
 */
  final public SqlNode FromClause() throws ParseException {
    SqlNode e, e2, condition;
    SqlLiteral natural, joinType, joinConditionType;
    SqlNodeList list;
    SqlParserPos pos;
    e = TableRef();
    label_12:
    while (true) {
      if (jj_2_21(2)) {
        ;
      } else {
        break label_12;
      }
      if (jj_2_22(3)) {
        natural = Natural();
        joinType = JoinType();
        e2 = TableRef();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ON:
          jj_consume_token(ON);
                    joinConditionType = JoinConditionType.ON.symbol(getPos());
          condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
                    e = new SqlJoin(joinType.getParserPosition(),
                        e,
                        natural,
                        joinType,
                        e2,
                        joinConditionType,
                        condition);
          break;
        case USING:
          jj_consume_token(USING);
                    joinConditionType = JoinConditionType.USING.symbol(getPos());
          list = ParenthesizedSimpleIdentifierList();
                    e = new SqlJoin(joinType.getParserPosition(),
                        e,
                        natural,
                        joinType,
                        e2,
                        joinConditionType,
                        new SqlNodeList(list.getList(), Span.of(joinConditionType).end(this)));
          break;
        default:
          jj_la1[77] = jj_gen;
                    e = new SqlJoin(joinType.getParserPosition(),
                        e,
                        natural,
                        joinType,
                        e2,
                        JoinConditionType.NONE.symbol(joinType.getParserPosition()),
                        null);
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
                      joinType = JoinType.COMMA.symbol(getPos());
          e2 = TableRef();
                e = new SqlJoin(joinType.getParserPosition(),
                    e,
                    SqlLiteral.createBoolean(false, joinType.getParserPosition()),
                    joinType,
                    e2,
                    JoinConditionType.NONE.symbol(SqlParserPos.ZERO),
                    null);
          break;
        case CROSS:
          jj_consume_token(CROSS);
                      joinType = JoinType.CROSS.symbol(getPos());
          jj_consume_token(APPLY);
          e2 = TableRef2(true);
                if (!this.conformance.isApplyAllowed()) {
                    {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.applyNotAllowed());}
                }
                e = new SqlJoin(joinType.getParserPosition(),
                    e,
                    SqlLiteral.createBoolean(false, joinType.getParserPosition()),
                    joinType,
                    e2,
                    JoinConditionType.NONE.symbol(SqlParserPos.ZERO),
                    null);
          break;
        case OUTER:
          jj_consume_token(OUTER);
                      joinType = JoinType.LEFT.symbol(getPos());
          jj_consume_token(APPLY);
          e2 = TableRef2(true);
                if (!this.conformance.isApplyAllowed()) {
                    {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.applyNotAllowed());}
                }
                e = new SqlJoin(joinType.getParserPosition(),
                    e,
                    SqlLiteral.createBoolean(false, joinType.getParserPosition()),
                    joinType,
                    e2,
                    JoinConditionType.ON.symbol(SqlParserPos.ZERO),
                    SqlLiteral.createBoolean(true, joinType.getParserPosition()));
          break;
        default:
          jj_la1[78] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a table reference in a FROM clause, not lateral unless LATERAL
 * is explicitly specified.
 */
  final public SqlNode TableRef() throws ParseException {
    final SqlNode e;
    e = TableRef2(false);
                           {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a table reference in a FROM clause.
 */
  final public SqlNode TableRef2(boolean lateral) throws ParseException {
    SqlNode tableRef;
    final SqlNode over;
    final SqlNode snapshot;
    final SqlNode match;
    SqlNodeList extendList = null;
    final SqlIdentifier alias;
    final Span s, s2;
    SqlNodeList args;
    SqlNode sample;
    boolean isBernoulli;
    SqlNumericLiteral samplePercentage;
    boolean isRepeatable = false;
    int repeatableSeed = 0;
    SqlNodeList columnAliasList = null;
    SqlUnnestOperator unnestOp = SqlStdOperatorTable.UNNEST;
    if (jj_2_23(2)) {
      tableRef = TableRefWithHintsOpt();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTEND:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXTEND:
          jj_consume_token(EXTEND);
          break;
        default:
          jj_la1[79] = jj_gen;
          ;
        }
        extendList = ExtendList();
                tableRef = extend(tableRef, extendList);
        break;
      default:
        jj_la1[80] = jj_gen;
        ;
      }
      over = TableOverOpt();
            if (over != null) {
                tableRef = SqlStdOperatorTable.OVER.createCall(
                    getPos(), tableRef, over);
            }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        tableRef = Snapshot(tableRef);
        break;
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH_RECOGNIZE:
        tableRef = MatchRecognize(tableRef);
        break;
      default:
        jj_la1[82] = jj_gen;
        ;
      }
    } else if (jj_2_24(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LATERAL:
        jj_consume_token(LATERAL);
                      lateral = true;
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      tableRef = ParenthesizedExpression(ExprContext.ACCEPT_QUERY);
      over = TableOverOpt();
            if (over != null) {
                tableRef = SqlStdOperatorTable.OVER.createCall(
                    getPos(), tableRef, over);
            }
            if (lateral) {
                tableRef = SqlStdOperatorTable.LATERAL.createCall(
                    getPos(), tableRef);
            }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH_RECOGNIZE:
        tableRef = MatchRecognize(tableRef);
        break;
      default:
        jj_la1[84] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNNEST:
        jj_consume_token(UNNEST);
                   s = span();
        args = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_SUB_QUERY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          jj_consume_token(ORDINALITY);
                unnestOp = SqlStdOperatorTable.UNNEST_WITH_ORDINALITY;
          break;
        default:
          jj_la1[85] = jj_gen;
          ;
        }
            tableRef = unnestOp.createCall(s.end(this), (List<SqlNode>) args);
        break;
      case LATERAL:
      case TABLE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LATERAL:
          jj_consume_token(LATERAL);
                     lateral = true;
          break;
        default:
          jj_la1[86] = jj_gen;
          ;
        }
        jj_consume_token(TABLE);
                  s = span();
        jj_consume_token(LPAREN);
        tableRef = TableFunctionCall(s.pos());
        jj_consume_token(RPAREN);
            if (lateral) {
                tableRef = SqlStdOperatorTable.LATERAL.createCall(
                    s.end(this), tableRef);
            }
        break;
      default:
        jj_la1[87] = jj_gen;
        if (jj_2_25(1)) {
          tableRef = ExtendedTableRef();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    if (jj_2_26(2)) {
      tableRef = Pivot(tableRef);
    } else {
      ;
    }
    if (jj_2_27(2)) {
      tableRef = Unpivot(tableRef);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        columnAliasList = ParenthesizedSimpleIdentifierList();
        break;
      default:
        jj_la1[89] = jj_gen;
        ;
      }
            if (columnAliasList == null) {
                tableRef = SqlStdOperatorTable.AS.createCall(
                    Span.of(tableRef).end(this), tableRef, alias);
            } else {
                List<SqlNode> idList = new ArrayList<SqlNode>();
                idList.add(tableRef);
                idList.add(alias);
                idList.addAll(columnAliasList.getList());
                tableRef = SqlStdOperatorTable.AS.createCall(
                    Span.of(tableRef).end(this), idList);
            }
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLESAMPLE:
      jj_consume_token(TABLESAMPLE);
                        s2 = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUBSTITUTE:
        jj_consume_token(SUBSTITUTE);
        jj_consume_token(LPAREN);
        sample = StringLiteral();
        jj_consume_token(RPAREN);
                String sampleName =
                    SqlLiteral.unchain(sample).getValueAs(String.class);
                SqlSampleSpec sampleSpec = SqlSampleSpec.createNamed(sampleName);
                final SqlLiteral sampleLiteral =
                    SqlLiteral.createSample(sampleSpec, s2.end(this));
                tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(
                    s2.add(tableRef).end(this), tableRef, sampleLiteral);
        break;
      case BERNOULLI:
      case SYSTEM:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BERNOULLI:
          jj_consume_token(BERNOULLI);
                    isBernoulli = true;
          break;
        case SYSTEM:
          jj_consume_token(SYSTEM);
                    isBernoulli = false;
          break;
        default:
          jj_la1[91] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        samplePercentage = UnsignedNumericLiteral();
        jj_consume_token(RPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case REPEATABLE:
          jj_consume_token(REPEATABLE);
          jj_consume_token(LPAREN);
          repeatableSeed = IntLiteral();
          jj_consume_token(RPAREN);
                    isRepeatable = true;
          break;
        default:
          jj_la1[92] = jj_gen;
          ;
        }
                final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
                BigDecimal rate = samplePercentage.bigDecimalValue();
                if (rate.compareTo(BigDecimal.ZERO) < 0
                    || rate.compareTo(ONE_HUNDRED) > 0)
                {
                    {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.invalidSampleSize());}
                }

                // Treat TABLESAMPLE(0) and TABLESAMPLE(100) as no table
                // sampling at all.  Not strictly correct: TABLESAMPLE(0)
                // should produce no output, but it simplifies implementation
                // to know that some amount of sampling will occur.
                // In practice values less than ~1E-43% are treated as 0.0 and
                // values greater than ~99.999997% are treated as 1.0
                float fRate = rate.divide(ONE_HUNDRED).floatValue();
                if (fRate > 0.0f && fRate < 1.0f) {
                    SqlSampleSpec tableSampleSpec =
                    isRepeatable
                        ? SqlSampleSpec.createTableSample(
                            isBernoulli, fRate, repeatableSeed)
                        : SqlSampleSpec.createTableSample(isBernoulli, fRate);

                    SqlLiteral tableSampleLiteral =
                        SqlLiteral.createSample(tableSampleSpec, s2.end(this));
                    tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(
                        s2.end(this), tableRef, tableSampleLiteral);
                }
        break;
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
        {if (true) return tableRef;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList ExtendList() throws ParseException {
    final Span s;
    List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    ColumnType(list);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      ColumnType(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void ColumnType(List<SqlNode> list) throws ParseException {
    SqlIdentifier name;
    SqlDataTypeSpec type;
    boolean nullable = true;
    name = CompoundIdentifier();
    type = DataType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
            nullable = false;
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
        list.add(name);
        list.add(type.withNullable(nullable, getPos()));
  }

/**
 * Parses a compound identifier with optional type.
 */
  final public void CompoundIdentifierType(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
    final SqlIdentifier name;
    SqlDataTypeSpec type = null;
    boolean nullable = true;
    name = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case ANY:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BIGINT:
    case BINARY:
    case BOOLEAN:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHARACTER:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DEC:
    case DECADE:
    case DECIMAL:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOUBLE:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FLOAT:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INT:
    case INTEGER:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case NUMERIC:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case REAL:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SMALLINT:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TINYINT:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VARBINARY:
    case VARCHAR:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      type = DataType();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
        jj_consume_token(NULL);
                nullable = false;
        break;
      default:
        jj_la1[97] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[98] = jj_gen;
      ;
    }
        if (type != null) {
            if (!this.conformance.allowExtend()) {
                {if (true) throw SqlUtil.newContextException(type.getParserPosition(),
                    RESOURCE.extendNotAllowed());}
            }
            extendList.add(name);
            extendList.add(type.withNullable(nullable, getPos()));
        }
        list.add(name);
  }

  final public SqlNode TableFunctionCall(SqlParserPos pos) throws ParseException {
    SqlNode call;
    SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPECIFIC:
      jj_consume_token(SPECIFIC);
            funcType = SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION;
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    call = NamedRoutineCall(funcType, ExprContext.ACCEPT_CURSOR);
        {if (true) return SqlStdOperatorTable.COLLECTION_TABLE.createCall(pos, call);}
    throw new Error("Missing return statement in function");
  }

/**
 * Abstract production:
 *    SqlNode ExtendedTableRef()
 *
 * <p>Allows parser to be extended with new types of table references.  The
 * default implementation of this production is empty.
 */

/*
 * Abstract production:
 *
 *    SqlNode TableOverOpt()
 *
 * Allows an OVER clause following a table expression as an extension to
 * standard SQL syntax. The default implementation of this production is empty.
 */

/**
 * Parses an explicit TABLE t reference.
 */
  final public SqlNode ExplicitTable(SqlParserPos pos) throws ParseException {
    SqlNode tableRef;
    jj_consume_token(TABLE);
    tableRef = CompoundIdentifier();
        {if (true) return SqlStdOperatorTable.EXPLICIT_TABLE.createCall(pos, tableRef);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a VALUES leaf query expression.
 */
  final public SqlNode TableConstructor() throws ParseException {
    final List<SqlNode> rowConstructorList = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(VALUES);
               s = span();
    RowConstructorList(rowConstructorList);
        {if (true) return SqlStdOperatorTable.VALUES.createCall(
            s.end(this), rowConstructorList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one or more rows in a VALUES expression.
 */
  final public void RowConstructorList(List<SqlNode> list) throws ParseException {
    SqlNode rowConstructor;
    rowConstructor = RowConstructor();
                                        list.add(rowConstructor);
    label_14:
    while (true) {
      if (jj_2_28(2)) {
        ;
      } else {
        break label_14;
      }
      jj_consume_token(COMMA);
      rowConstructor = RowConstructor();
                                                    list.add(rowConstructor);
    }
  }

/**
 * Parses a row constructor in the context of a VALUES expression.
 */
  final public SqlNode RowConstructor() throws ParseException {
    SqlNodeList valueList;
    SqlNode value;
    final Span s;
    if (jj_2_29(3)) {
      jj_consume_token(LPAREN);
                   s = span();
      jj_consume_token(ROW);
      valueList = ParenthesizedQueryOrCommaListWithDefault(ExprContext.ACCEPT_NONCURSOR);
      jj_consume_token(RPAREN);
                   s.add(this);
    } else if (jj_2_30(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
                    s = span();
        break;
      default:
        jj_la1[100] = jj_gen;
              s = Span.of();
      }
      valueList = ParenthesizedQueryOrCommaListWithDefault(ExprContext.ACCEPT_NONCURSOR);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        value = Expression(ExprContext.ACCEPT_NONCURSOR);
            // NOTE: A bare value here is standard SQL syntax, believe it or
            // not.  Taken together with multi-row table constructors, it leads
            // to very easy mistakes if you forget the parentheses on a
            // single-row constructor.  This is also the reason for the
            // LOOKAHEAD in RowConstructorList().  It would be so much more
            // reasonable to require parentheses.  Sigh.
            s = Span.of(value);
            valueList = new SqlNodeList(Collections.singletonList(value),
                value.getParserPosition());
        break;
      default:
        jj_la1[101] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        // REVIEW jvs 8-Feb-2004: Should we discriminate between scalar
        // sub-queries inside of ROW and row sub-queries?  The standard does,
        // but the distinction seems to be purely syntactic.
        {if (true) return SqlStdOperatorTable.ROW.createCall(s.end(valueList),
            (List<SqlNode>) valueList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the optional WHERE clause for SELECT, DELETE, and UPDATE.
 */
  final public SqlNode WhereOpt() throws ParseException {
    SqlNode condition;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return condition;}
      break;
    default:
      jj_la1[102] = jj_gen;
        {if (true) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the optional GROUP BY clause for SELECT.
 */
  final public SqlNodeList GroupByOpt() throws ParseException {
    List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GROUP:
      jj_consume_token(GROUP);
              s = span();
      jj_consume_token(BY);
      list = GroupingElementList();
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
      break;
    default:
      jj_la1[103] = jj_gen;
        {if (true) return null;}
    }
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> GroupingElementList() throws ParseException {
    List<SqlNode> list = new ArrayList<SqlNode>();
    SqlNode e;
    e = GroupingElement();
                            list.add(e);
    label_15:
    while (true) {
      if (jj_2_31(2)) {
        ;
      } else {
        break label_15;
      }
      jj_consume_token(COMMA);
      e = GroupingElement();
                                list.add(e);
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode GroupingElement() throws ParseException {
    List<SqlNode> list;
    final SqlNodeList nodes;
    final SqlNode e;
    final Span s;
    if (jj_2_32(2)) {
      jj_consume_token(GROUPING);
                 s = span();
      jj_consume_token(SETS);
      jj_consume_token(LPAREN);
      list = GroupingElementList();
      jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.GROUPING_SETS.createCall(s.end(this), list);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROLLUP:
        jj_consume_token(ROLLUP);
               s = span();
        jj_consume_token(LPAREN);
        nodes = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.ROLLUP.createCall(s.end(this),
            nodes.getList());}
        break;
      case CUBE:
        jj_consume_token(CUBE);
             s = span();
        jj_consume_token(LPAREN);
        nodes = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.CUBE.createCall(s.end(this),
            nodes.getList());}
        break;
      default:
        jj_la1[104] = jj_gen;
        if (jj_2_33(3)) {
          jj_consume_token(LPAREN);
          jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(getPos());}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case A:
          case ABS:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ARRAY:
          case ARRAY_AGG:
          case ARRAY_CONCAT_AGG:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case AVG:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CARDINALITY:
          case CASCADE:
          case CASE:
          case CAST:
          case CATALOG:
          case CATALOG_NAME:
          case CEIL:
          case CEILING:
          case CENTURY:
          case CHAIN:
          case CHAR_LENGTH:
          case CHARACTER_LENGTH:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASSIFIER:
          case CLASS_ORIGIN:
          case COALESCE:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLLECT:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CONVERT:
          case COUNT:
          case COVAR_POP:
          case COVAR_SAMP:
          case CUME_DIST:
          case CURRENT:
          case CURRENT_CATALOG:
          case CURRENT_DATE:
          case CURRENT_DEFAULT_TRANSFORM_GROUP:
          case CURRENT_PATH:
          case CURRENT_ROLE:
          case CURRENT_SCHEMA:
          case CURRENT_TIME:
          case CURRENT_TIMESTAMP:
          case CURRENT_USER:
          case CURSOR:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATE:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DENSE_RANK:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOT_FORMAT:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ELEMENT:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EVERY:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case EXISTS:
          case EXP:
          case EXTRACT:
          case FALSE:
          case FINAL:
          case FIRST:
          case FIRST_VALUE:
          case FLOOR:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case FUSION:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case GROUP_CONCAT:
          case GROUPING:
          case HIERARCHY:
          case HOP:
          case HOUR:
          case HOURS:
          case IGNORE:
          case ILIKE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDE:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INTERSECTION:
          case INTERVAL:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case JSON_ARRAY:
          case JSON_ARRAYAGG:
          case JSON_EXISTS:
          case JSON_OBJECT:
          case JSON_OBJECTAGG:
          case JSON_QUERY:
          case JSON_VALUE:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAG:
          case LAST:
          case LAST_VALUE:
          case LEAD:
          case LEFT:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LN:
          case LOCALTIME:
          case LOCALTIMESTAMP:
          case LOCATOR:
          case LOWER:
          case M:
          case MAP:
          case MATCHED:
          case MATCH_NUMBER:
          case MAX:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MIN:
          case MINUTE:
          case MINUTES:
          case MINVALUE:
          case MOD:
          case MONTH:
          case MONTHS:
          case MORE_:
          case MULTISET:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NEW:
          case NEXT:
          case NORMALIZED:
          case NOT:
          case NTH_VALUE:
          case NTILE:
          case NULL:
          case NULLABLE:
          case NULLIF:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTET_LENGTH:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERLAY:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PERCENT_RANK:
          case PERIOD:
          case PIVOT:
          case PLACING:
          case PLAN:
          case PLI:
          case POSITION:
          case POWER:
          case PRECEDING:
          case PRESERVE:
          case PREV:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case RANK:
          case READ:
          case REGR_COUNT:
          case REGR_SXX:
          case REGR_SYY:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case RIGHT:
          case RLIKE:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW:
          case ROW_COUNT:
          case ROW_NUMBER:
          case RUNNING:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECOND:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEPARATOR:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SESSION_USER:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOME:
          case SOURCE:
          case SPACE:
          case SPECIFIC:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case SQRT:
          case STATE:
          case STATEMENT:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case STRING_AGG:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case SUBSTRING:
          case SUM:
          case SYSTEM_USER:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIME:
          case TIMESTAMP:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRANSLATE:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TRIM:
          case TRUE:
          case TRUNCATE:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNKNOWN:
          case UNPIVOT:
          case UNNAMED:
          case UPPER:
          case USAGE:
          case USER:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VAR_POP:
          case VAR_SAMP:
          case VERSION:
          case VIEW:
          case WEEK:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEAR:
          case YEARS:
          case ZONE:
          case UNSIGNED_INTEGER_LITERAL:
          case APPROX_NUMERIC_LITERAL:
          case DECIMAL_NUMERIC_LITERAL:
          case BINARY_STRING_LITERAL:
          case QUOTED_STRING:
          case PREFIXED_STRING_LITERAL:
          case UNICODE_STRING_LITERAL:
          case BIG_QUERY_DOUBLE_QUOTED_STRING:
          case BIG_QUERY_QUOTED_STRING:
          case LPAREN:
          case LBRACE_D:
          case LBRACE_T:
          case LBRACE_TS:
          case LBRACE_FN:
          case HOOK:
          case PLUS:
          case MINUS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return e;}
            break;
          default:
            jj_la1[105] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of expressions separated by commas.
 */
  final public SqlNodeList ExpressionCommaList(final Span s,
    ExprContext exprContext) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    ExpressionCommaList2(list, exprContext);
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of expressions separated by commas,
 * appending expressions to a given list.
 */
  final public void ExpressionCommaList2(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    SqlNode e;
    e = Expression(exprContext);
                                  list.add(e);
    label_16:
    while (true) {
      if (jj_2_34(2)) {
        ;
      } else {
        break label_16;
      }
      jj_consume_token(COMMA);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            list.add(e);
    }
  }

/**
 * Parses the optional HAVING clause for SELECT.
 */
  final public SqlNode HavingOpt() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HAVING:
      jj_consume_token(HAVING);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                            {if (true) return e;}
      break;
    default:
      jj_la1[106] = jj_gen;
      {if (true) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the optional WINDOW clause for SELECT
 */
  final public SqlNodeList WindowOpt() throws ParseException {
    SqlIdentifier id;
    SqlWindow e;
    List<SqlNode> list;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WINDOW:
      jj_consume_token(WINDOW);
               s = span();
      id = SimpleIdentifier();
      jj_consume_token(AS);
      e = WindowSpecification();
        e.setDeclName(id);
        list = startList(e);
      label_17:
      while (true) {
        if (jj_2_35(2)) {
          ;
        } else {
          break label_17;
        }
        jj_consume_token(COMMA);
        id = SimpleIdentifier();
        jj_consume_token(AS);
        e = WindowSpecification();
            e.setDeclName(id);
            list.add(e);
      }
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
      break;
    default:
      jj_la1[107] = jj_gen;
        {if (true) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a window specification.
 */
  final public SqlWindow WindowSpecification() throws ParseException {
    SqlIdentifier id;
    List list;
    SqlNodeList partitionList;
    SqlNodeList orderList;
    SqlLiteral isRows = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
    SqlNode lowerBound = null, upperBound = null;
    SqlParserPos startPos;
    final Span s, s1, s2;
    SqlLiteral allowPartial = null;
    jj_consume_token(LPAREN);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      id = SimpleIdentifier();
      break;
    default:
      jj_la1[108] = jj_gen;
          id = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
                      s1 = span();
      jj_consume_token(BY);
      partitionList = ExpressionCommaList(s1, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[109] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderBy(true);
      break;
    default:
      jj_la1[110] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RANGE:
    case ROWS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROWS:
        jj_consume_token(ROWS);
                     isRows = SqlLiteral.createBoolean(true, getPos());
        break;
      case RANGE:
        jj_consume_token(RANGE);
                      isRows = SqlLiteral.createBoolean(false, getPos());
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
        jj_consume_token(BETWEEN);
        lowerBound = WindowRange();
        jj_consume_token(AND);
        upperBound = WindowRange();
        break;
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        lowerBound = WindowRange();
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALLOW:
    case DISALLOW:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALLOW:
        jj_consume_token(ALLOW);
                  s2 = span();
        jj_consume_token(PARTIAL);
            allowPartial = SqlLiteral.createBoolean(true, s2.end(this));
        break;
      case DISALLOW:
        jj_consume_token(DISALLOW);
                     s2 = span();
        jj_consume_token(PARTIAL);
            allowPartial = SqlLiteral.createBoolean(false, s2.end(this));
        break;
      default:
        jj_la1[114] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[115] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlWindow.create(
            null, id, partitionList, orderList,
            isRows, lowerBound, upperBound, allowPartial, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode WindowRange() throws ParseException {
    final SqlNode e;
    final Span s;
    if (jj_2_36(2)) {
      jj_consume_token(CURRENT);
                s = span();
      jj_consume_token(ROW);
        {if (true) return SqlWindow.createCurrentRow(s.end(this));}
    } else if (jj_2_37(2)) {
      jj_consume_token(UNBOUNDED);
                  s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDING:
        jj_consume_token(PRECEDING);
            {if (true) return SqlWindow.createUnboundedPreceding(s.end(this));}
        break;
      case FOLLOWING:
        jj_consume_token(FOLLOWING);
            {if (true) return SqlWindow.createUnboundedFollowing(s.end(this));}
        break;
      default:
        jj_la1[116] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = Expression(ExprContext.ACCEPT_NON_QUERY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRECEDING:
          jj_consume_token(PRECEDING);
            {if (true) return SqlWindow.createPreceding(e, getPos());}
          break;
        case FOLLOWING:
          jj_consume_token(FOLLOWING);
            {if (true) return SqlWindow.createFollowing(e, getPos());}
          break;
        default:
          jj_la1[117] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an ORDER BY clause.
 */
  final public SqlNodeList OrderBy(boolean accept) throws ParseException {
    List<SqlNode> list;
    SqlNode e;
    final Span s;
    jj_consume_token(ORDER);
        s = span();
        if (!accept) {
            // Someone told us ORDER BY wasn't allowed here.  So why
            // did they bother calling us?  To get the correct
            // parser position for error reporting.
            {if (true) throw SqlUtil.newContextException(s.pos(), RESOURCE.illegalOrderBy());}
        }
    jj_consume_token(BY);
    e = OrderItem();
        list = startList(e);
    label_18:
    while (true) {
      if (jj_2_38(2)) {
        ;
      } else {
        break label_18;
      }
      jj_consume_token(COMMA);
      e = OrderItem();
                                               list.add(e);
    }
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one list item in an ORDER BY clause.
 */
  final public SqlNode OrderItem() throws ParseException {
    SqlNode e;
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
        jj_consume_token(ASC);
        break;
      case DESC:
        jj_consume_token(DESC);
            e = SqlStdOperatorTable.DESC.createCall(getPos(), e);
        break;
      default:
        jj_la1[119] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[120] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULLS:
      if (jj_2_39(2)) {
        jj_consume_token(NULLS);
        jj_consume_token(FIRST);
            e = SqlStdOperatorTable.NULLS_FIRST.createCall(getPos(), e);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULLS:
          jj_consume_token(NULLS);
          jj_consume_token(LAST);
            e = SqlStdOperatorTable.NULLS_LAST.createCall(getPos(), e);
          break;
        default:
          jj_la1[121] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[122] = jj_gen;
      ;
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a FOR SYSTEM_TIME clause following a table expression.
 */
  final public SqlSnapshot Snapshot(SqlNode tableRef) throws ParseException {
    final Span s;
    final SqlNode e;
      s = span();
    jj_consume_token(FOR);
    jj_consume_token(SYSTEM_TIME);
    jj_consume_token(AS);
    jj_consume_token(OF);
    // Syntax for temporal table in
        // standard SQL 2011 IWD 9075-2:201?(E) 7.6 <table reference>
        // supports grammar as following:
        // 1. datetime literal
        // 2. datetime value function, i.e. CURRENT_TIMESTAMP
        // 3. datetime term in 1 or 2 +(or -) interval term
    
        // We extend to support column reference, use Expression
        // to simplify the parsing code.
        e = Expression(ExprContext.ACCEPT_NON_QUERY);
        {if (true) return new SqlSnapshot(s.end(this), tableRef, e);}
    throw new Error("Missing return statement in function");
  }

/** Parses a PIVOT clause following a table expression. */
  final public SqlNode Pivot(SqlNode tableRef) throws ParseException {
    final Span s;
    final Span s2;
    final List<SqlNode> aggList = new ArrayList<SqlNode>();
    final List<SqlNode> valueList = new ArrayList<SqlNode>();
    final SqlNodeList axisList;
    final SqlNodeList inList;
    jj_consume_token(PIVOT);
              s = span();
    jj_consume_token(LPAREN);
    PivotAgg(aggList);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[123] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      PivotAgg(aggList);
    }
    jj_consume_token(FOR);
    axisList = SimpleIdentifierOrList();
    jj_consume_token(IN);
    jj_consume_token(LPAREN);
                    s2 = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      PivotValue(valueList);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[124] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        PivotValue(valueList);
      }
      break;
    default:
      jj_la1[125] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        inList = new SqlNodeList(valueList, s2.end(this));
    jj_consume_token(RPAREN);
        {if (true) return new SqlPivot(s.end(this), tableRef,
            new SqlNodeList(aggList, SqlParserPos.sum(aggList)),
            axisList, inList);}
    throw new Error("Missing return statement in function");
  }

  final public void PivotAgg(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlIdentifier alias;
    e = NamedFunctionCall();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[126] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e,
                    alias));
      break;
    default:
      jj_la1[127] = jj_gen;
          list.add(e);
    }
  }

  final public void PivotValue(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlNodeList tuple;
    final SqlIdentifier alias;
    e = RowConstructor();
                           tuple = SqlParserUtil.stripRow(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[128] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(tuple).end(this),
                    tuple, alias));
      break;
    default:
      jj_la1[129] = jj_gen;
          list.add(tuple);
    }
  }

/** Parses an UNPIVOT clause following a table expression. */
  final public SqlNode Unpivot(SqlNode tableRef) throws ParseException {
    final Span s;
    final boolean includeNulls;
    final SqlNodeList measureList;
    final SqlNodeList axisList;
    final Span s2;
    final List<SqlNode> values = new ArrayList<SqlNode>();
    final SqlNodeList inList;
    jj_consume_token(UNPIVOT);
                s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCLUDE:
      jj_consume_token(INCLUDE);
      jj_consume_token(NULLS);
                            includeNulls = true;
      break;
    case EXCLUDE:
      jj_consume_token(EXCLUDE);
      jj_consume_token(NULLS);
                            includeNulls = false;
      break;
    default:
      jj_la1[130] = jj_gen;
          includeNulls = false;
    }
    jj_consume_token(LPAREN);
    measureList = SimpleIdentifierOrList();
    jj_consume_token(FOR);
    axisList = SimpleIdentifierOrList();
    jj_consume_token(IN);
    jj_consume_token(LPAREN);
               s2 = span();
    UnpivotValue(values);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[131] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
      UnpivotValue(values);
    }
    jj_consume_token(RPAREN);
      inList = new SqlNodeList(values, s2.end(this));
    jj_consume_token(RPAREN);
        {if (true) return new SqlUnpivot(s.end(this), tableRef, includeNulls, measureList,
            axisList, inList);}
    throw new Error("Missing return statement in function");
  }

  final public void UnpivotValue(List<SqlNode> list) throws ParseException {
    final SqlNodeList columnList;
    final SqlNode values;
    columnList = SimpleIdentifierOrList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      values = RowConstructor();
            final SqlNodeList valueList = SqlParserUtil.stripRow(values);
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(columnList).end(this),
                    columnList, valueList));
      break;
    default:
      jj_la1[132] = jj_gen;
          list.add(columnList);
    }
  }

/**
 * Parses a MATCH_RECOGNIZE clause following a table expression.
 */
  final public SqlMatchRecognize MatchRecognize(SqlNode tableRef) throws ParseException {
    final Span s, s0, s1, s2;
    SqlNodeList measureList = SqlNodeList.EMPTY;
    SqlNodeList partitionList = SqlNodeList.EMPTY;
    SqlNodeList orderList = SqlNodeList.EMPTY;
    SqlNode pattern;
    SqlLiteral interval;
    SqlNodeList patternDefList;
    final SqlNode after;
    SqlParserPos pos;
    final SqlNode var;
    final SqlLiteral rowsPerMatch;
    SqlNodeList subsetList = SqlNodeList.EMPTY;
    SqlLiteral isStrictStarts = SqlLiteral.createBoolean(false, getPos());
    SqlLiteral isStrictEnds = SqlLiteral.createBoolean(false, getPos());
    jj_consume_token(MATCH_RECOGNIZE);
                        s = span();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
                      s2 = span();
      jj_consume_token(BY);
      partitionList = ExpressionCommaList(s2, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[133] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderBy(true);
      break;
    default:
      jj_la1[134] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MEASURES:
      jj_consume_token(MEASURES);
      measureList = MeasureColumnCommaList(span());
      break;
    default:
      jj_la1[135] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ONE:
      jj_consume_token(ONE);
                s0 = span();
      jj_consume_token(ROW);
      jj_consume_token(PER);
      jj_consume_token(MATCH);
            rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ONE_ROW.symbol(s0.end(this));
      break;
    case ALL:
      jj_consume_token(ALL);
                s0 = span();
      jj_consume_token(ROWS);
      jj_consume_token(PER);
      jj_consume_token(MATCH);
            rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS.symbol(s0.end(this));
      break;
    default:
      jj_la1[136] = jj_gen;
            rowsPerMatch = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AFTER:
      jj_consume_token(AFTER);
                  s1 = span();
      jj_consume_token(MATCH);
      jj_consume_token(SKIP_);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TO:
        jj_consume_token(TO);
        if (jj_2_41(2)) {
          jj_consume_token(NEXT);
          jj_consume_token(ROW);
                    after = SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW
                        .symbol(s1.end(this));
        } else if (jj_2_42(2)) {
          jj_consume_token(FIRST);
          var = SimpleIdentifier();
                    after = SqlMatchRecognize.SKIP_TO_FIRST.createCall(
                        s1.end(var), var);
        } else if (true) {
          if (jj_2_40(2)) {
            jj_consume_token(LAST);
          } else {
            ;
          }
          var = SimpleIdentifier();
                    after = SqlMatchRecognize.SKIP_TO_LAST.createCall(
                        s1.end(var), var);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case PAST:
        jj_consume_token(PAST);
        jj_consume_token(LAST);
        jj_consume_token(ROW);
                 after = SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW
                     .symbol(s1.end(this));
        break;
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[138] = jj_gen;
          after = null;
    }
    jj_consume_token(PATTERN);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CARET:
      jj_consume_token(CARET);
                  isStrictStarts = SqlLiteral.createBoolean(true, getPos());
      break;
    default:
      jj_la1[139] = jj_gen;
          isStrictStarts = SqlLiteral.createBoolean(false, getPos());
    }
    pattern = PatternExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      jj_consume_token(DOLLAR);
                   isStrictEnds = SqlLiteral.createBoolean(true, getPos());
      break;
    default:
      jj_la1[140] = jj_gen;
          isStrictEnds = SqlLiteral.createBoolean(false, getPos());
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      jj_consume_token(WITHIN);
      interval = IntervalLiteral();
      break;
    default:
      jj_la1[141] = jj_gen;
          interval = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBSET:
      jj_consume_token(SUBSET);
      subsetList = SubsetDefinitionCommaList(span());
      break;
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    jj_consume_token(DEFINE);
    patternDefList = PatternDefinitionCommaList(span());
    jj_consume_token(RPAREN);
        {if (true) return new SqlMatchRecognize(s.end(this), tableRef,
            pattern, isStrictStarts, isStrictEnds, patternDefList, measureList,
            after, subsetList, rowsPerMatch, partitionList, orderList, interval);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList MeasureColumnCommaList(Span s) throws ParseException {
    SqlNode e;
    final List<SqlNode> eList = new ArrayList<SqlNode>();
    e = MeasureColumn();
        eList.add(e);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[143] = jj_gen;
        break label_22;
      }
      jj_consume_token(COMMA);
      e = MeasureColumn();
            eList.add(e);
    }
        {if (true) return new SqlNodeList(eList, s.addAll(eList).pos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode MeasureColumn() throws ParseException {
    SqlNode e;
    SqlIdentifier alias;
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(AS);
    alias = SimpleIdentifier();
        {if (true) return SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e, alias);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternExpression() throws ParseException {
    SqlNode left;
    SqlNode right;
    left = PatternTerm();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VERTICAL_BAR:
        ;
        break;
      default:
        jj_la1[144] = jj_gen;
        break label_23;
      }
      jj_consume_token(VERTICAL_BAR);
      right = PatternTerm();
            left = SqlStdOperatorTable.PATTERN_ALTER.createCall(
                Span.of(left).end(right), left, right);
    }
        {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternTerm() throws ParseException {
    SqlNode left;
    SqlNode right;
    left = PatternFactor();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERMUTE:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case LPAREN:
      case LBRACE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[145] = jj_gen;
        break label_24;
      }
      right = PatternFactor();
            left = SqlStdOperatorTable.PATTERN_CONCAT.createCall(
                Span.of(left).end(right), left, right);
    }
        {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternFactor() throws ParseException {
    SqlNode e;
    SqlNode extra;
    SqlLiteral startNum = null;
    SqlLiteral endNum = null;
    SqlLiteral reluctant = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
    e = PatternPrimary();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case HOOK:
    case PLUS:
    case STAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
                startNum = SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
                endNum = SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);
        break;
      case PLUS:
        jj_consume_token(PLUS);
                startNum = SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO);
                endNum = SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);
        break;
      case HOOK:
        jj_consume_token(HOOK);
                startNum = SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
                endNum = SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO);
        break;
      case LBRACE:
        jj_consume_token(LBRACE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
          startNum = UnsignedNumericLiteral();
                                                      endNum = startNum;
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
                        endNum = SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case UNSIGNED_INTEGER_LITERAL:
            case APPROX_NUMERIC_LITERAL:
            case DECIMAL_NUMERIC_LITERAL:
              endNum = UnsignedNumericLiteral();
              break;
            default:
              jj_la1[146] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[147] = jj_gen;
            ;
          }
          jj_consume_token(RBRACE);
          break;
        case COMMA:
                    startNum = SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);
          jj_consume_token(COMMA);
          endNum = UnsignedNumericLiteral();
          jj_consume_token(RBRACE);
          break;
        case MINUS:
          jj_consume_token(MINUS);
          extra = PatternExpression();
          jj_consume_token(MINUS);
          jj_consume_token(RBRACE);
                    extra = SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(
                        Span.of(extra).end(this), extra);
                    e = SqlStdOperatorTable.PATTERN_CONCAT.createCall(
                        Span.of(e).end(this), e, extra);
                    {if (true) return e;}
          break;
        default:
          jj_la1[148] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOOK:
        jj_consume_token(HOOK);
                if (startNum.intValue(true) != endNum.intValue(true)) {
                    reluctant = SqlLiteral.createBoolean(true, SqlParserPos.ZERO);
                }
        break;
      default:
        jj_la1[150] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[151] = jj_gen;
      ;
    }
        if (startNum == null) {
            {if (true) return e;}
        } else {
            {if (true) return SqlStdOperatorTable.PATTERN_QUANTIFIER.createCall(
                span().end(e), e, startNum, endNum, reluctant);}
        }
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternPrimary() throws ParseException {
    final Span s;
    SqlNode e;
    List<SqlNode> eList;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = SimpleIdentifier();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      e = PatternExpression();
      jj_consume_token(RPAREN);
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
                   s = span();
      jj_consume_token(MINUS);
      e = PatternExpression();
      jj_consume_token(MINUS);
      jj_consume_token(RBRACE);
            e = SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(s.end(this), e);
      break;
    case PERMUTE:
      jj_consume_token(PERMUTE);
                        s = span();
      jj_consume_token(LPAREN);
      e = PatternExpression();
                eList = new ArrayList<SqlNode>();
                eList.add(e);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[152] = jj_gen;
          break label_25;
        }
        jj_consume_token(COMMA);
        e = PatternExpression();
                    eList.add(e);
      }
      jj_consume_token(RPAREN);
                e = SqlStdOperatorTable.PATTERN_PERMUTE.createCall(
                    s.end(this), eList);
      break;
    default:
      jj_la1[153] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList SubsetDefinitionCommaList(Span s) throws ParseException {
    SqlNode e;
    final List<SqlNode> eList = new ArrayList<SqlNode>();
    e = SubsetDefinition();
        eList.add(e);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[154] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      e = SubsetDefinition();
            eList.add(e);
    }
        {if (true) return new SqlNodeList(eList, s.addAll(eList).pos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode SubsetDefinition() throws ParseException {
    final SqlNode var;
    final SqlNodeList varList;
    var = SimpleIdentifier();
    jj_consume_token(EQ);
    jj_consume_token(LPAREN);
    varList = ExpressionCommaList(span(), ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.EQUALS.createCall(span().end(var), var,
            varList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList PatternDefinitionCommaList(Span s) throws ParseException {
    SqlNode e;
    final List<SqlNode> eList = new ArrayList<SqlNode>();
    e = PatternDefinition();
        eList.add(e);
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[155] = jj_gen;
        break label_27;
      }
      jj_consume_token(COMMA);
      e = PatternDefinition();
            eList.add(e);
    }
        {if (true) return new SqlNodeList(eList, s.addAll(eList).pos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternDefinition() throws ParseException {
    final SqlNode var;
    final SqlNode e;
    var = SimpleIdentifier();
    jj_consume_token(AS);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.AS.createCall(Span.of(var, e).pos(), e, var);}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// Expressions

/**
 * Parses a SQL expression (such as might occur in a WHERE clause) followed by
 * the end-of-file symbol.
 */
  final public SqlNode SqlExpressionEof() throws ParseException {
    SqlNode e;
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(0);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses either a row expression or a query expression without ORDER BY.
 */
  final public SqlNode QueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNodeList withList = null;
    SqlNode e;
    SqlOperator op;
    SqlParserPos pos;
    SqlParserPos withPos;
    List<Object> list;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      withList = WithList();
      break;
    default:
      jj_la1[156] = jj_gen;
      ;
    }
    e = LeafQueryOrExpr(exprContext);
        list = startList(e);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
      case INTERSECT:
      case SET_MINUS:
      case UNION:
        ;
        break;
      default:
        jj_la1[157] = jj_gen;
        break label_28;
      }
            if (!e.isA(SqlKind.QUERY)) {
                // whoops, expression we just parsed wasn't a query,
                // but we're about to see something like UNION, so
                // force an exception retroactively
                checkNonQueryExpression(ExprContext.ACCEPT_QUERY);
            }
      op = BinaryQueryOperator();
            // ensure a query is legal in this context
            pos = getPos();
            checkQueryExpression(exprContext);
      e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
            list.add(new SqlParserUtil.ToTreeListItem(op, pos));
            list.add(e);
    }
        e = SqlParserUtil.toTree(list);
        if (withList != null) {
            e = new SqlWith(withList.getParserPosition(), withList, e);
        }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList WithList() throws ParseException {
    SqlWithItem withItem;
    SqlParserPos pos;
    SqlNodeList list;
    jj_consume_token(WITH);
             list = new SqlNodeList(getPos());
    withItem = WithItem();
                           list.add(withItem);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[158] = jj_gen;
        break label_29;
      }
      jj_consume_token(COMMA);
      withItem = WithItem();
                                       list.add(withItem);
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlWithItem WithItem() throws ParseException {
    SqlIdentifier id;
    SqlNodeList columnList = null;
    SqlNode definition;
    id = SimpleIdentifier();
    if (jj_2_43(2)) {
      columnList = ParenthesizedSimpleIdentifierList();
    } else {
      ;
    }
    jj_consume_token(AS);
    definition = ParenthesizedExpression(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlWithItem(id.getParserPosition(), id, columnList,
            definition);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses either a row expression, a leaf query expression, or
 * a parenthesized expression of any kind.
 */
  final public SqlNode LeafQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(exprContext);
                                  {if (true) return e;}
      break;
    case SELECT:
    case TABLE:
    case VALUES:
      e = LeafQuery(exprContext);
                                 {if (true) return e;}
      break;
    default:
      jj_la1[159] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a row expression or a parenthesized expression of any kind.
 */
  final public SqlNode Expression(ExprContext exprContext) throws ParseException {
    List<Object> list;
    SqlNode e;
    list = Expression2(exprContext);
        e = SqlParserUtil.toTree(list);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

// TODO jvs 15-Nov-2003:  ANY/ALL
  final public void Expression2b(ExprContext exprContext, List<Object> list) throws ParseException {
    SqlNode e;
    SqlOperator op;
    SqlNode ext;
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXISTS:
      case NOT:
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[160] = jj_gen;
        break label_30;
      }
      op = PrefixRowOperator();
            checkNonQueryExpression(exprContext);
            list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
    }
    e = Expression3(exprContext);
        list.add(e);
    label_31:
    while (true) {
      if (jj_2_44(2)) {
        ;
      } else {
        break label_31;
      }
      jj_consume_token(DOT);
      ext = RowExpressionExtension();
            list.add(
                new SqlParserUtil.ToTreeListItem(
                    SqlStdOperatorTable.DOT, getPos()));
            list.add(ext);
    }
  }

/**
 * Parses a binary row expression, or a parenthesized expression of any
 * kind.
 *
 * <p>The result is as a flat list of operators and operands. The top-level
 * call to get an expression should call {@link #Expression}, but lower-level
 * calls should call this, to give the parser the opportunity to associate
 * operator calls.
 *
 * <p>For example 'a = b like c = d' should come out '((a = b) like c) = d'
 * because LIKE and '=' have the same precedence, but tends to come out as '(a
 * = b) like (c = d)' because (a = b) and (c = d) are parsed as separate
 * expressions.
 */
  final public List<Object> Expression2(ExprContext exprContext) throws ParseException {
    final List<Object> list = new ArrayList();
    List<Object> list2;
    final List<Object> list3 = new ArrayList();
    SqlNodeList nodeList;
    SqlNode e;
    SqlOperator op;
    SqlIdentifier p;
    final Span s = span();
    Expression2b(exprContext, list);
    if (jj_2_52(2)) {
      label_32:
      while (true) {
        if (jj_2_47(2)) {
                    checkNonQueryExpression(exprContext);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            jj_consume_token(IN);
                                 op = SqlStdOperatorTable.NOT_IN;
            break;
          case IN:
            jj_consume_token(IN);
                           op = SqlStdOperatorTable.IN;
            break;
          case EQ:
          case GT:
          case LT:
          case LE:
          case GE:
          case NE:
          case NE2:
                      final SqlKind k;
            k = comp();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SOME:
              jj_consume_token(SOME);
                                 op = SqlStdOperatorTable.some(k);
              break;
            case ANY:
              jj_consume_token(ANY);
                                op = SqlStdOperatorTable.some(k);
              break;
            case ALL:
              jj_consume_token(ALL);
                                op = SqlStdOperatorTable.all(k);
              break;
            default:
              jj_la1[161] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[162] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                  s.clear().add(this);
          nodeList = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_NONCURSOR);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    s.add(nodeList);
                    // special case for stuff like IN (s1 UNION s2)
                    if (nodeList.size() == 1) {
                        SqlNode item = nodeList.get(0);
                        if (item.isA(SqlKind.QUERY)) {
                            list.add(item);
                        } else {
                            list.add(nodeList);
                        }
                    } else {
                        list.add(nodeList);
                    }
        } else if (jj_2_48(2)) {
                    checkNonQueryExpression(exprContext);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            jj_consume_token(BETWEEN);
                        op = SqlStdOperatorTable.NOT_BETWEEN;
                        s.clear().add(this);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASYMMETRIC:
            case SYMMETRIC:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SYMMETRIC:
                jj_consume_token(SYMMETRIC);
                                      op = SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN;
                break;
              case ASYMMETRIC:
                jj_consume_token(ASYMMETRIC);
                break;
              default:
                jj_la1[163] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              jj_la1[164] = jj_gen;
              ;
            }
            break;
          case BETWEEN:
            jj_consume_token(BETWEEN);
                        op = SqlStdOperatorTable.BETWEEN;
                        s.clear().add(this);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASYMMETRIC:
            case SYMMETRIC:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SYMMETRIC:
                jj_consume_token(SYMMETRIC);
                                      op = SqlStdOperatorTable.SYMMETRIC_BETWEEN;
                break;
              case ASYMMETRIC:
                jj_consume_token(ASYMMETRIC);
                break;
              default:
                jj_la1[165] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              jj_la1[166] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[167] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          Expression2b(ExprContext.ACCEPT_SUB_QUERY, list3);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list3);
                    list3.clear();
        } else if (jj_2_49(2)) {
                    checkNonQueryExpression(exprContext);
                    s.clear().add(this);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LIKE:
              jj_consume_token(LIKE);
                                     op = SqlStdOperatorTable.NOT_LIKE;
              break;
            case ILIKE:
              jj_consume_token(ILIKE);
                                      op = SqlLibraryOperators.NOT_ILIKE;
              break;
            case RLIKE:
              jj_consume_token(RLIKE);
                                      op = SqlLibraryOperators.NOT_RLIKE;
              break;
            case SIMILAR:
              jj_consume_token(SIMILAR);
              jj_consume_token(TO);
                                             op = SqlStdOperatorTable.NOT_SIMILAR_TO;
              break;
            default:
              jj_la1[168] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          case LIKE:
            jj_consume_token(LIKE);
                                 op = SqlStdOperatorTable.LIKE;
            break;
          case ILIKE:
            jj_consume_token(ILIKE);
                                  op = SqlLibraryOperators.ILIKE;
            break;
          case RLIKE:
            jj_consume_token(RLIKE);
                                  op = SqlLibraryOperators.RLIKE;
            break;
          case SIMILAR:
            jj_consume_token(SIMILAR);
            jj_consume_token(TO);
                                         op = SqlStdOperatorTable.SIMILAR_TO;
            break;
          default:
            jj_la1[169] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          list2 = Expression2(ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list2);
          if (jj_2_45(2)) {
            jj_consume_token(ESCAPE);
            e = Expression3(ExprContext.ACCEPT_SUB_QUERY);
                        s.clear().add(this);
                        list.add(
                            new SqlParserUtil.ToTreeListItem(
                                SqlStdOperatorTable.ESCAPE, s.pos()));
                        list.add(e);
          } else {
            ;
          }
        } else if (jj_2_50(3)) {
          op = BinaryRowOperator();
                    checkNonQueryExpression(exprContext);
                    list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
          Expression2b(ExprContext.ACCEPT_SUB_QUERY, list);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            jj_consume_token(LBRACKET);
            e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            jj_consume_token(RBRACKET);
                    list.add(
                        new SqlParserUtil.ToTreeListItem(
                            SqlStdOperatorTable.ITEM, getPos()));
                    list.add(e);
            label_33:
            while (true) {
              if (jj_2_46(2)) {
                ;
              } else {
                break label_33;
              }
              jj_consume_token(DOT);
              p = SimpleIdentifier();
                        list.add(
                            new SqlParserUtil.ToTreeListItem(
                                SqlStdOperatorTable.DOT, getPos()));
                        list.add(p);
            }
            break;
          case FORMAT:
          case IS:
                    checkNonQueryExpression(exprContext);
            op = PostfixRowOperator();
                    list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
            break;
          default:
            jj_la1[170] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        if (jj_2_51(2)) {
          ;
        } else {
          break label_32;
        }
      }
            {if (true) return list;}
    } else {
            {if (true) return list;}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a comparison operator inside a SOME / ALL predicate. */
  final public SqlKind comp() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      jj_consume_token(LT);
           {if (true) return SqlKind.LESS_THAN;}
      break;
    case LE:
      jj_consume_token(LE);
           {if (true) return SqlKind.LESS_THAN_OR_EQUAL;}
      break;
    case GT:
      jj_consume_token(GT);
           {if (true) return SqlKind.GREATER_THAN;}
      break;
    case GE:
      jj_consume_token(GE);
           {if (true) return SqlKind.GREATER_THAN_OR_EQUAL;}
      break;
    case EQ:
      jj_consume_token(EQ);
           {if (true) return SqlKind.EQUALS;}
      break;
    case NE:
      jj_consume_token(NE);
           {if (true) return SqlKind.NOT_EQUALS;}
      break;
    case NE2:
      jj_consume_token(NE2);
        if (!this.conformance.isBangEqualAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.bangEqualNotAllowed());}
        }
        {if (true) return SqlKind.NOT_EQUALS;}
      break;
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a unary row expression, or a parenthesized expression of any
 * kind.
 */
  final public SqlNode Expression3(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    final SqlNodeList list;
    final SqlNodeList list1;
    final SqlNodeList list2;
    final SqlOperator op;
    final Span s;
    Span rowSpan = null;
    if (jj_2_54(2)) {
      e = AtomicRowExpression();
        checkNonQueryExpression(exprContext);
        {if (true) return e;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CURSOR:
        e = CursorExpression(exprContext);
                                        {if (true) return e;}
        break;
      default:
        jj_la1[173] = jj_gen;
        if (jj_2_55(3)) {
          jj_consume_token(ROW);
        s = span();
          list = ParenthesizedQueryOrCommaList(exprContext);
        if (exprContext != ExprContext.ACCEPT_ALL
            && exprContext != ExprContext.ACCEPT_CURSOR
            && !this.conformance.allowExplicitRowValueConstructor())
        {
            {if (true) throw SqlUtil.newContextException(s.end(list),
                RESOURCE.illegalRowExpression());}
        }
        {if (true) return SqlStdOperatorTable.ROW.createCall(list);}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ROW:
          case LPAREN:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ROW:
              jj_consume_token(ROW);
                rowSpan = span();
              break;
            default:
              jj_la1[172] = jj_gen;
              ;
            }
            list1 = ParenthesizedQueryOrCommaList(exprContext);
        if (rowSpan != null) {
            // interpret as row constructor
            {if (true) return SqlStdOperatorTable.ROW.createCall(rowSpan.end(list1),
                (List<SqlNode>) list1);}
        }
            if (jj_2_53(2)) {
              e = IntervalQualifier();
                if ((list1.size() == 1)
                    && list1.get(0) instanceof SqlCall)
                {
                    final SqlCall call = (SqlCall) list1.get(0);
                    if (call.getKind() == SqlKind.MINUS
                            && call.operandCount() == 2) {
                        List<SqlNode> list3 = startList(call.operand(0));
                        list3.add(call.operand(1));
                        list3.add(e);
                        {if (true) return SqlStdOperatorTable.MINUS_DATE.createCall(
                            Span.of(list1).end(this), list3);}
                     }
                }
                {if (true) throw SqlUtil.newContextException(span().end(list1),
                    RESOURCE.illegalMinusDate());}
            } else {
              ;
            }
        if (list1.size() == 1) {
            // interpret as single value or query
            {if (true) return list1.get(0);}
        } else {
            // interpret as row constructor
            {if (true) return SqlStdOperatorTable.ROW.createCall(span().end(list1),
                (List<SqlNode>) list1);}
        }
            break;
          default:
            jj_la1[174] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlOperator periodOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVERLAPS:
      jj_consume_token(OVERLAPS);
                  {if (true) return SqlStdOperatorTable.OVERLAPS;}
      break;
    default:
      jj_la1[175] = jj_gen;
      if (jj_2_56(2)) {
        jj_consume_token(IMMEDIATELY);
        jj_consume_token(PRECEDES);
                                {if (true) return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRECEDES:
          jj_consume_token(PRECEDES);
                  {if (true) return SqlStdOperatorTable.PRECEDES;}
          break;
        case IMMEDIATELY:
          jj_consume_token(IMMEDIATELY);
          jj_consume_token(SUCCEEDS);
                                {if (true) return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;}
          break;
        case SUCCEEDS:
          jj_consume_token(SUCCEEDS);
                  {if (true) return SqlStdOperatorTable.SUCCEEDS;}
          break;
        case EQUALS:
          jj_consume_token(EQUALS);
                {if (true) return SqlStdOperatorTable.PERIOD_EQUALS;}
          break;
        default:
          jj_la1[176] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a COLLATE clause
 */
  final public SqlCollation CollateClause() throws ParseException {
    jj_consume_token(COLLATE);
    jj_consume_token(COLLATION_ID);
        {if (true) return new SqlCollation(
            getToken(0).image, SqlCollation.Coercibility.EXPLICIT);}
    throw new Error("Missing return statement in function");
  }

/**
 * Numeric literal or parameter; used in LIMIT, OFFSET and FETCH clauses.
 */
  final public SqlNode UnsignedNumericLiteralOrParam() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      e = UnsignedNumericLiteral();
      break;
    case HOOK:
      e = DynamicParam();
      break;
    default:
      jj_la1[177] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a row expression extension, it can be either an identifier,
 * or a call to a named function.
 */
  final public SqlNode RowExpressionExtension() throws ParseException {
    final SqlFunctionCategory funcType;
    final SqlIdentifier p;
    final Span s;
    final List<SqlNode> args;
    SqlCall call;
    SqlNode e;
    SqlLiteral quantifier = null;
    p = SimpleIdentifier();
        e = p;
    if (jj_2_59(2147483647)) {
                                s = span();
            funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
      if (jj_2_57(2)) {
        jj_consume_token(LPAREN);
        jj_consume_token(STAR);
                args = startList(SqlIdentifier.star(getPos()));
        jj_consume_token(RPAREN);
      } else if (jj_2_58(2)) {
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
                args = Collections.emptyList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          args = FunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
                quantifier = (SqlLiteral) args.get(0);
                args.remove(0);
          break;
        default:
          jj_la1[178] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
            call = createCall(p, s.end(this), funcType, quantifier, args);
            e = call;
    } else {
      ;
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to the STRING_AGG aggregate function (or to an aggregate
 * function with similar syntax: ARRAY_AGG, ARRAY_CONCAT_AGG, GROUP_CONCAT).
 */
  final public SqlCall StringAggFunctionCall() throws ParseException {
    final Span s, s2;
    final SqlOperator op;
    final List<SqlNode> args = new ArrayList();
    final SqlLiteral qualifier;
    final SqlNodeList orderBy;
    final Pair<SqlParserPos, SqlOperator> nullTreatment;
    final SqlNode separator;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY_AGG:
      jj_consume_token(ARRAY_AGG);
                      s = span(); op = SqlLibraryOperators.ARRAY_AGG;
      break;
    case ARRAY_CONCAT_AGG:
      jj_consume_token(ARRAY_CONCAT_AGG);
                             s = span(); op = SqlLibraryOperators.ARRAY_CONCAT_AGG;
      break;
    case GROUP_CONCAT:
      jj_consume_token(GROUP_CONCAT);
                         s = span(); op = SqlLibraryOperators.GROUP_CONCAT;
      break;
    case STRING_AGG:
      jj_consume_token(STRING_AGG);
                       s = span(); op = SqlLibraryOperators.STRING_AGG;
      break;
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      qualifier = AllOrDistinct();
      break;
    default:
      jj_la1[180] = jj_gen;
          qualifier = null;
    }
    Arg(args, ExprContext.ACCEPT_SUB_QUERY);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[181] = jj_gen;
        break label_34;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(ExprContext.ACCEPT_SUB_QUERY);
      Arg(args, ExprContext.ACCEPT_SUB_QUERY);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IGNORE:
    case RESPECT:
      nullTreatment = NullTreatment();
      break;
    default:
      jj_la1[182] = jj_gen;
          nullTreatment = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = OrderBy(true);
            args.add(orderBy);
      break;
    default:
      jj_la1[183] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEPARATOR:
      jj_consume_token(SEPARATOR);
                      s2 = span();
      separator = StringLiteral();
            args.add(SqlInternalOperators.SEPARATOR.createCall(s2.end(this), separator));
      break;
    default:
      jj_la1[184] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        SqlCall call = op.createCall(qualifier, s.end(this), args);
        if (nullTreatment != null) {
            // Wrap in RESPECT_NULLS or IGNORE_NULLS.
            call = nullTreatment.right.createCall(nullTreatment.left, call);
        }
        {if (true) return call;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an atomic row expression.
 */
  final public SqlNode AtomicRowExpression() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case FALSE:
    case INTERVAL:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = LiteralOrIntervalExpression();
      break;
    case HOOK:
      e = DynamicParam();
      break;
    default:
      jj_la1[185] = jj_gen;
      if (jj_2_60(2)) {
        e = BuiltinFunctionCall();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE_FN:
          e = JdbcFunctionCall();
          break;
        case MULTISET:
          e = MultisetConstructor();
          break;
        case ARRAY:
          e = ArrayConstructor();
          break;
        default:
          jj_la1[186] = jj_gen;
          if (jj_2_61(3)) {
            e = MapConstructor();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PERIOD:
              e = PeriodConstructor();
              break;
            default:
              jj_la1[187] = jj_gen;
              if (jj_2_62(2147483647)) {
                e = NamedFunctionCall();
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case CURRENT_CATALOG:
                case CURRENT_DATE:
                case CURRENT_DEFAULT_TRANSFORM_GROUP:
                case CURRENT_PATH:
                case CURRENT_ROLE:
                case CURRENT_SCHEMA:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case CURRENT_USER:
                case LOCALTIME:
                case LOCALTIMESTAMP:
                case SESSION_USER:
                case SYSTEM_USER:
                case USER:
                  e = ContextVariable();
                  break;
                case A:
                case ABSENT:
                case ABSOLUTE:
                case ACTION:
                case ADA:
                case ADD:
                case ADMIN:
                case AFTER:
                case ALWAYS:
                case APPLY:
                case ARRAY_AGG:
                case ARRAY_CONCAT_AGG:
                case ASC:
                case ASSERTION:
                case ASSIGNMENT:
                case ATTRIBUTE:
                case ATTRIBUTES:
                case BEFORE:
                case BERNOULLI:
                case BREADTH:
                case C:
                case CASCADE:
                case CATALOG:
                case CATALOG_NAME:
                case CENTURY:
                case CHAIN:
                case CHARACTER_SET_CATALOG:
                case CHARACTER_SET_NAME:
                case CHARACTER_SET_SCHEMA:
                case CHARACTERISTICS:
                case CHARACTERS:
                case CLASS_ORIGIN:
                case COBOL:
                case COLLATION:
                case COLLATION_CATALOG:
                case COLLATION_NAME:
                case COLLATION_SCHEMA:
                case COLUMN_NAME:
                case COMMAND_FUNCTION:
                case COMMAND_FUNCTION_CODE:
                case COMMITTED:
                case CONDITIONAL:
                case CONDITION_NUMBER:
                case CONNECTION:
                case CONNECTION_NAME:
                case CONSTRAINT_CATALOG:
                case CONSTRAINT_NAME:
                case CONSTRAINT_SCHEMA:
                case CONSTRAINTS:
                case CONSTRUCTOR:
                case CONTINUE:
                case CURSOR_NAME:
                case DATA:
                case DATABASE:
                case DATETIME_INTERVAL_CODE:
                case DATETIME_INTERVAL_PRECISION:
                case DAYS:
                case DECADE:
                case DEFAULTS:
                case DEFERRABLE:
                case DEFERRED:
                case DEFINED:
                case DEFINER:
                case DEGREE:
                case DEPTH:
                case DERIVED:
                case DESC:
                case DESCRIPTION:
                case DESCRIPTOR:
                case DIAGNOSTICS:
                case DISPATCH:
                case DOMAIN:
                case DOT_FORMAT:
                case DOW:
                case DOY:
                case DYNAMIC_FUNCTION:
                case DYNAMIC_FUNCTION_CODE:
                case ENCODING:
                case EPOCH:
                case ERROR:
                case EXCEPTION:
                case EXCLUDE:
                case EXCLUDING:
                case FINAL:
                case FIRST:
                case FOLLOWING:
                case FORMAT:
                case FORTRAN:
                case FOUND:
                case FRAC_SECOND:
                case G:
                case GENERAL:
                case GENERATED:
                case GEOMETRY:
                case GO:
                case GOTO:
                case GRANTED:
                case GROUP_CONCAT:
                case HIERARCHY:
                case HOP:
                case HOURS:
                case IGNORE:
                case ILIKE:
                case IMMEDIATE:
                case IMMEDIATELY:
                case IMPLEMENTATION:
                case INCLUDE:
                case INCLUDING:
                case INCREMENT:
                case INITIALLY:
                case INPUT:
                case INSTANCE:
                case INSTANTIABLE:
                case INVOKER:
                case ISODOW:
                case ISOYEAR:
                case ISOLATION:
                case JAVA:
                case JSON:
                case K:
                case KEY:
                case KEY_MEMBER:
                case KEY_TYPE:
                case LABEL:
                case LAST:
                case LENGTH:
                case LEVEL:
                case LIBRARY:
                case LOCATOR:
                case M:
                case MAP:
                case MATCHED:
                case MAXVALUE:
                case MESSAGE_LENGTH:
                case MESSAGE_OCTET_LENGTH:
                case MESSAGE_TEXT:
                case MICROSECOND:
                case MILLISECOND:
                case MILLENNIUM:
                case MINUTES:
                case MINVALUE:
                case MONTHS:
                case MORE_:
                case MUMPS:
                case NAME:
                case NAMES:
                case NANOSECOND:
                case NESTING:
                case NORMALIZED:
                case NULLABLE:
                case NULLS:
                case NUMBER:
                case OBJECT:
                case OCTETS:
                case OPTION:
                case OPTIONS:
                case ORDERING:
                case ORDINALITY:
                case OTHERS:
                case OUTPUT:
                case OVERRIDING:
                case PAD:
                case PARAMETER_MODE:
                case PARAMETER_NAME:
                case PARAMETER_ORDINAL_POSITION:
                case PARAMETER_SPECIFIC_CATALOG:
                case PARAMETER_SPECIFIC_NAME:
                case PARAMETER_SPECIFIC_SCHEMA:
                case PARTIAL:
                case PASCAL:
                case PASSING:
                case PASSTHROUGH:
                case PAST:
                case PATH:
                case PIVOT:
                case PLACING:
                case PLAN:
                case PLI:
                case PRECEDING:
                case PRESERVE:
                case PRIOR:
                case PRIVILEGES:
                case PUBLIC:
                case QUARTER:
                case READ:
                case RELATIVE:
                case REPEATABLE:
                case REPLACE:
                case RESPECT:
                case RESTART:
                case RESTRICT:
                case RETURNED_CARDINALITY:
                case RETURNED_LENGTH:
                case RETURNED_OCTET_LENGTH:
                case RETURNED_SQLSTATE:
                case RETURNING:
                case RLIKE:
                case ROLE:
                case ROUTINE:
                case ROUTINE_CATALOG:
                case ROUTINE_NAME:
                case ROUTINE_SCHEMA:
                case ROW_COUNT:
                case SCALAR:
                case SCALE:
                case SCHEMA:
                case SCHEMA_NAME:
                case SCOPE_CATALOGS:
                case SCOPE_NAME:
                case SCOPE_SCHEMA:
                case SECONDS:
                case SECTION:
                case SECURITY:
                case SELF:
                case SEPARATOR:
                case SEQUENCE:
                case SERIALIZABLE:
                case SERVER:
                case SERVER_NAME:
                case SESSION:
                case SETS:
                case SIMPLE:
                case SIZE:
                case SOURCE:
                case SPACE:
                case SPECIFIC_NAME:
                case SQL_BIGINT:
                case SQL_BINARY:
                case SQL_BIT:
                case SQL_BLOB:
                case SQL_BOOLEAN:
                case SQL_CHAR:
                case SQL_CLOB:
                case SQL_DATE:
                case SQL_DECIMAL:
                case SQL_DOUBLE:
                case SQL_FLOAT:
                case SQL_INTEGER:
                case SQL_INTERVAL_DAY:
                case SQL_INTERVAL_DAY_TO_HOUR:
                case SQL_INTERVAL_DAY_TO_MINUTE:
                case SQL_INTERVAL_DAY_TO_SECOND:
                case SQL_INTERVAL_HOUR:
                case SQL_INTERVAL_HOUR_TO_MINUTE:
                case SQL_INTERVAL_HOUR_TO_SECOND:
                case SQL_INTERVAL_MINUTE:
                case SQL_INTERVAL_MINUTE_TO_SECOND:
                case SQL_INTERVAL_MONTH:
                case SQL_INTERVAL_SECOND:
                case SQL_INTERVAL_YEAR:
                case SQL_INTERVAL_YEAR_TO_MONTH:
                case SQL_LONGVARBINARY:
                case SQL_LONGVARCHAR:
                case SQL_LONGVARNCHAR:
                case SQL_NCHAR:
                case SQL_NCLOB:
                case SQL_NUMERIC:
                case SQL_NVARCHAR:
                case SQL_REAL:
                case SQL_SMALLINT:
                case SQL_TIME:
                case SQL_TIMESTAMP:
                case SQL_TINYINT:
                case SQL_TSI_DAY:
                case SQL_TSI_FRAC_SECOND:
                case SQL_TSI_HOUR:
                case SQL_TSI_MICROSECOND:
                case SQL_TSI_MINUTE:
                case SQL_TSI_MONTH:
                case SQL_TSI_QUARTER:
                case SQL_TSI_SECOND:
                case SQL_TSI_WEEK:
                case SQL_TSI_YEAR:
                case SQL_VARBINARY:
                case SQL_VARCHAR:
                case STATE:
                case STATEMENT:
                case STRING_AGG:
                case STRUCTURE:
                case STYLE:
                case SUBCLASS_ORIGIN:
                case SUBSTITUTE:
                case TABLE_NAME:
                case TEMPORARY:
                case TIES:
                case TIMESTAMPADD:
                case TIMESTAMPDIFF:
                case TOP_LEVEL_COUNT:
                case TRANSACTION:
                case TRANSACTIONS_ACTIVE:
                case TRANSACTIONS_COMMITTED:
                case TRANSACTIONS_ROLLED_BACK:
                case TRANSFORM:
                case TRANSFORMS:
                case TRIGGER_CATALOG:
                case TRIGGER_NAME:
                case TRIGGER_SCHEMA:
                case TUMBLE:
                case TYPE:
                case UNBOUNDED:
                case UNCOMMITTED:
                case UNCONDITIONAL:
                case UNDER:
                case UNPIVOT:
                case UNNAMED:
                case USAGE:
                case USER_DEFINED_TYPE_CATALOG:
                case USER_DEFINED_TYPE_CODE:
                case USER_DEFINED_TYPE_NAME:
                case USER_DEFINED_TYPE_SCHEMA:
                case UTF8:
                case UTF16:
                case UTF32:
                case VERSION:
                case VIEW:
                case WEEK:
                case WORK:
                case WRAPPER:
                case WRITE:
                case XML:
                case YEARS:
                case ZONE:
                case BRACKET_QUOTED_IDENTIFIER:
                case QUOTED_IDENTIFIER:
                case BACK_QUOTED_IDENTIFIER:
                case HYPHENATED_IDENTIFIER:
                case IDENTIFIER:
                case UNICODE_QUOTED_IDENTIFIER:
                  e = CompoundIdentifier();
                  break;
                case NEW:
                  e = NewSpecification();
                  break;
                case CASE:
                  e = CaseExpression();
                  break;
                case CURRENT:
                case NEXT:
                  e = SequenceExpression();
                  break;
                default:
                  jj_la1[188] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode CaseExpression() throws ParseException {
    final Span whenSpan = Span.of();
    final Span thenSpan = Span.of();
    final Span s;
    SqlNode e;
    SqlNode caseIdentifier = null;
    SqlNode elseClause = null;
    List<SqlNode> whenList = new ArrayList<SqlNode>();
    List<SqlNode> thenList = new ArrayList<SqlNode>();
    jj_consume_token(CASE);
             s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      caseIdentifier = Expression(ExprContext.ACCEPT_SUB_QUERY);
      break;
    default:
      jj_la1[189] = jj_gen;
      ;
    }
    label_35:
    while (true) {
      jj_consume_token(WHEN);
                 whenSpan.add(this);
      e = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
            if (((SqlNodeList) e).size() == 1) {
                e = ((SqlNodeList) e).get(0);
            }
            whenList.add(e);
      jj_consume_token(THEN);
                 thenSpan.add(this);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            thenList.add(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[190] = jj_gen;
        break label_35;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseClause = Expression(ExprContext.ACCEPT_SUB_QUERY);
      break;
    default:
      jj_la1[191] = jj_gen;
      ;
    }
    jj_consume_token(END);
        {if (true) return SqlCase.createSwitched(s.end(this), caseIdentifier,
            new SqlNodeList(whenList, whenSpan.addAll(whenList).pos()),
            new SqlNodeList(thenList, thenSpan.addAll(thenList).pos()),
            elseClause);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall SequenceExpression() throws ParseException {
    final Span s;
    final SqlOperator f;
    final SqlNode sequenceRef;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEXT:
      jj_consume_token(NEXT);
                 f = SqlStdOperatorTable.NEXT_VALUE; s = span();
      break;
    default:
      jj_la1[192] = jj_gen;
      if (jj_2_63(3)) {
        jj_consume_token(CURRENT);
                    f = SqlStdOperatorTable.CURRENT_VALUE; s = span();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(VALUE);
    jj_consume_token(FOR);
    sequenceRef = CompoundIdentifier();
        {if (true) return f.createCall(s.end(sequenceRef), sequenceRef);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses "SET &lt;NAME&gt; = VALUE" or "RESET &lt;NAME&gt;", without a leading
 * "ALTER &lt;SCOPE&gt;".
 */
  final public SqlSetOption SqlSetOption(Span s, String scope) throws ParseException {
    SqlIdentifier name;
    final SqlNode val;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SET:
      jj_consume_token(SET);
            s.add(this);
      name = CompoundIdentifier();
      jj_consume_token(EQ);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATE:
      case FALSE:
      case INTERVAL:
      case NULL:
      case TIME:
      case TIMESTAMP:
      case TRUE:
      case UNKNOWN:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case PLUS:
      case MINUS:
        val = Literal();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        val = SimpleIdentifier();
        break;
      case ON:
        jj_consume_token(ON);
                // OFF is handled by SimpleIdentifier, ON handled here.
                val = new SqlIdentifier(token.image.toUpperCase(Locale.ROOT),
                    getPos());
        break;
      default:
        jj_la1[193] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return new SqlSetOption(s.end(val), scope, name, val);}
      break;
    case RESET:
      jj_consume_token(RESET);
            s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        name = CompoundIdentifier();
        break;
      case ALL:
        jj_consume_token(ALL);
                name = new SqlIdentifier(token.image.toUpperCase(Locale.ROOT),
                    getPos());
        break;
      default:
        jj_la1[194] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return new SqlSetOption(s.end(name), scope, name, null);}
      break;
    default:
      jj_la1[195] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an expression for setting or resetting an option in SQL, such as QUOTED_IDENTIFIERS,
 * or explain plan level (physical/logical).
 */
  final public SqlAlter SqlAlter() throws ParseException {
    final Span s;
    final String scope;
    final SqlAlter alterNode;
    jj_consume_token(ALTER);
              s = span();
    scope = Scope();
    alterNode = SqlSetOption(s, scope);
        {if (true) return alterNode;}
    throw new Error("Missing return statement in function");
  }

  final public String Scope() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SYSTEM:
      jj_consume_token(SYSTEM);
      break;
    case SESSION:
      jj_consume_token(SESSION);
      break;
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                               {if (true) return token.image.toUpperCase(Locale.ROOT);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a literal expression, allowing continued string literals.
 * Usually returns an SqlLiteral, but a continued string literal
 * is an SqlCall expression, which concatenates 2 or more string
 * literals; the validator reduces this.
 *
 * <p>If the context allows both literals and expressions,
 * use {@link #LiteralOrIntervalExpression}, which requires less
 * lookahead.
 */
  final public SqlNode Literal() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case FALSE:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = NonIntervalLiteral();
      break;
    case INTERVAL:
      e = IntervalLiteral();
      break;
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal that is not an interval literal. */
  final public SqlNode NonIntervalLiteral() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case PLUS:
    case MINUS:
      e = NumericLiteral();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      e = StringLiteral();
      break;
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
      e = SpecialLiteral();
      break;
    case DATE:
    case TIME:
    case TIMESTAMP:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
      e = DateTimeLiteral();
      break;
    default:
      jj_la1[198] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal or an interval expression.
 *
 * <p>We include them in the same production because it is difficult to
 * distinguish interval literals from interval expression (both of which
 * start with the {@code INTERVAL} keyword); this way, we can use less
 * LOOKAHEAD. */
  final public SqlNode LiteralOrIntervalExpression() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERVAL:
      e = IntervalLiteralOrExpression();
      break;
    case DATE:
    case FALSE:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = NonIntervalLiteral();
      break;
    default:
      jj_la1[199] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a unsigned numeric literal */
  final public SqlNumericLiteral UnsignedNumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        {if (true) return SqlLiteral.createExactNumeric(token.image, getPos());}
      break;
    case DECIMAL_NUMERIC_LITERAL:
      jj_consume_token(DECIMAL_NUMERIC_LITERAL);
        {if (true) return SqlLiteral.createExactNumeric(token.image, getPos());}
      break;
    case APPROX_NUMERIC_LITERAL:
      jj_consume_token(APPROX_NUMERIC_LITERAL);
        {if (true) return SqlLiteral.createApproxNumeric(token.image, getPos());}
      break;
    default:
      jj_la1[200] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a numeric literal (can be signed) */
  final public SqlLiteral NumericLiteral() throws ParseException {
    final SqlNumericLiteral num;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      num = UnsignedNumericLiteral();
        {if (true) return num;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              s = span();
      num = UnsignedNumericLiteral();
        {if (true) return SqlLiteral.createNegative(num, s.end(this));}
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      num = UnsignedNumericLiteral();
        {if (true) return num;}
      break;
    default:
      jj_la1[201] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parse a special literal keyword */
  final public SqlLiteral SpecialLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             {if (true) return SqlLiteral.createBoolean(true, getPos());}
      break;
    case FALSE:
      jj_consume_token(FALSE);
              {if (true) return SqlLiteral.createBoolean(false, getPos());}
      break;
    case UNKNOWN:
      jj_consume_token(UNKNOWN);
                {if (true) return SqlLiteral.createUnknown(getPos());}
      break;
    case NULL:
      jj_consume_token(NULL);
             {if (true) return SqlLiteral.createNull(getPos());}
      break;
    default:
      jj_la1[202] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a string literal. The literal may be continued onto several
 * lines.  For a simple literal, the result is an SqlLiteral.  For a continued
 * literal, the result is an SqlCall expression, which concatenates 2 or more
 * string literals; the validator reduces this.
 *
 * @see SqlLiteral#unchain(SqlNode)
 * @see SqlLiteral#stringValue(SqlNode)
 *
 * @return a literal expression
 */
  final public SqlNode StringLiteral() throws ParseException {
    String p;
    int nfrags = 0;
    List<SqlLiteral> frags = null;
    char unicodeEscapeChar = 0;
    String charSet = null;
    SqlCharStringLiteral literal;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
      jj_consume_token(BINARY_STRING_LITERAL);
        try {
            p = SqlParserUtil.trim(token.image, "xX'");
            frags = startList(SqlLiteral.createBinaryString(p, getPos()));
            nfrags++;
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.illegalBinaryString(token.image));}
        }
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case QUOTED_STRING:
          ;
          break;
        default:
          jj_la1[203] = jj_gen;
          break label_36;
        }
        jj_consume_token(QUOTED_STRING);
            try {
                p = SqlParserUtil.trim(token.image, "'"); // no embedded quotes
                frags.add(SqlLiteral.createBinaryString(p, getPos()));
                nfrags++;
            } catch (NumberFormatException ex) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.illegalBinaryString(token.image));}
            }
      }
        assert (nfrags > 0);
        if (nfrags == 1) {
            {if (true) return frags.get(0);} // just the head fragment
        } else {
            SqlParserPos pos2 = SqlParserPos.sum(frags);
            {if (true) return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, frags);}
        }
      break;
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PREFIXED_STRING_LITERAL:
        jj_consume_token(PREFIXED_STRING_LITERAL);
          charSet = SqlParserUtil.getCharacterSet(token.image);
        break;
      case QUOTED_STRING:
        jj_consume_token(QUOTED_STRING);
        break;
      case UNICODE_STRING_LITERAL:
        jj_consume_token(UNICODE_STRING_LITERAL);
            // TODO jvs 2-Feb-2009:  support the explicit specification of
            // a character set for Unicode string literals, per SQL:2003
            unicodeEscapeChar = BACKSLASH;
            charSet = "UTF16";
        break;
      default:
        jj_la1[204] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        p = SqlParserUtil.parseString(token.image);
        try {
            literal = SqlLiteral.createCharString(p, charSet, getPos());
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
        frags = startList(literal);
        nfrags++;
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case QUOTED_STRING:
          ;
          break;
        default:
          jj_la1[205] = jj_gen;
          break label_37;
        }
        jj_consume_token(QUOTED_STRING);
            p = SqlParserUtil.parseString(token.image);
            try {
                literal = SqlLiteral.createCharString(p, charSet, getPos());
            } catch (java.nio.charset.UnsupportedCharsetException e) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.unknownCharacterSet(charSet));}
            }
            frags.add(literal);
            nfrags++;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UESCAPE:
        jj_consume_token(UESCAPE);
        jj_consume_token(QUOTED_STRING);
            if (unicodeEscapeChar == 0) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.unicodeEscapeUnexpected());}
            }
            String s = SqlParserUtil.parseString(token.image);
            unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
        break;
      default:
        jj_la1[206] = jj_gen;
        ;
      }
        assert nfrags > 0;
        if (nfrags == 1) {
            // just the head fragment
            SqlLiteral lit = (SqlLiteral) frags.get(0);
            {if (true) return lit.unescapeUnicode(unicodeEscapeChar);}
        } else {
            SqlNode[] rands = (SqlNode[]) frags.toArray(new SqlNode[nfrags]);
            for (int i = 0; i < rands.length; ++i) {
                rands[i] = ((SqlLiteral) rands[i]).unescapeUnicode(
                    unicodeEscapeChar);
            }
            SqlParserPos pos2 = SqlParserPos.sum(rands);
            {if (true) return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, rands);}
        }
      break;
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_DOUBLE_QUOTED_STRING);
        p = SqlParserUtil.stripQuotes(getToken(0).image, DQ, DQ, "\\\"",
            Casing.UNCHANGED);
        try {
            {if (true) return SqlLiteral.createCharString(p, charSet, getPos());}
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      break;
    case BIG_QUERY_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_QUOTED_STRING);
        p = SqlParserUtil.stripQuotes(getToken(0).image, "'", "'", "\\'",
            Casing.UNCHANGED);
        try {
            {if (true) return SqlLiteral.createCharString(p, charSet, getPos());}
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      break;
    default:
      jj_la1[207] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a date/time literal.
 */
  final public SqlLiteral DateTimeLiteral() throws ParseException {
    final String  p;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE_D:
      jj_consume_token(LBRACE_D);
      jj_consume_token(QUOTED_STRING);
        p = token.image;
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseDateLiteral(p, getPos());}
      break;
    case LBRACE_T:
      jj_consume_token(LBRACE_T);
      jj_consume_token(QUOTED_STRING);
        p = token.image;
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseTimeLiteral(p, getPos());}
      break;
    case LBRACE_TS:
      jj_consume_token(LBRACE_TS);
                  s = span();
      jj_consume_token(QUOTED_STRING);
        p = token.image;
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseTimestampLiteral(p, s.end(this));}
      break;
    case DATE:
      jj_consume_token(DATE);
             s = span();
      jj_consume_token(QUOTED_STRING);
        {if (true) return SqlParserUtil.parseDateLiteral(token.image, s.end(this));}
      break;
    case TIME:
      jj_consume_token(TIME);
             s = span();
      jj_consume_token(QUOTED_STRING);
        {if (true) return SqlParserUtil.parseTimeLiteral(token.image, s.end(this));}
      break;
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
                  s = span();
      jj_consume_token(QUOTED_STRING);
        {if (true) return SqlParserUtil.parseTimestampLiteral(token.image, s.end(this));}
      break;
    default:
      jj_la1[208] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a MULTISET constructor */
  final public SqlNode MultisetConstructor() throws ParseException {
    List<SqlNode> args;
    SqlNode e;
    final Span s;
    jj_consume_token(MULTISET);
                 s = span();
    if (jj_2_64(2)) {
      jj_consume_token(LPAREN);
      // by sub query "MULTISET(SELECT * FROM T)"
              e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.MULTISET_QUERY.createCall(
                s.end(this), e);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        // TODO: do trigraph as well ??( ??)
                e = Expression(ExprContext.ACCEPT_NON_QUERY);
                                                       args = startList(e);
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[209] = jj_gen;
            break label_38;
          }
          jj_consume_token(COMMA);
          e = Expression(ExprContext.ACCEPT_NON_QUERY);
                                                                   args.add(e);
        }
        jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.MULTISET_VALUE.createCall(
                s.end(this), args);}
        break;
      default:
        jj_la1[210] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an ARRAY constructor */
  final public SqlNode ArrayConstructor() throws ParseException {
    SqlNodeList args;
    SqlNode e;
    final Span s;
    jj_consume_token(ARRAY);
              s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      // by sub query "MULTISET(SELECT * FROM T)"
              e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.ARRAY_QUERY.createCall(
                s.end(this), e);}
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        args = ExpressionCommaList(s, ExprContext.ACCEPT_NON_QUERY);
        break;
      default:
        jj_la1[211] = jj_gen;
              args = SqlNodeList.EMPTY;
      }
      jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(
                s.end(this), args.getList());}
      break;
    default:
      jj_la1[212] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a MAP constructor */
  final public SqlNode MapConstructor() throws ParseException {
    SqlNodeList args;
    SqlNode e;
    final Span s;
    jj_consume_token(MAP);
            s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      // by sub query "MAP (SELECT empno, deptno FROM emp)"
              e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.MAP_QUERY.createCall(
                s.end(this), e);}
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        args = ExpressionCommaList(s, ExprContext.ACCEPT_NON_QUERY);
        break;
      default:
        jj_la1[213] = jj_gen;
              args = SqlNodeList.EMPTY;
      }
      jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR.createCall(
                s.end(this), args.getList());}
      break;
    default:
      jj_la1[214] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a PERIOD constructor */
  final public SqlNode PeriodConstructor() throws ParseException {
    final SqlNode e0, e1;
    final Span s;
    jj_consume_token(PERIOD);
               s = span();
    jj_consume_token(LPAREN);
    e0 = Expression(ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    e1 = Expression(ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.ROW.createCall(s.end(this), e0, e1);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an interval literal.
 */
  final public SqlLiteral IntervalLiteral() throws ParseException {
    final String p;
    final SqlIntervalQualifier intervalQualifier;
    int sign = 1;
    final Span s;
    jj_consume_token(INTERVAL);
                 s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
                  sign = -1;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                 sign = 1;
        break;
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[216] = jj_gen;
      ;
    }
    jj_consume_token(QUOTED_STRING);
                      p = token.image;
    intervalQualifier = IntervalQualifier();
        {if (true) return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier),
            sign, p, intervalQualifier);}
    throw new Error("Missing return statement in function");
  }

/** Parses an interval literal (e.g. {@code INTERVAL '2:3' HOUR TO MINUTE})
 * or an interval expression (e.g. {@code INTERVAL emp.empno MINUTE}
 * or {@code INTERVAL 3 MONTHS}). */
  final public SqlNode IntervalLiteralOrExpression() throws ParseException {
    final String p;
    final SqlIntervalQualifier intervalQualifier;
    int sign = 1;
    final Span s;
    SqlNode e;
    jj_consume_token(INTERVAL);
                 s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
                  sign = -1;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                 sign = 1;
        break;
      default:
        jj_la1[217] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[218] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
                          p = token.image;
      intervalQualifier = IntervalQualifier();
            {if (true) return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier),
                sign, p, intervalQualifier);}
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case LPAREN:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        break;
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
        e = UnsignedNumericLiteral();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = CompoundIdentifier();
        break;
      default:
        jj_la1[219] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      intervalQualifier = IntervalQualifierStart();
            if (sign == -1) {
                e = SqlStdOperatorTable.UNARY_MINUS.createCall(e.getParserPosition(), e);
            }
            {if (true) return SqlStdOperatorTable.INTERVAL.createCall(s.end(this), e,
                intervalQualifier);}
      break;
    default:
      jj_la1[220] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Year() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YEAR:
      jj_consume_token(YEAR);
             {if (true) return TimeUnit.YEAR;}
      break;
    case YEARS:
      jj_consume_token(YEARS);
              {if (true) return warn(TimeUnit.YEAR);}
      break;
    default:
      jj_la1[221] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Month() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MONTH:
      jj_consume_token(MONTH);
              {if (true) return TimeUnit.MONTH;}
      break;
    case MONTHS:
      jj_consume_token(MONTHS);
               {if (true) return warn(TimeUnit.MONTH);}
      break;
    default:
      jj_la1[222] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Day() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DAY:
      jj_consume_token(DAY);
            {if (true) return TimeUnit.DAY;}
      break;
    case DAYS:
      jj_consume_token(DAYS);
             {if (true) return warn(TimeUnit.DAY);}
      break;
    default:
      jj_la1[223] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Hour() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOUR:
      jj_consume_token(HOUR);
             {if (true) return TimeUnit.HOUR;}
      break;
    case HOURS:
      jj_consume_token(HOURS);
              {if (true) return warn(TimeUnit.HOUR);}
      break;
    default:
      jj_la1[224] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Minute() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUTE:
      jj_consume_token(MINUTE);
               {if (true) return TimeUnit.MINUTE;}
      break;
    case MINUTES:
      jj_consume_token(MINUTES);
                {if (true) return warn(TimeUnit.MINUTE);}
      break;
    default:
      jj_la1[225] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Second() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SECOND:
      jj_consume_token(SECOND);
               {if (true) return TimeUnit.SECOND;}
      break;
    case SECONDS:
      jj_consume_token(SECONDS);
                {if (true) return warn(TimeUnit.SECOND);}
      break;
    default:
      jj_la1[226] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlIntervalQualifier IntervalQualifier() throws ParseException {
    final Span s;
    final TimeUnit start;
    TimeUnit end = null;
    int startPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    int secondFracPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YEAR:
    case YEARS:
      start = Year();
                         s = span();
      startPrec = PrecisionOpt();
      if (jj_2_65(2)) {
        jj_consume_token(TO);
        end = Month();
      } else {
        ;
      }
      break;
    case MONTH:
    case MONTHS:
      start = Month();
                          s = span();
      startPrec = PrecisionOpt();
      break;
    case DAY:
    case DAYS:
      start = Day();
                        s = span();
      startPrec = PrecisionOpt();
      if (jj_2_66(2)) {
        jj_consume_token(TO);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HOUR:
        case HOURS:
          end = Hour();
          break;
        case MINUTE:
        case MINUTES:
          end = Minute();
          break;
        case SECOND:
        case SECONDS:
          end = Second();
          secondFracPrec = PrecisionOpt();
          break;
        default:
          jj_la1[227] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      break;
    case HOUR:
    case HOURS:
      start = Hour();
                         s = span();
      startPrec = PrecisionOpt();
      if (jj_2_67(2)) {
        jj_consume_token(TO);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUTE:
        case MINUTES:
          end = Minute();
          break;
        case SECOND:
        case SECONDS:
          end = Second();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            jj_consume_token(LPAREN);
            secondFracPrec = UnsignedIntLiteral();
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[228] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[229] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      break;
    case MINUTE:
    case MINUTES:
      start = Minute();
                           s = span();
      startPrec = PrecisionOpt();
      if (jj_2_68(2)) {
        jj_consume_token(TO);
        end = Second();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          secondFracPrec = UnsignedIntLiteral();
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[230] = jj_gen;
          ;
        }
      } else {
        ;
      }
      break;
    case SECOND:
    case SECONDS:
      start = Second();
                           s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        startPrec = UnsignedIntLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          secondFracPrec = UnsignedIntLiteral();
          break;
        default:
          jj_la1[231] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[232] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[233] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIntervalQualifier(start, startPrec, end, secondFracPrec,
            s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** Interval qualifier without 'TO unit'. */
  final public SqlIntervalQualifier IntervalQualifierStart() throws ParseException {
    final Span s;
    final TimeUnit start;
    int startPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    int secondFracPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DAY:
    case DAYS:
    case HOUR:
    case HOURS:
    case MINUTE:
    case MINUTES:
    case MONTH:
    case MONTHS:
    case YEAR:
    case YEARS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case YEAR:
      case YEARS:
        start = Year();
        break;
      case MONTH:
      case MONTHS:
        start = Month();
        break;
      case DAY:
      case DAYS:
        start = Day();
        break;
      case HOUR:
      case HOURS:
        start = Hour();
        break;
      case MINUTE:
      case MINUTES:
        start = Minute();
        break;
      default:
        jj_la1[234] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          s = span();
      startPrec = PrecisionOpt();
      break;
    case SECOND:
    case SECONDS:
      start = Second();
                           s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        startPrec = UnsignedIntLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          secondFracPrec = UnsignedIntLiteral();
          break;
        default:
          jj_la1[235] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[236] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[237] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIntervalQualifier(start, startPrec, null, secondFracPrec,
            s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses time unit for EXTRACT, CEIL and FLOOR functions.
 * Note that it does't include NANOSECOND and MICROSECOND.
 */
  final public TimeUnit TimeUnit() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MILLISECOND:
      jj_consume_token(MILLISECOND);
                    {if (true) return TimeUnit.MILLISECOND;}
      break;
    case SECOND:
      jj_consume_token(SECOND);
               {if (true) return TimeUnit.SECOND;}
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
               {if (true) return TimeUnit.MINUTE;}
      break;
    case HOUR:
      jj_consume_token(HOUR);
             {if (true) return TimeUnit.HOUR;}
      break;
    case DAY:
      jj_consume_token(DAY);
            {if (true) return TimeUnit.DAY;}
      break;
    case DOW:
      jj_consume_token(DOW);
            {if (true) return TimeUnit.DOW;}
      break;
    case DOY:
      jj_consume_token(DOY);
            {if (true) return TimeUnit.DOY;}
      break;
    case ISODOW:
      jj_consume_token(ISODOW);
               {if (true) return TimeUnit.ISODOW;}
      break;
    case ISOYEAR:
      jj_consume_token(ISOYEAR);
                {if (true) return TimeUnit.ISOYEAR;}
      break;
    case WEEK:
      jj_consume_token(WEEK);
             {if (true) return TimeUnit.WEEK;}
      break;
    case MONTH:
      jj_consume_token(MONTH);
              {if (true) return TimeUnit.MONTH;}
      break;
    case QUARTER:
      jj_consume_token(QUARTER);
                {if (true) return TimeUnit.QUARTER;}
      break;
    case YEAR:
      jj_consume_token(YEAR);
             {if (true) return TimeUnit.YEAR;}
      break;
    case EPOCH:
      jj_consume_token(EPOCH);
              {if (true) return TimeUnit.EPOCH;}
      break;
    case DECADE:
      jj_consume_token(DECADE);
               {if (true) return TimeUnit.DECADE;}
      break;
    case CENTURY:
      jj_consume_token(CENTURY);
                {if (true) return TimeUnit.CENTURY;}
      break;
    case MILLENNIUM:
      jj_consume_token(MILLENNIUM);
                   {if (true) return TimeUnit.MILLENNIUM;}
      break;
    default:
      jj_la1[238] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit TimestampInterval() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FRAC_SECOND:
      jj_consume_token(FRAC_SECOND);
                    {if (true) return TimeUnit.MICROSECOND;}
      break;
    case MICROSECOND:
      jj_consume_token(MICROSECOND);
                    {if (true) return TimeUnit.MICROSECOND;}
      break;
    case NANOSECOND:
      jj_consume_token(NANOSECOND);
                   {if (true) return TimeUnit.NANOSECOND;}
      break;
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
                            {if (true) return TimeUnit.NANOSECOND;}
      break;
    case SQL_TSI_MICROSECOND:
      jj_consume_token(SQL_TSI_MICROSECOND);
                            {if (true) return TimeUnit.MICROSECOND;}
      break;
    case SECOND:
      jj_consume_token(SECOND);
               {if (true) return TimeUnit.SECOND;}
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
                       {if (true) return TimeUnit.SECOND;}
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
               {if (true) return TimeUnit.MINUTE;}
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
                       {if (true) return TimeUnit.MINUTE;}
      break;
    case HOUR:
      jj_consume_token(HOUR);
             {if (true) return TimeUnit.HOUR;}
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
                     {if (true) return TimeUnit.HOUR;}
      break;
    case DAY:
      jj_consume_token(DAY);
            {if (true) return TimeUnit.DAY;}
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
                    {if (true) return TimeUnit.DAY;}
      break;
    case WEEK:
      jj_consume_token(WEEK);
             {if (true) return TimeUnit.WEEK;}
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
                     {if (true) return TimeUnit.WEEK;}
      break;
    case MONTH:
      jj_consume_token(MONTH);
              {if (true) return TimeUnit.MONTH;}
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
                      {if (true) return TimeUnit.MONTH;}
      break;
    case QUARTER:
      jj_consume_token(QUARTER);
                {if (true) return TimeUnit.QUARTER;}
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
                        {if (true) return TimeUnit.QUARTER;}
      break;
    case YEAR:
      jj_consume_token(YEAR);
             {if (true) return TimeUnit.YEAR;}
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
                     {if (true) return TimeUnit.YEAR;}
      break;
    default:
      jj_la1[239] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a dynamic parameter marker.
 */
  final public SqlDynamicParam DynamicParam() throws ParseException {
    jj_consume_token(HOOK);
        {if (true) return new SqlDynamicParam(nDynamicParams++, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one segment of an identifier that may be composite.
 *
 * <p>Each time it reads an identifier it writes one element to each list;
 * the entry in {@code positions} records its position and whether the
 * segment was quoted.
 */
  final public void IdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
    final String id;
    char unicodeEscapeChar = BACKSLASH;
    final SqlParserPos pos;
    final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
            id = unquotedIdentifier();
            pos = getPos();
      break;
    case HYPHENATED_IDENTIFIER:
      jj_consume_token(HYPHENATED_IDENTIFIER);
            id = unquotedIdentifier();
            pos = getPos();
      break;
    case QUOTED_IDENTIFIER:
      jj_consume_token(QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, DQ, DQ, DQDQ,
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BACK_QUOTED_IDENTIFIER:
      jj_consume_token(BACK_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "`", "`", "``",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BRACKET_QUOTED_IDENTIFIER:
      jj_consume_token(BRACKET_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "[", "]", "]]",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case UNICODE_QUOTED_IDENTIFIER:
      jj_consume_token(UNICODE_QUOTED_IDENTIFIER);
            span = span();
            String image = getToken(0).image;
            image = image.substring(image.indexOf('"'));
            image = SqlParserUtil.stripQuotes(image, DQ, DQ, DQDQ, quotedCasing);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UESCAPE:
        jj_consume_token(UESCAPE);
        jj_consume_token(QUOTED_STRING);
                String s = SqlParserUtil.parseString(token.image);
                unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
        break;
      default:
        jj_la1[240] = jj_gen;
        ;
      }
            pos = span.end(this).withQuoting(true);
            SqlLiteral lit = SqlLiteral.createCharString(image, "UTF16", pos);
            lit = lit.unescapeUnicode(unicodeEscapeChar);
            id = lit.toValue();
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
      id = NonReservedKeyWord();
            pos = getPos();
      break;
    default:
      jj_la1[241] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (id.length() > this.identifierMaxLength) {
            {if (true) throw SqlUtil.newContextException(pos,
                RESOURCE.identifierTooLong(id, this.identifierMaxLength));}
        }
        names.add(id);
        if (positions != null) {
            positions.add(pos);
        }
  }

/** As {@link #IdentifierSegment} but part of a table name (for example,
 * following {@code FROM}, {@code INSERT} or {@code UPDATE}).
 *
 * <p>In some dialects the lexical rules for table names are different from
 * for other identifiers. For example, in BigQuery, table names may contain
 * hyphens. */
  final public void TableIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
    IdentifierSegment(names, positions);
        final int n = names.size();
        if (n > 0
                && positions.size() == n
                && names.get(n - 1).contains(".")
                && positions.get(n - 1).isQuoted()
                && this.conformance.splitQuotedTableName()) {
            final String name = names.remove(n - 1);
            final SqlParserPos pos = positions.remove(n - 1);
            final String[] splitNames = name.split("\\.");
            for (String splitName : splitNames) {
                names.add(splitName);
                positions.add(pos);
            }
        }
  }

/**
 * Parses a simple identifier as a String.
 */
  final public String Identifier() throws ParseException {
    final List<String> names = new ArrayList<String>();
    IdentifierSegment(names, null);
        {if (true) return names.get(0);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a simple identifier as an SqlIdentifier.
 */
  final public SqlIdentifier SimpleIdentifier() throws ParseException {
    final List<String> names = new ArrayList<String>();
    final List<SqlParserPos> positions = new ArrayList<SqlParserPos>();
    IdentifierSegment(names, positions);
        {if (true) return new SqlIdentifier(names.get(0), positions.get(0));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a character literal as an SqlIdentifier.
 * Only valid for column aliases in certain dialects.
 */
  final public SqlIdentifier SimpleIdentifierFromStringLiteral() throws ParseException {
    jj_consume_token(QUOTED_STRING);
        if (!this.conformance.allowCharLiteralAlias()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.charLiteralAliasNotValid());}
        }
        final String s = SqlParserUtil.parseString(token.image);
        {if (true) return new SqlIdentifier(s, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a comma-separated list of simple identifiers.
 */
  final public void SimpleIdentifierCommaList(List<SqlNode> list) throws ParseException {
    SqlIdentifier id;
    id = SimpleIdentifier();
                             list.add(id);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[242] = jj_gen;
        break label_39;
      }
      jj_consume_token(COMMA);
      id = SimpleIdentifier();
            list.add(id);
    }
  }

/**
  * List of simple identifiers in parentheses. The position extends from the
  * open parenthesis to the close parenthesis.
  */
  final public SqlNodeList ParenthesizedSimpleIdentifierList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    SimpleIdentifierCommaList(list);
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** List of simple identifiers in parentheses or one simple identifier.
 *
 * <ul>Examples:
 * <li>{@code DEPTNO}
 * <li>{@code (EMPNO, DEPTNO)}
 * </ul>
 */
  final public SqlNodeList SimpleIdentifierOrList() throws ParseException {
    SqlIdentifier id;
    SqlNodeList list;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      id = SimpleIdentifier();
        {if (true) return new SqlNodeList(Collections.singletonList(id), id.getParserPosition());}
      break;
    case LPAREN:
      list = ParenthesizedSimpleIdentifierList();
        {if (true) return list;}
      break;
    default:
      jj_la1[243] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a compound identifier.
 */
  final public SqlIdentifier CompoundIdentifier() throws ParseException {
    final List<String> nameList = new ArrayList<String>();
    final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();
    boolean star = false;
    IdentifierSegment(nameList, posList);
    label_40:
    while (true) {
      if (jj_2_69(2)) {
        ;
      } else {
        break label_40;
      }
      jj_consume_token(DOT);
      IdentifierSegment(nameList, posList);
    }
    if (jj_2_70(2)) {
      jj_consume_token(DOT);
      jj_consume_token(STAR);
            star = true;
            nameList.add("");
            posList.add(getPos());
    } else {
      ;
    }
        SqlParserPos pos = SqlParserPos.sum(posList);
        if (star) {
            {if (true) return SqlIdentifier.star(nameList, pos, posList);}
        }
        {if (true) return new SqlIdentifier(nameList, null, pos, posList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a compound identifier in the FROM clause.
 */
  final public SqlIdentifier CompoundTableIdentifier() throws ParseException {
    final List<String> nameList = new ArrayList<String>();
    final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();
    TableIdentifierSegment(nameList, posList);
    label_41:
    while (true) {
      if (jj_2_71(2)) {
        ;
      } else {
        break label_41;
      }
      jj_consume_token(DOT);
      TableIdentifierSegment(nameList, posList);
    }
        SqlParserPos pos = SqlParserPos.sum(posList);
        {if (true) return new SqlIdentifier(nameList, null, pos, posList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a comma-separated list of compound identifiers.
 */
  final public void CompoundIdentifierTypeCommaList(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
    CompoundIdentifierType(list, extendList);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[244] = jj_gen;
        break label_42;
      }
      jj_consume_token(COMMA);
      CompoundIdentifierType(list, extendList);
    }
  }

/**
 * List of compound identifiers in parentheses. The position extends from the
 * open parenthesis to the close parenthesis.
 */
  final public Pair<SqlNodeList, SqlNodeList> ParenthesizedCompoundIdentifierList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final List<SqlNode> extendList = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    CompoundIdentifierTypeCommaList(list, extendList);
    jj_consume_token(RPAREN);
        {if (true) return Pair.of(new SqlNodeList(list, s.end(this)), new SqlNodeList(extendList, s.end(this)));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a NEW UDT(...) expression.
 */
  final public SqlNode NewSpecification() throws ParseException {
    final Span s;
    final SqlNode routineCall;
    jj_consume_token(NEW);
            s = span();
    routineCall = NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR,
                ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.NEW.createCall(s.end(routineCall), routineCall);}
    throw new Error("Missing return statement in function");
  }

//TODO: real parse errors.
  final public int UnsignedIntLiteral() throws ParseException {
    Token t;
    t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        try {
            {if (true) return Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
    throw new Error("Missing return statement in function");
  }

  final public int IntLiteral() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case PLUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNED_INTEGER_LITERAL:
        t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        break;
      case PLUS:
        jj_consume_token(PLUS);
        t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        break;
      default:
        jj_la1[245] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        try {
            {if (true) return Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
      break;
    case MINUS:
      jj_consume_token(MINUS);
      t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        try {
            {if (true) return -Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
      break;
    default:
      jj_la1[246] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Type name with optional scale and precision.
  final public SqlDataTypeSpec DataType() throws ParseException {
    SqlTypeNameSpec typeName;
    final Span s;
    typeName = TypeName();
        s = Span.of(typeName.getParserPos());
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case MULTISET:
        ;
        break;
      default:
        jj_la1[247] = jj_gen;
        break label_43;
      }
      typeName = CollectionsTypeName(typeName);
    }
        {if (true) return new SqlDataTypeSpec(typeName, s.add(typeName.getParserPos()).pos());}
    throw new Error("Missing return statement in function");
  }

// Some SQL type names need special handling due to the fact that they have
// spaces in them but are not quoted.
  final public SqlTypeNameSpec TypeName() throws ParseException {
    final SqlTypeNameSpec typeNameSpec;
    final SqlIdentifier typeName;
    final Span s = Span.of();
    if (jj_2_72(2)) {
      typeNameSpec = SqlTypeName(s);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        typeNameSpec = RowTypeName();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        typeName = CompoundIdentifier();
            typeNameSpec = new SqlUserDefinedTypeNameSpec(typeName, s.end(this));
        break;
      default:
        jj_la1[248] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return typeNameSpec;}
    throw new Error("Missing return statement in function");
  }

// Types used for JDBC and ODBC scalar conversion function
  final public SqlTypeNameSpec SqlTypeName(Span s) throws ParseException {
    final SqlTypeNameSpec sqlTypeNameSpec;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIGINT:
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case GEOMETRY:
    case INT:
    case INTEGER:
    case REAL:
    case SMALLINT:
    case TINYINT:
      sqlTypeNameSpec = SqlTypeName1(s);
      break;
    case BINARY:
    case VARBINARY:
      sqlTypeNameSpec = SqlTypeName2(s);
      break;
    case ANY:
    case DEC:
    case DECIMAL:
    case NUMERIC:
      sqlTypeNameSpec = SqlTypeName3(s);
      break;
    case CHAR:
    case CHARACTER:
    case VARCHAR:
      sqlTypeNameSpec = CharacterTypeName(s);
      break;
    case DATE:
    case TIME:
    case TIMESTAMP:
      sqlTypeNameSpec = DateTimeTypeName();
      break;
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return sqlTypeNameSpec;}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that don't allow any extra specifications except the type name.
// For extra specification, we mean precision, scale, charSet, etc.
  final public SqlTypeNameSpec SqlTypeName1(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GEOMETRY:
      jj_consume_token(GEOMETRY);
            if (!this.conformance.allowGeometry()) {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.geometryDisabled());}
            }
            s.add(this);
            sqlTypeName = SqlTypeName.GEOMETRY;
      break;
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
                    s.add(this); sqlTypeName = SqlTypeName.BOOLEAN;
      break;
    case INT:
    case INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      case INT:
        jj_consume_token(INT);
        break;
      default:
        jj_la1[250] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                s.add(this); sqlTypeName = SqlTypeName.INTEGER;
      break;
    case TINYINT:
      jj_consume_token(TINYINT);
                    s.add(this); sqlTypeName = SqlTypeName.TINYINT;
      break;
    case SMALLINT:
      jj_consume_token(SMALLINT);
                     s.add(this); sqlTypeName = SqlTypeName.SMALLINT;
      break;
    case BIGINT:
      jj_consume_token(BIGINT);
                   s.add(this); sqlTypeName = SqlTypeName.BIGINT;
      break;
    case REAL:
      jj_consume_token(REAL);
                 s.add(this); sqlTypeName = SqlTypeName.REAL;
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
                   s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECISION:
        jj_consume_token(PRECISION);
        break;
      default:
        jj_la1[251] = jj_gen;
        ;
      }
                          sqlTypeName = SqlTypeName.DOUBLE;
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
                  s.add(this); sqlTypeName = SqlTypeName.FLOAT;
      break;
    default:
      jj_la1[252] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that allows precision specification.
  final public SqlTypeNameSpec SqlTypeName2(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    int precision = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY:
      jj_consume_token(BINARY);
                   s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VARYING:
        jj_consume_token(VARYING);
                        sqlTypeName = SqlTypeName.VARBINARY;
        break;
      default:
        jj_la1[253] = jj_gen;
              sqlTypeName = SqlTypeName.BINARY;
      }
      break;
    case VARBINARY:
      jj_consume_token(VARBINARY);
                      s.add(this); sqlTypeName = SqlTypeName.VARBINARY;
      break;
    default:
      jj_la1[254] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    precision = PrecisionOpt();
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that allows precision and scale specifications.
  final public SqlTypeNameSpec SqlTypeName3(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    int precision = -1;
    int scale = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEC:
    case DECIMAL:
    case NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      case DEC:
        jj_consume_token(DEC);
        break;
      case NUMERIC:
        jj_consume_token(NUMERIC);
        break;
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                          s.add(this); sqlTypeName = SqlTypeName.DECIMAL;
      break;
    case ANY:
      jj_consume_token(ANY);
                s.add(this); sqlTypeName = SqlTypeName.ANY;
      break;
    default:
      jj_la1[256] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      precision = UnsignedIntLiteral();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        scale = UnsignedIntLiteral();
        break;
      default:
        jj_la1[257] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[258] = jj_gen;
      ;
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, scale, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Types used for for JDBC and ODBC scalar conversion function
  final public SqlJdbcDataTypeName JdbcOdbcDataTypeName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case SQL_CHAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_CHAR:
        jj_consume_token(SQL_CHAR);
        break;
      case CHAR:
        jj_consume_token(CHAR);
        break;
      default:
        jj_la1[259] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_CHAR;}
      break;
    case SQL_VARCHAR:
    case VARCHAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_VARCHAR:
        jj_consume_token(SQL_VARCHAR);
        break;
      case VARCHAR:
        jj_consume_token(VARCHAR);
        break;
      default:
        jj_la1[260] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_VARCHAR;}
      break;
    case DATE:
    case SQL_DATE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DATE:
        jj_consume_token(SQL_DATE);
        break;
      case DATE:
        jj_consume_token(DATE);
        break;
      default:
        jj_la1[261] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_DATE;}
      break;
    case SQL_TIME:
    case TIME:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TIME:
        jj_consume_token(SQL_TIME);
        break;
      case TIME:
        jj_consume_token(TIME);
        break;
      default:
        jj_la1[262] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_TIME;}
      break;
    case SQL_TIMESTAMP:
    case TIMESTAMP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TIMESTAMP:
        jj_consume_token(SQL_TIMESTAMP);
        break;
      case TIMESTAMP:
        jj_consume_token(TIMESTAMP);
        break;
      default:
        jj_la1[263] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                      {if (true) return SqlJdbcDataTypeName.SQL_TIMESTAMP;}
      break;
    case DECIMAL:
    case SQL_DECIMAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DECIMAL:
        jj_consume_token(SQL_DECIMAL);
        break;
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      default:
        jj_la1[264] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_DECIMAL;}
      break;
    case NUMERIC:
    case SQL_NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_NUMERIC:
        jj_consume_token(SQL_NUMERIC);
        break;
      case NUMERIC:
        jj_consume_token(NUMERIC);
        break;
      default:
        jj_la1[265] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_NUMERIC;}
      break;
    case BOOLEAN:
    case SQL_BOOLEAN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BOOLEAN:
        jj_consume_token(SQL_BOOLEAN);
        break;
      case BOOLEAN:
        jj_consume_token(BOOLEAN);
        break;
      default:
        jj_la1[266] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_BOOLEAN;}
      break;
    case INTEGER:
    case SQL_INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_INTEGER:
        jj_consume_token(SQL_INTEGER);
        break;
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      default:
        jj_la1[267] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_INTEGER;}
      break;
    case BINARY:
    case SQL_BINARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BINARY:
        jj_consume_token(SQL_BINARY);
        break;
      case BINARY:
        jj_consume_token(BINARY);
        break;
      default:
        jj_la1[268] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_BINARY;}
      break;
    case SQL_VARBINARY:
    case VARBINARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_VARBINARY:
        jj_consume_token(SQL_VARBINARY);
        break;
      case VARBINARY:
        jj_consume_token(VARBINARY);
        break;
      default:
        jj_la1[269] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                      {if (true) return SqlJdbcDataTypeName.SQL_VARBINARY;}
      break;
    case SQL_TINYINT:
    case TINYINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TINYINT:
        jj_consume_token(SQL_TINYINT);
        break;
      case TINYINT:
        jj_consume_token(TINYINT);
        break;
      default:
        jj_la1[270] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_TINYINT;}
      break;
    case SMALLINT:
    case SQL_SMALLINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_SMALLINT:
        jj_consume_token(SQL_SMALLINT);
        break;
      case SMALLINT:
        jj_consume_token(SMALLINT);
        break;
      default:
        jj_la1[271] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                    {if (true) return SqlJdbcDataTypeName.SQL_SMALLINT;}
      break;
    case BIGINT:
    case SQL_BIGINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BIGINT:
        jj_consume_token(SQL_BIGINT);
        break;
      case BIGINT:
        jj_consume_token(BIGINT);
        break;
      default:
        jj_la1[272] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_BIGINT;}
      break;
    case REAL:
    case SQL_REAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_REAL:
        jj_consume_token(SQL_REAL);
        break;
      case REAL:
        jj_consume_token(REAL);
        break;
      default:
        jj_la1[273] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                           {if (true) return SqlJdbcDataTypeName.SQL_REAL;}
      break;
    case DOUBLE:
    case SQL_DOUBLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DOUBLE:
        jj_consume_token(SQL_DOUBLE);
        break;
      case DOUBLE:
        jj_consume_token(DOUBLE);
        break;
      default:
        jj_la1[274] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_DOUBLE;}
      break;
    case FLOAT:
    case SQL_FLOAT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_FLOAT:
        jj_consume_token(SQL_FLOAT);
        break;
      case FLOAT:
        jj_consume_token(FLOAT);
        break;
      default:
        jj_la1[275] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                              {if (true) return SqlJdbcDataTypeName.SQL_FLOAT;}
      break;
    case SQL_INTERVAL_YEAR:
      jj_consume_token(SQL_INTERVAL_YEAR);
                          {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR;}
      break;
    case SQL_INTERVAL_YEAR_TO_MONTH:
      jj_consume_token(SQL_INTERVAL_YEAR_TO_MONTH);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR_TO_MONTH;}
      break;
    case SQL_INTERVAL_MONTH:
      jj_consume_token(SQL_INTERVAL_MONTH);
                           {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MONTH;}
      break;
    case SQL_INTERVAL_DAY:
      jj_consume_token(SQL_INTERVAL_DAY);
                         {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY;}
      break;
    case SQL_INTERVAL_DAY_TO_HOUR:
      jj_consume_token(SQL_INTERVAL_DAY_TO_HOUR);
                                 {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_HOUR;}
      break;
    case SQL_INTERVAL_DAY_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_DAY_TO_MINUTE);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_MINUTE;}
      break;
    case SQL_INTERVAL_DAY_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_DAY_TO_SECOND);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_SECOND;}
      break;
    case SQL_INTERVAL_HOUR:
      jj_consume_token(SQL_INTERVAL_HOUR);
                          {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR;}
      break;
    case SQL_INTERVAL_HOUR_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_MINUTE);
                                    {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_MINUTE;}
      break;
    case SQL_INTERVAL_HOUR_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_SECOND);
                                    {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_SECOND;}
      break;
    case SQL_INTERVAL_MINUTE:
      jj_consume_token(SQL_INTERVAL_MINUTE);
                            {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE;}
      break;
    case SQL_INTERVAL_MINUTE_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_MINUTE_TO_SECOND);
                                      {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE_TO_SECOND;}
      break;
    case SQL_INTERVAL_SECOND:
      jj_consume_token(SQL_INTERVAL_SECOND);
                            {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_SECOND;}
      break;
    default:
      jj_la1[276] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral JdbcOdbcDataType() throws ParseException {
    SqlJdbcDataTypeName typeName;
    typeName = JdbcOdbcDataTypeName();
        {if (true) return typeName.symbol(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a collection type name, the input element type name may
* also be a collection type.
*/
  final public SqlTypeNameSpec CollectionsTypeName(SqlTypeNameSpec elementTypeName) throws ParseException {
    final SqlTypeName collectionTypeName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MULTISET:
      jj_consume_token(MULTISET);
                     collectionTypeName = SqlTypeName.MULTISET;
      break;
    case ARRAY:
      jj_consume_token(ARRAY);
                  collectionTypeName = SqlTypeName.ARRAY;
      break;
    default:
      jj_la1[277] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlCollectionTypeNameSpec(elementTypeName,
                collectionTypeName, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a nullable option, default is true.
*/
  final public boolean NullableOptDefaultTrue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
             {if (true) return true;}
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[278] = jj_gen;
      {if (true) return true;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a nullable option, default is false.
*/
  final public boolean NullableOptDefaultFalse() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
             {if (true) return true;}
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[279] = jj_gen;
      {if (true) return false;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "name1 type1 [NULL | NOT NULL], name2 type2 [NULL | NOT NULL] ..." list,
* the field type default is not nullable.
*/
  final public void FieldNameTypeCommaList(List<SqlIdentifier> fieldNames,
        List<SqlDataTypeSpec> fieldTypes) throws ParseException {
    SqlIdentifier fName;
    SqlDataTypeSpec fType;
    boolean nullable;
    fName = SimpleIdentifier();
    fType = DataType();
    nullable = NullableOptDefaultFalse();
        fieldNames.add(fName);
        fieldTypes.add(fType.withNullable(nullable, getPos()));
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[280] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
      fName = SimpleIdentifier();
      fType = DataType();
      nullable = NullableOptDefaultFalse();
            fieldNames.add(fName);
            fieldTypes.add(fType.withNullable(nullable, getPos()));
    }
  }

/**
* Parse Row type with format: Row(name1 type1, name2 type2).
* Every field type can have suffix of `NULL` or `NOT NULL` to indicate if this type is nullable.
* i.e. Row(f0 int not null, f1 varchar null).
*/
  final public SqlTypeNameSpec RowTypeName() throws ParseException {
    List<SqlIdentifier> fieldNames = new ArrayList<SqlIdentifier>();
    List<SqlDataTypeSpec> fieldTypes = new ArrayList<SqlDataTypeSpec>();
    jj_consume_token(ROW);
    jj_consume_token(LPAREN);
    FieldNameTypeCommaList(fieldNames, fieldTypes);
    jj_consume_token(RPAREN);
        {if (true) return new SqlRowTypeNameSpec(getPos(), fieldNames, fieldTypes);}
    throw new Error("Missing return statement in function");
  }

/**
* Parse character types: char, varchar.
*/
  final public SqlTypeNameSpec CharacterTypeName(Span s) throws ParseException {
    int precision = -1;
    final SqlTypeName sqlTypeName;
    String charSetName = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CHARACTER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHARACTER:
        jj_consume_token(CHARACTER);
        break;
      case CHAR:
        jj_consume_token(CHAR);
        break;
      default:
        jj_la1[281] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                 s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VARYING:
        jj_consume_token(VARYING);
                        sqlTypeName = SqlTypeName.VARCHAR;
        break;
      default:
        jj_la1[282] = jj_gen;
              sqlTypeName = SqlTypeName.CHAR;
      }
      break;
    case VARCHAR:
      jj_consume_token(VARCHAR);
                    s.add(this); sqlTypeName = SqlTypeName.VARCHAR;
      break;
    default:
      jj_la1[283] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    precision = PrecisionOpt();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARACTER:
      jj_consume_token(CHARACTER);
      jj_consume_token(SET);
      charSetName = Identifier();
      break;
    default:
      jj_la1[284] = jj_gen;
      ;
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, charSetName, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
* Parse datetime types: date, time, timestamp.
*/
  final public SqlTypeNameSpec DateTimeTypeName() throws ParseException {
    int precision = -1;
    SqlTypeName typeName;
    boolean withLocalTimeZone = false;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
      jj_consume_token(DATE);
        typeName = SqlTypeName.DATE;
        {if (true) return new SqlBasicTypeNameSpec(typeName, getPos());}
      break;
    default:
      jj_la1[285] = jj_gen;
      if (jj_2_73(2)) {
        jj_consume_token(TIME);
             s = span();
        precision = PrecisionOpt();
        withLocalTimeZone = TimeZoneOpt();
        if (withLocalTimeZone) {
            typeName = SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE;
        } else {
            typeName = SqlTypeName.TIME;
        }
        {if (true) return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIMESTAMP:
          jj_consume_token(TIMESTAMP);
                  s = span();
          precision = PrecisionOpt();
          withLocalTimeZone = TimeZoneOpt();
        if (withLocalTimeZone) {
            typeName = SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
        } else {
            typeName = SqlTypeName.TIMESTAMP;
        }
        {if (true) return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));}
          break;
        default:
          jj_la1[286] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

// Parse an optional data type precision, default is -1.
  final public int PrecisionOpt() throws ParseException {
    int precision = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      precision = UnsignedIntLiteral();
      jj_consume_token(RPAREN);
      {if (true) return precision;}
      break;
    default:
      jj_la1[287] = jj_gen;
      {if (true) return -1;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a time zone suffix for DateTime types. According to SQL-2011,
* "with time zone" and "without time zone" belong to standard SQL but we
* only implement the "without time zone".
*
* <p>We also support "with local time zone".
*
* @return true if this is "with local time zone".
*/
  final public boolean TimeZoneOpt() throws ParseException {
    if (jj_2_74(3)) {
      jj_consume_token(WITHOUT);
      jj_consume_token(TIME);
      jj_consume_token(ZONE);
                              {if (true) return false;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(LOCAL);
        jj_consume_token(TIME);
        jj_consume_token(ZONE);
                                   {if (true) return true;}
        break;
      default:
        jj_la1[288] = jj_gen;
      {if (true) return false;}
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CURSOR(query) expression.  The parser allows these
 * anywhere, but the validator restricts them to appear only as
 * arguments to table functions.
 */
  final public SqlNode CursorExpression(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    final Span s;
    jj_consume_token(CURSOR);
        s = span();
        if (exprContext != ExprContext.ACCEPT_ALL
                && exprContext != ExprContext.ACCEPT_CURSOR) {
            {if (true) throw SqlUtil.newContextException(s.end(this),
                RESOURCE.illegalCursorExpression());}
        }
    e = Expression(ExprContext.ACCEPT_QUERY);
        {if (true) return SqlStdOperatorTable.CURSOR.createCall(s.end(e), e);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a builtin function with special syntax.
 */
  final public SqlNode BuiltinFunctionCall() throws ParseException {
    final SqlIdentifier name;
    List<SqlNode> args = null;
    SqlNode e = null;
    final Span s;
    SqlDataTypeSpec dt;
    TimeUnit interval;
    final TimeUnit unit;
    final SqlNode node;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CAST:
      jj_consume_token(CAST);
                 s = span();
      jj_consume_token(LPAREN);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                                args = startList(e);
      jj_consume_token(AS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case ANY:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BIGINT:
      case BINARY:
      case BOOLEAN:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHARACTER:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DEC:
      case DECADE:
      case DECIMAL:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOUBLE:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FLOAT:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INT:
      case INTEGER:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case NUMERIC:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case REAL:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SMALLINT:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TINYINT:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VARBINARY:
      case VARCHAR:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        dt = DataType();
                              args.add(dt);
        break;
      case INTERVAL:
        jj_consume_token(INTERVAL);
        e = IntervalQualifier();
                                                 args.add(e);
        break;
      default:
        jj_la1[289] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.CAST.createCall(s.end(this), args);}
      break;
    case EXTRACT:
      jj_consume_token(EXTRACT);
            s = span();
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NANOSECOND:
        jj_consume_token(NANOSECOND);
                           unit = TimeUnit.NANOSECOND;
        break;
      case MICROSECOND:
        jj_consume_token(MICROSECOND);
                            unit = TimeUnit.MICROSECOND;
        break;
      case CENTURY:
      case DAY:
      case DECADE:
      case DOW:
      case DOY:
      case EPOCH:
      case HOUR:
      case ISODOW:
      case ISOYEAR:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTE:
      case MONTH:
      case QUARTER:
      case SECOND:
      case WEEK:
      case YEAR:
        unit = TimeUnit();
        break;
      default:
        jj_la1[290] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          args = startList(new SqlIntervalQualifier(unit, null, getPos()));
      jj_consume_token(FROM);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                       args.add(e);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.EXTRACT.createCall(s.end(this), args);}
      break;
    case POSITION:
      jj_consume_token(POSITION);
                     s = span();
      jj_consume_token(LPAREN);
      // FIXME jvs 31-Aug-2006:  FRG-192:  This should be
              // Expression(ExprContext.ACCEPT_SUB_QUERY), but that doesn't work
              // because it matches the other kind of IN.
              e = AtomicRowExpression();
                                    args = startList(e);
      jj_consume_token(IN);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                       args.add(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
        e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                           args.add(e);
        break;
      default:
        jj_la1[291] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.POSITION.createCall(s.end(this), args);}
      break;
    case CONVERT:
      jj_consume_token(CONVERT);
                    s = span();
      jj_consume_token(LPAREN);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args = startList(e);
      jj_consume_token(USING);
      name = SimpleIdentifier();
            args.add(name);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.CONVERT.createCall(s.end(this), args);}
      break;
    case TRANSLATE:
      jj_consume_token(TRANSLATE);
                      s = span();
      jj_consume_token(LPAREN);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args = startList(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        name = SimpleIdentifier();
                args.add(name);
        jj_consume_token(RPAREN);
                {if (true) return SqlStdOperatorTable.TRANSLATE.createCall(s.end(this),
                    args);}
        break;
      case RPAREN:
      case COMMA:
        label_45:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[292] = jj_gen;
            break label_45;
          }
          jj_consume_token(COMMA);
          e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                    args.add(e);
        }
        jj_consume_token(RPAREN);
                {if (true) return SqlLibraryOperators.TRANSLATE3.createCall(s.end(this),
                    args);}
        break;
      default:
        jj_la1[293] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case OVERLAY:
      jj_consume_token(OVERLAY);
                    s = span();
      jj_consume_token(LPAREN);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args = startList(e);
      jj_consume_token(PLACING);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args.add(e);
      jj_consume_token(FROM);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args.add(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                args.add(e);
        break;
      default:
        jj_la1[294] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.OVERLAY.createCall(s.end(this), args);}
      break;
    case FLOOR:
      jj_consume_token(FLOOR);
                  s = span();
      e = FloorCeilOptions(s, true);
            {if (true) return e;}
      break;
    case CEIL:
    case CEILING:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CEIL:
        jj_consume_token(CEIL);
        break;
      case CEILING:
        jj_consume_token(CEILING);
        break;
      default:
        jj_la1[295] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                s = span();
      e = FloorCeilOptions(s, false);
            {if (true) return e;}
      break;
    case SUBSTRING:
      jj_consume_token(SUBSTRING);
                      s = span();
      jj_consume_token(LPAREN);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
          args = startList(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
        break;
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[296] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
          args.add(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
      case COMMA:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FOR:
          jj_consume_token(FOR);
          break;
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[297] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        e = Expression(ExprContext.ACCEPT_SUB_QUERY);
              args.add(e);
        break;
      default:
        jj_la1[298] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.SUBSTRING.createCall(
                s.end(this), args);}
      break;
    case TRIM:
      jj_consume_token(TRIM);
            SqlLiteral flag = null;
            SqlNode trimChars = null;
            s = span();
      jj_consume_token(LPAREN);
      if (jj_2_75(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOTH:
        case LEADING:
        case TRAILING:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BOTH:
            jj_consume_token(BOTH);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.BOTH.symbol(getPos());
            break;
          case TRAILING:
            jj_consume_token(TRAILING);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.TRAILING.symbol(getPos());
            break;
          case LEADING:
            jj_consume_token(LEADING);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.LEADING.symbol(getPos());
            break;
          default:
            jj_la1[299] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[300] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ARRAY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CASE:
        case CAST:
        case CATALOG:
        case CATALOG_NAME:
        case CEIL:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASSIFIER:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CONVERT:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT:
        case CURRENT_CATALOG:
        case CURRENT_DATE:
        case CURRENT_DEFAULT_TRANSFORM_GROUP:
        case CURRENT_PATH:
        case CURRENT_ROLE:
        case CURRENT_SCHEMA:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURRENT_USER:
        case CURSOR:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOT_FORMAT:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXISTS:
        case EXP:
        case EXTRACT:
        case FALSE:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case ILIKE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDE:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INTERVAL:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case JSON_ARRAY:
        case JSON_ARRAYAGG:
        case JSON_EXISTS:
        case JSON_OBJECT:
        case JSON_OBJECTAGG:
        case JSON_QUERY:
        case JSON_VALUE:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MATCH_NUMBER:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MULTISET:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NEW:
        case NEXT:
        case NORMALIZED:
        case NOT:
        case NTH_VALUE:
        case NTILE:
        case NULL:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERLAY:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENT_RANK:
        case PERIOD:
        case PIVOT:
        case PLACING:
        case PLAN:
        case PLI:
        case POSITION:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PREV:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case RLIKE:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW:
        case ROW_COUNT:
        case ROW_NUMBER:
        case RUNNING:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEPARATOR:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SESSION_USER:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STATEMENT:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case SYSTEM_USER:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIME:
        case TIMESTAMP:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRANSLATE:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRIM:
        case TRUE:
        case TRUNCATE:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNKNOWN:
        case UNPIVOT:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
        case BINARY_STRING_LITERAL:
        case QUOTED_STRING:
        case PREFIXED_STRING_LITERAL:
        case UNICODE_STRING_LITERAL:
        case BIG_QUERY_DOUBLE_QUOTED_STRING:
        case BIG_QUERY_QUOTED_STRING:
        case LPAREN:
        case LBRACE_D:
        case LBRACE_T:
        case LBRACE_TS:
        case LBRACE_FN:
        case HOOK:
        case PLUS:
        case MINUS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          trimChars = Expression(ExprContext.ACCEPT_SUB_QUERY);
          break;
        default:
          jj_la1[301] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          jj_consume_token(FROM);
                    if (null == flag && null == trimChars) {
                        {if (true) throw SqlUtil.newContextException(getPos(),
                            RESOURCE.illegalFromEmpty());}
                    }
          break;
        case RPAREN:
          jj_consume_token(RPAREN);
                    // This is to handle the case of TRIM(x)
                    // (FRG-191).
                    if (flag == null) {
                        flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
                    }
                    args = startList(flag);
                    args.add(null); // no trim chars
                    args.add(trimChars); // reinterpret trimChars as source
                    {if (true) return SqlStdOperatorTable.TRIM.createCall(s.end(this),
                        args);}
          break;
        default:
          jj_la1[302] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            if (flag == null) {
                flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
            }
            args = startList(flag);
            args.add(trimChars);
            args.add(e);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.TRIM.createCall(s.end(this), args);}
      break;
    case TIMESTAMPADD:
      node = TimestampAddFunctionCall();
                                            {if (true) return node;}
      break;
    case TIMESTAMPDIFF:
      node = TimestampDiffFunctionCall();
                                             {if (true) return node;}
      break;
    case CLASSIFIER:
    case FINAL:
    case FIRST:
    case LAST:
    case MATCH_NUMBER:
    case NEXT:
    case PREV:
    case RUNNING:
      node = MatchRecognizeFunctionCall();
                                              {if (true) return node;}
      break;
    case JSON_EXISTS:
      node = JsonExistsFunctionCall();
                                          {if (true) return node;}
      break;
    case JSON_VALUE:
      node = JsonValueFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_QUERY:
      node = JsonQueryFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_OBJECT:
      node = JsonObjectFunctionCall();
                                          {if (true) return node;}
      break;
    case JSON_OBJECTAGG:
      node = JsonObjectAggFunctionCall();
                                             {if (true) return node;}
      break;
    case JSON_ARRAY:
      node = JsonArrayFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_ARRAYAGG:
      node = JsonArrayAggFunctionCall();
                                            {if (true) return node;}
      break;
    case HOP:
    case SESSION:
    case TUMBLE:
      node = GroupByWindowingCall();
                                        {if (true) return node;}
      break;
    default:
      jj_la1[303] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlJsonEncoding JsonRepresentation() throws ParseException {
    jj_consume_token(JSON);
    if (jj_2_76(2)) {
      jj_consume_token(ENCODING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UTF8:
        jj_consume_token(UTF8);
                     {if (true) return SqlJsonEncoding.UTF8;}
        break;
      case UTF16:
        jj_consume_token(UTF16);
                      {if (true) return SqlJsonEncoding.UTF16;}
        break;
      case UTF32:
        jj_consume_token(UTF32);
                      {if (true) return SqlJsonEncoding.UTF32;}
        break;
      default:
        jj_la1[304] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
        {if (true) return SqlJsonEncoding.UTF8;}
    throw new Error("Missing return statement in function");
  }

  final public void JsonInputClause() throws ParseException {
    jj_consume_token(FORMAT);
    JsonRepresentation();
  }

  final public SqlDataTypeSpec JsonReturningClause() throws ParseException {
    SqlDataTypeSpec dt;
    jj_consume_token(RETURNING);
    dt = DataType();
                                  {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public SqlDataTypeSpec JsonOutputClause() throws ParseException {
    SqlDataTypeSpec dataType;
    dataType = JsonReturningClause();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FORMAT:
      jj_consume_token(FORMAT);
      JsonRepresentation();
      break;
    default:
      jj_la1[305] = jj_gen;
      ;
    }
        {if (true) return dataType;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonPathSpec() throws ParseException {
    SqlNode e;
    e = StringLiteral();
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonApiCommonSyntax() throws ParseException {
    SqlNode e;
    List<SqlNode> args = new ArrayList<SqlNode>();
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        args.add(e);
    jj_consume_token(COMMA);
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
            args.add(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
      e = Expression(ExprContext.ACCEPT_NON_QUERY);

      jj_consume_token(AS);
      e = SimpleIdentifier();

      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[306] = jj_gen;
          break label_46;
        }
        jj_consume_token(COMMA);
        e = Expression(ExprContext.ACCEPT_NON_QUERY);

        jj_consume_token(AS);
        e = SimpleIdentifier();

      }
      break;
    default:
      jj_la1[307] = jj_gen;
      ;
    }
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public SqlJsonExistsErrorBehavior JsonExistsErrorBehavior() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             {if (true) return SqlJsonExistsErrorBehavior.TRUE;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
              {if (true) return SqlJsonExistsErrorBehavior.FALSE;}
      break;
    case UNKNOWN:
      jj_consume_token(UNKNOWN);
                {if (true) return SqlJsonExistsErrorBehavior.UNKNOWN;}
      break;
    case ERROR:
      jj_consume_token(ERROR);
              {if (true) return SqlJsonExistsErrorBehavior.ERROR;}
      break;
    default:
      jj_la1[308] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonExistsFunctionCall() throws ParseException {
    List<SqlNode> args = new ArrayList<SqlNode>();
    List<SqlNode> commonSyntax;
    final Span span;
    SqlJsonExistsErrorBehavior errorBehavior;
    jj_consume_token(JSON_EXISTS);
                    span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args.addAll(commonSyntax);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
    case FALSE:
    case TRUE:
    case UNKNOWN:
      errorBehavior = JsonExistsErrorBehavior();
                                                    args.add(errorBehavior.symbol(getPos()));
      jj_consume_token(ON);
      jj_consume_token(ERROR);
      break;
    default:
      jj_la1[309] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_EXISTS.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonValueEmptyOrErrorBehavior() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlJsonValueEmptyOrErrorBehavior.ERROR.symbol(getPos()));
      break;
    case NULL:
      jj_consume_token(NULL);
            list.add(SqlJsonValueEmptyOrErrorBehavior.NULL.symbol(getPos()));
      break;
    case DEFAULT_:
      jj_consume_token(DEFAULT_);
      e = Expression(ExprContext.ACCEPT_NON_QUERY);
            list.add(SqlJsonValueEmptyOrErrorBehavior.DEFAULT.symbol(getPos()));
            list.add(e);
      break;
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMPTY:
      jj_consume_token(EMPTY);
            list.add(SqlJsonEmptyOrError.EMPTY.symbol(getPos()));
      break;
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlJsonEmptyOrError.ERROR.symbol(getPos()));
      break;
    default:
      jj_la1[311] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonValueFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>(7);
    SqlNode e;
    List<SqlNode> commonSyntax;
    final Span span;
    List<SqlNode> behavior;
    jj_consume_token(JSON_VALUE);
                   span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args.addAll(commonSyntax);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNING:
      e = JsonReturningClause();
            args.add(SqlJsonValueReturning.RETURNING.symbol(getPos()));
            args.add(e);
      break;
    default:
      jj_la1[312] = jj_gen;
      ;
    }
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_:
      case ERROR:
      case NULL:
        ;
        break;
      default:
        jj_la1[313] = jj_gen;
        break label_47;
      }
      behavior = JsonValueEmptyOrErrorBehavior();
            args.addAll(behavior);
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_VALUE.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonQueryEmptyOrErrorBehavior() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.ERROR, getPos()));
      break;
    case NULL:
      jj_consume_token(NULL);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, getPos()));
      break;
    default:
      jj_la1[314] = jj_gen;
      if (jj_2_77(2)) {
        jj_consume_token(EMPTY);
        jj_consume_token(ARRAY);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, getPos()));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EMPTY:
          jj_consume_token(EMPTY);
          jj_consume_token(OBJECT);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, getPos()));
          break;
        default:
          jj_la1[315] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(ON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMPTY:
      jj_consume_token(EMPTY);
            list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.EMPTY, getPos()));
      break;
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.ERROR, getPos()));
      break;
    default:
      jj_la1[316] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonQueryWrapperBehavior() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHOUT:
      jj_consume_token(WITHOUT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
        jj_consume_token(ARRAY);
        break;
      default:
        jj_la1[317] = jj_gen;
        ;
      }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, getPos());}
      break;
    default:
      jj_la1[321] = jj_gen;
      if (jj_2_78(2)) {
        jj_consume_token(WITH);
        jj_consume_token(CONDITIONAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ARRAY:
          jj_consume_token(ARRAY);
          break;
        default:
          jj_la1[318] = jj_gen;
          ;
        }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, getPos());}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UNCONDITIONAL:
            jj_consume_token(UNCONDITIONAL);
            break;
          default:
            jj_la1[319] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ARRAY:
            jj_consume_token(ARRAY);
            break;
          default:
            jj_la1[320] = jj_gen;
            ;
          }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, getPos());}
          break;
        default:
          jj_la1[322] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonQueryFunctionCall() throws ParseException {
    final SqlNode[] args = new SqlNode[5];
    SqlNode e;
    List<SqlNode> commonSyntax;
    final Span span;
    List<SqlNode> behavior;
    jj_consume_token(JSON_QUERY);
                   span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args[0] = commonSyntax.get(0);
        args[1] = commonSyntax.get(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
    case WITHOUT:
      e = JsonQueryWrapperBehavior();
      jj_consume_token(WRAPPER);
            args[2] = e;
      break;
    default:
      jj_la1[323] = jj_gen;
      ;
    }
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EMPTY:
      case ERROR:
      case NULL:
        ;
        break;
      default:
        jj_la1[324] = jj_gen;
        break label_48;
      }
      behavior = JsonQueryEmptyOrErrorBehavior();
            final SqlJsonEmptyOrError symbol =
                ((SqlLiteral) behavior.get(1)).getValueAs(SqlJsonEmptyOrError.class);
            switch (symbol) {
            case EMPTY:
                args[3] = behavior.get(0);
                break;
            case ERROR:
                args[4] = behavior.get(0);
                break;
            }
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_QUERY.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonName() throws ParseException {
    final SqlNode e;
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonNameAndValue() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    SqlNode e;
    boolean kvMode = false;
    if (jj_2_79(2)) {
      jj_consume_token(KEY);
                kvMode = true;
    } else {
      ;
    }
    e = JsonName();
        list.add(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUE:
      jj_consume_token(VALUE);
      break;
    case COLON:
      jj_consume_token(COLON);
            if (kvMode) {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.illegalColon());}
            }
      break;
    default:
      jj_la1[325] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        list.add(e);
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonConstructorNullClause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
      jj_consume_token(ON);
      jj_consume_token(NULL);
        {if (true) return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.NULL_ON_NULL, getPos());}
      break;
    case ABSENT:
      jj_consume_token(ABSENT);
      jj_consume_token(ON);
      jj_consume_token(NULL);
        {if (true) return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.ABSENT_ON_NULL, getPos());}
      break;
    default:
      jj_la1[326] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonObjectFunctionCall() throws ParseException {
    final List<SqlNode> nvArgs = new ArrayList<SqlNode>();
    final SqlNode[] otherArgs = new SqlNode[1];
    SqlNode e;
    List<SqlNode> list;
    final Span span;
    jj_consume_token(JSON_OBJECT);
                    span = span();
    jj_consume_token(LPAREN);
    if (jj_2_80(2)) {
      list = JsonNameAndValue();
            nvArgs.addAll(list);
      label_49:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[327] = jj_gen;
          break label_49;
        }
        jj_consume_token(COMMA);
        list = JsonNameAndValue();
                nvArgs.addAll(list);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            otherArgs[0] = e;
      break;
    default:
      jj_la1[328] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        final List<SqlNode> args = new ArrayList();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(nvArgs);
        {if (true) return SqlStdOperatorTable.JSON_OBJECT.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonObjectAggFunctionCall() throws ParseException {
    final SqlNode[] args = new SqlNode[2];
    List<SqlNode> list;
    final Span span;
    SqlJsonConstructorNullClause nullClause =
        SqlJsonConstructorNullClause.NULL_ON_NULL;
    final SqlNode e;
    jj_consume_token(JSON_OBJECTAGG);
                       span = span();
    jj_consume_token(LPAREN);
    list = JsonNameAndValue();
        args[0] = list.get(0);
        args[1] = list.get(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            nullClause = (SqlJsonConstructorNullClause) ((SqlLiteral) e).getValue();
      break;
    default:
      jj_la1[329] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_OBJECTAGG.with(nullClause)
            .createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonArrayFunctionCall() throws ParseException {
    final List<SqlNode> elements = new ArrayList<SqlNode>();
    final SqlNode[] otherArgs = new SqlNode[1];
    SqlNode e;
    final Span span;
    jj_consume_token(JSON_ARRAY);
                   span = span();
    jj_consume_token(LPAREN);
    if (jj_2_81(2)) {
      e = Expression(ExprContext.ACCEPT_NON_QUERY);
            elements.add(e);
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[330] = jj_gen;
          break label_50;
        }
        jj_consume_token(COMMA);
        e = Expression(ExprContext.ACCEPT_NON_QUERY);
                elements.add(e);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            otherArgs[0] = e;
      break;
    default:
      jj_la1[331] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        final List<SqlNode> args = new ArrayList();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(elements);
        {if (true) return SqlStdOperatorTable.JSON_ARRAY.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList JsonArrayAggOrderByClause() throws ParseException {
    final SqlNodeList orderList;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderBy(true);
      break;
    default:
      jj_la1[332] = jj_gen;
          orderList = null;
    }
        {if (true) return orderList;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonArrayAggFunctionCall() throws ParseException {
    final SqlNode valueExpr;
    final SqlNodeList orderList;
    List<SqlNode> list;
    final Span span;
    SqlJsonConstructorNullClause nullClause =
        SqlJsonConstructorNullClause.ABSENT_ON_NULL;
    SqlNode e = null;
    final SqlNode aggCall;
    jj_consume_token(JSON_ARRAYAGG);
                      span = span();
    jj_consume_token(LPAREN);
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        valueExpr = e;
    orderList = JsonArrayAggOrderByClause();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            nullClause = (SqlJsonConstructorNullClause) ((SqlLiteral) e).getValue();
      break;
    default:
      jj_la1[333] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        aggCall = SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
            .createCall(span.end(this), valueExpr, orderList);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      e = withinGroup(aggCall);
            if (orderList != null) {
                {if (true) throw SqlUtil.newContextException(span.pos().plus(e.getParserPosition()),
                    RESOURCE.ambiguousSortOrderInJsonArrayAggFunc());}
            }
            {if (true) return (SqlCall) e;}
      break;
    default:
      jj_la1[334] = jj_gen;
      ;
    }
        if (orderList == null) {
            {if (true) return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
                .createCall(span.end(this), valueExpr);}
        }
        {if (true) return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
            .createCall(span.end(this), valueExpr, orderList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIMESTAMPADD.
 */
  final public SqlCall TimestampAddFunctionCall() throws ParseException {
    List<SqlNode> args;
    SqlNode e;
    final Span s;
    TimeUnit interval;
    SqlNode node;
    jj_consume_token(TIMESTAMPADD);
                     s = span();
    jj_consume_token(LPAREN);
    interval = TimestampInterval();
        args = startList(SqlLiteral.createSymbol(interval, getPos()));
    jj_consume_token(COMMA);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                   args.add(e);
    jj_consume_token(COMMA);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                   args.add(e);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.TIMESTAMP_ADD.createCall(
            s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIMESTAMPDIFF.
 */
  final public SqlCall TimestampDiffFunctionCall() throws ParseException {
    List<SqlNode> args;
    SqlNode e;
    final Span s;
    TimeUnit interval;
    SqlNode node;
    jj_consume_token(TIMESTAMPDIFF);
                      s = span();
    jj_consume_token(LPAREN);
    interval = TimestampInterval();
        args = startList(SqlLiteral.createSymbol(interval, getPos()));
    jj_consume_token(COMMA);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                   args.add(e);
    jj_consume_token(COMMA);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                   args.add(e);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(
            s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a grouping function inside the GROUP BY clause,
 * for example {@code TUMBLE(rowtime, INTERVAL '1' MINUTE)}.
 */
  final public SqlCall GroupByWindowingCall() throws ParseException {
    final Span s;
    final List<SqlNode> args;
    final SqlOperator op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TUMBLE:
      jj_consume_token(TUMBLE);
            op = SqlStdOperatorTable.TUMBLE_OLD;
      break;
    case HOP:
      jj_consume_token(HOP);
            op = SqlStdOperatorTable.HOP_OLD;
      break;
    case SESSION:
      jj_consume_token(SESSION);
            op = SqlStdOperatorTable.SESSION_OLD;
      break;
    default:
      jj_la1[335] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        s = span();
    args = UnquantifiedFunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return op.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeFunctionCall() throws ParseException {
    final SqlCall func;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASSIFIER:
      jj_consume_token(CLASSIFIER);
                       s = span();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            func = SqlStdOperatorTable.CLASSIFIER.createCall(s.end(this));
      break;
    case MATCH_NUMBER:
      jj_consume_token(MATCH_NUMBER);
                         s = span();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            func = SqlStdOperatorTable.MATCH_NUMBER.createCall(s.end(this));
      break;
    default:
      jj_la1[336] = jj_gen;
      if (jj_2_82(3)) {
        func = MatchRecognizeNavigationLogical();
      } else if (jj_2_83(2)) {
        func = MatchRecognizeNavigationPhysical();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FINAL:
        case RUNNING:
          func = MatchRecognizeCallWithModifier();
          break;
        default:
          jj_la1[337] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
      {if (true) return func;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeCallWithModifier() throws ParseException {
    final Span s;
    final SqlOperator runningOp;
    final SqlNode func;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RUNNING:
      jj_consume_token(RUNNING);
                    runningOp = SqlStdOperatorTable.RUNNING;
      break;
    case FINAL:
      jj_consume_token(FINAL);
                  runningOp = SqlStdOperatorTable.FINAL;
      break;
    default:
      jj_la1[338] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    func = NamedFunctionCall();
        {if (true) return runningOp.createCall(s.end(func), func);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeNavigationLogical() throws ParseException {
    final Span s = Span.of();
    SqlCall func;
    final SqlOperator funcOp;
    final SqlOperator runningOp;
    SqlNode arg0;
    SqlNode arg1 = SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RUNNING:
      jj_consume_token(RUNNING);
                    runningOp = SqlStdOperatorTable.RUNNING; s.add(this);
      break;
    case FINAL:
      jj_consume_token(FINAL);
                  runningOp = SqlStdOperatorTable.FINAL; s.add(this);
      break;
    default:
      jj_la1[339] = jj_gen;
          runningOp = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
                  funcOp = SqlStdOperatorTable.FIRST;
      break;
    case LAST:
      jj_consume_token(LAST);
                 funcOp = SqlStdOperatorTable.LAST;
      break;
    default:
      jj_la1[340] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s.add(this);
    jj_consume_token(LPAREN);
    arg0 = Expression(ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      arg1 = NumericLiteral();
      break;
    default:
      jj_la1[341] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        func = funcOp.createCall(s.end(this), arg0, arg1);
        if (runningOp != null) {
            {if (true) return runningOp.createCall(s.end(this), func);}
        } else {
            {if (true) return func;}
        }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeNavigationPhysical() throws ParseException {
    final Span s;
    SqlCall func;
    SqlOperator funcOp;
    SqlNode arg0;
    SqlNode arg1 = SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PREV:
      jj_consume_token(PREV);
                 funcOp = SqlStdOperatorTable.PREV;
      break;
    case NEXT:
      jj_consume_token(NEXT);
                 funcOp = SqlStdOperatorTable.NEXT;
      break;
    default:
      jj_la1[342] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    jj_consume_token(LPAREN);
    arg0 = Expression(ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      arg1 = NumericLiteral();
      break;
    default:
      jj_la1[343] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return funcOp.createCall(s.end(this), arg0, arg1);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall withinDistinct(SqlNode arg) throws ParseException {
    final Span s;
    final SqlNodeList distinctList;
    jj_consume_token(WITHIN);
               s = span();
    jj_consume_token(DISTINCT);
    jj_consume_token(LPAREN);
    distinctList = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.WITHIN_DISTINCT.createCall(
            s.end(this), arg, distinctList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall withinGroup(SqlNode arg) throws ParseException {
    final Span s;
    final SqlNodeList orderList;
    jj_consume_token(WITHIN);
               s = span();
    jj_consume_token(GROUP);
    jj_consume_token(LPAREN);
    orderList = OrderBy(true);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.WITHIN_GROUP.createCall(
            s.end(this), arg, orderList);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<SqlParserPos, SqlOperator> NullTreatment() throws ParseException {
    final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IGNORE:
      jj_consume_token(IGNORE);
               span = span();
      jj_consume_token(NULLS);
        {if (true) return Pair.of(span.end(this), SqlStdOperatorTable.IGNORE_NULLS);}
      break;
    case RESPECT:
      jj_consume_token(RESPECT);
                span = span();
      jj_consume_token(NULLS);
        {if (true) return Pair.of(span.end(this), SqlStdOperatorTable.RESPECT_NULLS);}
      break;
    default:
      jj_la1[344] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall nullTreatment(SqlCall arg) throws ParseException {
    final Pair<SqlParserPos, SqlOperator> pair;
    pair = NullTreatment();
                             {if (true) return pair.right.createCall(pair.left, arg);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a named function (could be a builtin with regular
 * syntax, or else a UDF).
 *
 * <p>NOTE: every UDF has two names: an <em>invocation name</em> and a
 * <em>specific name</em>.  Normally, function calls are resolved via overload
 * resolution and invocation names.  The SPECIFIC prefix allows overload
 * resolution to be bypassed.  Note that usage of the SPECIFIC prefix in
 * queries is non-standard; it is used internally by Farrago, e.g. in stored
 * view definitions to permanently bind references to a particular function
 * after the overload resolution performed by view creation.
 *
 * <p>TODO jvs 25-Mar-2005:  Once we have SQL-Flagger support, flag SPECIFIC
 * as non-standard.
 */
  final public SqlNode NamedFunctionCall() throws ParseException {
    SqlCall call;
    final Span filterSpan;
    final SqlNode filter;
    final Span overSpan;
    final SqlNode over;
    final Span withinGroupSpan;
    if (jj_2_84(2)) {
      call = StringAggFunctionCall();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT_DATE:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXP:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NTH_VALUE:
      case NTILE:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case ROW_NUMBER:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUM:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        call = NamedCall();
        break;
      default:
        jj_la1[345] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_85(2)) {
      call = nullTreatment(call);
    } else {
      ;
    }
    if (jj_2_86(2)) {
      // decide between WITHIN DISTINCT and WITHIN GROUP
              call = withinDistinct(call);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      call = withinGroup(call);
      break;
    default:
      jj_la1[346] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FILTER:
      jj_consume_token(FILTER);
                   filterSpan = span();
      jj_consume_token(LPAREN);
      jj_consume_token(WHERE);
      filter = Expression(ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(RPAREN);
            call = SqlStdOperatorTable.FILTER.createCall(
                filterSpan.end(this), call, filter);
      break;
    default:
      jj_la1[347] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVER:
      jj_consume_token(OVER);
                 overSpan = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        over = SimpleIdentifier();
        break;
      case LPAREN:
        over = WindowSpecification();
        break;
      default:
        jj_la1[348] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            call = SqlStdOperatorTable.OVER.createCall(overSpan.end(over), call, over);
      break;
    default:
      jj_la1[349] = jj_gen;
      ;
    }
        {if (true) return call;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall NamedCall() throws ParseException {
    final SqlFunctionCategory funcType;
    final SqlIdentifier qualifiedName;
    final Span s;
    final List<SqlNode> args;
    SqlLiteral quantifier = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPECIFIC:
      jj_consume_token(SPECIFIC);
            funcType = SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION;
      break;
    default:
      jj_la1[350] = jj_gen;
          funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
    }
    qualifiedName = FunctionName();
        s = span();
    if (jj_2_87(2)) {
      jj_consume_token(LPAREN);
      jj_consume_token(STAR);
            args = startList(SqlIdentifier.star(getPos()));
      jj_consume_token(RPAREN);
    } else if (jj_2_88(2)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            args = Collections.emptyList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        args = FunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
            quantifier = (SqlLiteral) args.get(0);
            args.remove(0);
        break;
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return createCall(qualifiedName, s.end(this), funcType, quantifier, args);}
    throw new Error("Missing return statement in function");
  }

/*
* Parse Floor/Ceil function parameters
*/
  final public SqlNode StandardFloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
    SqlNode e;
    final List<SqlNode> args;
    TimeUnit unit;
    SqlCall function;
    final Span s1;
    jj_consume_token(LPAREN);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        args = startList(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TO:
      jj_consume_token(TO);
      unit = TimeUnit();
            args.add(new SqlIntervalQualifier(unit, null, getPos()));
      break;
    default:
      jj_la1[352] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        SqlOperator op = floorFlag
            ? SqlStdOperatorTable.FLOOR
            : SqlStdOperatorTable.CEIL;
        function =  op.createCall(s.end(this), args);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVER:
      jj_consume_token(OVER);
                 s1 = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = SimpleIdentifier();
        break;
      case LPAREN:
        e = WindowSpecification();
        break;
      default:
        jj_la1[353] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return SqlStdOperatorTable.OVER.createCall(s1.end(this), function, e);}
      break;
    default:
      jj_la1[354] = jj_gen;
          {if (true) return function;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the name of a JDBC function that is a token but is not reserved.
 */
  final public String NonReservedJdbcFunctionName() throws ParseException {
    jj_consume_token(SUBSTRING);
        {if (true) return unquotedIdentifier();}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the name of a function (either a compound identifier or
 * a reserved word which can be used as a function name).
 */
  final public SqlIdentifier FunctionName() throws ParseException {
    SqlIdentifier qualifiedName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      qualifiedName = CompoundIdentifier();
      break;
    case ABS:
    case AVG:
    case CARDINALITY:
    case CEILING:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case COALESCE:
    case COLLECT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT_DATE:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case DENSE_RANK:
    case ELEMENT:
    case EVERY:
    case EXP:
    case FIRST_VALUE:
    case FLOOR:
    case FUSION:
    case GROUPING:
    case HOUR:
    case INTERSECTION:
    case LAG:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOWER:
    case MAX:
    case MIN:
    case MINUTE:
    case MOD:
    case MONTH:
    case NTH_VALUE:
    case NTILE:
    case NULLIF:
    case OCTET_LENGTH:
    case PERCENT_RANK:
    case POWER:
    case RANK:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RIGHT:
    case ROW_NUMBER:
    case SECOND:
    case SOME:
    case SQRT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case SUM:
    case TRUNCATE:
    case UPPER:
    case USER:
    case VAR_POP:
    case VAR_SAMP:
    case YEAR:
      qualifiedName = ReservedFunctionName();
      break;
    default:
      jj_la1[355] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return qualifiedName;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a reserved word which is used as the name of a function.
 */
  final public SqlIdentifier ReservedFunctionName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABS:
      jj_consume_token(ABS);
      break;
    case AVG:
      jj_consume_token(AVG);
      break;
    case CARDINALITY:
      jj_consume_token(CARDINALITY);
      break;
    case CEILING:
      jj_consume_token(CEILING);
      break;
    case CHAR_LENGTH:
      jj_consume_token(CHAR_LENGTH);
      break;
    case CHARACTER_LENGTH:
      jj_consume_token(CHARACTER_LENGTH);
      break;
    case COALESCE:
      jj_consume_token(COALESCE);
      break;
    case COLLECT:
      jj_consume_token(COLLECT);
      break;
    case COVAR_POP:
      jj_consume_token(COVAR_POP);
      break;
    case COVAR_SAMP:
      jj_consume_token(COVAR_SAMP);
      break;
    case CUME_DIST:
      jj_consume_token(CUME_DIST);
      break;
    case COUNT:
      jj_consume_token(COUNT);
      break;
    case CURRENT_DATE:
      jj_consume_token(CURRENT_DATE);
      break;
    case CURRENT_TIME:
      jj_consume_token(CURRENT_TIME);
      break;
    case CURRENT_TIMESTAMP:
      jj_consume_token(CURRENT_TIMESTAMP);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    case ELEMENT:
      jj_consume_token(ELEMENT);
      break;
    case EVERY:
      jj_consume_token(EVERY);
      break;
    case EXP:
      jj_consume_token(EXP);
      break;
    case FIRST_VALUE:
      jj_consume_token(FIRST_VALUE);
      break;
    case FLOOR:
      jj_consume_token(FLOOR);
      break;
    case FUSION:
      jj_consume_token(FUSION);
      break;
    case INTERSECTION:
      jj_consume_token(INTERSECTION);
      break;
    case GROUPING:
      jj_consume_token(GROUPING);
      break;
    case HOUR:
      jj_consume_token(HOUR);
      break;
    case LAG:
      jj_consume_token(LAG);
      break;
    case LEAD:
      jj_consume_token(LEAD);
      break;
    case LEFT:
      jj_consume_token(LEFT);
      break;
    case LAST_VALUE:
      jj_consume_token(LAST_VALUE);
      break;
    case LN:
      jj_consume_token(LN);
      break;
    case LOCALTIME:
      jj_consume_token(LOCALTIME);
      break;
    case LOCALTIMESTAMP:
      jj_consume_token(LOCALTIMESTAMP);
      break;
    case LOWER:
      jj_consume_token(LOWER);
      break;
    case MAX:
      jj_consume_token(MAX);
      break;
    case MIN:
      jj_consume_token(MIN);
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    case MONTH:
      jj_consume_token(MONTH);
      break;
    case NTH_VALUE:
      jj_consume_token(NTH_VALUE);
      break;
    case NTILE:
      jj_consume_token(NTILE);
      break;
    case NULLIF:
      jj_consume_token(NULLIF);
      break;
    case OCTET_LENGTH:
      jj_consume_token(OCTET_LENGTH);
      break;
    case PERCENT_RANK:
      jj_consume_token(PERCENT_RANK);
      break;
    case POWER:
      jj_consume_token(POWER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case REGR_COUNT:
      jj_consume_token(REGR_COUNT);
      break;
    case REGR_SXX:
      jj_consume_token(REGR_SXX);
      break;
    case REGR_SYY:
      jj_consume_token(REGR_SYY);
      break;
    case RIGHT:
      jj_consume_token(RIGHT);
      break;
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case SECOND:
      jj_consume_token(SECOND);
      break;
    case SOME:
      jj_consume_token(SOME);
      break;
    case SQRT:
      jj_consume_token(SQRT);
      break;
    case STDDEV_POP:
      jj_consume_token(STDDEV_POP);
      break;
    case STDDEV_SAMP:
      jj_consume_token(STDDEV_SAMP);
      break;
    case SUM:
      jj_consume_token(SUM);
      break;
    case UPPER:
      jj_consume_token(UPPER);
      break;
    case TRUNCATE:
      jj_consume_token(TRUNCATE);
      break;
    case USER:
      jj_consume_token(USER);
      break;
    case VAR_POP:
      jj_consume_token(VAR_POP);
      break;
    case VAR_SAMP:
      jj_consume_token(VAR_SAMP);
      break;
    case YEAR:
      jj_consume_token(YEAR);
      break;
    default:
      jj_la1[356] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIdentifier(unquotedIdentifier(), getPos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlIdentifier ContextVariable() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CURRENT_CATALOG:
      jj_consume_token(CURRENT_CATALOG);
      break;
    case CURRENT_DATE:
      jj_consume_token(CURRENT_DATE);
      break;
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
      jj_consume_token(CURRENT_DEFAULT_TRANSFORM_GROUP);
      break;
    case CURRENT_PATH:
      jj_consume_token(CURRENT_PATH);
      break;
    case CURRENT_ROLE:
      jj_consume_token(CURRENT_ROLE);
      break;
    case CURRENT_SCHEMA:
      jj_consume_token(CURRENT_SCHEMA);
      break;
    case CURRENT_TIME:
      jj_consume_token(CURRENT_TIME);
      break;
    case CURRENT_TIMESTAMP:
      jj_consume_token(CURRENT_TIMESTAMP);
      break;
    case CURRENT_USER:
      jj_consume_token(CURRENT_USER);
      break;
    case LOCALTIME:
      jj_consume_token(LOCALTIME);
      break;
    case LOCALTIMESTAMP:
      jj_consume_token(LOCALTIMESTAMP);
      break;
    case SESSION_USER:
      jj_consume_token(SESSION_USER);
      break;
    case SYSTEM_USER:
      jj_consume_token(SYSTEM_USER);
      break;
    case USER:
      jj_consume_token(USER);
      break;
    default:
      jj_la1[357] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIdentifier(unquotedIdentifier(), getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a function call expression with JDBC syntax.
 */
  final public SqlNode JdbcFunctionCall() throws ParseException {
    String name;
    SqlIdentifier id;
    SqlNode e;
    SqlLiteral tl;
    SqlNodeList args;
    SqlCall call;
    final Span s, s1;
    jj_consume_token(LBRACE_FN);
        s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIMESTAMPADD:
      call = TimestampAddFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    default:
      jj_la1[361] = jj_gen;
      if (jj_2_91(3)) {
        call = TimestampDiffFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CONVERT:
          jj_consume_token(CONVERT);
                    name = unquotedIdentifier();
          jj_consume_token(LPAREN);
          e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args = new SqlNodeList(getPos());
            args.add(e);
          jj_consume_token(COMMA);
          tl = JdbcOdbcDataType();
                                  args.add(tl);
          jj_consume_token(RPAREN);
          break;
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CATALOG:
        case CATALOG_NAME:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT_DATE:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOT_FORMAT:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXP:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case ILIKE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDE:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSERT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NORMALIZED:
        case NTH_VALUE:
        case NTILE:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENT_RANK:
        case PIVOT:
        case PLACING:
        case PLAN:
        case PLI:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case RLIKE:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW_COUNT:
        case ROW_NUMBER:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEPARATOR:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STATEMENT:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRUNCATE:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNPIVOT:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INSERT:
          case LEFT:
          case RIGHT:
          case TRUNCATE:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INSERT:
              jj_consume_token(INSERT);
              break;
            case LEFT:
              jj_consume_token(LEFT);
              break;
            case RIGHT:
              jj_consume_token(RIGHT);
              break;
            case TRUNCATE:
              jj_consume_token(TRUNCATE);
              break;
            default:
              jj_la1[358] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
                                                           name = unquotedIdentifier();
            break;
          case ABS:
          case AVG:
          case CARDINALITY:
          case CEILING:
          case CHAR_LENGTH:
          case CHARACTER_LENGTH:
          case COALESCE:
          case COLLECT:
          case COUNT:
          case COVAR_POP:
          case COVAR_SAMP:
          case CUME_DIST:
          case CURRENT_DATE:
          case CURRENT_TIME:
          case CURRENT_TIMESTAMP:
          case DENSE_RANK:
          case ELEMENT:
          case EVERY:
          case EXP:
          case FIRST_VALUE:
          case FLOOR:
          case FUSION:
          case GROUPING:
          case HOUR:
          case INTERSECTION:
          case LAG:
          case LAST_VALUE:
          case LEAD:
          case LN:
          case LOCALTIME:
          case LOCALTIMESTAMP:
          case LOWER:
          case MAX:
          case MIN:
          case MINUTE:
          case MOD:
          case MONTH:
          case NTH_VALUE:
          case NTILE:
          case NULLIF:
          case OCTET_LENGTH:
          case PERCENT_RANK:
          case POWER:
          case RANK:
          case REGR_COUNT:
          case REGR_SXX:
          case REGR_SYY:
          case ROW_NUMBER:
          case SECOND:
          case SOME:
          case SQRT:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case SUM:
          case UPPER:
          case USER:
          case VAR_POP:
          case VAR_SAMP:
          case YEAR:
            // For cases like {fn power(1,2)} and {fn lower('a')}
                        id = ReservedFunctionName();
                                          name = id.getSimple();
            break;
          case SUBSTRING:
            // For cases like {fn substring('foo', 1,2)}
                        name = NonReservedJdbcFunctionName();
            break;
          case A:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ARRAY_AGG:
          case ARRAY_CONCAT_AGG:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CASCADE:
          case CATALOG:
          case CATALOG_NAME:
          case CENTURY:
          case CHAIN:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASS_ORIGIN:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOT_FORMAT:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case FINAL:
          case FIRST:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case GROUP_CONCAT:
          case HIERARCHY:
          case HOP:
          case HOURS:
          case IGNORE:
          case ILIKE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDE:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAST:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LOCATOR:
          case M:
          case MAP:
          case MATCHED:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MINUTES:
          case MINVALUE:
          case MONTHS:
          case MORE_:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NORMALIZED:
          case NULLABLE:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PIVOT:
          case PLACING:
          case PLAN:
          case PLI:
          case PRECEDING:
          case PRESERVE:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case READ:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case RLIKE:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW_COUNT:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEPARATOR:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOURCE:
          case SPACE:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case STATE:
          case STATEMENT:
          case STRING_AGG:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNPIVOT:
          case UNNAMED:
          case USAGE:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VERSION:
          case VIEW:
          case WEEK:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEARS:
          case ZONE:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            name = Identifier();
            break;
          default:
            jj_la1[359] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_89(2)) {
            jj_consume_token(LPAREN);
            jj_consume_token(STAR);
                                           s1 = span();
            jj_consume_token(RPAREN);
                args = new SqlNodeList(s1.pos());
                args.add(SqlIdentifier.star(s1.pos()));
          } else if (jj_2_90(2)) {
            jj_consume_token(LPAREN);
            jj_consume_token(RPAREN);
                                             args = SqlNodeList.EMPTY;
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LPAREN:
              args = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_SUB_QUERY);
              break;
            default:
              jj_la1[360] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
        default:
          jj_la1[362] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(RBRACE);
        {if (true) return new SqlJdbcFunctionCall(name).createCall(s.end(this),
            args.getList());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary query operator like UNION.
 */
  final public SqlBinaryOperator BinaryQueryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      jj_consume_token(UNION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.UNION_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.UNION;}
        break;
      default:
        jj_la1[363] = jj_gen;
              {if (true) return SqlStdOperatorTable.UNION;}
      }
      break;
    case INTERSECT:
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.INTERSECT_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.INTERSECT;}
        break;
      default:
        jj_la1[364] = jj_gen;
              {if (true) return SqlStdOperatorTable.INTERSECT;}
      }
      break;
    case EXCEPT:
    case SET_MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
        jj_consume_token(EXCEPT);
        break;
      case SET_MINUS:
        jj_consume_token(SET_MINUS);
                if (!this.conformance.isMinusAllowed()) {
                    {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.minusNotAllowed());}
                }
        break;
      default:
        jj_la1[365] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.EXCEPT_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.EXCEPT;}
        break;
      default:
        jj_la1[366] = jj_gen;
              {if (true) return SqlStdOperatorTable.EXCEPT;}
      }
      break;
    default:
      jj_la1[367] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary multiset operator.
 */
  final public SqlBinaryOperator BinaryMultisetOperator() throws ParseException {
    jj_consume_token(MULTISET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      jj_consume_token(UNION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_UNION_DISTINCT;}
          break;
        default:
          jj_la1[368] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[369] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_UNION;}
      break;
    case INTERSECT:
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT;}
          break;
        default:
          jj_la1[370] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[371] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_INTERSECT;}
      break;
    case EXCEPT:
      jj_consume_token(EXCEPT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT;}
          break;
        default:
          jj_la1[372] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[373] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_EXCEPT;}
      break;
    default:
      jj_la1[374] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary row operator like AND.
 */
  final public SqlBinaryOperator BinaryRowOperator() throws ParseException {
    SqlBinaryOperator op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
           {if (true) return SqlStdOperatorTable.EQUALS;}
      break;
    case GT:
      jj_consume_token(GT);
           {if (true) return SqlStdOperatorTable.GREATER_THAN;}
      break;
    case LT:
      jj_consume_token(LT);
           {if (true) return SqlStdOperatorTable.LESS_THAN;}
      break;
    case LE:
      jj_consume_token(LE);
           {if (true) return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;}
      break;
    case GE:
      jj_consume_token(GE);
           {if (true) return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;}
      break;
    case NE:
      jj_consume_token(NE);
           {if (true) return SqlStdOperatorTable.NOT_EQUALS;}
      break;
    case NE2:
      jj_consume_token(NE2);
        if (!this.conformance.isBangEqualAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.bangEqualNotAllowed());}
        }
        {if (true) return SqlStdOperatorTable.NOT_EQUALS;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
             {if (true) return SqlStdOperatorTable.PLUS;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return SqlStdOperatorTable.MINUS;}
      break;
    case STAR:
      jj_consume_token(STAR);
             {if (true) return SqlStdOperatorTable.MULTIPLY;}
      break;
    case SLASH:
      jj_consume_token(SLASH);
              {if (true) return SqlStdOperatorTable.DIVIDE;}
      break;
    case PERCENT_REMAINDER:
      jj_consume_token(PERCENT_REMAINDER);
        if (!this.conformance.isPercentRemainderAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.percentRemainderNotAllowed());}
        }
        {if (true) return SqlStdOperatorTable.PERCENT_REMAINDER;}
      break;
    case CONCAT:
      jj_consume_token(CONCAT);
               {if (true) return SqlStdOperatorTable.CONCAT;}
      break;
    case AND:
      jj_consume_token(AND);
            {if (true) return SqlStdOperatorTable.AND;}
      break;
    case OR:
      jj_consume_token(OR);
           {if (true) return SqlStdOperatorTable.OR;}
      break;
    default:
      jj_la1[375] = jj_gen;
      if (jj_2_92(2)) {
        jj_consume_token(IS);
        jj_consume_token(DISTINCT);
        jj_consume_token(FROM);
                                          {if (true) return SqlStdOperatorTable.IS_DISTINCT_FROM;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IS:
          jj_consume_token(IS);
          jj_consume_token(NOT);
          jj_consume_token(DISTINCT);
          jj_consume_token(FROM);
                                   {if (true) return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;}
          break;
        case MEMBER:
          jj_consume_token(MEMBER);
          jj_consume_token(OF);
                    {if (true) return SqlStdOperatorTable.MEMBER_OF;}
          break;
        default:
          jj_la1[376] = jj_gen;
          if (jj_2_93(2)) {
            jj_consume_token(SUBMULTISET);
            jj_consume_token(OF);
                                      {if (true) return SqlStdOperatorTable.SUBMULTISET_OF;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case NOT:
              jj_consume_token(NOT);
              jj_consume_token(SUBMULTISET);
              jj_consume_token(OF);
                               {if (true) return SqlStdOperatorTable.NOT_SUBMULTISET_OF;}
              break;
            case CONTAINS:
              jj_consume_token(CONTAINS);
                 {if (true) return SqlStdOperatorTable.CONTAINS;}
              break;
            case OVERLAPS:
              jj_consume_token(OVERLAPS);
                 {if (true) return SqlStdOperatorTable.OVERLAPS;}
              break;
            case EQUALS:
              jj_consume_token(EQUALS);
               {if (true) return SqlStdOperatorTable.PERIOD_EQUALS;}
              break;
            case PRECEDES:
              jj_consume_token(PRECEDES);
                 {if (true) return SqlStdOperatorTable.PRECEDES;}
              break;
            case SUCCEEDS:
              jj_consume_token(SUCCEEDS);
                 {if (true) return SqlStdOperatorTable.SUCCEEDS;}
              break;
            default:
              jj_la1[377] = jj_gen;
              if (jj_2_94(2)) {
                jj_consume_token(IMMEDIATELY);
                jj_consume_token(PRECEDES);
                                            {if (true) return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;}
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case IMMEDIATELY:
                  jj_consume_token(IMMEDIATELY);
                  jj_consume_token(SUCCEEDS);
                               {if (true) return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;}
                  break;
                case MULTISET:
                  op = BinaryMultisetOperator();
                                    {if (true) return op;}
                  break;
                default:
                  jj_la1[378] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a prefix row operator like NOT.
 */
  final public SqlPrefixOperator PrefixRowOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
             {if (true) return SqlStdOperatorTable.UNARY_PLUS;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return SqlStdOperatorTable.UNARY_MINUS;}
      break;
    case NOT:
      jj_consume_token(NOT);
            {if (true) return SqlStdOperatorTable.NOT;}
      break;
    case EXISTS:
      jj_consume_token(EXISTS);
               {if (true) return SqlStdOperatorTable.EXISTS;}
      break;
    default:
      jj_la1[379] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a postfix row operator like IS NOT NULL.
 */
  final public SqlPostfixOperator PostfixRowOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
        jj_consume_token(A);
        jj_consume_token(SET);
                    {if (true) return SqlStdOperatorTable.IS_A_SET;}
        break;
      case NOT:
        jj_consume_token(NOT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                     {if (true) return SqlStdOperatorTable.IS_NOT_NULL;}
          break;
        case TRUE:
          jj_consume_token(TRUE);
                     {if (true) return SqlStdOperatorTable.IS_NOT_TRUE;}
          break;
        case FALSE:
          jj_consume_token(FALSE);
                      {if (true) return SqlStdOperatorTable.IS_NOT_FALSE;}
          break;
        case UNKNOWN:
          jj_consume_token(UNKNOWN);
                        {if (true) return SqlStdOperatorTable.IS_NOT_UNKNOWN;}
          break;
        case A:
          jj_consume_token(A);
          jj_consume_token(SET);
                        {if (true) return SqlStdOperatorTable.IS_NOT_A_SET;}
          break;
        case EMPTY:
          jj_consume_token(EMPTY);
                      {if (true) return SqlStdOperatorTable.IS_NOT_EMPTY;}
          break;
        default:
          jj_la1[380] = jj_gen;
          if (jj_2_95(2)) {
            jj_consume_token(JSON);
            jj_consume_token(VALUE);
                                          {if (true) return SqlStdOperatorTable.IS_NOT_JSON_VALUE;}
          } else if (jj_2_96(2)) {
            jj_consume_token(JSON);
            jj_consume_token(OBJECT);
                                           {if (true) return SqlStdOperatorTable.IS_NOT_JSON_OBJECT;}
          } else if (jj_2_97(2)) {
            jj_consume_token(JSON);
            jj_consume_token(ARRAY);
                                          {if (true) return SqlStdOperatorTable.IS_NOT_JSON_ARRAY;}
          } else if (jj_2_98(2)) {
            jj_consume_token(JSON);
            jj_consume_token(SCALAR);
                                           {if (true) return SqlStdOperatorTable.IS_NOT_JSON_SCALAR;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case JSON:
              jj_consume_token(JSON);
                     {if (true) return SqlStdOperatorTable.IS_NOT_JSON_VALUE;}
              break;
            default:
              jj_la1[381] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
      case EMPTY:
      case FALSE:
      case JSON:
      case NULL:
      case TRUE:
      case UNKNOWN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                     {if (true) return SqlStdOperatorTable.IS_NULL;}
          break;
        case TRUE:
          jj_consume_token(TRUE);
                     {if (true) return SqlStdOperatorTable.IS_TRUE;}
          break;
        case FALSE:
          jj_consume_token(FALSE);
                      {if (true) return SqlStdOperatorTable.IS_FALSE;}
          break;
        case UNKNOWN:
          jj_consume_token(UNKNOWN);
                        {if (true) return SqlStdOperatorTable.IS_UNKNOWN;}
          break;
        case EMPTY:
          jj_consume_token(EMPTY);
                      {if (true) return SqlStdOperatorTable.IS_EMPTY;}
          break;
        default:
          jj_la1[382] = jj_gen;
          if (jj_2_99(2)) {
            jj_consume_token(JSON);
            jj_consume_token(VALUE);
                                          {if (true) return SqlStdOperatorTable.IS_JSON_VALUE;}
          } else if (jj_2_100(2)) {
            jj_consume_token(JSON);
            jj_consume_token(OBJECT);
                                           {if (true) return SqlStdOperatorTable.IS_JSON_OBJECT;}
          } else if (jj_2_101(2)) {
            jj_consume_token(JSON);
            jj_consume_token(ARRAY);
                                          {if (true) return SqlStdOperatorTable.IS_JSON_ARRAY;}
          } else if (jj_2_102(2)) {
            jj_consume_token(JSON);
            jj_consume_token(SCALAR);
                                           {if (true) return SqlStdOperatorTable.IS_JSON_SCALAR;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case JSON:
              jj_consume_token(JSON);
                     {if (true) return SqlStdOperatorTable.IS_JSON_VALUE;}
              break;
            default:
              jj_la1[383] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
      default:
        jj_la1[384] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case FORMAT:
      jj_consume_token(FORMAT);
      JsonRepresentation();
            {if (true) return SqlStdOperatorTable.JSON_VALUE_EXPRESSION;}
      break;
    default:
      jj_la1[385] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a non-reserved keyword for use as an identifier.
 *
 * <p>The method is broken up into several sub-methods; without this
 * decomposition, parsers such as Babel with more than ~1,000 non-reserved
 * keywords would generate such deeply nested 'if' statements that javac would
 * fail with a {@link StackOverflowError}.
 *
 * <p>The list is generated from the FMPP config data. To add or remove
 * keywords, modify config.fmpp. For parsers except Babel, make sure that
 * keywords are not reserved by the SQL standard.
 *
 * @see Glossary#SQL2003 SQL:2003 Part 2 Section 5.2
 */
  final public String NonReservedKeyWord() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ACTION:
    case ADMIN:
    case APPLY:
    case ASC:
    case ATTRIBUTE:
    case BERNOULLI:
    case CASCADE:
    case CENTURY:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERS:
    case COLLATION:
    case COLLATION_SCHEMA:
    case COMMAND_FUNCTION_CODE:
    case CONDITION_NUMBER:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_SCHEMA:
    case CURSOR_NAME:
    case DATETIME_INTERVAL_CODE:
    case DECADE:
    case DEFERRED:
    case DEGREE:
    case DESC:
    case DIAGNOSTICS:
    case DOW:
    case DYNAMIC_FUNCTION:
    case EPOCH:
    case EXCLUDE:
    case FIRST:
    case FORTRAN:
    case G:
    case GEOMETRY:
    case GRANTED:
    case HOP:
    case ILIKE:
    case IMPLEMENTATION:
    case INCREMENT:
    case INSTANCE:
    case ISODOW:
    case JAVA:
    case KEY:
    case LABEL:
    case LEVEL:
    case M:
    case MAXVALUE:
    case MESSAGE_TEXT:
    case MILLISECOND:
    case MONTHS:
    case NAME:
    case NESTING:
    case NULLS:
    case OCTETS:
    case ORDERING:
    case OUTPUT:
    case PARAMETER_MODE:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARTIAL:
    case PASSTHROUGH:
    case PIVOT:
    case PLI:
    case PRIOR:
    case QUARTER:
    case REPEATABLE:
    case RESTART:
    case RETURNED_LENGTH:
    case RETURNING:
    case ROUTINE:
    case ROUTINE_SCHEMA:
    case SCALE:
    case SCOPE_CATALOGS:
    case SECONDS:
    case SELF:
    case SERIALIZABLE:
    case SESSION:
    case SIZE:
    case SPECIFIC_NAME:
    case SQL_BIT:
    case SQL_CHAR:
    case SQL_DECIMAL:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_LONGVARCHAR:
    case SQL_NCLOB:
    case SQL_REAL:
    case SQL_TIMESTAMP:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_SECOND:
    case SQL_VARBINARY:
    case STATEMENT:
    case STYLE:
    case TABLE_NAME:
    case TIMESTAMPADD:
    case TRANSACTION:
    case TRANSACTIONS_ROLLED_BACK:
    case TRIGGER_CATALOG:
    case TUMBLE:
    case UNCOMMITTED:
    case UNPIVOT:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case WEEK:
    case WRITE:
    case ZONE:
      NonReservedKeyWord0of3();
      break;
    case ABSENT:
    case ADA:
    case AFTER:
    case ARRAY_AGG:
    case ASSERTION:
    case ATTRIBUTES:
    case BREADTH:
    case CATALOG:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CLASS_ORIGIN:
    case COLLATION_CATALOG:
    case COLUMN_NAME:
    case COMMITTED:
    case CONNECTION:
    case CONSTRAINT_NAME:
    case CONSTRUCTOR:
    case DATA:
    case DATETIME_INTERVAL_PRECISION:
    case DEFAULTS:
    case DEFINED:
    case DEPTH:
    case DESCRIPTION:
    case DISPATCH:
    case DOY:
    case DYNAMIC_FUNCTION_CODE:
    case ERROR:
    case EXCLUDING:
    case FOLLOWING:
    case FOUND:
    case GENERAL:
    case GO:
    case GROUP_CONCAT:
    case HOURS:
    case IMMEDIATE:
    case INCLUDE:
    case INITIALLY:
    case INSTANTIABLE:
    case ISOLATION:
    case JSON:
    case KEY_MEMBER:
    case LAST:
    case LIBRARY:
    case MAP:
    case MESSAGE_LENGTH:
    case MICROSECOND:
    case MINUTES:
    case MORE_:
    case NAMES:
    case NORMALIZED:
    case NUMBER:
    case OPTION:
    case ORDINALITY:
    case OVERRIDING:
    case PARAMETER_NAME:
    case PARAMETER_SPECIFIC_NAME:
    case PASCAL:
    case PAST:
    case PLACING:
    case PRECEDING:
    case PRIVILEGES:
    case READ:
    case REPLACE:
    case RESTRICT:
    case RETURNED_OCTET_LENGTH:
    case RLIKE:
    case ROUTINE_CATALOG:
    case ROW_COUNT:
    case SCHEMA:
    case SCOPE_NAME:
    case SECTION:
    case SEPARATOR:
    case SERVER:
    case SETS:
    case SOURCE:
    case SQL_BIGINT:
    case SQL_BLOB:
    case SQL_CLOB:
    case SQL_DOUBLE:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARNCHAR:
    case SQL_NUMERIC:
    case SQL_SMALLINT:
    case SQL_TINYINT:
    case SQL_TSI_HOUR:
    case SQL_TSI_MONTH:
    case SQL_TSI_WEEK:
    case SQL_VARCHAR:
    case STRING_AGG:
    case SUBCLASS_ORIGIN:
    case TEMPORARY:
    case TIMESTAMPDIFF:
    case TRANSACTIONS_ACTIVE:
    case TRANSFORM:
    case TRIGGER_NAME:
    case TYPE:
    case UNCONDITIONAL:
    case UNNAMED:
    case USER_DEFINED_TYPE_CODE:
    case UTF16:
    case VERSION:
    case WORK:
    case XML:
      NonReservedKeyWord1of3();
      break;
    case ABSOLUTE:
    case ADD:
    case ALWAYS:
    case ARRAY_CONCAT_AGG:
    case ASSIGNMENT:
    case BEFORE:
    case C:
    case CATALOG_NAME:
    case CHARACTER_SET_NAME:
    case CHARACTERISTICS:
    case COBOL:
    case COLLATION_NAME:
    case COMMAND_FUNCTION:
    case CONDITIONAL:
    case CONNECTION_NAME:
    case CONSTRAINTS:
    case CONTINUE:
    case DATABASE:
    case DAYS:
    case DEFERRABLE:
    case DEFINER:
    case DERIVED:
    case DESCRIPTOR:
    case DOMAIN:
    case DOT_FORMAT:
    case ENCODING:
    case EXCEPTION:
    case FINAL:
    case FORMAT:
    case FRAC_SECOND:
    case GENERATED:
    case GOTO:
    case HIERARCHY:
    case IGNORE:
    case IMMEDIATELY:
    case INCLUDING:
    case INPUT:
    case INVOKER:
    case ISOYEAR:
    case K:
    case KEY_TYPE:
    case LENGTH:
    case LOCATOR:
    case MATCHED:
    case MESSAGE_OCTET_LENGTH:
    case MILLENNIUM:
    case MINVALUE:
    case MUMPS:
    case NANOSECOND:
    case NULLABLE:
    case OBJECT:
    case OPTIONS:
    case OTHERS:
    case PAD:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PASSING:
    case PATH:
    case PLAN:
    case PRESERVE:
    case PUBLIC:
    case RELATIVE:
    case RESPECT:
    case RETURNED_CARDINALITY:
    case RETURNED_SQLSTATE:
    case ROLE:
    case ROUTINE_NAME:
    case SCALAR:
    case SCHEMA_NAME:
    case SCOPE_SCHEMA:
    case SECURITY:
    case SEQUENCE:
    case SERVER_NAME:
    case SIMPLE:
    case SPACE:
    case SQL_BINARY:
    case SQL_BOOLEAN:
    case SQL_DATE:
    case SQL_FLOAT:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_SECOND:
    case SQL_LONGVARBINARY:
    case SQL_NCHAR:
    case SQL_NVARCHAR:
    case SQL_TIME:
    case SQL_TSI_DAY:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case STATE:
    case STRUCTURE:
    case SUBSTITUTE:
    case TIES:
    case TOP_LEVEL_COUNT:
    case TRANSACTIONS_COMMITTED:
    case TRANSFORMS:
    case TRIGGER_SCHEMA:
    case UNBOUNDED:
    case UNDER:
    case USAGE:
    case USER_DEFINED_TYPE_NAME:
    case UTF32:
    case VIEW:
    case WRAPPER:
    case YEARS:
      NonReservedKeyWord2of3();
      break;
    default:
      jj_la1[386] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return unquotedIdentifier();}
    throw new Error("Missing return statement in function");
  }

/** @see #NonReservedKeyWord */
  final public void NonReservedKeyWord0of3() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
      jj_consume_token(A);
      break;
    case ACTION:
      jj_consume_token(ACTION);
      break;
    case ADMIN:
      jj_consume_token(ADMIN);
      break;
    case APPLY:
      jj_consume_token(APPLY);
      break;
    case ASC:
      jj_consume_token(ASC);
      break;
    case ATTRIBUTE:
      jj_consume_token(ATTRIBUTE);
      break;
    case BERNOULLI:
      jj_consume_token(BERNOULLI);
      break;
    case CASCADE:
      jj_consume_token(CASCADE);
      break;
    case CENTURY:
      jj_consume_token(CENTURY);
      break;
    case CHARACTERS:
      jj_consume_token(CHARACTERS);
      break;
    case CHARACTER_SET_SCHEMA:
      jj_consume_token(CHARACTER_SET_SCHEMA);
      break;
    case COLLATION:
      jj_consume_token(COLLATION);
      break;
    case COLLATION_SCHEMA:
      jj_consume_token(COLLATION_SCHEMA);
      break;
    case COMMAND_FUNCTION_CODE:
      jj_consume_token(COMMAND_FUNCTION_CODE);
      break;
    case CONDITION_NUMBER:
      jj_consume_token(CONDITION_NUMBER);
      break;
    case CONSTRAINT_CATALOG:
      jj_consume_token(CONSTRAINT_CATALOG);
      break;
    case CONSTRAINT_SCHEMA:
      jj_consume_token(CONSTRAINT_SCHEMA);
      break;
    case CURSOR_NAME:
      jj_consume_token(CURSOR_NAME);
      break;
    case DATETIME_INTERVAL_CODE:
      jj_consume_token(DATETIME_INTERVAL_CODE);
      break;
    case DECADE:
      jj_consume_token(DECADE);
      break;
    case DEFERRED:
      jj_consume_token(DEFERRED);
      break;
    case DEGREE:
      jj_consume_token(DEGREE);
      break;
    case DESC:
      jj_consume_token(DESC);
      break;
    case DIAGNOSTICS:
      jj_consume_token(DIAGNOSTICS);
      break;
    case DOW:
      jj_consume_token(DOW);
      break;
    case DYNAMIC_FUNCTION:
      jj_consume_token(DYNAMIC_FUNCTION);
      break;
    case EPOCH:
      jj_consume_token(EPOCH);
      break;
    case EXCLUDE:
      jj_consume_token(EXCLUDE);
      break;
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case FORTRAN:
      jj_consume_token(FORTRAN);
      break;
    case G:
      jj_consume_token(G);
      break;
    case GEOMETRY:
      jj_consume_token(GEOMETRY);
      break;
    case GRANTED:
      jj_consume_token(GRANTED);
      break;
    case HOP:
      jj_consume_token(HOP);
      break;
    case ILIKE:
      jj_consume_token(ILIKE);
      break;
    case IMPLEMENTATION:
      jj_consume_token(IMPLEMENTATION);
      break;
    case INCREMENT:
      jj_consume_token(INCREMENT);
      break;
    case INSTANCE:
      jj_consume_token(INSTANCE);
      break;
    case ISODOW:
      jj_consume_token(ISODOW);
      break;
    case JAVA:
      jj_consume_token(JAVA);
      break;
    case KEY:
      jj_consume_token(KEY);
      break;
    case LABEL:
      jj_consume_token(LABEL);
      break;
    case LEVEL:
      jj_consume_token(LEVEL);
      break;
    case M:
      jj_consume_token(M);
      break;
    case MAXVALUE:
      jj_consume_token(MAXVALUE);
      break;
    case MESSAGE_TEXT:
      jj_consume_token(MESSAGE_TEXT);
      break;
    case MILLISECOND:
      jj_consume_token(MILLISECOND);
      break;
    case MONTHS:
      jj_consume_token(MONTHS);
      break;
    case NAME:
      jj_consume_token(NAME);
      break;
    case NESTING:
      jj_consume_token(NESTING);
      break;
    case NULLS:
      jj_consume_token(NULLS);
      break;
    case OCTETS:
      jj_consume_token(OCTETS);
      break;
    case ORDERING:
      jj_consume_token(ORDERING);
      break;
    case OUTPUT:
      jj_consume_token(OUTPUT);
      break;
    case PARAMETER_MODE:
      jj_consume_token(PARAMETER_MODE);
      break;
    case PARAMETER_SPECIFIC_CATALOG:
      jj_consume_token(PARAMETER_SPECIFIC_CATALOG);
      break;
    case PARTIAL:
      jj_consume_token(PARTIAL);
      break;
    case PASSTHROUGH:
      jj_consume_token(PASSTHROUGH);
      break;
    case PIVOT:
      jj_consume_token(PIVOT);
      break;
    case PLI:
      jj_consume_token(PLI);
      break;
    case PRIOR:
      jj_consume_token(PRIOR);
      break;
    case QUARTER:
      jj_consume_token(QUARTER);
      break;
    case REPEATABLE:
      jj_consume_token(REPEATABLE);
      break;
    case RESTART:
      jj_consume_token(RESTART);
      break;
    case RETURNED_LENGTH:
      jj_consume_token(RETURNED_LENGTH);
      break;
    case RETURNING:
      jj_consume_token(RETURNING);
      break;
    case ROUTINE:
      jj_consume_token(ROUTINE);
      break;
    case ROUTINE_SCHEMA:
      jj_consume_token(ROUTINE_SCHEMA);
      break;
    case SCALE:
      jj_consume_token(SCALE);
      break;
    case SCOPE_CATALOGS:
      jj_consume_token(SCOPE_CATALOGS);
      break;
    case SECONDS:
      jj_consume_token(SECONDS);
      break;
    case SELF:
      jj_consume_token(SELF);
      break;
    case SERIALIZABLE:
      jj_consume_token(SERIALIZABLE);
      break;
    case SESSION:
      jj_consume_token(SESSION);
      break;
    case SIZE:
      jj_consume_token(SIZE);
      break;
    case SPECIFIC_NAME:
      jj_consume_token(SPECIFIC_NAME);
      break;
    case SQL_BIT:
      jj_consume_token(SQL_BIT);
      break;
    case SQL_CHAR:
      jj_consume_token(SQL_CHAR);
      break;
    case SQL_DECIMAL:
      jj_consume_token(SQL_DECIMAL);
      break;
    case SQL_INTEGER:
      jj_consume_token(SQL_INTEGER);
      break;
    case SQL_INTERVAL_DAY_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_DAY_TO_MINUTE);
      break;
    case SQL_INTERVAL_HOUR_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_MINUTE);
      break;
    case SQL_INTERVAL_MINUTE_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_MINUTE_TO_SECOND);
      break;
    case SQL_INTERVAL_YEAR:
      jj_consume_token(SQL_INTERVAL_YEAR);
      break;
    case SQL_LONGVARCHAR:
      jj_consume_token(SQL_LONGVARCHAR);
      break;
    case SQL_NCLOB:
      jj_consume_token(SQL_NCLOB);
      break;
    case SQL_REAL:
      jj_consume_token(SQL_REAL);
      break;
    case SQL_TIMESTAMP:
      jj_consume_token(SQL_TIMESTAMP);
      break;
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_VARBINARY:
      jj_consume_token(SQL_VARBINARY);
      break;
    case STATEMENT:
      jj_consume_token(STATEMENT);
      break;
    case STYLE:
      jj_consume_token(STYLE);
      break;
    case TABLE_NAME:
      jj_consume_token(TABLE_NAME);
      break;
    case TIMESTAMPADD:
      jj_consume_token(TIMESTAMPADD);
      break;
    case TRANSACTION:
      jj_consume_token(TRANSACTION);
      break;
    case TRANSACTIONS_ROLLED_BACK:
      jj_consume_token(TRANSACTIONS_ROLLED_BACK);
      break;
    case TRIGGER_CATALOG:
      jj_consume_token(TRIGGER_CATALOG);
      break;
    case TUMBLE:
      jj_consume_token(TUMBLE);
      break;
    case UNCOMMITTED:
      jj_consume_token(UNCOMMITTED);
      break;
    case UNPIVOT:
      jj_consume_token(UNPIVOT);
      break;
    case USER_DEFINED_TYPE_CATALOG:
      jj_consume_token(USER_DEFINED_TYPE_CATALOG);
      break;
    case USER_DEFINED_TYPE_SCHEMA:
      jj_consume_token(USER_DEFINED_TYPE_SCHEMA);
      break;
    case UTF8:
      jj_consume_token(UTF8);
      break;
    case WEEK:
      jj_consume_token(WEEK);
      break;
    case WRITE:
      jj_consume_token(WRITE);
      break;
    case ZONE:
      jj_consume_token(ZONE);
      break;
    default:
      jj_la1[387] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** @see #NonReservedKeyWord */
  final public void NonReservedKeyWord1of3() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
      jj_consume_token(ABSENT);
      break;
    case ADA:
      jj_consume_token(ADA);
      break;
    case AFTER:
      jj_consume_token(AFTER);
      break;
    case ARRAY_AGG:
      jj_consume_token(ARRAY_AGG);
      break;
    case ASSERTION:
      jj_consume_token(ASSERTION);
      break;
    case ATTRIBUTES:
      jj_consume_token(ATTRIBUTES);
      break;
    case BREADTH:
      jj_consume_token(BREADTH);
      break;
    case CATALOG:
      jj_consume_token(CATALOG);
      break;
    case CHAIN:
      jj_consume_token(CHAIN);
      break;
    case CHARACTER_SET_CATALOG:
      jj_consume_token(CHARACTER_SET_CATALOG);
      break;
    case CLASS_ORIGIN:
      jj_consume_token(CLASS_ORIGIN);
      break;
    case COLLATION_CATALOG:
      jj_consume_token(COLLATION_CATALOG);
      break;
    case COLUMN_NAME:
      jj_consume_token(COLUMN_NAME);
      break;
    case COMMITTED:
      jj_consume_token(COMMITTED);
      break;
    case CONNECTION:
      jj_consume_token(CONNECTION);
      break;
    case CONSTRAINT_NAME:
      jj_consume_token(CONSTRAINT_NAME);
      break;
    case CONSTRUCTOR:
      jj_consume_token(CONSTRUCTOR);
      break;
    case DATA:
      jj_consume_token(DATA);
      break;
    case DATETIME_INTERVAL_PRECISION:
      jj_consume_token(DATETIME_INTERVAL_PRECISION);
      break;
    case DEFAULTS:
      jj_consume_token(DEFAULTS);
      break;
    case DEFINED:
      jj_consume_token(DEFINED);
      break;
    case DEPTH:
      jj_consume_token(DEPTH);
      break;
    case DESCRIPTION:
      jj_consume_token(DESCRIPTION);
      break;
    case DISPATCH:
      jj_consume_token(DISPATCH);
      break;
    case DOY:
      jj_consume_token(DOY);
      break;
    case DYNAMIC_FUNCTION_CODE:
      jj_consume_token(DYNAMIC_FUNCTION_CODE);
      break;
    case ERROR:
      jj_consume_token(ERROR);
      break;
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      break;
    case FOLLOWING:
      jj_consume_token(FOLLOWING);
      break;
    case FOUND:
      jj_consume_token(FOUND);
      break;
    case GENERAL:
      jj_consume_token(GENERAL);
      break;
    case GO:
      jj_consume_token(GO);
      break;
    case GROUP_CONCAT:
      jj_consume_token(GROUP_CONCAT);
      break;
    case HOURS:
      jj_consume_token(HOURS);
      break;
    case IMMEDIATE:
      jj_consume_token(IMMEDIATE);
      break;
    case INCLUDE:
      jj_consume_token(INCLUDE);
      break;
    case INITIALLY:
      jj_consume_token(INITIALLY);
      break;
    case INSTANTIABLE:
      jj_consume_token(INSTANTIABLE);
      break;
    case ISOLATION:
      jj_consume_token(ISOLATION);
      break;
    case JSON:
      jj_consume_token(JSON);
      break;
    case KEY_MEMBER:
      jj_consume_token(KEY_MEMBER);
      break;
    case LAST:
      jj_consume_token(LAST);
      break;
    case LIBRARY:
      jj_consume_token(LIBRARY);
      break;
    case MAP:
      jj_consume_token(MAP);
      break;
    case MESSAGE_LENGTH:
      jj_consume_token(MESSAGE_LENGTH);
      break;
    case MICROSECOND:
      jj_consume_token(MICROSECOND);
      break;
    case MINUTES:
      jj_consume_token(MINUTES);
      break;
    case MORE_:
      jj_consume_token(MORE_);
      break;
    case NAMES:
      jj_consume_token(NAMES);
      break;
    case NORMALIZED:
      jj_consume_token(NORMALIZED);
      break;
    case NUMBER:
      jj_consume_token(NUMBER);
      break;
    case OPTION:
      jj_consume_token(OPTION);
      break;
    case ORDINALITY:
      jj_consume_token(ORDINALITY);
      break;
    case OVERRIDING:
      jj_consume_token(OVERRIDING);
      break;
    case PARAMETER_NAME:
      jj_consume_token(PARAMETER_NAME);
      break;
    case PARAMETER_SPECIFIC_NAME:
      jj_consume_token(PARAMETER_SPECIFIC_NAME);
      break;
    case PASCAL:
      jj_consume_token(PASCAL);
      break;
    case PAST:
      jj_consume_token(PAST);
      break;
    case PLACING:
      jj_consume_token(PLACING);
      break;
    case PRECEDING:
      jj_consume_token(PRECEDING);
      break;
    case PRIVILEGES:
      jj_consume_token(PRIVILEGES);
      break;
    case READ:
      jj_consume_token(READ);
      break;
    case REPLACE:
      jj_consume_token(REPLACE);
      break;
    case RESTRICT:
      jj_consume_token(RESTRICT);
      break;
    case RETURNED_OCTET_LENGTH:
      jj_consume_token(RETURNED_OCTET_LENGTH);
      break;
    case RLIKE:
      jj_consume_token(RLIKE);
      break;
    case ROUTINE_CATALOG:
      jj_consume_token(ROUTINE_CATALOG);
      break;
    case ROW_COUNT:
      jj_consume_token(ROW_COUNT);
      break;
    case SCHEMA:
      jj_consume_token(SCHEMA);
      break;
    case SCOPE_NAME:
      jj_consume_token(SCOPE_NAME);
      break;
    case SECTION:
      jj_consume_token(SECTION);
      break;
    case SEPARATOR:
      jj_consume_token(SEPARATOR);
      break;
    case SERVER:
      jj_consume_token(SERVER);
      break;
    case SETS:
      jj_consume_token(SETS);
      break;
    case SOURCE:
      jj_consume_token(SOURCE);
      break;
    case SQL_BIGINT:
      jj_consume_token(SQL_BIGINT);
      break;
    case SQL_BLOB:
      jj_consume_token(SQL_BLOB);
      break;
    case SQL_CLOB:
      jj_consume_token(SQL_CLOB);
      break;
    case SQL_DOUBLE:
      jj_consume_token(SQL_DOUBLE);
      break;
    case SQL_INTERVAL_DAY:
      jj_consume_token(SQL_INTERVAL_DAY);
      break;
    case SQL_INTERVAL_DAY_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_DAY_TO_SECOND);
      break;
    case SQL_INTERVAL_HOUR_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_SECOND);
      break;
    case SQL_INTERVAL_MONTH:
      jj_consume_token(SQL_INTERVAL_MONTH);
      break;
    case SQL_INTERVAL_YEAR_TO_MONTH:
      jj_consume_token(SQL_INTERVAL_YEAR_TO_MONTH);
      break;
    case SQL_LONGVARNCHAR:
      jj_consume_token(SQL_LONGVARNCHAR);
      break;
    case SQL_NUMERIC:
      jj_consume_token(SQL_NUMERIC);
      break;
    case SQL_SMALLINT:
      jj_consume_token(SQL_SMALLINT);
      break;
    case SQL_TINYINT:
      jj_consume_token(SQL_TINYINT);
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_VARCHAR:
      jj_consume_token(SQL_VARCHAR);
      break;
    case STRING_AGG:
      jj_consume_token(STRING_AGG);
      break;
    case SUBCLASS_ORIGIN:
      jj_consume_token(SUBCLASS_ORIGIN);
      break;
    case TEMPORARY:
      jj_consume_token(TEMPORARY);
      break;
    case TIMESTAMPDIFF:
      jj_consume_token(TIMESTAMPDIFF);
      break;
    case TRANSACTIONS_ACTIVE:
      jj_consume_token(TRANSACTIONS_ACTIVE);
      break;
    case TRANSFORM:
      jj_consume_token(TRANSFORM);
      break;
    case TRIGGER_NAME:
      jj_consume_token(TRIGGER_NAME);
      break;
    case TYPE:
      jj_consume_token(TYPE);
      break;
    case UNCONDITIONAL:
      jj_consume_token(UNCONDITIONAL);
      break;
    case UNNAMED:
      jj_consume_token(UNNAMED);
      break;
    case USER_DEFINED_TYPE_CODE:
      jj_consume_token(USER_DEFINED_TYPE_CODE);
      break;
    case UTF16:
      jj_consume_token(UTF16);
      break;
    case VERSION:
      jj_consume_token(VERSION);
      break;
    case WORK:
      jj_consume_token(WORK);
      break;
    case XML:
      jj_consume_token(XML);
      break;
    default:
      jj_la1[388] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** @see #NonReservedKeyWord */
  final public void NonReservedKeyWord2of3() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSOLUTE:
      jj_consume_token(ABSOLUTE);
      break;
    case ADD:
      jj_consume_token(ADD);
      break;
    case ALWAYS:
      jj_consume_token(ALWAYS);
      break;
    case ARRAY_CONCAT_AGG:
      jj_consume_token(ARRAY_CONCAT_AGG);
      break;
    case ASSIGNMENT:
      jj_consume_token(ASSIGNMENT);
      break;
    case BEFORE:
      jj_consume_token(BEFORE);
      break;
    case C:
      jj_consume_token(C);
      break;
    case CATALOG_NAME:
      jj_consume_token(CATALOG_NAME);
      break;
    case CHARACTERISTICS:
      jj_consume_token(CHARACTERISTICS);
      break;
    case CHARACTER_SET_NAME:
      jj_consume_token(CHARACTER_SET_NAME);
      break;
    case COBOL:
      jj_consume_token(COBOL);
      break;
    case COLLATION_NAME:
      jj_consume_token(COLLATION_NAME);
      break;
    case COMMAND_FUNCTION:
      jj_consume_token(COMMAND_FUNCTION);
      break;
    case CONDITIONAL:
      jj_consume_token(CONDITIONAL);
      break;
    case CONNECTION_NAME:
      jj_consume_token(CONNECTION_NAME);
      break;
    case CONSTRAINTS:
      jj_consume_token(CONSTRAINTS);
      break;
    case CONTINUE:
      jj_consume_token(CONTINUE);
      break;
    case DATABASE:
      jj_consume_token(DATABASE);
      break;
    case DAYS:
      jj_consume_token(DAYS);
      break;
    case DEFERRABLE:
      jj_consume_token(DEFERRABLE);
      break;
    case DEFINER:
      jj_consume_token(DEFINER);
      break;
    case DERIVED:
      jj_consume_token(DERIVED);
      break;
    case DESCRIPTOR:
      jj_consume_token(DESCRIPTOR);
      break;
    case DOMAIN:
      jj_consume_token(DOMAIN);
      break;
    case DOT_FORMAT:
      jj_consume_token(DOT_FORMAT);
      break;
    case ENCODING:
      jj_consume_token(ENCODING);
      break;
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
      break;
    case FINAL:
      jj_consume_token(FINAL);
      break;
    case FORMAT:
      jj_consume_token(FORMAT);
      break;
    case FRAC_SECOND:
      jj_consume_token(FRAC_SECOND);
      break;
    case GENERATED:
      jj_consume_token(GENERATED);
      break;
    case GOTO:
      jj_consume_token(GOTO);
      break;
    case HIERARCHY:
      jj_consume_token(HIERARCHY);
      break;
    case IGNORE:
      jj_consume_token(IGNORE);
      break;
    case IMMEDIATELY:
      jj_consume_token(IMMEDIATELY);
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      break;
    case INPUT:
      jj_consume_token(INPUT);
      break;
    case INVOKER:
      jj_consume_token(INVOKER);
      break;
    case ISOYEAR:
      jj_consume_token(ISOYEAR);
      break;
    case K:
      jj_consume_token(K);
      break;
    case KEY_TYPE:
      jj_consume_token(KEY_TYPE);
      break;
    case LENGTH:
      jj_consume_token(LENGTH);
      break;
    case LOCATOR:
      jj_consume_token(LOCATOR);
      break;
    case MATCHED:
      jj_consume_token(MATCHED);
      break;
    case MESSAGE_OCTET_LENGTH:
      jj_consume_token(MESSAGE_OCTET_LENGTH);
      break;
    case MILLENNIUM:
      jj_consume_token(MILLENNIUM);
      break;
    case MINVALUE:
      jj_consume_token(MINVALUE);
      break;
    case MUMPS:
      jj_consume_token(MUMPS);
      break;
    case NANOSECOND:
      jj_consume_token(NANOSECOND);
      break;
    case NULLABLE:
      jj_consume_token(NULLABLE);
      break;
    case OBJECT:
      jj_consume_token(OBJECT);
      break;
    case OPTIONS:
      jj_consume_token(OPTIONS);
      break;
    case OTHERS:
      jj_consume_token(OTHERS);
      break;
    case PAD:
      jj_consume_token(PAD);
      break;
    case PARAMETER_ORDINAL_POSITION:
      jj_consume_token(PARAMETER_ORDINAL_POSITION);
      break;
    case PARAMETER_SPECIFIC_SCHEMA:
      jj_consume_token(PARAMETER_SPECIFIC_SCHEMA);
      break;
    case PASSING:
      jj_consume_token(PASSING);
      break;
    case PATH:
      jj_consume_token(PATH);
      break;
    case PLAN:
      jj_consume_token(PLAN);
      break;
    case PRESERVE:
      jj_consume_token(PRESERVE);
      break;
    case PUBLIC:
      jj_consume_token(PUBLIC);
      break;
    case RELATIVE:
      jj_consume_token(RELATIVE);
      break;
    case RESPECT:
      jj_consume_token(RESPECT);
      break;
    case RETURNED_CARDINALITY:
      jj_consume_token(RETURNED_CARDINALITY);
      break;
    case RETURNED_SQLSTATE:
      jj_consume_token(RETURNED_SQLSTATE);
      break;
    case ROLE:
      jj_consume_token(ROLE);
      break;
    case ROUTINE_NAME:
      jj_consume_token(ROUTINE_NAME);
      break;
    case SCALAR:
      jj_consume_token(SCALAR);
      break;
    case SCHEMA_NAME:
      jj_consume_token(SCHEMA_NAME);
      break;
    case SCOPE_SCHEMA:
      jj_consume_token(SCOPE_SCHEMA);
      break;
    case SECURITY:
      jj_consume_token(SECURITY);
      break;
    case SEQUENCE:
      jj_consume_token(SEQUENCE);
      break;
    case SERVER_NAME:
      jj_consume_token(SERVER_NAME);
      break;
    case SIMPLE:
      jj_consume_token(SIMPLE);
      break;
    case SPACE:
      jj_consume_token(SPACE);
      break;
    case SQL_BINARY:
      jj_consume_token(SQL_BINARY);
      break;
    case SQL_BOOLEAN:
      jj_consume_token(SQL_BOOLEAN);
      break;
    case SQL_DATE:
      jj_consume_token(SQL_DATE);
      break;
    case SQL_FLOAT:
      jj_consume_token(SQL_FLOAT);
      break;
    case SQL_INTERVAL_DAY_TO_HOUR:
      jj_consume_token(SQL_INTERVAL_DAY_TO_HOUR);
      break;
    case SQL_INTERVAL_HOUR:
      jj_consume_token(SQL_INTERVAL_HOUR);
      break;
    case SQL_INTERVAL_MINUTE:
      jj_consume_token(SQL_INTERVAL_MINUTE);
      break;
    case SQL_INTERVAL_SECOND:
      jj_consume_token(SQL_INTERVAL_SECOND);
      break;
    case SQL_LONGVARBINARY:
      jj_consume_token(SQL_LONGVARBINARY);
      break;
    case SQL_NCHAR:
      jj_consume_token(SQL_NCHAR);
      break;
    case SQL_NVARCHAR:
      jj_consume_token(SQL_NVARCHAR);
      break;
    case SQL_TIME:
      jj_consume_token(SQL_TIME);
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_MICROSECOND:
      jj_consume_token(SQL_TSI_MICROSECOND);
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
      break;
    case STATE:
      jj_consume_token(STATE);
      break;
    case STRUCTURE:
      jj_consume_token(STRUCTURE);
      break;
    case SUBSTITUTE:
      jj_consume_token(SUBSTITUTE);
      break;
    case TIES:
      jj_consume_token(TIES);
      break;
    case TOP_LEVEL_COUNT:
      jj_consume_token(TOP_LEVEL_COUNT);
      break;
    case TRANSACTIONS_COMMITTED:
      jj_consume_token(TRANSACTIONS_COMMITTED);
      break;
    case TRANSFORMS:
      jj_consume_token(TRANSFORMS);
      break;
    case TRIGGER_SCHEMA:
      jj_consume_token(TRIGGER_SCHEMA);
      break;
    case UNBOUNDED:
      jj_consume_token(UNBOUNDED);
      break;
    case UNDER:
      jj_consume_token(UNDER);
      break;
    case USAGE:
      jj_consume_token(USAGE);
      break;
    case USER_DEFINED_TYPE_NAME:
      jj_consume_token(USER_DEFINED_TYPE_NAME);
      break;
    case UTF32:
      jj_consume_token(UTF32);
      break;
    case VIEW:
      jj_consume_token(VIEW);
      break;
    case WRAPPER:
      jj_consume_token(WRAPPER);
      break;
    case YEARS:
      jj_consume_token(YEARS);
      break;
    default:
      jj_la1[389] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Defines a production which can never be accepted by the parser.
 * In effect, it tells the parser, "If you got here, you've gone too far."
 * It is used as the default production for parser extension points;
 * derived parsers replace it with a real production when they want to
 * implement a particular extension point.
 */
  final public void UnusedExtension() throws ParseException {
    if (false) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ZONE);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  final private boolean jj_3R_525() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_524() {
    if (jj_3R_293()) return true;
    return false;
  }

  final private boolean jj_3R_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(658)) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    return false;
  }

  final private boolean jj_3R_523() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_509() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_523()) {
    jj_scanpos = xsp;
    if (jj_3R_524()) {
    jj_scanpos = xsp;
    if (jj_3R_525()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_508() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_522() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_521() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_507() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_521()) {
    jj_scanpos = xsp;
    if (jj_3R_522()) return true;
    }
    return false;
  }

  final private boolean jj_3R_422() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_481() {
    if (jj_scan_token(INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_507()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_508()) {
    jj_scanpos = xsp;
    if (jj_3R_509()) return true;
    }
    return false;
  }

  final private boolean jj_3R_341() {
    if (jj_scan_token(JSON_QUERY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_scan_token(LAST)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(CONDITIONAL)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(598)) {
    jj_scanpos = xsp;
    if (jj_scan_token(751)) {
    jj_scanpos = xsp;
    if (jj_scan_token(750)) {
    jj_scanpos = xsp;
    if (jj_scan_token(748)) {
    jj_scanpos = xsp;
    if (jj_scan_token(749)) {
    jj_scanpos = xsp;
    if (jj_scan_token(747)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_330() {
    if (jj_scan_token(PERIOD)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_348() {
    return false;
  }

  final private boolean jj_3R_347() {
    if (jj_3R_434()) return true;
    return false;
  }

  final private boolean jj_3R_248() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) return true;
    }
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_scan_token(FIRST)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_scan_token(EMPTY)) return true;
    if (jj_scan_token(ARRAY)) return true;
    return false;
  }

  final private boolean jj_3_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(484)) return true;
    }
    }
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_scan_token(NEXT)) return true;
    if (jj_scan_token(ROW)) return true;
    return false;
  }

  final private boolean jj_3R_247() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_109()) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_scan_token(MAP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) return true;
    }
    return false;
  }

  final private boolean jj_3R_420() {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_340() {
    if (jj_scan_token(JSON_VALUE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_419() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_scan_token(MATCH_RECOGNIZE)) return true;
    return false;
  }

  final private boolean jj_3R_329() {
    if (jj_scan_token(ARRAY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_419()) {
    jj_scanpos = xsp;
    if (jj_3R_420()) return true;
    }
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_418() {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_109()) return true;
    return false;
  }

  final private boolean jj_3R_328() {
    if (jj_scan_token(MULTISET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3R_418()) return true;
    }
    return false;
  }

  final private boolean jj_3R_339() {
    if (jj_scan_token(JSON_EXISTS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_537() {
    if (jj_scan_token(TIMESTAMP)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    return false;
  }

  final private boolean jj_3R_536() {
    if (jj_scan_token(TIME)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_scan_token(EXCLUDE)) return true;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_scan_token(INCLUDE)) return true;
    return false;
  }

  final private boolean jj_3R_535() {
    if (jj_scan_token(DATE)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(UNPIVOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_scan_token(AS)) return true;
    if (jj_scan_token(JSON)) return true;
    return false;
  }

  final private boolean jj_3R_534() {
    if (jj_scan_token(LBRACE_TS)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_scan_token(AS)) return true;
    if (jj_scan_token(XML)) return true;
    return false;
  }

  final private boolean jj_3R_533() {
    if (jj_scan_token(LBRACE_T)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_532() {
    if (jj_scan_token(LBRACE_D)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_527() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_532()) {
    jj_scanpos = xsp;
    if (jj_3R_533()) {
    jj_scanpos = xsp;
    if (jj_3R_534()) {
    jj_scanpos = xsp;
    if (jj_3R_535()) {
    jj_scanpos = xsp;
    if (jj_3R_536()) {
    jj_scanpos = xsp;
    if (jj_3R_537()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_392() {
    if (jj_scan_token(BIG_QUERY_QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_391() {
    if (jj_scan_token(BIG_QUERY_DOUBLE_QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(PIVOT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_464() {
    if (jj_scan_token(UESCAPE)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_491() {
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  final private boolean jj_3R_128() {
    if (jj_scan_token(UTF32)) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_scan_token(UTF16)) return true;
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_scan_token(UTF8)) return true;
    return false;
  }

  final private boolean jj_3R_463() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_scan_token(ENCODING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_408() {
    if (jj_scan_token(JSON)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(HINT_BEG)) return true;
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3R_246() {
    if (jj_3R_346()) return true;
    return false;
  }

  final private boolean jj_3R_245() {
    if (jj_3R_345()) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_scan_token(NULLS)) return true;
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  final private boolean jj_3R_244() {
    if (jj_3R_344()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_243() {
    if (jj_3R_343()) return true;
    return false;
  }

  final private boolean jj_3R_462() {
    if (jj_scan_token(UNICODE_STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_242() {
    if (jj_3R_342()) return true;
    return false;
  }

  final private boolean jj_3R_461() {
    if (jj_scan_token(PREFIXED_STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_241() {
    if (jj_3R_341()) return true;
    return false;
  }

  final private boolean jj_3R_240() {
    if (jj_3R_340()) return true;
    return false;
  }

  final private boolean jj_3R_239() {
    if (jj_3R_339()) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_390() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_461()) {
    jj_scanpos = xsp;
    if (jj_scan_token(692)) {
    jj_scanpos = xsp;
    if (jj_3R_462()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_463()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_464()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_238() {
    if (jj_3R_338()) return true;
    return false;
  }

  final private boolean jj_3R_237() {
    if (jj_3R_137()) return true;
    return false;
  }

  final private boolean jj_3R_236() {
    if (jj_3R_337()) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_460() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_277() {
    if (jj_scan_token(LEADING)) return true;
    return false;
  }

  final private boolean jj_3R_297() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) {
    jj_scanpos = xsp;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_389() {
    if (jj_scan_token(BINARY_STRING_LITERAL)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_460()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_276() {
    if (jj_scan_token(TRAILING)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_122() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_275() {
    if (jj_scan_token(BOTH)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(FOLLOWING)) return true;
    return false;
  }

  final private boolean jj_3_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(PRECEDING)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    }
    return false;
  }

  final private boolean jj_3R_235() {
    if (jj_scan_token(TRIM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(CURRENT)) return true;
    if (jj_scan_token(ROW)) return true;
    return false;
  }

  final private boolean jj_3R_531() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3R_530() {
    if (jj_scan_token(UNKNOWN)) return true;
    return false;
  }

  final private boolean jj_3R_529() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_528() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_526() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) {
    jj_scanpos = xsp;
    if (jj_3R_529()) {
    jj_scanpos = xsp;
    if (jj_3R_530()) {
    jj_scanpos = xsp;
    if (jj_3R_531()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_234() {
    if (jj_scan_token(SUBSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_143()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_144()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_467() {
    if (jj_3R_293()) return true;
    return false;
  }

  final private boolean jj_3R_233() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) return true;
    }
    if (jj_3R_336()) return true;
    return false;
  }

  final private boolean jj_3R_466() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_293()) return true;
    return false;
  }

  final private boolean jj_3R_232() {
    if (jj_scan_token(FLOOR)) return true;
    if (jj_3R_336()) return true;
    return false;
  }

  final private boolean jj_3R_393() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_465()) {
    jj_scanpos = xsp;
    if (jj_3R_466()) {
    jj_scanpos = xsp;
    if (jj_3R_467()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_465() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_293()) return true;
    return false;
  }

  final private boolean jj_3R_300() {
    if (jj_3R_297()) return true;
    return false;
  }

  final private boolean jj_3R_299() {
    if (jj_3R_393()) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) return true;
    }
    return false;
  }

  final private boolean jj_3R_387() {
    if (jj_scan_token(APPROX_NUMERIC_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_386() {
    if (jj_scan_token(DECIMAL_NUMERIC_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_231() {
    if (jj_scan_token(OVERLAY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_293() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_385()) {
    jj_scanpos = xsp;
    if (jj_3R_386()) {
    jj_scanpos = xsp;
    if (jj_3R_387()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_385() {
    if (jj_scan_token(UNSIGNED_INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_296() {
    if (jj_3R_297()) return true;
    return false;
  }

  final private boolean jj_3R_414() {
    if (jj_3R_482()) return true;
    return false;
  }

  final private boolean jj_3R_295() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3R_413() {
    if (jj_3R_481()) return true;
    return false;
  }

  final private boolean jj_3R_140() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) return true;
    }
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_297()) return true;
    return false;
  }

  final private boolean jj_3R_326() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_413()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) return true;
    }
    return false;
  }

  final private boolean jj_3R_230() {
    if (jj_scan_token(TRANSLATE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_513() {
    if (jj_3R_527()) return true;
    return false;
  }

  final private boolean jj_3R_512() {
    if (jj_3R_526()) return true;
    return false;
  }

  final private boolean jj_3R_511() {
    if (jj_3R_297()) return true;
    return false;
  }

  final private boolean jj_3R_510() {
    if (jj_3R_393()) return true;
    return false;
  }

  final private boolean jj_3R_229() {
    if (jj_scan_token(CONVERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_140()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_141()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3R_482() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_510()) {
    jj_scanpos = xsp;
    if (jj_3R_511()) {
    jj_scanpos = xsp;
    if (jj_3R_512()) {
    jj_scanpos = xsp;
    if (jj_3R_513()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_228() {
    if (jj_scan_token(POSITION)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_227() {
    if (jj_scan_token(EXTRACT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_226() {
    if (jj_scan_token(CAST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_490() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_434() {
    if (jj_3R_490()) return true;
    return false;
  }

  final private boolean jj_3R_309() {
    if (jj_scan_token(CURSOR)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_scan_token(CUBE)) return true;
    return false;
  }

  final private boolean jj_3R_274() {
    return false;
  }

  final private boolean jj_3R_273() {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(LOCAL)) return true;
    return false;
  }

  final private boolean jj_3R_480() {
    if (jj_scan_token(JSON)) return true;
    return false;
  }

  final private boolean jj_3R_167() {
    if (jj_scan_token(ROLLUP)) return true;
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(SCALAR)) return true;
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(ARRAY)) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_scan_token(WITHOUT)) return true;
    if (jj_scan_token(TIME)) return true;
    if (jj_scan_token(ZONE)) return true;
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(OBJECT)) return true;
    return false;
  }

  final private boolean jj_3_99() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(VALUE)) return true;
    return false;
  }

  final private boolean jj_3R_322() {
    if (jj_scan_token(FORMAT)) return true;
    if (jj_3R_408()) return true;
    return false;
  }

  final private boolean jj_3R_479() {
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(GROUPING)) return true;
    if (jj_scan_token(SETS)) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_478() {
    if (jj_scan_token(UNKNOWN)) return true;
    return false;
  }

  final private boolean jj_3R_477() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_476() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_308() {
    if (jj_scan_token(DEFAULT_)) return true;
    return false;
  }

  final private boolean jj_3R_475() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3_98() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(SCALAR)) return true;
    return false;
  }

  final private boolean jj_3R_407() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_475()) {
    jj_scanpos = xsp;
    if (jj_3R_476()) {
    jj_scanpos = xsp;
    if (jj_3R_477()) {
    jj_scanpos = xsp;
    if (jj_3R_478()) {
    jj_scanpos = xsp;
    if (jj_3R_479()) {
    jj_scanpos = xsp;
    if (jj_3_99()) {
    jj_scanpos = xsp;
    if (jj_3_100()) {
    jj_scanpos = xsp;
    if (jj_3_101()) {
    jj_scanpos = xsp;
    if (jj_3_102()) {
    jj_scanpos = xsp;
    if (jj_3R_480()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(ARRAY)) return true;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(OBJECT)) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_scan_token(JSON)) return true;
    if (jj_scan_token(VALUE)) return true;
    return false;
  }

  final private boolean jj_3R_272() {
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3R_120() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) return true;
    }
    return false;
  }

  final private boolean jj_3R_271() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_538()) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_52()) return true;
    if (jj_scan_token(NAMED_ARGUMENT_ASSIGNMENT)) return true;
    return false;
  }

  final private boolean jj_3R_425() {
    if (jj_scan_token(NEXT)) return true;
    return false;
  }

  final private boolean jj_3R_406() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_335() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_425()) {
    jj_scanpos = xsp;
    if (jj_3_63()) return true;
    }
    if (jj_scan_token(VALUE)) return true;
    return false;
  }

  final private boolean jj_3R_405() {
    if (jj_scan_token(A)) return true;
    return false;
  }

  final private boolean jj_3R_207() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) return true;
    }
    return false;
  }

  final private boolean jj_3R_321() {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_459() {
    if (jj_scan_token(TIMESTAMP)) return true;
    if (jj_3R_120()) return true;
    if (jj_3R_121()) return true;
    return false;
  }

  final private boolean jj_3R_401() {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  final private boolean jj_3R_400() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_399() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_319() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_398()) {
    jj_scanpos = xsp;
    if (jj_3R_399()) {
    jj_scanpos = xsp;
    if (jj_3R_400()) {
    jj_scanpos = xsp;
    if (jj_3R_401()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_398() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_52()) return true;
    if (jj_scan_token(NAMED_ARGUMENT_ASSIGNMENT)) return true;
    return false;
  }

  final private boolean jj_3R_424() {
    if (jj_scan_token(WHEN)) return true;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_scan_token(TIME)) return true;
    if (jj_3R_120()) return true;
    if (jj_3R_121()) return true;
    return false;
  }

  final private boolean jj_3R_206() {
    if (jj_3R_320()) return true;
    return false;
  }

  final private boolean jj_3R_423() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_205() {
    if (jj_scan_token(IMMEDIATELY)) return true;
    if (jj_scan_token(SUCCEEDS)) return true;
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_scan_token(IMMEDIATELY)) return true;
    if (jj_scan_token(PRECEDES)) return true;
    return false;
  }

  final private boolean jj_3R_360() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_458()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3R_459()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_458() {
    if (jj_scan_token(DATE)) return true;
    return false;
  }

  final private boolean jj_3R_204() {
    if (jj_scan_token(SUCCEEDS)) return true;
    return false;
  }

  final private boolean jj_3R_203() {
    if (jj_scan_token(PRECEDES)) return true;
    return false;
  }

  final private boolean jj_3R_202() {
    if (jj_scan_token(EQUALS)) return true;
    return false;
  }

  final private boolean jj_3R_201() {
    if (jj_scan_token(OVERLAPS)) return true;
    return false;
  }

  final private boolean jj_3R_334() {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) jj_scanpos = xsp;
    if (jj_3R_424()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_424()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_200() {
    if (jj_scan_token(CONTAINS)) return true;
    return false;
  }

  final private boolean jj_3R_199() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(SUBMULTISET)) return true;
    if (jj_scan_token(OF)) return true;
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_scan_token(SUBMULTISET)) return true;
    if (jj_scan_token(OF)) return true;
    return false;
  }

  final private boolean jj_3R_198() {
    if (jj_scan_token(MEMBER)) return true;
    if (jj_scan_token(OF)) return true;
    return false;
  }

  final private boolean jj_3R_197() {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3_92() {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(DISTINCT)) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  final private boolean jj_3R_196() {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  final private boolean jj_3R_195() {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  final private boolean jj_3R_194() {
    if (jj_scan_token(CONCAT)) return true;
    return false;
  }

  final private boolean jj_3R_457() {
    if (jj_scan_token(CHARACTER)) return true;
    if (jj_scan_token(SET)) return true;
    return false;
  }

  final private boolean jj_3R_225() {
    if (jj_3R_335()) return true;
    return false;
  }

  final private boolean jj_3_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(519)) jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_500() {
    return false;
  }

  final private boolean jj_3R_193() {
    if (jj_scan_token(PERCENT_REMAINDER)) return true;
    return false;
  }

  final private boolean jj_3R_224() {
    if (jj_3R_334()) return true;
    return false;
  }

  final private boolean jj_3R_456() {
    if (jj_scan_token(VARCHAR)) return true;
    return false;
  }

  final private boolean jj_3R_192() {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  final private boolean jj_3R_499() {
    if (jj_scan_token(VARYING)) return true;
    return false;
  }

  final private boolean jj_3R_191() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  final private boolean jj_3R_223() {
    if (jj_3R_333()) return true;
    return false;
  }

  final private boolean jj_3R_190() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_189() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    return false;
  }

  final private boolean jj_3R_222() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(ROW)) return true;
    return false;
  }

  final private boolean jj_3R_221() {
    if (jj_3R_332()) return true;
    return false;
  }

  final private boolean jj_3R_455() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_499()) {
    jj_scanpos = xsp;
    if (jj_3R_500()) return true;
    }
    return false;
  }

  final private boolean jj_3R_220() {
    if (jj_3R_331()) return true;
    return false;
  }

  final private boolean jj_3R_188() {
    if (jj_scan_token(NE2)) return true;
    return false;
  }

  final private boolean jj_3R_187() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  final private boolean jj_3R_186() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  final private boolean jj_3_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_359() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_455()) {
    jj_scanpos = xsp;
    if (jj_3R_456()) return true;
    }
    if (jj_3R_120()) return true;
    xsp = jj_scanpos;
    if (jj_3R_457()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_185() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  final private boolean jj_3R_184() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  final private boolean jj_3R_219() {
    if (jj_3R_330()) return true;
    return false;
  }

  final private boolean jj_3R_183() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3_93()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3_94()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_307() {
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_3R_107()) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(ROW)) return true;
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_218() {
    if (jj_3R_329()) return true;
    return false;
  }

  final private boolean jj_3R_217() {
    if (jj_3R_328()) return true;
    return false;
  }

  final private boolean jj_3R_506() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3R_216() {
    if (jj_3R_327()) return true;
    return false;
  }

  final private boolean jj_3R_474() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_506()) return true;
    }
    return false;
  }

  final private boolean jj_3R_489() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_3R_106()) return true;
    return false;
  }

  final private boolean jj_3R_215() {
    if (jj_3R_294()) return true;
    return false;
  }

  final private boolean jj_3R_501() {
    if (jj_scan_token(ROW)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_520()) return true;
    return false;
  }

  final private boolean jj_3R_404() {
    if (jj_scan_token(EXCEPT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_474()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_505() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3R_214() {
    if (jj_3R_326()) return true;
    return false;
  }

  final private boolean jj_3R_473() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_505()) return true;
    }
    return false;
  }

  final private boolean jj_3R_160() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = false;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_307()) return true;
    if (jj_scan_token(ZONE)) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) {
    jj_scanpos = xsp;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_403() {
    if (jj_scan_token(INTERSECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_504() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3R_472() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_504()) return true;
    }
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3R_402() {
    if (jj_scan_token(UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_472()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_433() {
    if (jj_3R_489()) return true;
    return false;
  }

  final private boolean jj_3R_320() {
    if (jj_scan_token(MULTISET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_402()) {
    jj_scanpos = xsp;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_520() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3R_492() {
    if (jj_scan_token(VALUES)) return true;
    return false;
  }

  final private boolean jj_3R_493() {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_3R_308()) return true;
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_3R_159()) return true;
    return false;
  }

  final private boolean jj_3R_290() {
    if (jj_scan_token(STRING_AGG)) return true;
    return false;
  }

  final private boolean jj_3R_289() {
    if (jj_scan_token(GROUP_CONCAT)) return true;
    return false;
  }

  final private boolean jj_3R_288() {
    if (jj_scan_token(ARRAY_CONCAT_AGG)) return true;
    return false;
  }

  final private boolean jj_3R_287() {
    if (jj_scan_token(ARRAY_AGG)) return true;
    return false;
  }

  final private boolean jj_3R_134() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_503() {
    if (jj_scan_token(ARRAY)) return true;
    return false;
  }

  final private boolean jj_3R_502() {
    if (jj_scan_token(MULTISET)) return true;
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  final private boolean jj_3R_486() {
    if (jj_3R_515()) return true;
    return false;
  }

  final private boolean jj_3R_470() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_502()) {
    jj_scanpos = xsp;
    if (jj_3R_503()) return true;
    }
    return false;
  }

  final private boolean jj_3R_485() {
    if (jj_3R_514()) return true;
    return false;
  }

  final private boolean jj_3R_484() {
    if (jj_3R_349()) return true;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_483() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(467)) {
    jj_scanpos = xsp;
    if (jj_scan_token(631)) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  final private boolean jj_3R_417() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_483()) {
    jj_scanpos = xsp;
    if (jj_3R_484()) {
    jj_scanpos = xsp;
    if (jj_3R_485()) {
    jj_scanpos = xsp;
    if (jj_3R_486()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_416() {
    if (jj_scan_token(CONVERT)) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3R_303() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_3R_137()) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_159()) return true;
    return false;
  }

  final private boolean jj_3R_415() {
    if (jj_3R_337()) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_3R_294()) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_3R_293()) return true;
    return false;
  }

  final private boolean jj_3R_327() {
    if (jj_scan_token(LBRACE_FN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_415()) {
    jj_scanpos = xsp;
    if (jj_3_91()) {
    jj_scanpos = xsp;
    if (jj_3R_416()) {
    jj_scanpos = xsp;
    if (jj_3R_417()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_302() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) return true;
    }
    return false;
  }

  final private boolean jj_3R_145() {
    if (jj_3R_57()) return true;
    if (jj_3R_301()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_146() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_145()) return true;
    return false;
  }

  final private boolean jj_3R_454() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_538()) return true;
    return false;
  }

  final private boolean jj_3R_453() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_145()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_146()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_452() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(362)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_358() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_452()) {
    jj_scanpos = xsp;
    if (jj_3R_453()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_454()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_332() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(506)) {
    jj_scanpos = xsp;
    if (jj_scan_token(597)) {
    jj_scanpos = xsp;
    if (jj_scan_token(649)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_scan_token(IMMEDIATELY)) return true;
    if (jj_scan_token(PRECEDES)) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_159()) return true;
    return false;
  }

  final private boolean jj_3R_498() {
    return false;
  }

  final private boolean jj_3R_451() {
    if (jj_scan_token(VARBINARY)) return true;
    return false;
  }

  final private boolean jj_3R_497() {
    if (jj_scan_token(VARYING)) return true;
    return false;
  }

  final private boolean jj_3R_450() {
    if (jj_scan_token(BINARY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_497()) {
    jj_scanpos = xsp;
    if (jj_3R_498()) return true;
    }
    return false;
  }

  final private boolean jj_3R_437() {
    if (jj_3R_493()) return true;
    return false;
  }

  final private boolean jj_3R_436() {
    if (jj_3R_492()) return true;
    return false;
  }

  final private boolean jj_3R_357() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) return true;
    }
    if (jj_3R_120()) return true;
    return false;
  }

  final private boolean jj_3R_350() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_435()) {
    jj_scanpos = xsp;
    if (jj_3R_436()) {
    jj_scanpos = xsp;
    if (jj_3R_437()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_435() {
    if (jj_3R_491()) return true;
    return false;
  }

  final private boolean jj_3R_449() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  final private boolean jj_3R_448() {
    if (jj_scan_token(DOUBLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(422)) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_447() {
    if (jj_scan_token(REAL)) return true;
    return false;
  }

  final private boolean jj_3R_446() {
    if (jj_scan_token(BIGINT)) return true;
    return false;
  }

  final private boolean jj_3R_445() {
    if (jj_scan_token(SMALLINT)) return true;
    return false;
  }

  final private boolean jj_3R_444() {
    if (jj_scan_token(TINYINT)) return true;
    return false;
  }

  final private boolean jj_3R_443() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(262)) return true;
    }
    return false;
  }

  final private boolean jj_3R_442() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  final private boolean jj_3R_441() {
    if (jj_scan_token(GEOMETRY)) return true;
    return false;
  }

  final private boolean jj_3R_356() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_441()) {
    jj_scanpos = xsp;
    if (jj_3R_442()) {
    jj_scanpos = xsp;
    if (jj_3R_443()) {
    jj_scanpos = xsp;
    if (jj_3R_444()) {
    jj_scanpos = xsp;
    if (jj_3R_445()) {
    jj_scanpos = xsp;
    if (jj_3R_446()) {
    jj_scanpos = xsp;
    if (jj_3R_447()) {
    jj_scanpos = xsp;
    if (jj_3R_448()) {
    jj_scanpos = xsp;
    if (jj_3R_449()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_3R_104()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_51()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_270() {
    if (jj_3R_360()) return true;
    return false;
  }

  final private boolean jj_3R_269() {
    if (jj_3R_359()) return true;
    return false;
  }

  final private boolean jj_3R_310() {
    if (jj_scan_token(ROW)) return true;
    return false;
  }

  final private boolean jj_3R_268() {
    if (jj_3R_358()) return true;
    return false;
  }

  final private boolean jj_3R_349() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) {
    jj_scanpos = xsp;
    if (jj_scan_token(294)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(292)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(335)) {
    jj_scanpos = xsp;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) {
    jj_scanpos = xsp;
    if (jj_scan_token(359)) {
    jj_scanpos = xsp;
    if (jj_scan_token(365)) {
    jj_scanpos = xsp;
    if (jj_scan_token(409)) {
    jj_scanpos = xsp;
    if (jj_scan_token(419)) {
    jj_scanpos = xsp;
    if (jj_scan_token(433)) {
    jj_scanpos = xsp;
    if (jj_scan_token(443)) {
    jj_scanpos = xsp;
    if (jj_scan_token(447)) {
    jj_scanpos = xsp;
    if (jj_scan_token(449)) {
    jj_scanpos = xsp;
    if (jj_scan_token(467)) {
    jj_scanpos = xsp;
    if (jj_scan_token(478)) {
    jj_scanpos = xsp;
    if (jj_scan_token(492)) {
    jj_scanpos = xsp;
    if (jj_scan_token(516)) {
    jj_scanpos = xsp;
    if (jj_scan_token(575)) {
    jj_scanpos = xsp;
    if (jj_scan_token(580)) {
    jj_scanpos = xsp;
    if (jj_scan_token(581)) {
    jj_scanpos = xsp;
    if (jj_scan_token(593)) {
    jj_scanpos = xsp;
    if (jj_scan_token(646)) {
    jj_scanpos = xsp;
    if (jj_scan_token(631)) {
    jj_scanpos = xsp;
    if (jj_scan_token(649)) {
    jj_scanpos = xsp;
    if (jj_scan_token(661)) {
    jj_scanpos = xsp;
    if (jj_scan_token(662)) {
    jj_scanpos = xsp;
    if (jj_scan_token(682)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_267() {
    if (jj_3R_357()) return true;
    return false;
  }

  final private boolean jj_3R_171() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) jj_scanpos = xsp;
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3R_266() {
    if (jj_3R_356()) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_250() {
    if (jj_3R_349()) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_3R_306()) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3R_249() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) return true;
    }
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_scan_token(ROW)) return true;
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3R_469() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_3R_309()) return true;
    return false;
  }

  final private boolean jj_3R_468() {
    if (jj_3R_501()) return true;
    return false;
  }

  final private boolean jj_3R_396() {
    if (jj_scan_token(LATERAL)) return true;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_3R_119()) return true;
    return false;
  }

  final private boolean jj_3R_305() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_396()) jj_scanpos = xsp;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_3R_105()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_394() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3R_468()) {
    jj_scanpos = xsp;
    if (jj_3R_469()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_514() {
    if (jj_scan_token(SUBSTRING)) return true;
    return false;
  }

  final private boolean jj_3R_304() {
    if (jj_scan_token(UNNEST)) return true;
    return false;
  }

  final private boolean jj_3R_395() {
    if (jj_3R_470()) return true;
    return false;
  }

  final private boolean jj_3R_301() {
    if (jj_3R_394()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_395()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_317() {
    if (jj_scan_token(NE2)) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(LATERAL)) return true;
    return false;
  }

  final private boolean jj_3R_316() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_3R_158()) return true;
    return false;
  }

  final private boolean jj_3_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3R_315() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_157()) return true;
    return false;
  }

  final private boolean jj_3R_314() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  final private boolean jj_3R_313() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  final private boolean jj_3R_312() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  final private boolean jj_3R_172() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) {
    jj_scanpos = xsp;
    if (jj_3R_316()) {
    jj_scanpos = xsp;
    if (jj_3R_317()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_311() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(197)) jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3R_361() {
    return false;
  }

  final private boolean jj_3R_426() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_3R_207()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_67()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    xsp = jj_scanpos;
    if (jj_3R_70()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3R_155() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3_25()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_538() {
    if (jj_scan_token(UNSIGNED_INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_101()) return true;
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_517() {
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_155()) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(SIMILAR)) return true;
    if (jj_scan_token(TO)) return true;
    return false;
  }

  final private boolean jj_3R_516() {
    if (jj_scan_token(SPECIFIC)) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(RLIKE)) return true;
    return false;
  }

  final private boolean jj_3R_333() {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_422()) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(ILIKE)) return true;
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_scan_token(SIMILAR)) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(LIKE)) return true;
    return false;
  }

  final private boolean jj_3R_487() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_516()) {
    jj_scanpos = xsp;
    if (jj_3R_517()) return true;
    }
    if (jj_3R_108()) return true;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(RLIKE)) return true;
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_scan_token(ILIKE)) return true;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(LIKE)) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(NOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(OUTER)) return true;
    if (jj_scan_token(APPLY)) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_147()) return true;
    return false;
  }

  final private boolean jj_3_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    }
    }
    }
    }
    if (jj_3R_100()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(CROSS)) return true;
    if (jj_scan_token(APPLY)) return true;
    return false;
  }

  final private boolean jj_3R_176() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    return false;
  }

  final private boolean jj_3R_318() {
    if (jj_scan_token(SYMMETRIC)) return true;
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_3R_303()) return true;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_3R_136()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(BETWEEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_176()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_3R_135()) return true;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_421() {
    if (jj_3R_487()) return true;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_3R_134()) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_3R_118()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_71()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(BETWEEN)) return true;
    return false;
  }

  final private boolean jj_3R_331() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3R_421()) return true;
    }
    return false;
  }

  final private boolean jj_3_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    }
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_scan_token(SOME)) return true;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_3R_291()) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_3R_172()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_117()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_69()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_70()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_64()) return true;
    if (jj_3R_65()) return true;
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_363() {
    if (jj_scan_token(RESPECT)) return true;
    if (jj_scan_token(NULLS)) return true;
    return false;
  }

  final private boolean jj_3_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) return true;
    }
    }
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3R_291() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) return true;
    }
    return false;
  }

  final private boolean jj_3R_362() {
    if (jj_scan_token(IGNORE)) return true;
    if (jj_scan_token(NULLS)) return true;
    return false;
  }

  final private boolean jj_3_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_52() {
    Token xsp;
    if (jj_3_51()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3R_361()) return true;
    }
    return false;
  }

  final private boolean jj_3R_496() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(250)) {
    jj_scanpos = xsp;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) {
    jj_scanpos = xsp;
    if (jj_scan_token(283)) {
    jj_scanpos = xsp;
    if (jj_scan_token(286)) {
    jj_scanpos = xsp;
    if (jj_scan_token(297)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(363)) {
    jj_scanpos = xsp;
    if (jj_scan_token(376)) {
    jj_scanpos = xsp;
    if (jj_scan_token(381)) {
    jj_scanpos = xsp;
    if (jj_scan_token(389)) {
    jj_scanpos = xsp;
    if (jj_scan_token(393)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(400)) {
    jj_scanpos = xsp;
    if (jj_scan_token(403)) {
    jj_scanpos = xsp;
    if (jj_scan_token(414)) {
    jj_scanpos = xsp;
    if (jj_scan_token(424)) {
    jj_scanpos = xsp;
    if (jj_scan_token(430)) {
    jj_scanpos = xsp;
    if (jj_scan_token(450)) {
    jj_scanpos = xsp;
    if (jj_scan_token(455)) {
    jj_scanpos = xsp;
    if (jj_scan_token(460)) {
    jj_scanpos = xsp;
    if (jj_scan_token(463)) {
    jj_scanpos = xsp;
    if (jj_scan_token(469)) {
    jj_scanpos = xsp;
    if (jj_scan_token(474)) {
    jj_scanpos = xsp;
    if (jj_scan_token(482)) {
    jj_scanpos = xsp;
    if (jj_scan_token(485)) {
    jj_scanpos = xsp;
    if (jj_scan_token(489)) {
    jj_scanpos = xsp;
    if (jj_scan_token(495)) {
    jj_scanpos = xsp;
    if (jj_scan_token(501)) {
    jj_scanpos = xsp;
    if (jj_scan_token(504)) {
    jj_scanpos = xsp;
    if (jj_scan_token(512)) {
    jj_scanpos = xsp;
    if (jj_scan_token(518)) {
    jj_scanpos = xsp;
    if (jj_scan_token(527)) {
    jj_scanpos = xsp;
    if (jj_scan_token(530)) {
    jj_scanpos = xsp;
    if (jj_scan_token(533)) {
    jj_scanpos = xsp;
    if (jj_scan_token(536)) {
    jj_scanpos = xsp;
    if (jj_scan_token(539)) {
    jj_scanpos = xsp;
    if (jj_scan_token(542)) {
    jj_scanpos = xsp;
    if (jj_scan_token(545)) {
    jj_scanpos = xsp;
    if (jj_scan_token(548)) {
    jj_scanpos = xsp;
    if (jj_scan_token(551)) {
    jj_scanpos = xsp;
    if (jj_scan_token(554)) {
    jj_scanpos = xsp;
    if (jj_scan_token(557)) {
    jj_scanpos = xsp;
    if (jj_scan_token(560)) {
    jj_scanpos = xsp;
    if (jj_scan_token(563)) {
    jj_scanpos = xsp;
    if (jj_scan_token(566)) {
    jj_scanpos = xsp;
    if (jj_scan_token(569)) {
    jj_scanpos = xsp;
    if (jj_scan_token(572)) {
    jj_scanpos = xsp;
    if (jj_scan_token(577)) {
    jj_scanpos = xsp;
    if (jj_scan_token(584)) {
    jj_scanpos = xsp;
    if (jj_scan_token(589)) {
    jj_scanpos = xsp;
    if (jj_scan_token(603)) {
    jj_scanpos = xsp;
    if (jj_scan_token(612)) {
    jj_scanpos = xsp;
    if (jj_scan_token(616)) {
    jj_scanpos = xsp;
    if (jj_scan_token(619)) {
    jj_scanpos = xsp;
    if (jj_scan_token(627)) {
    jj_scanpos = xsp;
    if (jj_scan_token(635)) {
    jj_scanpos = xsp;
    if (jj_scan_token(638)) {
    jj_scanpos = xsp;
    if (jj_scan_token(648)) {
    jj_scanpos = xsp;
    if (jj_scan_token(652)) {
    jj_scanpos = xsp;
    if (jj_scan_token(657)) {
    jj_scanpos = xsp;
    if (jj_scan_token(668)) {
    jj_scanpos = xsp;
    if (jj_scan_token(679)) {
    jj_scanpos = xsp;
    if (jj_scan_token(683)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_142()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(WITHIN)) return true;
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  final private boolean jj_3R_298() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_3R_52()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_298()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_286() {
    if (jj_scan_token(NEXT)) return true;
    return false;
  }

  final private boolean jj_3R_285() {
    if (jj_scan_token(PREV)) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_3R_319()) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_177()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_87()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_44()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_284() {
    if (jj_scan_token(LAST)) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3R_283() {
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  final private boolean jj_3R_282() {
    return false;
  }

  final private boolean jj_3R_281() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  final private boolean jj_3R_280() {
    if (jj_scan_token(RUNNING)) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_3R_100()) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_scan_token(CROSS)) return true;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_515() {
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_scan_token(FULL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(383)) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_scan_token(RIGHT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(383)) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_scan_token(LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(383)) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_252() {
    if (jj_3R_350()) return true;
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_scan_token(INNER)) return true;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) return true;
    }
    return false;
  }

  final private boolean jj_3R_251() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_519() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_518() {
    if (jj_scan_token(RUNNING)) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_336() {
    if (jj_3R_426()) return true;
    return false;
  }

  final private boolean jj_3R_488() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_518()) {
    jj_scanpos = xsp;
    if (jj_3R_519()) return true;
    }
    if (jj_3R_331()) return true;
    return false;
  }

  final private boolean jj_3R_149() {
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_scan_token(NATURAL)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) return true;
    }
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3R_429() {
    if (jj_3R_488()) return true;
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_3R_133()) return true;
    return false;
  }

  final private boolean jj_3_82() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_428() {
    if (jj_scan_token(MATCH_NUMBER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_427() {
    if (jj_scan_token(CLASSIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_471() {
    if (jj_scan_token(WITH)) return true;
    return false;
  }

  final private boolean jj_3R_338() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_427()) {
    jj_scanpos = xsp;
    if (jj_3R_428()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3R_429()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_69() {
    return false;
  }

  final private boolean jj_3R_265() {
    if (jj_3R_355()) return true;
    return false;
  }

  final private boolean jj_3R_495() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(249)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(261)) {
    jj_scanpos = xsp;
    if (jj_scan_token(272)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(291)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(353)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_scan_token(375)) {
    jj_scanpos = xsp;
    if (jj_scan_token(380)) {
    jj_scanpos = xsp;
    if (jj_scan_token(388)) {
    jj_scanpos = xsp;
    if (jj_scan_token(392)) {
    jj_scanpos = xsp;
    if (jj_scan_token(395)) {
    jj_scanpos = xsp;
    if (jj_scan_token(399)) {
    jj_scanpos = xsp;
    if (jj_scan_token(402)) {
    jj_scanpos = xsp;
    if (jj_scan_token(413)) {
    jj_scanpos = xsp;
    if (jj_scan_token(421)) {
    jj_scanpos = xsp;
    if (jj_scan_token(428)) {
    jj_scanpos = xsp;
    if (jj_scan_token(434)) {
    jj_scanpos = xsp;
    if (jj_scan_token(453)) {
    jj_scanpos = xsp;
    if (jj_scan_token(457)) {
    jj_scanpos = xsp;
    if (jj_scan_token(462)) {
    jj_scanpos = xsp;
    if (jj_scan_token(468)) {
    jj_scanpos = xsp;
    if (jj_scan_token(473)) {
    jj_scanpos = xsp;
    if (jj_scan_token(477)) {
    jj_scanpos = xsp;
    if (jj_scan_token(484)) {
    jj_scanpos = xsp;
    if (jj_scan_token(488)) {
    jj_scanpos = xsp;
    if (jj_scan_token(494)) {
    jj_scanpos = xsp;
    if (jj_scan_token(500)) {
    jj_scanpos = xsp;
    if (jj_scan_token(503)) {
    jj_scanpos = xsp;
    if (jj_scan_token(508)) {
    jj_scanpos = xsp;
    if (jj_scan_token(517)) {
    jj_scanpos = xsp;
    if (jj_scan_token(526)) {
    jj_scanpos = xsp;
    if (jj_scan_token(529)) {
    jj_scanpos = xsp;
    if (jj_scan_token(532)) {
    jj_scanpos = xsp;
    if (jj_scan_token(535)) {
    jj_scanpos = xsp;
    if (jj_scan_token(538)) {
    jj_scanpos = xsp;
    if (jj_scan_token(541)) {
    jj_scanpos = xsp;
    if (jj_scan_token(544)) {
    jj_scanpos = xsp;
    if (jj_scan_token(547)) {
    jj_scanpos = xsp;
    if (jj_scan_token(550)) {
    jj_scanpos = xsp;
    if (jj_scan_token(553)) {
    jj_scanpos = xsp;
    if (jj_scan_token(556)) {
    jj_scanpos = xsp;
    if (jj_scan_token(559)) {
    jj_scanpos = xsp;
    if (jj_scan_token(562)) {
    jj_scanpos = xsp;
    if (jj_scan_token(565)) {
    jj_scanpos = xsp;
    if (jj_scan_token(568)) {
    jj_scanpos = xsp;
    if (jj_scan_token(571)) {
    jj_scanpos = xsp;
    if (jj_scan_token(574)) {
    jj_scanpos = xsp;
    if (jj_scan_token(583)) {
    jj_scanpos = xsp;
    if (jj_scan_token(586)) {
    jj_scanpos = xsp;
    if (jj_scan_token(601)) {
    jj_scanpos = xsp;
    if (jj_scan_token(607)) {
    jj_scanpos = xsp;
    if (jj_scan_token(615)) {
    jj_scanpos = xsp;
    if (jj_scan_token(618)) {
    jj_scanpos = xsp;
    if (jj_scan_token(626)) {
    jj_scanpos = xsp;
    if (jj_scan_token(633)) {
    jj_scanpos = xsp;
    if (jj_scan_token(637)) {
    jj_scanpos = xsp;
    if (jj_scan_token(643)) {
    jj_scanpos = xsp;
    if (jj_scan_token(651)) {
    jj_scanpos = xsp;
    if (jj_scan_token(656)) {
    jj_scanpos = xsp;
    if (jj_scan_token(666)) {
    jj_scanpos = xsp;
    if (jj_scan_token(678)) {
    jj_scanpos = xsp;
    if (jj_scan_token(681)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_388() {
    if (jj_scan_token(UESCAPE)) return true;
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  final private boolean jj_3R_432() {
    if (jj_scan_token(SESSION)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_3R_160()) return true;
    return false;
  }

  final private boolean jj_3R_431() {
    if (jj_scan_token(HOP)) return true;
    return false;
  }

  final private boolean jj_3R_264() {
    if (jj_scan_token(UNICODE_QUOTED_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_430() {
    if (jj_scan_token(TUMBLE)) return true;
    return false;
  }

  final private boolean jj_3R_263() {
    if (jj_scan_token(BRACKET_QUOTED_IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_346() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) {
    jj_scanpos = xsp;
    if (jj_3R_431()) {
    jj_scanpos = xsp;
    if (jj_3R_432()) return true;
    }
    }
    if (jj_3R_433()) return true;
    return false;
  }

  final private boolean jj_3R_262() {
    if (jj_scan_token(BACK_QUOTED_IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_397() {
    if (jj_3R_471()) return true;
    return false;
  }

  final private boolean jj_3R_261() {
    if (jj_scan_token(QUOTED_IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_306() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_397()) jj_scanpos = xsp;
    if (jj_3R_109()) return true;
    return false;
  }

  final private boolean jj_3R_260() {
    if (jj_scan_token(HYPHENATED_IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_259() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_scan_token(TIMESTAMPDIFF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_292()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_294() {
    if (jj_scan_token(HOOK)) return true;
    return false;
  }

  final private boolean jj_3R_337() {
    if (jj_scan_token(TIMESTAMPADD)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_384() {
    if (jj_scan_token(SQL_TSI_YEAR)) return true;
    return false;
  }

  final private boolean jj_3R_383() {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  final private boolean jj_3R_382() {
    if (jj_scan_token(SQL_TSI_QUARTER)) return true;
    return false;
  }

  final private boolean jj_3R_381() {
    if (jj_scan_token(QUARTER)) return true;
    return false;
  }

  final private boolean jj_3R_380() {
    if (jj_scan_token(SQL_TSI_MONTH)) return true;
    return false;
  }

  final private boolean jj_3R_379() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  final private boolean jj_3R_378() {
    if (jj_scan_token(SQL_TSI_WEEK)) return true;
    return false;
  }

  final private boolean jj_3R_377() {
    if (jj_scan_token(WEEK)) return true;
    return false;
  }

  final private boolean jj_3R_376() {
    if (jj_scan_token(SQL_TSI_DAY)) return true;
    return false;
  }

  final private boolean jj_3R_375() {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  final private boolean jj_3R_374() {
    if (jj_scan_token(SQL_TSI_HOUR)) return true;
    return false;
  }

  final private boolean jj_3R_373() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  final private boolean jj_3R_372() {
    if (jj_scan_token(SQL_TSI_MINUTE)) return true;
    return false;
  }

  final private boolean jj_3R_371() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  final private boolean jj_3R_370() {
    if (jj_scan_token(SQL_TSI_SECOND)) return true;
    return false;
  }

  final private boolean jj_3R_369() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  final private boolean jj_3R_368() {
    if (jj_scan_token(SQL_TSI_MICROSECOND)) return true;
    return false;
  }

  final private boolean jj_3R_367() {
    if (jj_scan_token(SQL_TSI_FRAC_SECOND)) return true;
    return false;
  }

  final private boolean jj_3R_366() {
    if (jj_scan_token(NANOSECOND)) return true;
    return false;
  }

  final private boolean jj_3R_365() {
    if (jj_scan_token(MICROSECOND)) return true;
    return false;
  }

  final private boolean jj_3R_292() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_3R_369()) {
    jj_scanpos = xsp;
    if (jj_3R_370()) {
    jj_scanpos = xsp;
    if (jj_3R_371()) {
    jj_scanpos = xsp;
    if (jj_3R_372()) {
    jj_scanpos = xsp;
    if (jj_3R_373()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_3R_377()) {
    jj_scanpos = xsp;
    if (jj_3R_378()) {
    jj_scanpos = xsp;
    if (jj_3R_379()) {
    jj_scanpos = xsp;
    if (jj_3R_380()) {
    jj_scanpos = xsp;
    if (jj_3R_381()) {
    jj_scanpos = xsp;
    if (jj_3R_382()) {
    jj_scanpos = xsp;
    if (jj_3R_383()) {
    jj_scanpos = xsp;
    if (jj_3R_384()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_364() {
    if (jj_scan_token(FRAC_SECOND)) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_scan_token(MATCHED)) return true;
    return false;
  }

  final private boolean jj_3R_494() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(243)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(270)) {
    jj_scanpos = xsp;
    if (jj_scan_token(273)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(287)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(326)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(347)) {
    jj_scanpos = xsp;
    if (jj_scan_token(360)) {
    jj_scanpos = xsp;
    if (jj_scan_token(366)) {
    jj_scanpos = xsp;
    if (jj_scan_token(379)) {
    jj_scanpos = xsp;
    if (jj_scan_token(384)) {
    jj_scanpos = xsp;
    if (jj_scan_token(391)) {
    jj_scanpos = xsp;
    if (jj_scan_token(394)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(401)) {
    jj_scanpos = xsp;
    if (jj_scan_token(412)) {
    jj_scanpos = xsp;
    if (jj_scan_token(415)) {
    jj_scanpos = xsp;
    if (jj_scan_token(427)) {
    jj_scanpos = xsp;
    if (jj_scan_token(431)) {
    jj_scanpos = xsp;
    if (jj_scan_token(452)) {
    jj_scanpos = xsp;
    if (jj_scan_token(456)) {
    jj_scanpos = xsp;
    if (jj_scan_token(461)) {
    jj_scanpos = xsp;
    if (jj_scan_token(464)) {
    jj_scanpos = xsp;
    if (jj_scan_token(472)) {
    jj_scanpos = xsp;
    if (jj_scan_token(475)) {
    jj_scanpos = xsp;
    if (jj_scan_token(483)) {
    jj_scanpos = xsp;
    if (jj_scan_token(487)) {
    jj_scanpos = xsp;
    if (jj_scan_token(493)) {
    jj_scanpos = xsp;
    if (jj_scan_token(498)) {
    jj_scanpos = xsp;
    if (jj_scan_token(502)) {
    jj_scanpos = xsp;
    if (jj_scan_token(505)) {
    jj_scanpos = xsp;
    if (jj_scan_token(513)) {
    jj_scanpos = xsp;
    if (jj_scan_token(520)) {
    jj_scanpos = xsp;
    if (jj_scan_token(528)) {
    jj_scanpos = xsp;
    if (jj_scan_token(531)) {
    jj_scanpos = xsp;
    if (jj_scan_token(534)) {
    jj_scanpos = xsp;
    if (jj_scan_token(537)) {
    jj_scanpos = xsp;
    if (jj_scan_token(540)) {
    jj_scanpos = xsp;
    if (jj_scan_token(543)) {
    jj_scanpos = xsp;
    if (jj_scan_token(546)) {
    jj_scanpos = xsp;
    if (jj_scan_token(549)) {
    jj_scanpos = xsp;
    if (jj_scan_token(552)) {
    jj_scanpos = xsp;
    if (jj_scan_token(555)) {
    jj_scanpos = xsp;
    if (jj_scan_token(558)) {
    jj_scanpos = xsp;
    if (jj_scan_token(561)) {
    jj_scanpos = xsp;
    if (jj_scan_token(564)) {
    jj_scanpos = xsp;
    if (jj_scan_token(567)) {
    jj_scanpos = xsp;
    if (jj_scan_token(570)) {
    jj_scanpos = xsp;
    if (jj_scan_token(573)) {
    jj_scanpos = xsp;
    if (jj_scan_token(578)) {
    jj_scanpos = xsp;
    if (jj_scan_token(585)) {
    jj_scanpos = xsp;
    if (jj_scan_token(599)) {
    jj_scanpos = xsp;
    if (jj_scan_token(606)) {
    jj_scanpos = xsp;
    if (jj_scan_token(614)) {
    jj_scanpos = xsp;
    if (jj_scan_token(617)) {
    jj_scanpos = xsp;
    if (jj_scan_token(625)) {
    jj_scanpos = xsp;
    if (jj_scan_token(632)) {
    jj_scanpos = xsp;
    if (jj_scan_token(636)) {
    jj_scanpos = xsp;
    if (jj_scan_token(642)) {
    jj_scanpos = xsp;
    if (jj_scan_token(650)) {
    jj_scanpos = xsp;
    if (jj_scan_token(653)) {
    jj_scanpos = xsp;
    if (jj_scan_token(655)) {
    jj_scanpos = xsp;
    if (jj_scan_token(669)) {
    jj_scanpos = xsp;
    if (jj_scan_token(680)) {
    jj_scanpos = xsp;
    if (jj_scan_token(684)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_345() {
    if (jj_scan_token(JSON_ARRAYAGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_440() {
    if (jj_3R_496()) return true;
    return false;
  }

  final private boolean jj_3R_439() {
    if (jj_3R_495()) return true;
    return false;
  }

  final private boolean jj_3R_438() {
    if (jj_3R_494()) return true;
    return false;
  }

  final private boolean jj_3R_355() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_438()) {
    jj_scanpos = xsp;
    if (jj_3R_439()) {
    jj_scanpos = xsp;
    if (jj_3R_440()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_325() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_3R_82()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_131()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_213() {
    if (jj_3R_116()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_scan_token(TO)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_3R_116()) return true;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_3R_256()) return true;
    return false;
  }

  final private boolean jj_3R_344() {
    if (jj_scan_token(JSON_ARRAY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_212() {
    if (jj_3R_256()) return true;
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_scan_token(TO)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) return true;
    }
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_3R_116()) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_3R_256()) return true;
    return false;
  }

  final private boolean jj_3R_211() {
    if (jj_3R_255()) return true;
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_3R_255()) return true;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_scan_token(TO)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_210() {
    if (jj_3R_324()) return true;
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_343() {
    if (jj_scan_token(JSON_OBJECTAGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_scan_token(TO)) return true;
    if (jj_3R_110()) return true;
    return false;
  }

  final private boolean jj_3R_209() {
    if (jj_3R_110()) return true;
    if (jj_3R_120()) return true;
    return false;
  }

  final private boolean jj_3R_208() {
    if (jj_3R_323()) return true;
    if (jj_3R_120()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_104() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_258() {
    if (jj_scan_token(SECONDS)) return true;
    return false;
  }

  final private boolean jj_3R_116() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    }
    return false;
  }

  final private boolean jj_3R_257() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_354() {
    if (jj_scan_token(MINUTES)) return true;
    return false;
  }

  final private boolean jj_3R_256() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) return true;
    }
    return false;
  }

  final private boolean jj_3R_353() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  final private boolean jj_3R_342() {
    if (jj_scan_token(JSON_OBJECT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_352() {
    if (jj_scan_token(HOURS)) return true;
    return false;
  }

  final private boolean jj_3R_255() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) return true;
    }
    return false;
  }

  final private boolean jj_3R_351() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  final private boolean jj_3R_412() {
    if (jj_scan_token(DAYS)) return true;
    return false;
  }

  final private boolean jj_3R_324() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_411()) {
    jj_scanpos = xsp;
    if (jj_3R_412()) return true;
    }
    return false;
  }

  final private boolean jj_3R_411() {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_254() {
    if (jj_scan_token(MONTHS)) return true;
    return false;
  }

  final private boolean jj_3_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(197)) jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    return false;
  }

  final private boolean jj_3R_253() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_scan_token(KEY)) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  final private boolean jj_3R_279() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_410() {
    if (jj_scan_token(YEARS)) return true;
    return false;
  }

  final private boolean jj_3R_323() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_409()) {
    jj_scanpos = xsp;
    if (jj_3R_410()) return true;
    }
    return false;
  }

  final private boolean jj_3R_409() {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  final private boolean jj_3R_278() {
    if (jj_scan_token(KEY)) return true;
    return false;
  }

  public SqlParserImplTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[390];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static private int[] jj_la1_13;
  static private int[] jj_la1_14;
  static private int[] jj_la1_15;
  static private int[] jj_la1_16;
  static private int[] jj_la1_17;
  static private int[] jj_la1_18;
  static private int[] jj_la1_19;
  static private int[] jj_la1_20;
  static private int[] jj_la1_21;
  static private int[] jj_la1_22;
  static private int[] jj_la1_23;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
      jj_la1_5();
      jj_la1_6();
      jj_la1_7();
      jj_la1_8();
      jj_la1_9();
      jj_la1_10();
      jj_la1_11();
      jj_la1_12();
      jj_la1_13();
      jj_la1_14();
      jj_la1_15();
      jj_la1_16();
      jj_la1_17();
      jj_la1_18();
      jj_la1_19();
      jj_la1_20();
      jj_la1_21();
      jj_la1_22();
      jj_la1_23();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3a43fe,0x0,0x8d3a43fe,0x400,0x0,0x400,0x8d3a43fe,0x8d3a43fe,0x0,0x8d3a63fe,0x8d3a63fe,0x0,0x8d3243fa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x800000,0x8d3a43fe,0x0,0x400,0x0,0x0,0x0,0x8d3243fa,0x0,0x8d3a43fe,0x0,0x8d3a43fe,0x0,0x0,0x0,0x0,0x800000,0x8db243fa,0x0,0x0,0x800000,0x8db243fa,0x0,0x0,0x0,0x800000,0x8db243fa,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x8d3243fa,0x8db243fa,0x8d3a43fe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x8db243fa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3343fa,0x0,0x0,0x8d3a43fe,0x0,0x0,0x0,0x8d3a43fe,0x0,0x0,0x8d3243fa,0x0,0x0,0x0,0x8d3a43fe,0x0,0x1000,0x1000,0x0,0x0,0x8d3a43fe,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x8d3a43fe,0x800000,0x8db243fa,0x800000,0x8db243fa,0x0,0x0,0x800000,0x0,0x0,0x0,0x400,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3243fa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3243fa,0x0,0x0,0x0,0x0,0x0,0x8d3a43fe,0x0,0x10400,0x0,0x10000000,0x10000000,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300000,0x400,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x8d3243fa,0x8d3a43fe,0x0,0x0,0x0,0x8d3243fa,0x8d3247fa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3a43fe,0x0,0x8d3a43fe,0x0,0x0,0x0,0x0,0x0,0x8d3243fa,0x8d3243fa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3243fa,0x0,0x8d3243fa,0x0,0x0,0x0,0x80000,0x8d3243fa,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3343fa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3a43fe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x8,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8d3243fe,0x0,0x0,0x8d3243fa,0x0,0x0,0x0,0x0,0x8d3243fa,0x0,0x8d3243fe,0x4,0x0,0x0,0x8d3243fe,0x0,0x0,0x8d3243fe,0x400,0x400,0x0,0x400,0x0,0x400,0x400,0x400,0x400,0x400,0x400,0x0,0x8000,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x2,0x0,0x8d3243fa,0x81020122,0x4100248,0x8204090,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fb2808d,0x0,0x7fb2808d,0x0,0x0,0x0,0x7fb2808d,0x7fb2808d,0x0,0x7fb6808d,0x7fb6808d,0x0,0x66228089,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fb2808d,0x0,0x0,0x0,0x2000000,0x0,0x66228089,0x0,0x7fb2808d,0x0,0x7fb2808d,0x0,0x0,0x0,0x0,0x0,0x66228089,0x0,0x0,0x0,0x66228089,0x0,0x0,0x0,0x0,0x66228089,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x66228089,0x66228089,0x7fb2808d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x66228089,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0xe622a689,0x0,0x0,0x7fb2808d,0x0,0x0,0x0,0x7fb2808d,0x0,0x0,0x66228089,0x0,0x0,0x0,0x7fb2818d,0x0,0x0,0x0,0x0,0x0,0x7fb2808d,0x0,0x0,0x0,0x0,0x0,0x0,0x7fb2808d,0x0,0x66228089,0x0,0x66228089,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x66228089,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x66228089,0x0,0x0,0x0,0x0,0x0,0x7fb2808d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x66a28089,0x7fb2808d,0x0,0x0,0x0,0x66228089,0x66228089,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fb2808d,0x0,0x7fb2808d,0x0,0x0,0x0,0x0,0x0,0x66228089,0x66228089,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x66228089,0x0,0x66228089,0x0,0x0,0x0,0x0,0x66228089,0x80002600,0x0,0x0,0x2200,0x0,0x400,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x400,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x80002600,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0xe622a689,0x20000000,0x0,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x4000,0x4000,0x7fb2808d,0x0,0x19000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7632808d,0x0,0x0,0x66228089,0x0,0x0,0x0,0x0,0x66228089,0x0,0x7632808d,0x10100004,0x0,0x0,0x7632808d,0x0,0x0,0x7632808d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x66228089,0x20200080,0x42008001,0x4020008,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5df66fd,0x0,0xb5df66fd,0x0,0x0,0x0,0xb5df66fd,0xb5df66fd,0x0,0xb5df66fd,0xb5df66fd,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5df66fd,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0xb5df66fd,0x0,0xb5df66fd,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0xb5cf44f8,0xb5df66fd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44fa,0x0,0x0,0xb5df66fd,0x0,0x0,0x0,0xb5df66fd,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0xb5df66fd,0x0,0x0,0x0,0x0,0x0,0xb5df66fd,0x0,0x0,0x0,0x0,0x0,0x0,0xb5df66fd,0x0,0xb5cf44f8,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0xb5df66fd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0xb5df66fd,0x0,0x0,0x0,0xb5cf44f8,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5df66fd,0x0,0xb5df66fd,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0xb5cf44f8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0xb5cf44f8,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0xb5cf44fa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5df66fd,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5df64fd,0x0,0x0,0xb5cf44f8,0x0,0x0,0x0,0x0,0xb5cf44f8,0x0,0xb5df64fd,0x102005,0x0,0x0,0xb5df64fd,0x0,0x0,0xb5df64fd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb5cf44f8,0x210900a0,0x84420408,0x10844050,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xddfc737d,0x0,0xddfc737d,0x0,0x0,0x0,0xddfc737d,0xddfc737d,0x0,0xddfc737d,0xddfc737d,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xddfc737d,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0xddfc737d,0x0,0xddfc737d,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x17d,0xddfc737d,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0xddfc737d,0x0,0x0,0x20000,0xddfc737d,0x0,0x0,0x17d,0x0,0x0,0x0,0xddfc737d,0x0,0x0,0x0,0x0,0x0,0xddfc737d,0x0,0x0,0x0,0x0,0x0,0x0,0xddfc737d,0x0,0x17d,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0xddfc737d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5df8017d,0xddfc737d,0x0,0x0,0x0,0x17d,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xddfc737d,0x0,0xddfc737d,0x0,0x0,0x0,0x0,0x0,0x17d,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0x17d,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xddfc737d,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1824717d,0x0,0x0,0x17d,0x0,0x0,0x0,0x0,0x17d,0x0,0x1824717d,0x18247000,0x5df00000,0x0,0x1824717d,0x0,0x0,0x1824737d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17d,0x14,0x48,0x121,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6dbbc97d,0x0,0x6dbbc97d,0x0,0x0,0x0,0x6dbbc97d,0x6dbbc97d,0x0,0x7dfb897d,0x7dfb897d,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6dfb897d,0x0,0x0,0x0,0x8,0x0,0x6d3b896d,0x0,0x6dfb897d,0x0,0x6dbbc97d,0x0,0x0,0x0,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6d3b896d,0x6d3b896d,0x6dbb897d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6d3b9d7d,0x0,0x0,0x6dbb897d,0x0,0x0,0x0,0x6dbb897d,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x6dbb897d,0x0,0x0,0x0,0x0,0x0,0x6dbb897d,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x6dbb897d,0x0,0x6d3b896d,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x0,0x6dbb897d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x6d3b896d,0x6dbb897d,0x0,0x0,0x0,0x6d3b897d,0x6d3b896d,0x0,0x0,0x10,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x6dbb897d,0x0,0x6dbb897d,0x0,0x0,0x0,0x0,0x0,0x6d3b896d,0x6d3b896d,0x0,0x0,0x180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180,0x180,0x0,0x0,0x180,0x880,0x80,0x0,0x6d3b896d,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x6d3b896d,0x1410,0x0,0x0,0x0,0x0,0x0,0x1400,0x1400,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x6d3b9d7d,0x880,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6dbb897d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6dbb896d,0x0,0x0,0x6d3b896d,0x0,0x0,0x0,0x0,0x6d3b896d,0x0,0x6dbb896d,0x800000,0x0,0x0,0x6dbb896d,0x0,0x0,0x6dbb896d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6d3b896d,0x8220821,0x21088044,0x44110108,};
   }
   private static void jj_la1_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea84b369,0x0,0xea84b369,0x10,0x0,0x10,0xea84b369,0xea84b369,0x0,0xea84b369,0xea84b369,0x0,0xe2843369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x80000000,0x0,0xea84b369,0x0,0x0,0x80000000,0x0,0x0,0xe2843369,0x0,0xea84b369,0x0,0xea84b369,0x0,0x0,0x0,0x0,0x0,0xe2843369,0x0,0x0,0x0,0xe2843369,0x0,0x0,0x0,0x0,0xe2843369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe2843369,0xe2843369,0xea84b369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe2843369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe28433e9,0x0,0x0,0xea84b369,0x0,0x0,0x0,0xea84b369,0x0,0x0,0xe2843369,0x0,0x0,0x0,0xea84b369,0x0,0x2,0x2,0x0,0x0,0xea84b369,0x0,0x0,0x0,0x0,0x0,0x0,0xea84b369,0x0,0xe2843369,0x0,0xe2843369,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe2843369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe2843369,0x0,0x0,0x0,0x10000000,0x0,0xea84b369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe2843369,0xea84b369,0x0,0x10000,0x0,0xe2843369,0xe2843369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea84b369,0x0,0xea84b369,0x0,0x0,0x0,0x0,0x0,0xe2843369,0xe2843369,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800300,0x0,0x0,0xe2843369,0x0,0xe2843369,0x0,0x0,0x0,0x0,0xe2843369,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe28433e9,0x800300,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea84b369,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x2000000,0x2020000,0x0,0x2000000,0x2000000,0x20000,0x2020000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2020000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xea84b369,0x0,0x0,0xe2843369,0x0,0x0,0x0,0x0,0xe2843369,0x0,0xea84b369,0x8008000,0x0,0x0,0xea84b369,0x0,0x0,0xea84b369,0x10,0x10,0x10000000,0x10,0x10000000,0x10,0x10,0x10,0x10,0x10,0x10,0x10000000,0x0,0x0,0x1000000,0x0,0x0,0x20000,0x0,0x20000,0x0,0x20000,0x0,0xe2843369,0x40801101,0x82002208,0x20040060,};
   }
   private static void jj_la1_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x200,0x0,0x0,0xf075b98c,0x0,0xf075b98c,0x0,0x0,0x0,0xf075b98c,0xf075b98c,0x0,0xf075b99c,0xf075b99c,0x0,0xe0751800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0xf075b98c,0x0,0x0,0x0,0x0,0x0,0xe0751800,0x0,0xf075b98c,0x0,0xf075b98c,0x0,0x20,0x20,0x20,0x0,0xe0751800,0x20,0x20,0x0,0xe0751800,0x0,0x20,0x20,0x0,0xe0751800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0751800,0xe0751800,0xf075b98c,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x20,0x20,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0751800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0755800,0x0,0x0,0xf075b98c,0x0,0x0,0x0,0xf075b98c,0x0,0x0,0xe0751800,0x0,0x0,0x0,0xf075b98c,0x0,0x0,0x0,0x10000,0x10000,0xf075b98c,0x0,0x0,0x0,0x0,0x0,0x0,0xf075b98c,0x0,0xe0751800,0x0,0xe0751800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0751800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0751800,0x0,0x0,0x0,0x0,0x0,0xf075b98c,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0xe0751800,0xf075b98c,0x0,0x0,0x0,0xe0751900,0xe0751800,0x0,0x0,0x100,0x100,0x100,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf075b98c,0x0,0xf075b98c,0x0,0x0,0x0,0x0,0x0,0xe0751800,0xe0751800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0xe0751800,0x0,0xe0751800,0x0,0x0,0x0,0x0,0xe0751800,0x4000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0755800,0x0,0x2000000,0x0,0x0,0x20000,0x0,0x2000000,0x20000,0x20000,0x0,0x0,0xf075b98c,0x2000000,0x9880,0x0,0x40000,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x800,0x1000,0x0,0x0,0x0,0x0,0xf075b808,0x0,0x400,0xe0751800,0x0,0x0,0x0,0x0,0xe0751800,0x0,0xf075b808,0x1000a008,0x0,0x0,0xf075b808,0x0,0x0,0xf075b808,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x100,0x0,0x100,0x0,0x100,0x40000,0xe0751800,0x20101000,0x40210000,0x80440800,};
   }
   private static void jj_la1_7() {
      jj_la1_7 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7dd359,0x0,0x4e7dd359,0x0,0x0,0x0,0x4e7dd359,0x4e7dd359,0x0,0x4e7dd359,0x4e7dd359,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x4e7dd359,0x0,0x0,0x4000000,0x0,0x0,0x4e7d5159,0x0,0x4e7dd359,0x0,0x4e7dd359,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x0,0x0,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x4e7d5159,0x4e7dd359,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x0,0x0,0x4e7dd359,0x0,0x80,0x0,0x4e7dd359,0x800,0x0,0x4e7d5159,0x0,0x0,0x0,0x4e7dd359,0x0,0x0,0x0,0x0,0x0,0x4e7dd359,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7dd359,0x0,0x4e7d5159,0x0,0x4e7d5159,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x0,0x4e7dd359,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x100,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x4e7dd359,0x0,0x0,0x0,0x4e7d5159,0x4e7d5159,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7dd359,0x0,0x4e7dd359,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x4e7d5159,0x0,0x0,0x0,0x18000,0x0,0x0,0x18000,0x0,0x0,0x0,0x0,0x0,0x18000,0x18000,0x0,0x0,0x18000,0x8000,0x8000,0x0,0x4e7d5159,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x4e7d5159,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7dd359,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x4e7dd359,0x0,0x0,0x4e7d5159,0x0,0x0,0x0,0x0,0x4e7d5159,0x0,0x4e7dd359,0x8200,0x0,0x0,0x4e7dd359,0x0,0x0,0x4e7dd359,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4e7d5159,0x8484041,0x42110108,0x4241010,};
   }
   private static void jj_la1_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffbd632,0x0,0xfffbd632,0x0,0x0,0x0,0xfffbd632,0xfffbd632,0x0,0xfffbd63a,0xfffbd63a,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffbd63a,0x0,0x0,0x0,0x0,0x0,0xf80bd032,0x0,0xfffbd63a,0x0,0xfffbd632,0x8,0x0,0x0,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80bd032,0xf80bd032,0xfffbd632,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80bd0f2,0x0,0x0,0xfffbd632,0x0,0x0,0x0,0xfffbd632,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0xfffbd632,0x0,0x0,0x0,0x0,0x0,0xfffbd632,0x0,0x0,0x0,0x0,0x0,0x0,0xfffbd632,0x0,0xf80bd032,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0x100,0x0,0xfffbd632,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0xf80bd032,0xfffbd632,0x0,0x0,0x0,0xf80bd432,0xf80bd032,0x0,0x0,0x400,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffbd632,0x0,0xfffbd632,0x0,0x0,0x0,0x0,0x0,0xf80bd032,0xf80bd032,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0x0,0x0,0xf80bd032,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0xf80bd032,0xc0,0xc0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80bd4f2,0xc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffbd632,0x0,0x7f00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80bd232,0x0,0x0,0xf80bd032,0x0,0x0,0x0,0x0,0xf80bd032,0x0,0xf80bd232,0x200,0x0,0x8,0xf80bd23a,0x0,0x0,0xf80bd23a,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x2000,0x0,0x0,0x0,0x0,0x80000,0x0,0x80000,0x80000,0x2000,0xf80bd032,0x90024010,0x20090020,0x48009002,};
   }
   private static void jj_la1_9() {
      jj_la1_9 = new int[] {0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x357e8f59,0x0,0x357e8f59,0x0,0x0,0x0,0x357e8f59,0x357e8f59,0x0,0x357e8f59,0x357e8f59,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x357e8f59,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x357e8f59,0x0,0x357e8f59,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x21680e08,0x357e8f59,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x20,0x8000000,0x0,0x20,0x20,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x357e8f59,0x0,0x0,0x0,0x357e8f59,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x357e8f59,0x0,0x0,0x0,0x0,0x0,0x357e8f59,0x0,0x0,0x0,0x0,0x0,0x0,0x357e8f59,0x0,0x21680e08,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x357e8f59,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x216e0e08,0x357e8f59,0x0,0x0,0x0,0x21680e08,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x357e8f59,0x0,0x357e8f59,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x357e8f59,0x0,0x4000008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x317e8f59,0x0,0x0,0x21680e08,0x0,0x0,0x0,0x0,0x21680e08,0x0,0x317e8f59,0x10168151,0x60000,0x100,0x317e8f59,0x0,0x0,0x317e8f59,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21680e08,0x20200400,0x400808,0x1080200,};
   }
   private static void jj_la1_10() {
      jj_la1_10 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x387f9fee,0x0,0x387f9fee,0x0,0x0,0x0,0x387f9fee,0x387f9fee,0x0,0x387f9fef,0x387f9fef,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x387f9fef,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x387f9fef,0x0,0x387f9fee,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x87b0cee,0x387f9fee,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x0,0x387f9fee,0x0,0x0,0x0,0x387f9fee,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x387f9fee,0x0,0x0,0x0,0x0,0x0,0x387f9fee,0x0,0x0,0x0,0x0,0x0,0x0,0x387f9fee,0x0,0x87b0cee,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x387f9fee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x387b0cee,0x387f9fee,0x0,0x0,0x20000000,0x87b0cee,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x387f9fee,0x0,0x387f9fee,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x87b0cee,0x0,0x18000,0x0,0x0,0x600,0x0,0x600,0x0,0x600,0x0,0x0,0x0,0x18600,0x18600,0x0,0x0,0x18600,0x82c0,0x408220,0x0,0x87b0cee,0x0,0x87b0cee,0x0,0x0,0x0,0x40000,0x87b0cee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x4082e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x387f9fee,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x87b9fee,0x0,0x0,0x87b0cee,0x0,0x0,0x0,0x0,0x87b0cee,0x0,0x87b9fee,0x9300,0x0,0x0,0x87b9fee,0x0,0x0,0x87b9fee,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x87b0cee,0x8110048,0x220422,0x480884,};
   }
   private static void jj_la1_11() {
      jj_la1_11 = new int[] {0x4000000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x39806bfe,0x0,0x39806bfe,0x0,0x0,0x0,0x39806bfe,0x39806bfe,0x0,0x39806bfe,0x39806bfe,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39806bfe,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x39806bfe,0x0,0x39806bfe,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x0,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x39804b42,0x39806bfe,0x0,0x80000000,0x80000000,0x80000000,0x0,0x80000,0x80000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x39804f42,0x0,0x0,0x39806bfe,0x0,0x0,0x0,0x39806bfe,0x0,0x0,0x39804b42,0x0,0x4000000,0x0,0x39806bfe,0x0,0x0,0x0,0x0,0x0,0x39806bfe,0x0,0x0,0x100,0x100,0x0,0x0,0x39806bfe,0x0,0x39804b42,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x4000000,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x0,0x39806bfe,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x20,0x0,0x0,0x39804b42,0x39806bfe,0x0,0x0,0x0,0x39884b62,0x39804b42,0x0,0x0,0x20,0x20,0x20,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39806bfe,0x0,0x39806bfe,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x39804b42,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x39804b42,0x400,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x24,0x24,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39804f42,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39806bfe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x20,0x0,0x20,0x20,0x0,0x20,0x4000000,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x39806bda,0x0,0x0,0x39804b42,0x0,0x0,0x0,0x0,0x39804b42,0x0,0x39806bda,0x2098,0x0,0x0,0x39806bda,0x0,0x0,0x39806bda,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x4,0x0,0x4,0x20,0x0,0x20,0x0,0x24,0x0,0x39804b42,0x8004100,0x10800202,0x21000840,};
   }
   private static void jj_la1_12() {
      jj_la1_12 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf60fbfb9,0x0,0xf60fbfb9,0x0,0x0,0x0,0xf60fbfb9,0xf60fbfb9,0x0,0xf60fbfb9,0xf60fbfb9,0x0,0xf00fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf60fbfb9,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0xf60fbfb9,0x0,0xf60fbfb9,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0x0,0x0,0xf00fbfb1,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0xf00fbfb1,0xf60fbfb9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0x0,0xf60fbfb9,0x0,0x0,0x0,0xf60fbfb9,0x0,0x0,0xf00fbfb1,0x4000,0x0,0x0,0xf60fbfb9,0x0,0x0,0x0,0x0,0x0,0xf60fbfb9,0x0,0x0,0x0,0x0,0x0,0x0,0xf60fbfb9,0x0,0xf00fbfb1,0x0,0xf00fbfb1,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf80fbfb1,0x0,0x0,0x0,0x0,0x0,0xf60fbfb9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0xf00fbfb1,0xf60fbfb9,0x0,0x0,0x0,0xf00fbfb1,0xf00fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf60fbfb9,0x0,0xf60fbfb9,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0xf00fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0xf00fbfb1,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf60fbfb9,0x0,0x8,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf20fbfb1,0x0,0x0,0xf00fbfb1,0x2,0x0,0x0,0x0,0xf00fbfb1,0x2,0xf20fbfb1,0x2000000,0x0,0x0,0xf20fbfb1,0x0,0x0,0xf20fbfb1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf00fbfb1,0x90022481,0x20048910,0x40091220,};
   }
   private static void jj_la1_13() {
      jj_la1_13 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8806db2a,0x0,0x8806db2a,0x0,0x0,0x0,0x8806db2a,0x8806db2a,0x0,0x8806db2a,0x8806db2a,0x0,0x4d920,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8806db2a,0x0,0x0,0x0,0x0,0x0,0x4d920,0x0,0x8806db2a,0x0,0x8806db2a,0x0,0x0,0x0,0x0,0x0,0x4d920,0x0,0x0,0x0,0x4d920,0x0,0x0,0x0,0x0,0x4d920,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4d920,0x4d920,0x8806db2a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4d920,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x14d920,0x0,0x0,0x8806db2a,0x0,0x0,0x0,0x8806db2a,0x0,0x0,0x4d920,0x0,0x0,0x10000,0x8806db2a,0x10000,0x0,0x0,0x20,0x20,0x8806db2a,0x0,0x0,0x0,0x0,0x0,0x0,0x8806db2a,0x0,0x4d920,0x0,0x4d920,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4d920,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4d920,0x0,0x0,0x0,0x0,0x0,0x8806db2a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4d920,0x8806db2a,0x0,0x0,0x0,0x4d920,0x4d920,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8806db2a,0x0,0x8806db2a,0x0,0x0,0x0,0x0,0x0,0x4d920,0x4d920,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x8000,0x0,0x4d920,0x0,0x4d920,0x0,0x0,0x0,0x0,0x4d920,0x100000,0x0,0x40,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x14d920,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8806db2a,0x0,0x202,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x8806d928,0x0,0x0,0x4d920,0x0,0x0,0x0,0x0,0x4d920,0x0,0x8806d928,0x88020008,0x0,0x0,0x8806d928,0x0,0x0,0x8806d928,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4d920,0x8800,0x41020,0x4100,};
   }
   private static void jj_la1_14() {
      jj_la1_14 = new int[] {0x0,0x0,0x0,0x90000000,0x90000000,0x0,0x0,0x90000000,0x0,0x0,0x0,0x7f39f3b6,0x0,0x7f39f3b6,0x0,0x0,0x0,0x7f39f3b6,0x7f39f3b6,0x0,0x7f39f3f6,0x7f39f3f6,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f39f3b6,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x7f39f3b6,0x0,0x7f39f3b6,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x0,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x2f31f3b4,0x7f39f3b6,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x3f31f3b4,0x0,0x10000000,0x7f39f3b6,0x0,0x0,0x800000,0x7f39f3b6,0x0,0x0,0x2f31f3b4,0x0,0x0,0x80000000,0x7f39f3b6,0x80000000,0x0,0x0,0x0,0x0,0x7f39f3b6,0x0,0x0,0x0,0x0,0x0,0x0,0x7f39f3b6,0x0,0x2f31f3b4,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x0,0x7f39f3b6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x10000000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x7f39f3b6,0x0,0x0,0x0,0x2f31f3b4,0x2f31f3b4,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f39f3b6,0x0,0x7f39f3b6,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x2f31f3b4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x3f31f3b4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f31f3b4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f39f3b6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x6f39f3b6,0x0,0x0,0x2f31f3b4,0x0,0x0,0x0,0x0,0x2f31f3b4,0x0,0x6f39f3b6,0x40080002,0x0,0x80000,0x6f39f3b6,0x0,0x0,0x6f39f3b6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f31f3b4,0x9012110,0x22104220,0x4209084,};
   }
   private static void jj_la1_15() {
      jj_la1_15 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x17f6f3bd,0x0,0x17f4f3bd,0x0,0x0,0x0,0x17f6f3bd,0x17f4f3bd,0x0,0x1ff6f3bd,0x1ff6f3bd,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17f6f3bd,0x0,0x0,0x0,0x10,0x0,0x13f4e3bc,0x0,0x17f6f3bd,0x0,0x17f6f3bd,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x13f4e3bc,0x17f4f3bd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x17f4f3bd,0x0,0x0,0x0,0x17f4f3bd,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x17f4f3bd,0x0,0x0,0x0,0x0,0x0,0x17f4f3bd,0x0,0x0,0x0,0x0,0x0,0x0,0x17f4f3bd,0x0,0x13f4e3bc,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x20000000,0x0,0x17f6f3bd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x17f4e3bc,0x17f4f3bd,0x0,0x0,0x0,0x13f4e3bc,0x13f4e3bc,0x8000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17f4f3bd,0x0,0x17f4f3bd,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x13f4e3bc,0x0,0x0,0x0,0x0,0x0,0x3000,0x3000,0x0,0x3000,0x0,0x0,0x0,0x3000,0x0,0x0,0x0,0x3000,0x1000,0x1000,0x0,0x13f4e3bc,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17f4f3bd,0x0,0x2000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x1,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x13f4f3bc,0x0,0x0,0x13f4e3bc,0x0,0x0,0x0,0x0,0x13f4e3bc,0x0,0x13f4f3bc,0x1000,0x4000000,0x0,0x13f4f3bc,0x0,0x0,0x13f4f3bc,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13f4e3bc,0x2442088,0x10904110,0x1208224,};
   }
   private static void jj_la1_16() {
      jj_la1_16 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0xffffc1f3,0x0,0x0,0x0,0xffffc1f3,0xffffc1f3,0x0,0xffffc1f3,0xffffc1f3,0x0,0xffffc163,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0x0,0x0,0x0,0x0,0xffffc163,0x0,0xffffc1f3,0x0,0xffffc1f3,0x0,0x0,0x0,0x0,0x0,0xffffc163,0x0,0x0,0x0,0xffffc163,0x0,0x0,0x0,0x0,0xffffc163,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc163,0xffffc163,0xffffc1f3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc163,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc16b,0x80,0x0,0xffffc1f3,0x0,0x0,0x0,0xffffc1f3,0x0,0x0,0xffffc163,0x0,0x0,0x0,0xffffc1f3,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0xffffc163,0x0,0xffffc163,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc163,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc163,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc163,0xffffc1f3,0x0,0x0,0x0,0xffffc163,0xffffc163,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0xffffc1f3,0x0,0x0,0x0,0x0,0x0,0xffffc163,0xffffc163,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc163,0x0,0xffffc163,0x0,0x0,0x0,0x0,0xffffc163,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x200000,0x0,0x0,0x400000,0x0,0x40000,0x2000000,0x8000,0x0,0x0,0x8,0x4000,0x0,0x800000,0x1000000,0xffecc008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc16b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc1f3,0x0,0x0,0xffffc163,0x0,0x80,0x0,0x0,0xffffc163,0x0,0xffffc173,0x10,0x0,0x0,0xffffc173,0x0,0x0,0xffffc173,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffc163,0x92490102,0x24924020,0x49248041,};
   }
   private static void jj_la1_17() {
      jj_la1_17 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x7fffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x7fffffff,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0xffffffff,0x0,0x0,0x0,0x7fffffff,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff80000,0x0,0x7fffffff,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x10000,0x20000,0x0,0x1000,0x0,0x0,0x0,0x20000000,0x40000,0x8000,0x0,0x4000,0x0,0x0,0x6007d07f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0xffffffff,0x80000000,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x24924924,0x49249249,0x12492492,};
   }
   private static void jj_la1_18() {
      jj_la1_18 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0xfae267b6,0x0,0xfaa267b6,0x0,0x0,0x0,0xfae267b6,0xfaa267b6,0x0,0xfae267b6,0xfae267b6,0x0,0xca802786,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0xfae267b6,0x0,0x0,0x0,0x0,0x400000,0xca802786,0x4,0xfae267b6,0x0,0xfae267b6,0x0,0x0,0x0,0x0,0x0,0xca802786,0x0,0x0,0x0,0xca802786,0x0,0x0,0x0,0x0,0xca802786,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xca802786,0xca802786,0xfaa267b6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0xca802786,0x80000,0x0,0x82000,0x1000000,0x0,0x0,0x0,0xfa802786,0x0,0x0,0xfaa267b6,0x0,0x0,0x0,0xfaa267b6,0x0,0x0,0xca802786,0x0,0x0,0x0,0xfaa267b6,0x0,0x0,0x0,0x0,0x0,0xfaa267b6,0x0,0x0,0x0,0x0,0x0,0x0,0xfaa267b6,0x0,0xca802786,0x0,0xca802786,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0xca802786,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xca802786,0x0,0x0,0x0,0x0,0x0,0xfae267b6,0x0,0x0,0x0,0x40000,0x40000,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x30000000,0x0,0x0,0xcaa02786,0xfaa267b6,0x0,0x0,0x0,0xfa802786,0xca802786,0x0,0x80000,0x30000000,0x30000000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x0,0x0,0xfaa267b6,0x0,0xfaa267b6,0x0,0x0,0x0,0x0,0x0,0xca802786,0xca802786,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xca802786,0x0,0xca802786,0x0,0x0,0x0,0x0,0xca802786,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0xfa802786,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfaa267b6,0x0,0xc0004000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xca8227b6,0x0,0x0,0xca802786,0x0,0x0,0x0,0x0,0xca802786,0x0,0xca8227b6,0x20030,0x200000,0x0,0xca8267b6,0x0,0x40000000,0xca8267b6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xca802786,0x40800204,0x82000480,0x8002102,};
   }
   private static void jj_la1_19() {
      jj_la1_19 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7bde1fd0,0x0,0x7bde1fd0,0x0,0x0,0x0,0x7bde1fd0,0x7bde1fd0,0x0,0x7bde1fd0,0x7bde1fd0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7bde1fd0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x0,0x7bde1fd0,0x0,0x7bde1fd0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x7b0e0fd0,0x7bde1fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd4,0x0,0x0,0x7bde1fd0,0x0,0x0,0x0,0x7bde1fd0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x7bde1fd0,0x0,0x0,0x0,0x0,0x0,0x7bde1fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x7bde1fd0,0x0,0x7b0e0fd0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x80000000,0x0,0x7bde1fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x7b0e0fd0,0x7bde1fd0,0x0,0x0,0x0,0x7b4e0fd0,0x7b0e0fd0,0x0,0x0,0x400000,0x400000,0x400000,0x0,0x0,0x400000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x7bde1fd0,0x0,0x7bde1fd0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x7b0e0fd0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x0,0x7b0e0fd0,0x4,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7b0e0fd4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x7bde1fd0,0x0,0x1101000,0x0,0x0,0x0,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7b8e0fd0,0x0,0x0,0x7b0e0fd0,0x0,0x0,0x0,0x8,0x7b0e0fd0,0x0,0x7b8e0fd0,0x800000,0x0,0x800000,0x7b8e0fd0,0x0,0x0,0x7b8e0fd0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x400000,0x0,0x400000,0x0,0x7b0e0fd0,0x11020240,0x22040480,0x48080910,};
   }
   private static void jj_la1_20() {
      jj_la1_20 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x346bbf4e,0x0,0x3463bf4e,0x0,0x0,0x0,0x346bbf4e,0x3463bf4e,0x0,0x346bbfee,0x346bbfee,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x346bbfee,0x0,0x0,0x0,0x0,0x0,0x3403bd0c,0x0,0x346bbfee,0x0,0x346bbf4e,0x80,0x0,0x0,0x0,0x0,0x3403bd0c,0x0,0x0,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x3403bd0c,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x3403bd0c,0x3403bd0c,0x3463bf4e,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3583bd0c,0x0,0x0,0x3463bf4e,0x0,0x0,0x0,0x3463bf4e,0x0,0x0,0x3403bd0c,0x0,0x0,0x0,0x3463bf4e,0x0,0x0,0x0,0x0,0x0,0x3463bf4e,0x0,0x0,0x0,0x0,0x0,0x0,0x3463bf4e,0x0,0x3403bd0c,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x0,0x346bbf4e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x3403bf0c,0x3463bf4e,0x40000000,0x0,0x0,0x3403bd0e,0x3403bd0c,0x0,0x0,0x2,0x2,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3463bf4e,0x0,0x3463bf4e,0x0,0x0,0x0,0x0,0x0,0x3403bd0c,0x3403bd0c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x3403bd0c,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x3403bd0c,0x1800000,0x0,0x0,0x0,0x2000000,0x800000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x0,0x0,0x0,0x0,0x0,0x2000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x3583bd0c,0x20000000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3463bf4e,0x0,0x0,0x38000,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3463bf4c,0x0,0x0,0x3403bd0c,0x0,0x0,0x0,0x0,0x3403bd0c,0x0,0x3463bf4c,0x600240,0x200,0x0,0x3463bf4c,0x0,0x0,0x3463bf4c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x2,0x0,0x3403bd0c,0x2000a404,0x4010808,0x10021100,};
   }
   private static void jj_la1_21() {
      jj_la1_21 = new int[] {0x0,0xe000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xeb78ffc8,0x0,0xeb78ffc0,0x0,0x0,0x0,0xeb78ffc8,0xeb78ffc0,0x0,0xeb78ffc8,0xeb78ffc8,0x0,0x3781bc0,0x378e000,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0xeb78ffc8,0x28,0x0,0x0,0x0,0x0,0x1bc0,0x0,0xeb78ffc8,0x0,0xeb78ffc8,0x0,0x0,0x0,0x8000000,0x0,0x1bc0,0x0,0x8000000,0x0,0x1bc0,0x0,0x0,0x8000000,0x0,0x1bc0,0x0,0x0,0x0,0x8000000,0x10000000,0x0,0x0,0x101bc0,0x101bc0,0xeb78ffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x8000000,0x1bc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1bc0,0x0,0x0,0xeb78ffc0,0x1,0x0,0x0,0xeb78ffc0,0x0,0x4,0x1bc0,0x0,0x0,0x0,0xeb78ffc0,0x0,0x0,0x0,0x0,0x0,0xeb78ffc0,0x0,0x0,0x0,0x0,0x0,0x0,0xeb78ffc0,0x0,0x1bc0,0x0,0x1bc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x8001bc0,0xe000,0x0,0xe000,0x0,0x0,0x0,0x0,0x8001bc0,0x0,0x0,0x8,0x0,0x0,0xeb78ffc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0xe000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0xe378e000,0x0,0x0,0x1bc0,0xeb78ffc0,0x0,0x0,0x0,0xe378fbc0,0x1bc0,0x0,0x0,0xe378e000,0xe378e000,0xe378e000,0xe000,0xe000,0x0,0x100000,0x700000,0x100000,0x0,0x3780000,0xe0000000,0x0,0x0,0xeb78ffc0,0x8000000,0xeb78ffc0,0x8000000,0x0,0x0,0x0,0x0,0x800fbc0,0x810fbc0,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x8000000,0x0,0x8000000,0xc00,0xc00,0x0,0x8000000,0xc00,0x400,0x400,0x0,0x1bc0,0x0,0x8001bc0,0x0,0x2000,0x2000,0x0,0x1bc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8,0x1bc0,0x400,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xeb78ffc0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x8,0x28,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fc0,0x10,0x0,0x8001bc0,0x0,0x0,0x8000000,0x0,0x8001bc0,0x0,0x1fc0,0x400,0x0,0x0,0x1fc0,0x8000000,0x0,0x1fc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1bc0,0x1100,0x240,0x880,};
   }
   private static void jj_la1_22() {
      jj_la1_22 = new int[] {0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x60801,0x80,0x60801,0x0,0x80,0x0,0x60801,0x60801,0x20,0x60801,0x60801,0x80,0x0,0x60000,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60801,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60801,0x80,0x60801,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0xe0801,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x60801,0x0,0x0,0x0,0x60801,0x0,0x0,0x0,0x0,0x0,0x0,0x60801,0x0,0x0,0x0,0x0,0x0,0x60801,0x0,0x0,0x0,0x0,0x80,0x80,0x60801,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x20000000,0x0,0x0,0x80,0x8000000,0x2,0x0,0x80,0x40080,0xa0802,0x800,0xa0802,0x80,0x2,0x80,0x80,0x0,0x0,0x80,0x60801,0x60000,0x0,0x1e700,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x1e700,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x60800,0x1,0x0,0x0,0x60801,0x0,0x0,0x0,0x60000,0x0,0x0,0x0,0x60000,0x60000,0x60000,0x0,0x60000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x8,0x60801,0x8,0x60801,0x8,0x60000,0x60000,0x60000,0x60000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x20000,0x60000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x80,0x80,0x80,0x0,0x0,0x60801,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fe700,0x0,0x0,0x0,0x60000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_23() {
      jj_la1_23 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x2f800,0x0,0x0,0x0,0x2f800,0x2f800,0x0,0x2f800,0x2f800,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x2f800,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x2f800,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x2f800,0x0,0x0,0x0,0x2f800,0x0,0x0,0x2f800,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x2f800,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x2f800,0x0,0x0,0x0,0x2f800,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x2f800,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x2f800,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f800,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x2f800,0x0,0x2f800,0x0,0x0,0x0,0x2f800,0x0,0x0,0x2f800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[102];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SqlParserImpl(java.io.InputStream stream) {
     this(stream, null);
  }
  public SqlParserImpl(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SqlParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 390; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 390; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SqlParserImpl(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SqlParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 390; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 390; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SqlParserImpl(SqlParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 390; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SqlParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 390; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[757];
    for (int i = 0; i < 757; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 390; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
          if ((jj_la1_13[i] & (1<<j)) != 0) {
            la1tokens[416+j] = true;
          }
          if ((jj_la1_14[i] & (1<<j)) != 0) {
            la1tokens[448+j] = true;
          }
          if ((jj_la1_15[i] & (1<<j)) != 0) {
            la1tokens[480+j] = true;
          }
          if ((jj_la1_16[i] & (1<<j)) != 0) {
            la1tokens[512+j] = true;
          }
          if ((jj_la1_17[i] & (1<<j)) != 0) {
            la1tokens[544+j] = true;
          }
          if ((jj_la1_18[i] & (1<<j)) != 0) {
            la1tokens[576+j] = true;
          }
          if ((jj_la1_19[i] & (1<<j)) != 0) {
            la1tokens[608+j] = true;
          }
          if ((jj_la1_20[i] & (1<<j)) != 0) {
            la1tokens[640+j] = true;
          }
          if ((jj_la1_21[i] & (1<<j)) != 0) {
            la1tokens[672+j] = true;
          }
          if ((jj_la1_22[i] & (1<<j)) != 0) {
            la1tokens[704+j] = true;
          }
          if ((jj_la1_23[i] & (1<<j)) != 0) {
            la1tokens[736+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 757; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 102; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
